/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.Connection;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.HostCatcher;
import com.limegroup.gnutella.ManagedConnection;
import com.limegroup.gnutella.MessageService;
import com.limegroup.gnutella.QueryUnicaster;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.SupernodeAssigner;
import com.limegroup.gnutella.connection.ConnectionChecker;
import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.handshaking.BadHandshakeException;
import com.limegroup.gnutella.handshaking.HandshakeResponse;
import com.limegroup.gnutella.handshaking.NoGnutellaOkException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.PingRequest;
import com.limegroup.gnutella.messages.vendor.QueryStatusResponse;
import com.limegroup.gnutella.messages.vendor.TCPConnectBackVendorMessage;
import com.limegroup.gnutella.messages.vendor.UDPConnectBackVendorMessage;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.QuestionsHandler;
import com.limegroup.gnutella.settings.UltrapeerSettings;
import com.limegroup.gnutella.util.IpPortSet;
import com.limegroup.gnutella.util.ManagedThread;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.util.Sockets;
import com.limegroup.gnutella.util.SystemUtils;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConnectionManager {
    private volatile long _disconnectTime = -1L;
    private volatile long _connectTime = Long.MAX_VALUE;
    private volatile long _automaticConnectTime = 0L;
    private volatile boolean _automaticallyConnecting;
    private volatile long _lastSuccessfulConnect = 0L;
    private volatile long _lastConnectionCheck = 0L;
    private static volatile int _connectionAttempts;
    private static final Log LOG;
    public static final int PREFERRED_CONNECTIONS_FOR_LEAF = 5;
    public static final int CONNECT_BACK_REDUNDANT_REQUESTS = 3;
    private static final int MINIMUM_IDLE_TIME = 1800000;
    public static final int RESERVED_NON_LIMEWIRE_LEAVES = 2;
    private volatile int _preferredConnections = -1;
    private HostCatcher _catcher;
    private final List _fetchers = new ArrayList();
    private final List _initializingFetchedConnections = new ArrayList();
    private ConnectionFetcher _dedicatedPrefFetcher;
    private volatile boolean _needPref = true;
    private boolean _needPrefInterrupterScheduled = false;
    private volatile List _connections = Collections.EMPTY_LIST;
    private volatile List _initializedConnections = Collections.EMPTY_LIST;
    private volatile List _initializedClientConnections = Collections.EMPTY_LIST;
    private volatile int _shieldedConnections = 0;
    private volatile int _nonLimeWireLeaves = 0;
    private volatile int _nonLimeWirePeers = 0;
    private volatile int _localeMatchingPeers = 0;
    private volatile int _leafTries;
    private volatile int _demotionLimit = 0;
    private volatile float _measuredUpstreamBandwidth = 0.0f;
    private volatile float _measuredDownstreamBandwidth = 0.0f;
    static /* synthetic */ Class class$com$limegroup$gnutella$ConnectionManager;

    public void initialize() {
        this._catcher = RouterService.getHostCatcher();
        if (SystemUtils.supportsIdleTime()) {
            RouterService.schedule(new Runnable(){

                public void run() {
                    ConnectionManager.this.setPreferredConnections();
                }
            }, 1000L, 1000L);
        }
    }

    public ManagedConnection createConnectionBlocking(String string, int n) throws IOException {
        ManagedConnection managedConnection = new ManagedConnection(string, n);
        this.initializeExternallyGeneratedConnection(managedConnection);
        ManagedThread managedThread = new ManagedThread(new OutgoingConnector(managedConnection, false), "OutgoingConnector");
        managedThread.setDaemon(true);
        managedThread.start();
        return managedConnection;
    }

    public void createConnectionAsynchronously(String string, int n) {
        OutgoingConnector outgoingConnector = new OutgoingConnector(new ManagedConnection(string, n), true);
        ManagedThread managedThread = new ManagedThread(outgoingConnector, "OutgoingConnectionThread");
        managedThread.setDaemon(true);
        managedThread.start();
    }

    void acceptConnection(Socket socket) {
        Thread.currentThread().setName("IncomingConnectionThread");
        ManagedConnection managedConnection = new ManagedConnection(socket);
        try {
            this.initializeExternallyGeneratedConnection(managedConnection);
        }
        catch (IOException iOException) {
            managedConnection.close();
            return;
        }
        try {
            this.startConnection(managedConnection);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void remove(ManagedConnection managedConnection) {
        if (!ConnectionSettings.REMOVE_ENABLED.getValue()) {
            return;
        }
        this.removeInternal(managedConnection);
        this.adjustConnectionFetchers();
    }

    public boolean isSupernode() {
        return this.isActiveSupernode() || this.isSupernodeCapable();
    }

    public boolean isSupernodeCapable() {
        return !NetworkUtils.isPrivate() && UltrapeerSettings.EVER_ULTRAPEER_CAPABLE.getValue() && !this.isShieldedLeaf() && !UltrapeerSettings.DISABLE_ULTRAPEER_MODE.getValue() && !this.isBehindProxy() && this.minConnectTimePassed();
    }

    private boolean minConnectTimePassed() {
        return Math.max(0L, System.currentTimeMillis() - this._connectTime) / 1000L >= (long)UltrapeerSettings.MIN_CONNECT_TIME.getValue();
    }

    public boolean isBehindProxy() {
        return ConnectionSettings.CONNECTION_METHOD.getValue() != 0;
    }

    public boolean isActiveSupernode() {
        return !this.isShieldedLeaf() && (this._initializedClientConnections.size() > 0 || this._initializedConnections.size() > 0);
    }

    public boolean isShieldedLeaf() {
        return this._shieldedConnections != 0;
    }

    public boolean hasSupernodeClientConnection() {
        return this.getNumInitializedClientConnections() > 0;
    }

    public boolean hasFreeSlots() {
        return this.isSupernode() && (this.hasFreeUltrapeerSlots() || this.hasFreeLeafSlots());
    }

    private boolean hasFreeUltrapeerSlots() {
        return this.getNumFreeNonLeafSlots() > 0;
    }

    private boolean hasFreeLeafSlots() {
        return this.getNumFreeLeafSlots() > 0;
    }

    boolean isConnectedTo(String string) {
        List list = this.getConnections();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ManagedConnection managedConnection = (ManagedConnection)iterator.next();
            if (!managedConnection.getAddress().equals(string)) continue;
            return true;
        }
        return false;
    }

    public int getNumConnections() {
        return this._connections.size();
    }

    public int getNumInitializedConnections() {
        return this._initializedConnections.size();
    }

    public int getNumInitializedClientConnections() {
        return this._initializedClientConnections.size();
    }

    public int getNumClientSupernodeConnections() {
        return this._shieldedConnections;
    }

    public synchronized int getNumUltrapeerConnections() {
        return this.ultrapeerToUltrapeerConnections();
    }

    public synchronized int getNumOldConnections() {
        return this.oldConnections();
    }

    public int getNumFreeLeafSlots() {
        if (this.isSupernode()) {
            return UltrapeerSettings.MAX_LEAVES.getValue() - this.getNumInitializedClientConnections();
        }
        return 0;
    }

    public int getNumFreeLimeWireLeafSlots() {
        return Math.max(0, this.getNumFreeLeafSlots() - Math.max(0, 2 - this._nonLimeWireLeaves));
    }

    public int getNumFreeNonLeafSlots() {
        return this._preferredConnections - this.getNumInitializedConnections();
    }

    public int getNumFreeLimeWireNonLeafSlots() {
        return Math.max(0, this.getNumFreeNonLeafSlots() - Math.max(0, (int)(ConnectionSettings.MIN_NON_LIME_PEERS.getValue() * (float)this._preferredConnections) - this._nonLimeWirePeers) - this.getNumLimeWireLocalePrefSlots());
    }

    public boolean isLocaleMatched() {
        return !ConnectionSettings.USE_LOCALE_PREF.getValue() || this._localeMatchingPeers != 0;
    }

    public int getNumLimeWireLocalePrefSlots() {
        return Math.max(0, ConnectionSettings.NUM_LOCALE_PREF.getValue() - this._localeMatchingPeers);
    }

    public boolean isFullyConnected() {
        return this._initializedConnections.size() >= this._preferredConnections;
    }

    public boolean isConnected() {
        return this._initializedClientConnections.size() > 0 || this._initializedConnections.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnecting() {
        if (this._disconnectTime != 0L) {
            return false;
        }
        if (this.isConnected()) {
            return false;
        }
        ConnectionManager connectionManager = this;
        synchronized (connectionManager) {
            return this._fetchers.size() != 0 || this._initializingFetchedConnections.size() != 0;
        }
    }

    public void measureBandwidth() {
        float f = 0.0f;
        float f2 = 0.0f;
        List list = this.getInitializedConnections();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ManagedConnection managedConnection = (ManagedConnection)iterator.next();
            managedConnection.measureBandwidth();
            f += managedConnection.getMeasuredUpstreamBandwidth();
            f2 += managedConnection.getMeasuredDownstreamBandwidth();
        }
        this._measuredUpstreamBandwidth = f;
        this._measuredDownstreamBandwidth = f2;
    }

    public float getMeasuredUpstreamBandwidth() {
        return this._measuredUpstreamBandwidth;
    }

    public float getMeasuredDownstreamBandwidth() {
        return this._measuredDownstreamBandwidth;
    }

    private boolean allowConnection(ManagedConnection managedConnection) {
        if (!managedConnection.receivedHeaders()) {
            return false;
        }
        return this.allowConnection(managedConnection.headers(), false);
    }

    public boolean allowConnectionAsLeaf(HandshakeResponse handshakeResponse) {
        return this.allowConnection(handshakeResponse, true);
    }

    public boolean allowConnection(HandshakeResponse handshakeResponse) {
        return this.allowConnection(handshakeResponse, !handshakeResponse.isUltrapeer());
    }

    public boolean allowAnyConnection() {
        if (this.isShieldedLeaf()) {
            return false;
        }
        return this.getNumInitializedConnections() < this._preferredConnections || this.isSupernode() && this.getNumInitializedClientConnections() < UltrapeerSettings.MAX_LEAVES.getValue();
    }

    public boolean allowConnection(HandshakeResponse handshakeResponse, boolean bl) {
        if (!ConnectionSettings.PREFERENCING_ACTIVE.getValue()) {
            return true;
        }
        if (!handshakeResponse.isLeaf() && !handshakeResponse.isUltrapeer()) {
            return false;
        }
        int n = ConnectionSettings.LIME_ATTEMPTS.getValue();
        if (!ConnectionSettings.ALLOW_WHILE_DISCONNECTED.getValue() && this._preferredConnections <= 0) {
            return false;
        }
        if (this.isShieldedLeaf() || !this.isSupernode()) {
            if (!handshakeResponse.isUltrapeer()) {
                return false;
            }
            if (!handshakeResponse.isGoodUltrapeer() || Sockets.getAttempts() < n && !handshakeResponse.isLimeWire()) {
                return false;
            }
            if (this._shieldedConnections < this._preferredConnections) {
                if (this.checkLocale(handshakeResponse.getLocalePref())) {
                    this._needPref = false;
                }
                if (this.isIdle()) {
                    return handshakeResponse.isLimeWire();
                }
                return true;
            }
            return this._needPref && this.checkLocale(handshakeResponse.getLocalePref());
        }
        if (handshakeResponse.isLeaf() || bl) {
            if (this.isShieldedLeaf() || !this.isSupernode()) {
                return false;
            }
            if (!ConnectionManager.allowUltrapeer2LeafConnection(handshakeResponse)) {
                return false;
            }
            int n2 = this.getNumInitializedClientConnections();
            int n3 = this._nonLimeWireLeaves;
            if (!handshakeResponse.isLimeWire() && n2 < UltrapeerSettings.MAX_LEAVES.getValue() && n3 < 2) {
                return true;
            }
            if (!handshakeResponse.isGoodLeaf()) {
                return false;
            }
            if (handshakeResponse.isGoodLeaf()) {
                return n2 + Math.max(0, 2 - n3) < UltrapeerSettings.MAX_LEAVES.getValue();
            }
        } else if (handshakeResponse.isGoodUltrapeer()) {
            int n4 = this.getNumInitializedConnections();
            int n5 = this._nonLimeWirePeers;
            int n6 = 0;
            if (!ConnectionManager.allowUltrapeer2UltrapeerConnection(handshakeResponse)) {
                return false;
            }
            if (ConnectionSettings.USE_LOCALE_PREF.getValue()) {
                if (this.checkLocale(handshakeResponse.getLocalePref()) && this._localeMatchingPeers < ConnectionSettings.NUM_LOCALE_PREF.getValue()) {
                    return true;
                }
                n6 = this.getNumLimeWireLocalePrefSlots();
            }
            if (!handshakeResponse.isLimeWire()) {
                double d = (double)n5 / (double)this._preferredConnections;
                if (d < (double)ConnectionSettings.MIN_NON_LIME_PEERS.getValue()) {
                    return true;
                }
                return d < (double)ConnectionSettings.MAX_NON_LIME_PEERS.getValue();
            }
            int n7 = (int)(ConnectionSettings.MIN_NON_LIME_PEERS.getValue() * (float)this._preferredConnections);
            return n4 + Math.max(0, n7 - n5) + n6 < this._preferredConnections;
        }
        return false;
    }

    private static boolean allowUltrapeer2UltrapeerConnection(HandshakeResponse handshakeResponse) {
        if (handshakeResponse.isLimeWire()) {
            return true;
        }
        String string = handshakeResponse.getUserAgent();
        if (string == null) {
            return false;
        }
        string = string.toLowerCase();
        String[] stringArray = ConnectionSettings.EVIL_HOSTS.getValue();
        for (int i = 0; i < stringArray.length; ++i) {
            if (string.indexOf(stringArray[i]) == -1) continue;
            return false;
        }
        return true;
    }

    private static boolean allowUltrapeer2LeafConnection(HandshakeResponse handshakeResponse) {
        if (handshakeResponse.isLimeWire()) {
            return true;
        }
        String string = handshakeResponse.getUserAgent();
        if (string == null) {
            return false;
        }
        string = string.toLowerCase();
        String[] stringArray = ConnectionSettings.EVIL_HOSTS.getValue();
        for (int i = 0; i < stringArray.length; ++i) {
            if (string.indexOf(stringArray[i]) == -1) continue;
            return false;
        }
        return true;
    }

    private int ultrapeerToUltrapeerConnections() {
        int n = 0;
        Iterator iterator = this._initializedConnections.iterator();
        while (iterator.hasNext()) {
            ManagedConnection managedConnection = (ManagedConnection)iterator.next();
            if (!managedConnection.isSupernodeSupernodeConnection()) continue;
            ++n;
        }
        return n;
    }

    private int oldConnections() {
        int n = 0;
        Iterator iterator = this._initializedConnections.iterator();
        while (iterator.hasNext()) {
            ManagedConnection managedConnection = (ManagedConnection)iterator.next();
            if (managedConnection.isSupernodeConnection()) continue;
            ++n;
        }
        return n;
    }

    public boolean supernodeNeeded() {
        return (double)this.getNumInitializedClientConnections() >= (double)UltrapeerSettings.MAX_LEAVES.getValue() * 0.9;
    }

    public List getInitializedConnections() {
        return this._initializedConnections;
    }

    public List getInitializedConnectionsMatchLocale(String string) {
        LinkedList<Connection> linkedList = new LinkedList<Connection>();
        Iterator iterator = this._initializedConnections.iterator();
        while (iterator.hasNext()) {
            Connection connection = (Connection)iterator.next();
            if (!string.equals(connection.getLocalePref())) continue;
            linkedList.add(connection);
        }
        return linkedList;
    }

    public List getInitializedClientConnections() {
        return this._initializedClientConnections;
    }

    public List getInitializedClientConnectionsMatchLocale(String string) {
        LinkedList<Connection> linkedList = new LinkedList<Connection>();
        Iterator iterator = this._initializedClientConnections.iterator();
        while (iterator.hasNext()) {
            Connection connection = (Connection)iterator.next();
            if (!string.equals(connection.getLocalePref())) continue;
            linkedList.add(connection);
        }
        return linkedList;
    }

    public List getConnections() {
        return this._connections;
    }

    public Set getPushProxies() {
        if (this.isShieldedLeaf()) {
            Iterator iterator = this.getInitializedConnections().iterator();
            IpPortSet ipPortSet = new IpPortSet();
            while (iterator.hasNext() && ipPortSet.size() < 4) {
                ManagedConnection managedConnection = (ManagedConnection)iterator.next();
                if (!managedConnection.isPushProxy()) continue;
                ipPortSet.add(managedConnection);
            }
            return ipPortSet;
        }
        return Collections.EMPTY_SET;
    }

    public boolean sendTCPConnectBackRequests() {
        Object object;
        int n = 0;
        ArrayList arrayList = new ArrayList(this.getInitializedConnections());
        Collections.shuffle(arrayList);
        Object object2 = arrayList.iterator();
        while (object2.hasNext()) {
            object = (ManagedConnection)object2.next();
            if (((Connection)object).remoteHostSupportsTCPRedirect() >= 0) continue;
            object2.remove();
        }
        if (arrayList.size() == 1) {
            object2 = (ManagedConnection)arrayList.get(0);
            for (int i = 0; i < 3; ++i) {
                TCPConnectBackVendorMessage tCPConnectBackVendorMessage = new TCPConnectBackVendorMessage(RouterService.getPort());
                ((ManagedConnection)object2).send(tCPConnectBackVendorMessage);
                ++n;
            }
        } else {
            object2 = new TCPConnectBackVendorMessage(RouterService.getPort());
            object = arrayList.iterator();
            while (object.hasNext() && n < 5) {
                ManagedConnection managedConnection = (ManagedConnection)object.next();
                managedConnection.send((Message)object2);
                ++n;
            }
        }
        return n > 0;
    }

    public boolean sendUDPConnectBackRequests(GUID gUID) {
        int n = 0;
        UDPConnectBackVendorMessage uDPConnectBackVendorMessage = new UDPConnectBackVendorMessage(RouterService.getPort(), gUID);
        ArrayList arrayList = new ArrayList(this.getInitializedConnections());
        Collections.shuffle(arrayList);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext() && n < 5) {
            ManagedConnection managedConnection = (ManagedConnection)iterator.next();
            if (managedConnection.remoteHostSupportsUDPConnectBack() < 0) continue;
            managedConnection.send(uDPConnectBackVendorMessage);
            ++n;
        }
        return n > 0;
    }

    public void updateQueryStatus(QueryStatusResponse queryStatusResponse) {
        if (this.isShieldedLeaf()) {
            Iterator iterator = this.getInitializedConnections().iterator();
            while (iterator.hasNext()) {
                ManagedConnection managedConnection = (ManagedConnection)iterator.next();
                if (managedConnection.remoteHostSupportsLeafGuidance() < 0) continue;
                managedConnection.send(queryStatusResponse);
            }
        }
    }

    public Endpoint getConnectedGUESSUltrapeer() {
        Iterator iterator = this._initializedConnections.iterator();
        while (iterator.hasNext()) {
            ManagedConnection managedConnection = (ManagedConnection)iterator.next();
            if (!managedConnection.isSupernodeConnection() || !managedConnection.isGUESSUltrapeer()) continue;
            return new Endpoint(managedConnection.getInetAddress().getAddress(), managedConnection.getPort());
        }
        return null;
    }

    public List getConnectedGUESSUltrapeers() {
        ArrayList<ManagedConnection> arrayList = new ArrayList<ManagedConnection>();
        Iterator iterator = this._initializedConnections.iterator();
        while (iterator.hasNext()) {
            ManagedConnection managedConnection = (ManagedConnection)iterator.next();
            if (!managedConnection.isSupernodeConnection() || !managedConnection.isGUESSUltrapeer()) continue;
            arrayList.add(managedConnection);
        }
        return arrayList;
    }

    private void connectionInitializing(Connection connection) {
        ArrayList<Connection> arrayList = new ArrayList<Connection>(this._connections);
        arrayList.add(connection);
        this._connections = Collections.unmodifiableList(arrayList);
    }

    private void connectionInitializingIncoming(ManagedConnection managedConnection) {
        this.connectionInitializing(managedConnection);
    }

    private boolean connectionInitialized(ManagedConnection managedConnection) {
        if (this._connections.contains(managedConnection)) {
            if (!this.allowInitializedConnection(managedConnection)) {
                this.removeInternal(managedConnection);
                return false;
            }
            if (!managedConnection.isSupernodeClientConnection()) {
                ArrayList<ManagedConnection> arrayList = new ArrayList<ManagedConnection>(this._initializedConnections);
                arrayList.add(managedConnection);
                this._initializedConnections = Collections.unmodifiableList(arrayList);
                if (managedConnection.isClientSupernodeConnection()) {
                    this.killPeerConnections();
                    ++this._shieldedConnections;
                }
                if (!managedConnection.isLimeWire()) {
                    ++this._nonLimeWirePeers;
                }
                if (this.checkLocale(managedConnection.getLocalePref())) {
                    ++this._localeMatchingPeers;
                }
            } else {
                ArrayList<ManagedConnection> arrayList = new ArrayList<ManagedConnection>(this._initializedClientConnections);
                arrayList.add(managedConnection);
                this._initializedClientConnections = Collections.unmodifiableList(arrayList);
                if (!managedConnection.isLimeWire()) {
                    ++this._nonLimeWireLeaves;
                }
            }
            managedConnection.postInit();
            this.sendInitialPingRequest(managedConnection);
            return true;
        }
        return false;
    }

    private boolean allowInitializedConnection(Connection connection) {
        if (!(!this.isShieldedLeaf() && this.isSupernode() || connection.isClientSupernodeConnection())) {
            return false;
        }
        return this.allowConnection(connection.headers());
    }

    private void killPeerConnections() {
        List list = this._initializedConnections;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ManagedConnection managedConnection = (ManagedConnection)iterator.next();
            if (!managedConnection.isSupernodeSupernodeConnection()) continue;
            this.removeInternal(managedConnection);
        }
    }

    public void sendUpdatedCapabilities() {
        Connection connection;
        Iterator iterator = this.getInitializedConnections().iterator();
        while (iterator.hasNext()) {
            connection = (Connection)iterator.next();
            connection.sendUpdatedCapabilities();
        }
        iterator = this.getInitializedClientConnections().iterator();
        while (iterator.hasNext()) {
            connection = (Connection)iterator.next();
            connection.sendUpdatedCapabilities();
        }
    }

    public synchronized void disconnect() {
        this._disconnectTime = System.currentTimeMillis();
        this._connectTime = Long.MAX_VALUE;
        this._preferredConnections = 0;
        this.adjustConnectionFetchers();
        Iterator iterator = this.getConnections().iterator();
        while (iterator.hasNext()) {
            ManagedConnection managedConnection = (ManagedConnection)iterator.next();
            this.remove(managedConnection);
            if (!managedConnection.isSupernodeConnection()) continue;
            this._catcher.add(new Endpoint(managedConnection.getInetAddress().getHostAddress(), managedConnection.getPort()), true, managedConnection.getLocalePref());
        }
        Sockets.clearAttempts();
    }

    public synchronized void connect() {
        this._disconnectTime = 0L;
        this._connectTime = System.currentTimeMillis();
        if (this.isConnected() || this._catcher == null) {
            return;
        }
        _connectionAttempts = 0;
        this._lastConnectionCheck = 0L;
        this._lastSuccessfulConnect = 0L;
        this._catcher.expire();
        this.setPreferredConnections();
        this._catcher.sendUDPPings();
    }

    private void sendInitialPingRequest(ManagedConnection managedConnection) {
        if (managedConnection.supportsPongCaching()) {
            return;
        }
        PingRequest pingRequest = this.getNumInitializedConnections() >= this._preferredConnections ? new PingRequest(1) : new PingRequest(4);
        managedConnection.send(pingRequest);
        try {
            managedConnection.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void removeInternal(ManagedConnection managedConnection) {
        ArrayList arrayList;
        int n;
        if (!managedConnection.isSupernodeClientConnection()) {
            n = this._initializedConnections.indexOf(managedConnection);
            if (n != -1) {
                arrayList = new ArrayList();
                arrayList.addAll(this._initializedConnections);
                arrayList.remove(managedConnection);
                this._initializedConnections = Collections.unmodifiableList(arrayList);
                if (managedConnection.isClientSupernodeConnection()) {
                    --this._shieldedConnections;
                }
                if (!managedConnection.isLimeWire()) {
                    --this._nonLimeWirePeers;
                }
                if (this.checkLocale(managedConnection.getLocalePref())) {
                    --this._localeMatchingPeers;
                }
            }
        } else {
            n = this._initializedClientConnections.indexOf(managedConnection);
            if (n != -1) {
                arrayList = new ArrayList();
                arrayList.addAll(this._initializedClientConnections);
                arrayList.remove(managedConnection);
                this._initializedClientConnections = Collections.unmodifiableList(arrayList);
                if (!managedConnection.isLimeWire()) {
                    --this._nonLimeWireLeaves;
                }
            }
        }
        if ((n = this._connections.indexOf(managedConnection)) != -1) {
            arrayList = new ArrayList(this._connections);
            arrayList.remove(managedConnection);
            this._connections = Collections.unmodifiableList(arrayList);
        }
        managedConnection.close();
        RouterService.getMessageRouter().removeConnection(managedConnection);
        RouterService.getCallback().connectionClosed(managedConnection);
        QueryUnicaster.instance().purgeQuery(managedConnection);
    }

    private synchronized void stabilizeConnections() {
        while (this.getNumInitializedConnections() > this._preferredConnections) {
            ManagedConnection managedConnection = null;
            Iterator iterator = this._initializedConnections.iterator();
            while (iterator.hasNext()) {
                ManagedConnection managedConnection2 = (ManagedConnection)iterator.next();
                if (!managedConnection2.isLimeWire()) {
                    managedConnection = managedConnection2;
                    break;
                }
                if (managedConnection != null && managedConnection2.getConnectionTime() <= managedConnection.getConnectionTime()) continue;
                managedConnection = managedConnection2;
            }
            if (managedConnection == null) continue;
            this.remove(managedConnection);
        }
        this.adjustConnectionFetchers();
    }

    private void adjustConnectionFetchers() {
        int n;
        if (ConnectionSettings.USE_LOCALE_PREF.getValue() && RouterService.isShieldedLeaf() && this._needPref && !this._needPrefInterrupterScheduled && this._dedicatedPrefFetcher == null) {
            this._dedicatedPrefFetcher = new ConnectionFetcher(true);
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    ConnectionManager connectionManager = ConnectionManager.this;
                    synchronized (connectionManager) {
                        ConnectionManager.this._needPref = false;
                        if (ConnectionManager.this._dedicatedPrefFetcher == null) {
                            return;
                        }
                        ConnectionManager.this._dedicatedPrefFetcher.interrupt();
                        ConnectionManager.this._dedicatedPrefFetcher = null;
                    }
                }
            };
            this._needPrefInterrupterScheduled = true;
            RouterService.schedule(runnable, 15000L, 0L);
        }
        int n2 = this.getNumInitializedConnections();
        int n3 = this._preferredConnections - n2;
        if (!RouterService.acceptedIncomingConnection() && !this.isActiveSupernode()) {
            n = 3;
        } else if (!this.isSupernode() || this.getNumUltrapeerConnections() == 0) {
            n = 3;
        } else if (n3 > 10) {
            n = 2;
        } else {
            n = 1;
            n3 = (int)((float)n3 - (5.0f + ConnectionSettings.MIN_NON_LIME_PEERS.getValue() * (float)this._preferredConnections));
        }
        int n4 = Math.min(10, n * n3) - this._fetchers.size() - this._initializingFetchedConnections.size();
        for (n4 = Math.min(n4, Sockets.getNumAllowedSockets()); n4 > 0; --n4) {
            this._fetchers.add(new ConnectionFetcher());
        }
        int n5 = this._fetchers.size();
        while (n4 < 0 && n5 > 0) {
            ConnectionFetcher connectionFetcher = (ConnectionFetcher)this._fetchers.remove(--n5);
            connectionFetcher.interrupt();
            ++n4;
        }
        int n6 = this._initializingFetchedConnections.size();
        while (n4 < 0 && n6 > 0) {
            ManagedConnection managedConnection = (ManagedConnection)this._initializingFetchedConnections.remove(--n6);
            this.removeInternal(managedConnection);
            ++n4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeFetchedConnection(ManagedConnection managedConnection, ConnectionFetcher connectionFetcher) throws NoGnutellaOkException, BadHandshakeException, IOException {
        ConnectionManager connectionManager = this;
        synchronized (connectionManager) {
            if (connectionFetcher.isInterrupted()) {
                throw new IOException("connection fetcher");
            }
            this._initializingFetchedConnections.add(managedConnection);
            if (connectionFetcher == this._dedicatedPrefFetcher) {
                this._dedicatedPrefFetcher = null;
            } else {
                this._fetchers.remove(connectionFetcher);
            }
            this.connectionInitializing(managedConnection);
        }
        RouterService.getCallback().connectionInitializing(managedConnection);
        try {
            managedConnection.initialize();
        }
        catch (IOException iOException) {
            ConnectionManager connectionManager2 = this;
            synchronized (connectionManager2) {
                this._initializingFetchedConnections.remove(managedConnection);
                this.removeInternal(managedConnection);
                this.adjustConnectionFetchers();
            }
            throw iOException;
        }
        finally {
            this.processConnectionHeaders(managedConnection);
        }
        this.completeConnectionInitialization(managedConnection, true);
    }

    private void processConnectionHeaders(Connection connection) {
        if (!connection.receivedHeaders()) {
            return;
        }
        Properties properties = connection.headers().props();
        if (properties == null) {
            return;
        }
        this.updateHostCache(connection.headers());
        String string = properties.getProperty("Listen-IP");
        if (string == null) {
            string = properties.getProperty("X-My-Address");
        }
        if (string != null && !connection.isOutgoing()) {
            int n = string.indexOf(58);
            if (n == -1) {
                return;
            }
            if (++n > string.length()) {
                return;
            }
            try {
                int n2 = Integer.parseInt(string.substring(n).trim());
                if (NetworkUtils.isValidPort(n2)) {
                    connection.setListeningPort(n2);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public boolean allowLeafDemotion() {
        ++this._leafTries;
        if (UltrapeerSettings.FORCE_ULTRAPEER_MODE.getValue() || this.isActiveSupernode()) {
            return false;
        }
        return !SupernodeAssigner.isTooGoodToPassUp() || this._leafTries >= this._demotionLimit;
    }

    public void tryToBecomeAnUltrapeer(int n) {
        if (this.isSupernode()) {
            return;
        }
        this._demotionLimit = n;
        this._leafTries = 0;
        this.disconnect();
        this.connect();
    }

    private void updateHostCache(HandshakeResponse handshakeResponse) {
        if (!handshakeResponse.hasXTryUltrapeers()) {
            return;
        }
        String string = handshakeResponse.getXTryUltrapeers();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        ArrayList<Endpoint> arrayList = new ArrayList<Endpoint>(stringTokenizer.countTokens());
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            try {
                Endpoint endpoint = new Endpoint(string2);
                arrayList.add(endpoint);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        this._catcher.add(arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeExternallyGeneratedConnection(ManagedConnection managedConnection) throws IOException {
        ConnectionManager connectionManager;
        if (managedConnection.isOutgoing()) {
            connectionManager = this;
            synchronized (connectionManager) {
                this.connectionInitializing(managedConnection);
                this.adjustConnectionFetchers();
            }
            RouterService.getCallback().connectionInitializing(managedConnection);
        }
        try {
            managedConnection.initialize();
        }
        catch (IOException iOException) {
            this.remove(managedConnection);
            throw iOException;
        }
        finally {
            this.processConnectionHeaders(managedConnection);
        }
        if (!managedConnection.isOutgoing() && !this.allowConnection(managedConnection)) {
            throw new IOException("No space for connection");
        }
        if (!managedConnection.isOutgoing()) {
            connectionManager = this;
            synchronized (connectionManager) {
                this.connectionInitializingIncoming(managedConnection);
                this.adjustConnectionFetchers();
            }
            RouterService.getCallback().connectionInitializing(managedConnection);
        }
        this.completeConnectionInitialization(managedConnection, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeConnectionInitialization(ManagedConnection managedConnection, boolean bl) {
        ConnectionManager connectionManager = this;
        synchronized (connectionManager) {
            boolean bl2;
            if (bl) {
                this._initializingFetchedConnections.remove(managedConnection);
            }
            if (bl2 = this.connectionInitialized(managedConnection)) {
                RouterService.getCallback().connectionInitialized(managedConnection);
                this.setPreferredConnections();
            }
        }
    }

    public int getPreferredConnectionCount() {
        return this._preferredConnections;
    }

    public boolean isConnectionIdle() {
        return this._preferredConnections == ConnectionSettings.IDLE_CONNECTIONS.getValue();
    }

    private void setPreferredConnections() {
        if (!ConnectionSettings.ALLOW_WHILE_DISCONNECTED.getValue() && this._disconnectTime != 0L) {
            return;
        }
        int n = this._preferredConnections;
        this._preferredConnections = this.isSupernode() ? ConnectionSettings.NUM_CONNECTIONS.getValue() : (this.isIdle() ? ConnectionSettings.IDLE_CONNECTIONS.getValue() : 5);
        if (n != this._preferredConnections) {
            this.stabilizeConnections();
        }
    }

    private boolean isIdle() {
        return SystemUtils.getIdleTime() >= 1800000L;
    }

    private void startConnection(ManagedConnection managedConnection) throws IOException {
        Thread.currentThread().setName("MessageLoopingThread");
        if (managedConnection.isGUESSUltrapeer()) {
            QueryUnicaster.instance().addUnicastEndpoint(managedConnection.getInetAddress(), managedConnection.getPort());
        }
        managedConnection.loopForMessages();
    }

    public void noInternetConnection() {
        if (this._automaticallyConnecting) {
            return;
        }
        MessageService.showError("NO_INTERNET_RETRYING", QuestionsHandler.NO_INTERNET_RETRYING);
        this.disconnect();
        RouterService.schedule(new Runnable(){

            public void run() {
                if (ConnectionManager.this._automaticConnectTime < ConnectionManager.this._disconnectTime) {
                    return;
                }
                if (!RouterService.isConnected()) {
                    ConnectionManager.this.connect();
                }
            }
        }, 10000L, 120000L);
        this._automaticConnectTime = System.currentTimeMillis();
        this._automaticallyConnecting = true;
        this.recoverHosts();
    }

    private void recoverHosts() {
        if (this._catcher != null && this._catcher.getNumHosts() < 100) {
            this._catcher.recoverHosts();
        }
    }

    private boolean checkLocale(String string) {
        if (string == null) {
            string = ApplicationSettings.DEFAULT_LOCALE.getValue();
        }
        return ApplicationSettings.LANGUAGE.getValue().equals(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        LOG = LogFactory.getLog((Class)(class$com$limegroup$gnutella$ConnectionManager == null ? (class$com$limegroup$gnutella$ConnectionManager = ConnectionManager.class$("com.limegroup.gnutella.ConnectionManager")) : class$com$limegroup$gnutella$ConnectionManager));
    }

    private class ConnectionFetcher
    extends ManagedThread {
        private boolean _pref = false;

        public ConnectionFetcher() {
            this(false);
        }

        public ConnectionFetcher(boolean bl) {
            this.setName("ConnectionFetcher");
            this._pref = bl;
            this.setDaemon(true);
            this.start();
        }

        public void managedRun() {
            try {
                Endpoint endpoint = null;
                do {
                    endpoint = ConnectionManager.this._catcher.getAnEndpoint();
                } while (!IPFilter.instance().allow(endpoint.getAddress()) || ConnectionManager.this.isConnectedTo(endpoint.getAddress()));
                Assert.that(endpoint != null);
                _connectionAttempts++;
                ManagedConnection managedConnection = new ManagedConnection(endpoint.getAddress(), endpoint.getPort());
                managedConnection.setLocalePreferencing(this._pref);
                long l = System.currentTimeMillis();
                if (!ConnectionManager.this.isConnected() && _connectionAttempts > 40 && l - ConnectionManager.this._lastSuccessfulConnect > 4000L && l - ConnectionManager.this._lastConnectionCheck > 3600000L) {
                    _connectionAttempts = 0;
                    ConnectionManager.this._lastConnectionCheck = l;
                    LOG.debug((Object)"checking for live connection");
                    ConnectionChecker.checkForLiveConnection();
                }
                try {
                    ConnectionManager.this.initializeFetchedConnection(managedConnection, this);
                    ConnectionManager.this._lastSuccessfulConnect = System.currentTimeMillis();
                    ConnectionManager.this._catcher.doneWithConnect(endpoint, true);
                    if (this._pref) {
                        ConnectionManager.this._needPref = false;
                    }
                }
                catch (NoGnutellaOkException noGnutellaOkException) {
                    ConnectionManager.this._lastSuccessfulConnect = System.currentTimeMillis();
                    if (noGnutellaOkException.getCode() == 577) {
                        ConnectionManager.this._catcher.add(endpoint, true, managedConnection.getLocalePref());
                    } else {
                        ConnectionManager.this._catcher.doneWithConnect(endpoint, true);
                        ConnectionManager.this._catcher.putHostOnProbation(endpoint);
                    }
                    throw noGnutellaOkException;
                }
                catch (IOException iOException) {
                    ConnectionManager.this._catcher.doneWithConnect(endpoint, false);
                    ConnectionManager.this._catcher.expireHost(endpoint);
                    throw iOException;
                }
                ConnectionManager.this.startConnection(managedConnection);
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            catch (Throwable throwable) {
                ErrorService.error(throwable);
            }
        }

        public String toString() {
            return "ConnectionFetcher";
        }
    }

    private class OutgoingConnector
    implements Runnable {
        private final ManagedConnection _connection;
        private final boolean _doInitialization;

        public OutgoingConnector(ManagedConnection managedConnection, boolean bl) {
            this._connection = managedConnection;
            this._doInitialization = bl;
        }

        public void run() {
            try {
                if (this._doInitialization) {
                    ConnectionManager.this.initializeExternallyGeneratedConnection(this._connection);
                }
                ConnectionManager.this.startConnection(this._connection);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

