/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.IncompleteFileDesc;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.Comparators;
import com.limegroup.gnutella.util.ConverterObjectInputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class CreationTimeCache {
    private static final Log LOG = LogFactory.getLog((Class)(class$com$limegroup$gnutella$CreationTimeCache == null ? (class$com$limegroup$gnutella$CreationTimeCache = CreationTimeCache.class$("com.limegroup.gnutella.CreationTimeCache")) : class$com$limegroup$gnutella$CreationTimeCache));
    private static final File CTIME_CACHE_FILE = new File(CommonUtils.getUserSettingsDir(), "createtimes.cache");
    private static CreationTimeCache instance = new CreationTimeCache();
    private final Map URN_TO_TIME_MAP = this.createMap();
    private final SortedMap TIME_TO_URNSET_MAP = new TreeMap(Comparators.inverseLongComparator());
    private boolean dirty = false;
    static /* synthetic */ Class class$com$limegroup$gnutella$CreationTimeCache;

    public static synchronized CreationTimeCache instance() {
        return instance;
    }

    private CreationTimeCache() {
        this.constructURNMap();
    }

    public synchronized Long getCreationTime(URN uRN) {
        return (Long)this.URN_TO_TIME_MAP.get(uRN);
    }

    public long getCreationTimeAsLong(URN uRN) {
        Long l = this.getCreationTime(uRN);
        if (l == null) {
            return -1L;
        }
        return l;
    }

    public synchronized void removeTime(URN uRN) {
        Long l = (Long)this.URN_TO_TIME_MAP.remove(uRN);
        this.removeURNFromURNSet(uRN, l);
        if (l != null) {
            this.dirty = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pruneTimes(boolean bl) {
        FileManager fileManager = RouterService.getFileManager();
        synchronized (fileManager) {
            CreationTimeCache creationTimeCache = this;
            synchronized (creationTimeCache) {
                Iterator iterator = this.URN_TO_TIME_MAP.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    if (!(entry.getKey() instanceof URN) || !(entry.getValue() instanceof Long)) {
                        iterator.remove();
                        this.dirty = true;
                        continue;
                    }
                    URN uRN = (URN)entry.getKey();
                    Long l = (Long)entry.getValue();
                    FileDesc fileDesc = RouterService.getFileManager().getFileDescForUrn(uRN);
                    if (fileDesc != null && fileDesc.getFile() != null && fileDesc.getFile().exists()) continue;
                    this.dirty = true;
                    iterator.remove();
                    if (!bl) continue;
                    this.removeURNFromURNSet(uRN, l);
                }
            }
        }
    }

    public synchronized void pruneTimes() {
        this.pruneTimes(true);
    }

    public synchronized void addTime(URN uRN, long l) throws IllegalArgumentException {
        if (uRN == null) {
            throw new IllegalArgumentException("Null URN.");
        }
        if (l <= 0L) {
            throw new IllegalArgumentException("Bad Time = " + l);
        }
        Long l2 = new Long(l);
        Long l3 = (Long)this.URN_TO_TIME_MAP.get(uRN);
        if (l3 == null || !l3.equals(l2)) {
            this.dirty = true;
            this.URN_TO_TIME_MAP.put(uRN, l2);
        }
    }

    public synchronized void commitTime(URN uRN) throws IllegalArgumentException {
        if (uRN == null) {
            throw new IllegalArgumentException("Null URN.");
        }
        Long l = (Long)this.URN_TO_TIME_MAP.get(uRN);
        if (l == null) {
            throw new IllegalArgumentException("Never added URN via addTime()");
        }
        HashSet<URN> hashSet = (HashSet<URN>)this.TIME_TO_URNSET_MAP.get(l);
        if (hashSet == null) {
            hashSet = new HashSet<URN>();
            this.TIME_TO_URNSET_MAP.put(l, hashSet);
        }
        hashSet.add(uRN);
    }

    public synchronized List getFiles(int n) throws IllegalArgumentException {
        return this.getFiles(null, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getFiles(QueryRequest queryRequest, int n) throws IllegalArgumentException {
        FileManager fileManager = RouterService.getFileManager();
        synchronized (fileManager) {
            CreationTimeCache creationTimeCache = this;
            synchronized (creationTimeCache) {
                Object object;
                Object object2;
                if (n < 1) {
                    throw new IllegalArgumentException("bad max = " + n);
                }
                ArrayList<URN> arrayList = new ArrayList<URN>();
                Iterator iterator = this.TIME_TO_URNSET_MAP.entrySet().iterator();
                MediaType.Aggregator aggregator = queryRequest == null ? null : MediaType.getAggregator(queryRequest);
                ArrayList<URN> arrayList2 = null;
                while (iterator.hasNext() && arrayList.size() < n) {
                    object2 = iterator.next();
                    object = (Set)object2.getValue();
                    Iterator iterator2 = object.iterator();
                    while (arrayList.size() < n && iterator2.hasNext()) {
                        URN uRN = (URN)iterator2.next();
                        FileDesc fileDesc = RouterService.getFileManager().getFileDescForUrn(uRN);
                        if (fileDesc == null || fileDesc instanceof IncompleteFileDesc) {
                            if (arrayList2 == null) {
                                arrayList2 = new ArrayList<URN>();
                            }
                            arrayList2.add(uRN);
                            continue;
                        }
                        if (aggregator == null) {
                            arrayList.add(uRN);
                            continue;
                        }
                        if (!aggregator.allow(fileDesc.getFileName())) continue;
                        arrayList.add(uRN);
                    }
                }
                if (arrayList2 != null) {
                    object2 = arrayList2.iterator();
                    while (object2.hasNext()) {
                        object = (URN)object2.next();
                        this.removeTime((URN)object);
                    }
                }
                return arrayList;
            }
        }
    }

    public synchronized List getFiles() {
        return this.getFiles(Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized void persistCache() {
        block12: {
            if (!this.dirty) {
                return;
            }
            ObjectOutputStream objectOutputStream = null;
            objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(CTIME_CACHE_FILE)));
            objectOutputStream.writeObject(this.URN_TO_TIME_MAP);
            Object var4_2 = null;
            try {
                if (objectOutputStream != null) {
                    objectOutputStream.close();
                }
                break block12;
            }
            catch (IOException iOException) {}
            break block12;
            {
                catch (IOException iOException) {
                    ErrorService.error(iOException);
                    Object var4_3 = null;
                    try {
                        if (objectOutputStream != null) {
                            objectOutputStream.close();
                        }
                        break block12;
                    }
                    catch (IOException iOException2) {}
                }
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                try {
                    if (objectOutputStream != null) {
                        objectOutputStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        this.dirty = false;
    }

    private synchronized void removeURNFromURNSet(URN uRN, Long l) {
        block2: {
            block1: {
                if (l == null) break block1;
                Set set = (Set)this.TIME_TO_URNSET_MAP.get(l);
                if (set == null || !set.remove(uRN) || set.size() >= 1) break block2;
                this.TIME_TO_URNSET_MAP.remove(l);
                break block2;
            }
            Iterator iterator = this.TIME_TO_URNSET_MAP.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Set set = (Set)entry.getValue();
                if (!set.contains(uRN)) continue;
                set.remove(uRN);
                if (set.size() >= 1) break;
                iterator.remove();
                break;
            }
        }
    }

    private void constructURNMap() {
        Set set = this.URN_TO_TIME_MAP.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Long l = (Long)entry.getValue();
            URN uRN = (URN)entry.getKey();
            if (RouterService.getFileManager().getFileDescForUrn(uRN) instanceof IncompleteFileDesc) continue;
            HashSet<URN> hashSet = (HashSet<URN>)this.TIME_TO_URNSET_MAP.get(l);
            if (hashSet == null) {
                hashSet = new HashSet<URN>();
                this.TIME_TO_URNSET_MAP.put(l, hashSet);
            }
            hashSet.add(uRN);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map createMap() {
        Map map;
        ObjectInputStream objectInputStream = null;
        try {
            try {
                objectInputStream = new ConverterObjectInputStream(new BufferedInputStream(new FileInputStream(CTIME_CACHE_FILE)));
                map = (Map)objectInputStream.readObject();
                Object var5_4 = null;
                if (objectInputStream == null) return map;
            }
            catch (Throwable throwable) {
                LOG.error((Object)"Unable to read creation time file", throwable);
                HashMap hashMap = new HashMap();
                Object var5_5 = null;
                if (objectInputStream == null) return hashMap;
                try {
                    objectInputStream.close();
                    return hashMap;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return hashMap;
            }
        }
        catch (Throwable throwable2) {
            Object var5_6 = null;
            if (objectInputStream == null) throw throwable2;
            try {}
            catch (IOException iOException) {
                throw throwable2;
            }
            objectInputStream.close();
            throw throwable2;
        }
        try {}
        catch (IOException iOException) {
            // empty catch block
            return map;
        }
        objectInputStream.close();
        return map;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

