/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.util.Buffer;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.util.StringUtils;
import java.io.IOException;
import java.io.Writer;
import java.text.ParseException;
import java.util.Comparator;
import java.util.Iterator;

public class ExtendedEndpoint
extends Endpoint {
    static final long DEFAULT_TIME_RECORDED = 0L;
    private long timeRecorded = -1L;
    static final int DEFAULT_DAILY_UPTIME = 345;
    private int dailyUptime = -1;
    static final int HISTORY_SIZE = 3;
    static final long WINDOW_TIME = 86400000L;
    private Buffer connectSuccesses = new Buffer(3);
    private Buffer connectFailures = new Buffer(3);
    private String _clientLocale = ApplicationSettings.DEFAULT_LOCALE.getValue();
    private int udpHostCacheFailures = -1;
    private static final String ownLocale = ApplicationSettings.LANGUAGE.getValue();
    private static final String LIST_SEPARATOR = ";";
    private static final String FIELD_SEPARATOR = ",";
    public static final String EOL = "\n";
    private static final Comparator PRIORITY_COMPARATOR = new PriorityComparator();

    public ExtendedEndpoint(String string, int n, int n2) {
        super(string, n);
        this.dailyUptime = n2;
        this.timeRecorded = this.now();
    }

    public ExtendedEndpoint(String string, int n) {
        super(string, n);
        this.timeRecorded = this.now();
    }

    public ExtendedEndpoint(String string, int n, boolean bl) {
        super(string, n, bl);
        this.timeRecorded = this.now();
    }

    public ExtendedEndpoint(String string, int n, int n2, String string2) {
        super(string, n);
        this.dailyUptime = n2;
        this.timeRecorded = this.now();
        this._clientLocale = string2;
    }

    public ExtendedEndpoint(String string, int n, String string2) {
        this(string, n);
        this._clientLocale = string2;
    }

    public long getTimeRecorded() {
        if (this.timeRecorded < 0L) {
            return 0L;
        }
        return this.timeRecorded;
    }

    public int getDailyUptime() {
        if (this.dailyUptime < 0) {
            return 345;
        }
        return this.dailyUptime;
    }

    public void setDailyUptime(int n) {
        this.dailyUptime = n;
    }

    public void recordConnectionSuccess() {
        this.recordConnectionAttempt(this.connectSuccesses, this.now());
    }

    public void recordConnectionFailure() {
        this.recordConnectionAttempt(this.connectFailures, this.now());
    }

    public Iterator getConnectionSuccesses() {
        return this.connectSuccesses.iterator();
    }

    public Iterator getConnectionFailures() {
        return this.connectFailures.iterator();
    }

    public String getClientLocale() {
        return this._clientLocale;
    }

    public void setClientLocale(String string) {
        this._clientLocale = string;
    }

    public boolean isUDPHostCache() {
        return this.udpHostCacheFailures != -1;
    }

    public void recordUDPHostCacheFailure() {
        Assert.that(this.isUDPHostCache());
        ++this.udpHostCacheFailures;
    }

    public void decrementUDPHostCacheFailure() {
        Assert.that(this.isUDPHostCache());
        this.udpHostCacheFailures = Math.max(0, this.udpHostCacheFailures - 1);
    }

    public void recordUDPHostCacheSuccess() {
        Assert.that(this.isUDPHostCache());
        this.udpHostCacheFailures = 0;
    }

    public int getUDPHostCacheFailures() {
        return this.udpHostCacheFailures;
    }

    public ExtendedEndpoint setUDPHostCache(boolean bl) {
        this.udpHostCacheFailures = bl ? 0 : -1;
        return this;
    }

    private void recordConnectionAttempt(Buffer buffer, long l) {
        if (buffer.isEmpty()) {
            buffer.addFirst(new Long(l));
        } else if (l - (Long)buffer.first() >= 86400000L) {
            buffer.addFirst(new Long(l));
        } else {
            buffer.removeFirst();
            buffer.addFirst(new Long(l));
        }
    }

    protected long now() {
        return System.currentTimeMillis();
    }

    public void write(Writer writer) throws IOException {
        writer.write(this.getAddress());
        writer.write(":");
        writer.write(this.getPort() + "");
        writer.write(FIELD_SEPARATOR);
        if (this.dailyUptime >= 0) {
            writer.write(this.dailyUptime + "");
        }
        writer.write(FIELD_SEPARATOR);
        if (this.timeRecorded >= 0L) {
            writer.write(this.timeRecorded + "");
        }
        writer.write(FIELD_SEPARATOR);
        this.write(writer, this.getConnectionSuccesses());
        writer.write(FIELD_SEPARATOR);
        this.write(writer, this.getConnectionFailures());
        writer.write(FIELD_SEPARATOR);
        writer.write(this._clientLocale);
        writer.write(FIELD_SEPARATOR);
        if (this.isUDPHostCache()) {
            writer.write(this.udpHostCacheFailures + "");
        }
        writer.write(EOL);
    }

    private void write(Writer writer, Iterator iterator) throws IOException {
        while (iterator.hasNext()) {
            writer.write(iterator.next().toString());
            if (!iterator.hasNext()) continue;
            writer.write(LIST_SEPARATOR);
        }
    }

    public static ExtendedEndpoint read(String string) throws ParseException {
        int n;
        String[] stringArray;
        boolean bl;
        int n2;
        String string2;
        Endpoint endpoint;
        String[] stringArray2 = StringUtils.splitNoCoalesce(string, FIELD_SEPARATOR);
        if (stringArray2.length == 0) {
            throw new ParseException("Empty line", 0);
        }
        try {
            endpoint = new Endpoint(stringArray2[0], true);
            string2 = endpoint.getAddress();
            n2 = endpoint.getPort();
            bl = true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                stringArray = new Endpoint(stringArray2[0], false, false);
                string2 = stringArray.getAddress();
                n2 = stringArray.getPort();
                bl = false;
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                ParseException parseException = new ParseException("Couldn't extract address and port from: " + stringArray2[0], 0);
                if (CommonUtils.isJava14OrLater()) {
                    parseException.initCause(illegalArgumentException2);
                }
                throw parseException;
            }
        }
        endpoint = new ExtendedEndpoint(string2, n2, false);
        if (stringArray2.length >= 2) {
            try {
                ((ExtendedEndpoint)endpoint).dailyUptime = Integer.parseInt(stringArray2[1].trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        ((ExtendedEndpoint)endpoint).timeRecorded = 0L;
        if (stringArray2.length >= 3) {
            try {
                ((ExtendedEndpoint)endpoint).timeRecorded = Long.parseLong(stringArray2[2].trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (stringArray2.length >= 4) {
            try {
                stringArray = StringUtils.split(stringArray2[3], LIST_SEPARATOR);
                for (n = stringArray.length - 1; n >= 0; --n) {
                    super.recordConnectionAttempt(((ExtendedEndpoint)endpoint).connectSuccesses, Long.parseLong(stringArray[n].trim()));
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (stringArray2.length >= 5) {
            try {
                stringArray = StringUtils.split(stringArray2[4], LIST_SEPARATOR);
                for (n = stringArray.length - 1; n >= 0; --n) {
                    super.recordConnectionAttempt(((ExtendedEndpoint)endpoint).connectFailures, Long.parseLong(stringArray[n].trim()));
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (stringArray2.length >= 6) {
            ((ExtendedEndpoint)endpoint).setClientLocale(stringArray2[5]);
        }
        if (stringArray2.length >= 7) {
            try {
                int n3 = Integer.parseInt(stringArray2[6]);
                if (n3 >= 0) {
                    ((ExtendedEndpoint)endpoint).udpHostCacheFailures = n3;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (bl && !NetworkUtils.isValidAddress(string2)) {
            throw new ParseException("invalid dotted addr: " + endpoint, 0);
        }
        if (!((ExtendedEndpoint)endpoint).isUDPHostCache() && !bl) {
            throw new ParseException("illegal non-UHC endpoint: " + endpoint, 0);
        }
        return endpoint;
    }

    public static Comparator priorityComparator() {
        return PRIORITY_COMPARATOR;
    }

    private int localeScore() {
        if (!ConnectionSettings.USE_LOCALE_PREF.getValue()) {
            return 0;
        }
        if (ownLocale.equals(this._clientLocale)) {
            return 1;
        }
        return -1;
    }

    private int connectScore() {
        long l;
        if (this.connectSuccesses.isEmpty() && this.connectFailures.isEmpty()) {
            return 0;
        }
        if (this.connectSuccesses.isEmpty()) {
            return -1;
        }
        if (this.connectFailures.isEmpty()) {
            return 1;
        }
        long l2 = (Long)this.connectSuccesses.last();
        if (l2 > (l = ((Long)this.connectFailures.last()).longValue())) {
            return 1;
        }
        if (l2 < l) {
            return -1;
        }
        return 0;
    }

    public boolean equals(Object object) {
        return super.equals(object);
    }

    static class PriorityComparator
    implements Comparator {
        PriorityComparator() {
        }

        public int compare(Object object, Object object2) {
            ExtendedEndpoint extendedEndpoint = (ExtendedEndpoint)object;
            ExtendedEndpoint extendedEndpoint2 = (ExtendedEndpoint)object2;
            int n = extendedEndpoint.connectScore() - extendedEndpoint2.connectScore();
            if (n != 0) {
                return n;
            }
            n = extendedEndpoint.localeScore() - extendedEndpoint2.localeScore();
            if (n != 0) {
                return n;
            }
            return extendedEndpoint.getDailyUptime() - extendedEndpoint2.getDailyUptime();
        }
    }
}

