/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.ManagedConnection;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.util.ProcessingQueue;
import java.net.InetSocketAddress;

class MessageDispatcher {
    private static final MessageDispatcher INSTANCE = new MessageDispatcher();
    private final ProcessingQueue DISPATCH = new ProcessingQueue("MessageDispatch");

    private MessageDispatcher() {
    }

    public static MessageDispatcher instance() {
        return INSTANCE;
    }

    public void dispatchUDP(Message message, InetSocketAddress inetSocketAddress) {
        this.DISPATCH.add(new UDPDispatch(message, inetSocketAddress));
    }

    public void dispatchMulticast(Message message, InetSocketAddress inetSocketAddress) {
        this.DISPATCH.add(new MulticastDispatch(message, inetSocketAddress));
    }

    public void dispatchTCP(Message message, ManagedConnection managedConnection) {
        this.DISPATCH.add(new TCPDispatch(message, managedConnection));
    }

    private static class TCPDispatch
    implements Runnable {
        private static final MessageRouter ROUTER = RouterService.getMessageRouter();
        private final Message m;
        private final ManagedConnection conn;

        TCPDispatch(Message message, ManagedConnection managedConnection) {
            this.m = message;
            this.conn = managedConnection;
        }

        public void run() {
            ROUTER.handleMessage(this.m, this.conn);
        }
    }

    private static class MulticastDispatch
    implements Runnable {
        private static final MessageRouter ROUTER = RouterService.getMessageRouter();
        private final Message m;
        private final InetSocketAddress addr;

        MulticastDispatch(Message message, InetSocketAddress inetSocketAddress) {
            this.m = message;
            this.addr = inetSocketAddress;
        }

        public void run() {
            ROUTER.handleMulticastMessage(this.m, this.addr);
        }
    }

    private static class UDPDispatch
    implements Runnable {
        private static final MessageRouter ROUTER = RouterService.getMessageRouter();
        private final Message m;
        private final InetSocketAddress addr;

        UDPDispatch(Message message, InetSocketAddress inetSocketAddress) {
            this.m = message;
            this.addr = inetSocketAddress;
        }

        public void run() {
            ROUTER.handleUDPMessage(this.m, this.addr);
        }
    }
}

