/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.Connection;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.ForMeReplyHandler;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.ManagedConnection;
import com.limegroup.gnutella.MessageListener;
import com.limegroup.gnutella.MulticastService;
import com.limegroup.gnutella.PongCacher;
import com.limegroup.gnutella.QueryUnicaster;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.RouteTable;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.UDPReplyHandler;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.UploadManager;
import com.limegroup.gnutella.guess.GUESSEndpoint;
import com.limegroup.gnutella.guess.OnDemandUnicaster;
import com.limegroup.gnutella.guess.QueryKey;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.PingReply;
import com.limegroup.gnutella.messages.PingRequest;
import com.limegroup.gnutella.messages.PushRequest;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.messages.StaticMessages;
import com.limegroup.gnutella.messages.vendor.GiveStatsVendorMessage;
import com.limegroup.gnutella.messages.vendor.HeadPing;
import com.limegroup.gnutella.messages.vendor.HeadPong;
import com.limegroup.gnutella.messages.vendor.HopsFlowVendorMessage;
import com.limegroup.gnutella.messages.vendor.LimeACKVendorMessage;
import com.limegroup.gnutella.messages.vendor.PushProxyAcknowledgement;
import com.limegroup.gnutella.messages.vendor.PushProxyRequest;
import com.limegroup.gnutella.messages.vendor.QueryStatusResponse;
import com.limegroup.gnutella.messages.vendor.ReplyNumberVendorMessage;
import com.limegroup.gnutella.messages.vendor.SimppRequestVM;
import com.limegroup.gnutella.messages.vendor.SimppVM;
import com.limegroup.gnutella.messages.vendor.StatisticVendorMessage;
import com.limegroup.gnutella.messages.vendor.TCPConnectBackRedirect;
import com.limegroup.gnutella.messages.vendor.TCPConnectBackVendorMessage;
import com.limegroup.gnutella.messages.vendor.UDPConnectBackRedirect;
import com.limegroup.gnutella.messages.vendor.UDPConnectBackVendorMessage;
import com.limegroup.gnutella.messages.vendor.UDPCrawlerPing;
import com.limegroup.gnutella.messages.vendor.UDPCrawlerPong;
import com.limegroup.gnutella.messages.vendor.VendorMessage;
import com.limegroup.gnutella.routing.PatchTableMessage;
import com.limegroup.gnutella.routing.QueryRouteTable;
import com.limegroup.gnutella.routing.ResetTableMessage;
import com.limegroup.gnutella.routing.RouteTableMessage;
import com.limegroup.gnutella.search.QueryDispatcher;
import com.limegroup.gnutella.search.QueryHandler;
import com.limegroup.gnutella.search.ResultCounter;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.DownloadSettings;
import com.limegroup.gnutella.settings.SearchSettings;
import com.limegroup.gnutella.settings.StatisticsSettings;
import com.limegroup.gnutella.simpp.SimppManager;
import com.limegroup.gnutella.statistics.OutOfBandThroughputStat;
import com.limegroup.gnutella.statistics.ReceivedMessageStatHandler;
import com.limegroup.gnutella.statistics.RouteErrorStat;
import com.limegroup.gnutella.statistics.RoutedQueryStat;
import com.limegroup.gnutella.statistics.SentMessageStatHandler;
import com.limegroup.gnutella.udpconnect.UDPConnectionMessage;
import com.limegroup.gnutella.udpconnect.UDPMultiplexor;
import com.limegroup.gnutella.upelection.PromotionManager;
import com.limegroup.gnutella.util.FixedSizeExpiringSet;
import com.limegroup.gnutella.util.FixedsizeHashMap;
import com.limegroup.gnutella.util.IOUtils;
import com.limegroup.gnutella.util.ManagedThread;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.util.NoMoreStorageException;
import com.limegroup.gnutella.util.ProcessingQueue;
import com.limegroup.gnutella.util.Sockets;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class MessageRouter {
    private static final Log LOG = LogFactory.getLog((Class)(class$com$limegroup$gnutella$MessageRouter == null ? (class$com$limegroup$gnutella$MessageRouter = MessageRouter.class$("com.limegroup.gnutella.MessageRouter")) : class$com$limegroup$gnutella$MessageRouter));
    protected static ConnectionManager _manager;
    private static final int OLD_CONNECTIONS_TO_USE = 15;
    protected byte[] _clientGUID;
    private final ReplyHandler FOR_ME_REPLY_HANDLER = ForMeReplyHandler.instance();
    private int MAX_ROUTE_TABLE_SIZE = 50000;
    private final int MAX_BYPASSED_RESULTS = 150;
    private RouteTable _pingRouteTable = new RouteTable(120, this.MAX_ROUTE_TABLE_SIZE);
    private RouteTable _queryRouteTable = new RouteTable(300, this.MAX_ROUTE_TABLE_SIZE);
    private RouteTable _pushRouteTable = new RouteTable(420, this.MAX_ROUTE_TABLE_SIZE);
    private RouteTable _headPongRouteTable = new RouteTable(10, this.MAX_ROUTE_TABLE_SIZE);
    private static final long CLEAR_TIME = 30000L;
    private static final long HOPS_FLOW_INTERVAL = 15000L;
    static int MAX_BUFFERED_REPLIES;
    private final Map _outOfBandReplies = new Hashtable();
    private final Map _bypassedResults = new HashMap();
    private static final FixedsizeHashMap _udpConnectBacks;
    private static final int MAX_UDP_CONNECTBACK_FORWARDS = 5;
    private static final FixedsizeHashMap _tcpConnectBacks;
    private static final int MAX_TCP_CONNECTBACK_FORWARDS = 5;
    private static final ProcessingQueue TCP_CONNECT_BACKER;
    private static final Set _udpHeadRequests;
    protected final QueryUnicaster UNICASTER = QueryUnicaster.instance();
    private final QueryDispatcher DYNAMIC_QUERIER = QueryDispatcher.instance();
    private ActivityCallback _callback;
    private static FileManager _fileManager;
    private final QRPPropagator QRP_PROPAGATOR = new QRPPropagator();
    private QueryRouteTable _lastQueryRouteTable;
    private static final int HIGH_HOPS_RESPONSE_LIMIT = 10;
    private static final long TIMED_GUID_LIFETIME = 25000L;
    private volatile Map _messageListeners = Collections.EMPTY_MAP;
    private final Object MESSAGE_LISTENER_LOCK = new Object();
    private PromotionManager _promotionManager;
    private final UDPMultiplexor _udpConnectionMultiplexor = UDPMultiplexor.instance();
    private long _lastQueryKeyTime;
    static /* synthetic */ Class class$com$limegroup$gnutella$MessageRouter;

    protected MessageRouter() {
        this._clientGUID = RouterService.getMyGUID();
    }

    public void initialize() {
        _manager = RouterService.getConnectionManager();
        this._callback = RouterService.getCallback();
        _fileManager = RouterService.getFileManager();
        this._promotionManager = RouterService.getPromotionManager();
        this.QRP_PROPAGATOR.start();
        RouterService.schedule(new Expirer(), 30000L, 30000L);
        RouterService.schedule(new ConnectBackExpirer(), 300000L, 300000L);
        RouterService.schedule(new HopsFlowManager(), 150000L, 15000L);
    }

    public void originateQueryGUID(byte[] byArray) {
        this._queryRouteTable.routeReply(byArray, this.FOR_ME_REPLY_HANDLER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queryKilled(GUID gUID) throws IllegalArgumentException {
        if (gUID == null) {
            throw new IllegalArgumentException("Input GUID is null!");
        }
        Map map = this._bypassedResults;
        synchronized (map) {
            if (!RouterService.getDownloadManager().isGuidForQueryDownloading(gUID)) {
                this._bypassedResults.remove(gUID);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadFinished(GUID gUID) throws IllegalArgumentException {
        if (gUID == null) {
            throw new IllegalArgumentException("Input GUID is null!");
        }
        Map map = this._bypassedResults;
        synchronized (map) {
            if (!this._callback.isQueryAlive(gUID) && !RouterService.getDownloadManager().isGuidForQueryDownloading(gUID)) {
                this._bypassedResults.remove(gUID);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getGuessLocs(GUID gUID) {
        HashSet hashSet = new HashSet();
        Map map = this._bypassedResults;
        synchronized (map) {
            Set set = (Set)this._bypassedResults.get(gUID);
            if (set != null) {
                hashSet.addAll(set);
            }
        }
        return hashSet;
    }

    public String getPingRouteTableDump() {
        return this._pingRouteTable.toString();
    }

    public String getQueryRouteTableDump() {
        return this._queryRouteTable.toString();
    }

    public String getPushRouteTableDump() {
        return this._pushRouteTable.toString();
    }

    public void removeConnection(ReplyHandler replyHandler) {
        this.DYNAMIC_QUERIER.removeReplyHandler(replyHandler);
        this._pingRouteTable.removeReplyHandler(replyHandler);
        this._queryRouteTable.removeReplyHandler(replyHandler);
        this._pushRouteTable.removeReplyHandler(replyHandler);
        this._headPongRouteTable.removeReplyHandler(replyHandler);
    }

    public void handleMessage(Message message, ManagedConnection managedConnection) {
        message.hop();
        if (message instanceof PingRequest) {
            ReceivedMessageStatHandler.TCP_PING_REQUESTS.addMessage(message);
            this.handlePingRequestPossibleDuplicate((PingRequest)message, managedConnection);
        } else if (message instanceof PingReply) {
            ReceivedMessageStatHandler.TCP_PING_REPLIES.addMessage(message);
            this.handlePingReply((PingReply)message, managedConnection);
        } else if (message instanceof QueryRequest) {
            ReceivedMessageStatHandler.TCP_QUERY_REQUESTS.addMessage(message);
            this.handleQueryRequestPossibleDuplicate((QueryRequest)message, managedConnection);
        } else if (message instanceof QueryReply) {
            ReceivedMessageStatHandler.TCP_QUERY_REPLIES.addMessage(message);
            QueryReply queryReply = (QueryReply)message;
            this.handleQueryReply(queryReply, managedConnection);
        } else if (message instanceof PushRequest) {
            ReceivedMessageStatHandler.TCP_PUSH_REQUESTS.addMessage(message);
            this.handlePushRequest((PushRequest)message, managedConnection);
        } else if (message instanceof ResetTableMessage) {
            ReceivedMessageStatHandler.TCP_RESET_ROUTE_TABLE_MESSAGES.addMessage(message);
            this.handleResetTableMessage((ResetTableMessage)message, managedConnection);
        } else if (message instanceof PatchTableMessage) {
            ReceivedMessageStatHandler.TCP_PATCH_ROUTE_TABLE_MESSAGES.addMessage(message);
            this.handlePatchTableMessage((PatchTableMessage)message, managedConnection);
        } else if (message instanceof TCPConnectBackVendorMessage) {
            ReceivedMessageStatHandler.TCP_TCP_CONNECTBACK.addMessage(message);
            this.handleTCPConnectBackRequest((TCPConnectBackVendorMessage)message, managedConnection);
        } else if (message instanceof UDPConnectBackVendorMessage) {
            ReceivedMessageStatHandler.TCP_UDP_CONNECTBACK.addMessage(message);
            this.handleUDPConnectBackRequest((UDPConnectBackVendorMessage)message, managedConnection);
        } else if (message instanceof TCPConnectBackRedirect) {
            this.handleTCPConnectBackRedirect((TCPConnectBackRedirect)message, managedConnection);
        } else if (message instanceof UDPConnectBackRedirect) {
            this.handleUDPConnectBackRedirect((UDPConnectBackRedirect)message, managedConnection);
        } else if (message instanceof PushProxyRequest) {
            this.handlePushProxyRequest((PushProxyRequest)message, managedConnection);
        } else if (message instanceof QueryStatusResponse) {
            this.handleQueryStatus((QueryStatusResponse)message, managedConnection);
        } else if (message instanceof GiveStatsVendorMessage) {
            this.handleGiveStats((GiveStatsVendorMessage)message, managedConnection);
        } else if (message instanceof StatisticVendorMessage) {
            this.handleStatisticsMessage((StatisticVendorMessage)message, managedConnection);
        } else if (message instanceof HeadPing) {
            this.handleHeadPing((HeadPing)message, managedConnection);
        } else if (message instanceof SimppRequestVM) {
            this.handleSimppRequest((SimppRequestVM)message, managedConnection);
        } else if (message instanceof SimppVM) {
            this.handleSimppVM((SimppVM)message);
        } else if (message instanceof HeadPong) {
            this.handleHeadPong((HeadPong)message, managedConnection);
        } else if (message instanceof VendorMessage) {
            managedConnection.handleVendorMessage((VendorMessage)message);
        }
        this.notifyMessageListener(message, managedConnection);
    }

    private final void notifyMessageListener(Message message, ReplyHandler replyHandler) {
        List list = (List)this._messageListeners.get(message.getGUID());
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                MessageListener messageListener = (MessageListener)iterator.next();
                messageListener.processMessage(message, replyHandler);
            }
        }
    }

    public void handleUDPMessage(Message message, InetSocketAddress inetSocketAddress) {
        message.hop();
        InetAddress inetAddress = inetSocketAddress.getAddress();
        int n = inetSocketAddress.getPort();
        if (!RouterService.isIpPortValid()) {
            return;
        }
        if (message instanceof UDPConnectionMessage) {
            this._udpConnectionMultiplexor.routeMessage((UDPConnectionMessage)message, inetAddress, n);
            return;
        }
        UDPReplyHandler uDPReplyHandler = new UDPReplyHandler(inetAddress, n);
        if (message instanceof QueryRequest) {
            if (this.hasValidQueryKey(inetAddress, n, (QueryRequest)message)) {
                this.sendAcknowledgement(inetSocketAddress, message.getGUID());
                if (!this.handleUDPQueryRequestPossibleDuplicate((QueryRequest)message, uDPReplyHandler)) {
                    ReceivedMessageStatHandler.UDP_DUPLICATE_QUERIES.addMessage(message);
                }
            }
            ReceivedMessageStatHandler.UDP_QUERY_REQUESTS.addMessage(message);
        } else if (message instanceof QueryReply) {
            QueryReply queryReply = (QueryReply)message;
            ReceivedMessageStatHandler.UDP_QUERY_REPLIES.addMessage(message);
            short s = queryReply.getResultCount();
            if (!queryReply.isReplyToMulticastQuery()) {
                OutOfBandThroughputStat.RESPONSES_RECEIVED.addData(s);
            }
            this.handleQueryReply(queryReply, uDPReplyHandler);
        } else if (message instanceof PingRequest) {
            ReceivedMessageStatHandler.UDP_PING_REQUESTS.addMessage(message);
            this.handleUDPPingRequestPossibleDuplicate((PingRequest)message, uDPReplyHandler, inetSocketAddress);
        } else if (message instanceof PingReply) {
            ReceivedMessageStatHandler.UDP_PING_REPLIES.addMessage(message);
            this.handleUDPPingReply((PingReply)message, uDPReplyHandler, inetAddress, n);
        } else if (message instanceof PushRequest) {
            ReceivedMessageStatHandler.UDP_PUSH_REQUESTS.addMessage(message);
            this.handlePushRequest((PushRequest)message, uDPReplyHandler);
        } else if (message instanceof LimeACKVendorMessage) {
            ReceivedMessageStatHandler.UDP_LIME_ACK.addMessage(message);
            this.handleLimeACKMessage((LimeACKVendorMessage)message, inetSocketAddress);
        } else if (message instanceof ReplyNumberVendorMessage) {
            this.handleReplyNumberMessage((ReplyNumberVendorMessage)message, inetSocketAddress);
        } else if (message instanceof GiveStatsVendorMessage) {
            this.handleGiveStats((GiveStatsVendorMessage)message, uDPReplyHandler);
        } else if (message instanceof StatisticVendorMessage) {
            this.handleStatisticsMessage((StatisticVendorMessage)message, uDPReplyHandler);
        } else if (message instanceof UDPCrawlerPing) {
            this.handleUDPCrawlerPing((UDPCrawlerPing)message, uDPReplyHandler);
        } else if (message instanceof HeadPing) {
            this.handleHeadPing((HeadPing)message, uDPReplyHandler);
        }
        this.notifyMessageListener(message, uDPReplyHandler);
    }

    public void handleMulticastMessage(Message message, InetSocketAddress inetSocketAddress) {
        if (message.getTTL() > 1) {
            return;
        }
        message.hop();
        InetAddress inetAddress = inetSocketAddress.getAddress();
        int n = inetSocketAddress.getPort();
        if (NetworkUtils.isLocalAddress(inetAddress) && !ConnectionSettings.ALLOW_MULTICAST_LOOPBACK.getValue()) {
            return;
        }
        UDPReplyHandler uDPReplyHandler = new UDPReplyHandler(inetAddress, n);
        if (message instanceof QueryRequest) {
            if (!this.handleUDPQueryRequestPossibleDuplicate((QueryRequest)message, uDPReplyHandler)) {
                ReceivedMessageStatHandler.MULTICAST_DUPLICATE_QUERIES.addMessage(message);
            }
            ReceivedMessageStatHandler.MULTICAST_QUERY_REQUESTS.addMessage(message);
        } else if (message instanceof PingRequest) {
            ReceivedMessageStatHandler.MULTICAST_PING_REQUESTS.addMessage(message);
            this.handleUDPPingRequestPossibleDuplicate((PingRequest)message, uDPReplyHandler, inetSocketAddress);
        } else if (message instanceof PushRequest) {
            ReceivedMessageStatHandler.MULTICAST_PUSH_REQUESTS.addMessage(message);
            this.handlePushRequest((PushRequest)message, uDPReplyHandler);
        }
        this.notifyMessageListener(message, uDPReplyHandler);
    }

    protected boolean hasValidQueryKey(InetAddress inetAddress, int n, QueryRequest queryRequest) {
        if (queryRequest.getQueryKey() == null) {
            return false;
        }
        QueryKey queryKey = QueryKey.getQueryKey(inetAddress, n);
        return queryRequest.getQueryKey().equals(queryKey);
    }

    protected void sendAcknowledgement(InetSocketAddress inetSocketAddress, byte[] byArray) {
        PingReply pingReply;
        ConnectionManager connectionManager = RouterService.getConnectionManager();
        Endpoint endpoint = connectionManager.getConnectedGUESSUltrapeer();
        if (endpoint != null) {
            try {
                pingReply = PingReply.createGUESSReply(byArray, (byte)1, endpoint);
            }
            catch (UnknownHostException unknownHostException) {
                pingReply = this.createPingReply(byArray);
            }
        } else {
            pingReply = this.createPingReply(byArray);
        }
        if (pingReply == null) {
            return;
        }
        UDPService.instance().send(pingReply, inetSocketAddress.getAddress(), inetSocketAddress.getPort());
        SentMessageStatHandler.UDP_PING_REPLIES.addMessage(pingReply);
    }

    private PingReply createPingReply(byte[] byArray) {
        GUESSEndpoint gUESSEndpoint = this.UNICASTER.getUnicastEndpoint();
        if (gUESSEndpoint == null) {
            if (RouterService.isIpPortValid()) {
                return PingReply.create(byArray, (byte)1);
            }
            return null;
        }
        return PingReply.createGUESSReply(byArray, (byte)1, gUESSEndpoint.getPort(), gUESSEndpoint.getAddress().getAddress());
    }

    final void handlePingRequestPossibleDuplicate(PingRequest pingRequest, ReplyHandler replyHandler) {
        if (this._pingRouteTable.tryToRouteReply(pingRequest.getGUID(), replyHandler) != null) {
            this.handlePingRequest(pingRequest, replyHandler);
        }
    }

    final void handleUDPPingRequestPossibleDuplicate(PingRequest pingRequest, ReplyHandler replyHandler, InetSocketAddress inetSocketAddress) {
        if (this._pingRouteTable.tryToRouteReply(pingRequest.getGUID(), replyHandler) != null) {
            this.handleUDPPingRequest(pingRequest, replyHandler, inetSocketAddress);
        }
    }

    final void handleQueryRequestPossibleDuplicate(QueryRequest queryRequest, ManagedConnection managedConnection) {
        boolean bl = queryRequest.getTTL() == 0 && (queryRequest.getHops() == 1 || queryRequest.getHops() == 2);
        ResultCounter resultCounter = this._queryRouteTable.tryToRouteReply(queryRequest.getGUID(), managedConnection);
        if (resultCounter != null) {
            if (bl) {
                this._queryRouteTable.setTTL(resultCounter, (byte)1);
            }
            this.handleQueryRequest(queryRequest, managedConnection, resultCounter, true);
        } else if (resultCounter == null && !bl) {
            if (this.wasProbeQuery(queryRequest)) {
                this.handleQueryRequest(queryRequest, managedConnection, resultCounter, false);
            } else {
                this.tallyDupQuery(queryRequest);
            }
        } else if (resultCounter == null && bl) {
            this.tallyDupQuery(queryRequest);
        } else {
            this.tallyDupQuery(queryRequest);
        }
    }

    private boolean wasProbeQuery(QueryRequest queryRequest) {
        return queryRequest.getTTL() > 0 && this._queryRouteTable.getAndSetTTL(queryRequest.getGUID(), (byte)1, (byte)(queryRequest.getTTL() + 1));
    }

    private void tallyDupQuery(QueryRequest queryRequest) {
        ReceivedMessageStatHandler.TCP_DUPLICATE_QUERIES.addMessage(queryRequest);
    }

    final boolean handleUDPQueryRequestPossibleDuplicate(QueryRequest queryRequest, ReplyHandler replyHandler) {
        ResultCounter resultCounter = this._queryRouteTable.tryToRouteReply(queryRequest.getGUID(), replyHandler);
        if (resultCounter != null) {
            this.handleQueryRequest(queryRequest, replyHandler, resultCounter, true);
            return true;
        }
        return false;
    }

    private final void handlePingRequest(PingRequest pingRequest, ReplyHandler replyHandler) {
        if (pingRequest.isHeartbeat() || replyHandler.allowNewPings()) {
            this.respondToPingRequest(pingRequest, replyHandler);
        }
    }

    protected void handleUDPPingRequest(PingRequest pingRequest, ReplyHandler replyHandler, InetSocketAddress inetSocketAddress) {
        if (pingRequest.isQueryKeyRequest()) {
            this.sendQueryKeyPong(pingRequest, inetSocketAddress);
        } else {
            this.respondToUDPPingRequest(pingRequest, inetSocketAddress, replyHandler);
        }
    }

    protected void sendQueryKeyPong(PingRequest pingRequest, InetSocketAddress inetSocketAddress) {
        long l = System.currentTimeMillis();
        if (l - this._lastQueryKeyTime < (long)SearchSettings.QUERY_KEY_DELAY.getValue()) {
            return;
        }
        this._lastQueryKeyTime = l;
        InetAddress inetAddress = inetSocketAddress.getAddress();
        int n = inetSocketAddress.getPort();
        QueryKey queryKey = QueryKey.getQueryKey(inetAddress, n);
        PingReply pingReply = PingReply.createQueryKeyReply(pingRequest.getGUID(), (byte)1, queryKey);
        UDPService.instance().send(pingReply, inetSocketAddress.getAddress(), inetSocketAddress.getPort());
    }

    protected void handleUDPPingReply(PingReply pingReply, ReplyHandler replyHandler, InetAddress inetAddress, int n) {
        if (pingReply.getQueryKey() != null) {
            OnDemandUnicaster.handleQueryKeyPong(pingReply);
            return;
        }
        if (pingReply.getPort() != n || !pingReply.getInetAddress().equals(inetAddress)) {
            this.UNICASTER.addUnicastEndpoint(inetAddress, n);
        }
        this.handlePingReply(pingReply, replyHandler);
    }

    protected void handleQueryRequest(QueryRequest queryRequest, ReplyHandler replyHandler, ResultCounter resultCounter, boolean bl) {
        if (!replyHandler.isPersonalSpam(queryRequest)) {
            this._callback.handleQueryString(queryRequest.getQuery());
        }
        this.updateMessage(queryRequest, replyHandler);
        if (replyHandler.isSupernodeClientConnection() && resultCounter != null) {
            if (queryRequest.desiresOutOfBandReplies()) {
                String string = replyHandler.getInetAddress().getHostAddress();
                String string2 = NetworkUtils.ip2string(RouterService.getAddress());
                if (!(queryRequest.getReplyAddress().equals(string) || queryRequest.getReplyAddress().equals(string2) && RouterService.isOOBCapable())) {
                    return;
                }
            }
            bl = false;
            this.respondToQueryRequest(queryRequest, this._clientGUID, replyHandler);
            this.multicastQueryRequest(queryRequest);
            if (replyHandler.isGoodLeaf()) {
                this.sendDynamicQuery(QueryHandler.createHandlerForNewLeaf(queryRequest, replyHandler, resultCounter), replyHandler);
            } else {
                this.sendDynamicQuery(QueryHandler.createHandlerForOldLeaf(queryRequest, replyHandler, resultCounter), replyHandler);
            }
        } else if (queryRequest.getTTL() > 0 && RouterService.isSupernode()) {
            if (replyHandler.isGoodUltrapeer()) {
                this.forwardQueryToUltrapeers(queryRequest, replyHandler);
            } else {
                this.forwardLimitedQueryToUltrapeers(queryRequest, replyHandler);
            }
        }
        if (bl) {
            this.forwardQueryRequestToLeaves(queryRequest, replyHandler);
            if (!(!queryRequest.isFirewalledSource() || RouterService.acceptedIncomingConnection() || queryRequest.canDoFirewalledTransfer() && UDPService.instance().canDoFWT())) {
                return;
            }
            this.respondToQueryRequest(queryRequest, this._clientGUID, replyHandler);
        }
    }

    protected void handleLimeACKMessage(LimeACKVendorMessage limeACKVendorMessage, InetSocketAddress inetSocketAddress) {
        GUID.TimedGUID timedGUID = new GUID.TimedGUID(new GUID(limeACKVendorMessage.getGUID()), 25000L);
        QueryResponseBundle queryResponseBundle = (QueryResponseBundle)this._outOfBandReplies.remove(timedGUID);
        if (queryResponseBundle != null && limeACKVendorMessage.getNumResults() > 0) {
            Object object;
            InetAddress inetAddress = inetSocketAddress.getAddress();
            int n = inetSocketAddress.getPort();
            Iterator iterator = null;
            if (limeACKVendorMessage.getNumResults() < queryResponseBundle._responses.length) {
                object = new Response[limeACKVendorMessage.getNumResults()];
                for (int i = 0; i < ((Response[])object).length; ++i) {
                    object[i] = queryResponseBundle._responses[i];
                }
                iterator = this.responsesToQueryReplies((Response[])object, queryResponseBundle._query, 1);
            } else {
                iterator = this.responsesToQueryReplies(queryResponseBundle._responses, queryResponseBundle._query, 1);
            }
            while (iterator.hasNext()) {
                object = (QueryReply)iterator.next();
                UDPService.instance().send((Message)object, inetAddress, n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleReplyNumberMessage(ReplyNumberVendorMessage replyNumberVendorMessage, InetSocketAddress inetSocketAddress) {
        GUID gUID = new GUID(replyNumberVendorMessage.getGUID());
        int n = RouterService.getSearchResultHandler().getNumResultsForQuery(gUID);
        if (n < 0) {
            n = this.DYNAMIC_QUERIER.getLeafResultsForQuery(gUID);
        }
        if (n < 0 || n > 250) {
            OutOfBandThroughputStat.RESPONSES_BYPASSED.addData(replyNumberVendorMessage.getNumResults());
            if (!replyNumberVendorMessage.canReceiveUnsolicited()) {
                return;
            }
            DownloadManager downloadManager = RouterService.getDownloadManager();
            if (!this._callback.isQueryAlive(gUID) && !downloadManager.isGuidForQueryDownloading(gUID)) {
                return;
            }
            GUESSEndpoint gUESSEndpoint = new GUESSEndpoint(inetSocketAddress.getAddress(), inetSocketAddress.getPort());
            Map map = this._bypassedResults;
            synchronized (map) {
                HashSet<GUESSEndpoint> hashSet = (HashSet<GUESSEndpoint>)this._bypassedResults.get(gUID);
                if (hashSet == null) {
                    hashSet = new HashSet<GUESSEndpoint>();
                    this._bypassedResults.put(gUID, hashSet);
                }
                if (this._bypassedResults.size() <= 150) {
                    hashSet.add(gUESSEndpoint);
                }
            }
            return;
        }
        LimeACKVendorMessage limeACKVendorMessage = new LimeACKVendorMessage(gUID, replyNumberVendorMessage.getNumResults());
        UDPService.instance().send(limeACKVendorMessage, inetSocketAddress.getAddress(), inetSocketAddress.getPort());
        OutOfBandThroughputStat.RESPONSES_REQUESTED.addData(replyNumberVendorMessage.getNumResults());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean bufferResponsesForLaterDelivery(QueryRequest queryRequest, Response[] responseArray) {
        Map map = this._outOfBandReplies;
        synchronized (map) {
            if (this._outOfBandReplies.size() < MAX_BUFFERED_REPLIES) {
                GUID.TimedGUID timedGUID = new GUID.TimedGUID(new GUID(queryRequest.getGUID()), 25000L);
                this._outOfBandReplies.put(timedGUID, new QueryResponseBundle(queryRequest, responseArray));
                return true;
            }
            return false;
        }
    }

    protected void handleUDPConnectBackRequest(UDPConnectBackVendorMessage uDPConnectBackVendorMessage, Connection connection) {
        GUID gUID = uDPConnectBackVendorMessage.getConnectBackGUID();
        int n = uDPConnectBackVendorMessage.getConnectBackPort();
        InetAddress inetAddress = connection.getInetAddress();
        UDPConnectBackRedirect uDPConnectBackRedirect = new UDPConnectBackRedirect(gUID, inetAddress, n);
        int n2 = 0;
        ArrayList arrayList = new ArrayList(_manager.getInitializedConnections());
        Collections.shuffle(arrayList);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext() && n2 < 5) {
            ManagedConnection managedConnection = (ManagedConnection)iterator.next();
            if (managedConnection == connection || managedConnection.remoteHostSupportsUDPRedirect() < 0) continue;
            managedConnection.send(uDPConnectBackRedirect);
            ++n2;
        }
    }

    protected void handleUDPConnectBackRedirect(UDPConnectBackRedirect uDPConnectBackRedirect, Connection connection) {
        if (!connection.isSupernodeSupernodeConnection()) {
            return;
        }
        GUID gUID = uDPConnectBackRedirect.getConnectBackGUID();
        int n = uDPConnectBackRedirect.getConnectBackPort();
        InetAddress inetAddress = uDPConnectBackRedirect.getConnectBackAddress();
        Endpoint endpoint = new Endpoint(inetAddress.getAddress(), n);
        if (_manager.isConnectedTo(endpoint.getAddress())) {
            return;
        }
        String string = inetAddress.getHostAddress();
        if (!this.shouldServiceRedirect(_udpConnectBacks, string)) {
            return;
        }
        PingRequest pingRequest = new PingRequest(gUID.bytes(), 1, 0);
        UDPService.instance().send(pingRequest, inetAddress, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shouldServiceRedirect(FixedsizeHashMap fixedsizeHashMap, Object object) {
        FixedsizeHashMap fixedsizeHashMap2 = fixedsizeHashMap;
        synchronized (fixedsizeHashMap2) {
            Object object2 = fixedsizeHashMap.get(object);
            if (object2 == null) {
                try {
                    fixedsizeHashMap.put(object, fixedsizeHashMap);
                    return true;
                }
                catch (NoMoreStorageException noMoreStorageException) {
                    return false;
                }
            }
            return false;
        }
    }

    protected void handleTCPConnectBackRequest(TCPConnectBackVendorMessage tCPConnectBackVendorMessage, Connection connection) {
        int n = tCPConnectBackVendorMessage.getConnectBackPort();
        InetAddress inetAddress = connection.getInetAddress();
        TCPConnectBackRedirect tCPConnectBackRedirect = new TCPConnectBackRedirect(inetAddress, n);
        int n2 = 0;
        ArrayList arrayList = new ArrayList(_manager.getInitializedConnections());
        Collections.shuffle(arrayList);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext() && n2 < 5) {
            ManagedConnection managedConnection = (ManagedConnection)iterator.next();
            if (managedConnection == connection || managedConnection.remoteHostSupportsTCPRedirect() < 0) continue;
            managedConnection.send(tCPConnectBackRedirect);
            ++n2;
        }
    }

    protected void handleTCPConnectBackRedirect(TCPConnectBackRedirect tCPConnectBackRedirect, Connection connection) {
        if (!connection.isSupernodeSupernodeConnection()) {
            return;
        }
        final int n = tCPConnectBackRedirect.getConnectBackPort();
        final String string = tCPConnectBackRedirect.getConnectBackAddress().getHostAddress();
        Endpoint endpoint = new Endpoint(string, n);
        if (_manager.isConnectedTo(endpoint.getAddress())) {
            return;
        }
        if (!this.shouldServiceRedirect(_tcpConnectBacks, string)) {
            return;
        }
        TCP_CONNECT_BACKER.add(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            public void run() {
                Socket socket = null;
                try {
                    socket = Sockets.connect(string, n, 12000);
                    OutputStream outputStream = socket.getOutputStream();
                    outputStream.write("CONNECT BACK\r\n\r\n".getBytes());
                    outputStream.flush();
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Succesful connectback to: " + string));
                    }
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        LOG.warn((Object)"Interrupted connectback", (Throwable)interruptedException);
                    }
                }
                catch (IOException iOException) {
                    LOG.warn((Object)"IOX during connectback", (Throwable)iOException);
                    IOUtils.close(socket);
                }
                catch (Throwable throwable) {
                    ErrorService.error(throwable);
                    {
                        catch (Throwable throwable2) {
                            IOUtils.close(socket);
                            throw throwable2;
                        }
                    }
                    IOUtils.close(socket);
                }
                IOUtils.close(socket);
            }
        });
    }

    protected void handlePushProxyRequest(PushProxyRequest pushProxyRequest, ManagedConnection managedConnection) {
        if (managedConnection.isSupernodeClientConnection() && RouterService.isIpPortValid()) {
            String string = NetworkUtils.ip2string(RouterService.getAddress());
            InetAddress inetAddress = null;
            try {
                inetAddress = InetAddress.getByName(string);
            }
            catch (UnknownHostException unknownHostException) {
                ErrorService.error(unknownHostException);
            }
            PushProxyAcknowledgement pushProxyAcknowledgement = new PushProxyAcknowledgement(inetAddress, RouterService.getPort(), pushProxyRequest.getClientGUID());
            managedConnection.send(pushProxyAcknowledgement);
            this._pushRouteTable.routeReply(pushProxyRequest.getClientGUID().bytes(), managedConnection);
        }
    }

    protected void handleQueryStatus(QueryStatusResponse queryStatusResponse, ManagedConnection managedConnection) {
        if (!managedConnection.isSupernodeClientConnection()) {
            return;
        }
        GUID gUID = queryStatusResponse.getQueryGUID();
        int n = queryStatusResponse.getNumResults();
        this.DYNAMIC_QUERIER.updateLeafResultsForQuery(gUID, n);
    }

    public void sendPingRequest(PingRequest pingRequest, ManagedConnection managedConnection) {
        if (pingRequest == null) {
            throw new NullPointerException("null ping");
        }
        if (managedConnection == null) {
            throw new NullPointerException("null connection");
        }
        this._pingRouteTable.routeReply(pingRequest.getGUID(), this.FOR_ME_REPLY_HANDLER);
        managedConnection.send(pingRequest);
    }

    public void sendQueryRequest(QueryRequest queryRequest, ManagedConnection managedConnection) {
        if (queryRequest == null) {
            throw new NullPointerException("null query");
        }
        if (managedConnection == null) {
            throw new NullPointerException("null connection");
        }
        this._queryRouteTable.routeReply(queryRequest.getGUID(), this.FOR_ME_REPLY_HANDLER);
        managedConnection.send(queryRequest);
    }

    public void broadcastPingRequest(PingRequest pingRequest) {
        if (pingRequest == null) {
            throw new NullPointerException("null ping");
        }
        this._pingRouteTable.routeReply(pingRequest.getGUID(), this.FOR_ME_REPLY_HANDLER);
        this.broadcastPingRequest(pingRequest, this.FOR_ME_REPLY_HANDLER, _manager);
    }

    public void sendDynamicQuery(QueryRequest queryRequest) {
        if (queryRequest == null) {
            throw new NullPointerException("null QueryHandler");
        }
        ResultCounter resultCounter = this._queryRouteTable.routeReply(queryRequest.getGUID(), this.FOR_ME_REPLY_HANDLER);
        if (RouterService.isSupernode()) {
            this.sendDynamicQuery(QueryHandler.createHandlerForMe(queryRequest, resultCounter), this.FOR_ME_REPLY_HANDLER);
        } else {
            this.originateLeafQuery(queryRequest);
        }
        this.multicastQueryRequest(QueryRequest.createMulticastQuery(queryRequest));
    }

    private void sendDynamicQuery(QueryHandler queryHandler, ReplyHandler replyHandler) {
        if (queryHandler == null) {
            throw new NullPointerException("null QueryHandler");
        }
        if (replyHandler == null) {
            throw new NullPointerException("null ReplyHandler");
        }
        this.DYNAMIC_QUERIER.addQuery(queryHandler);
    }

    private void broadcastPingRequest(PingRequest pingRequest, ReplyHandler replyHandler, ConnectionManager connectionManager) {
        List list = connectionManager.getInitializedConnections();
        int n = list.size();
        boolean bl = false;
        if (n > 3) {
            bl = true;
        }
        for (int i = 0; i < n; ++i) {
            ManagedConnection managedConnection = (ManagedConnection)list.get(i);
            if (!managedConnection.isStable() || replyHandler != this.FOR_ME_REPLY_HANDLER && (managedConnection == replyHandler || managedConnection.isClientSupernodeConnection())) continue;
            double d = managedConnection.supportsPongCaching() ? 0.7 : 0.9;
            if (bl && Math.random() < d) continue;
            managedConnection.send(pingRequest);
        }
    }

    public final void forwardQueryRequestToLeaves(QueryRequest queryRequest, ReplyHandler replyHandler) {
        int n;
        if (!RouterService.isSupernode()) {
            return;
        }
        List list = _manager.getInitializedClientConnections();
        List<ManagedConnection> list2 = new ArrayList<ManagedConnection>();
        for (n = 0; n < list.size(); ++n) {
            ManagedConnection managedConnection = (ManagedConnection)list.get(n);
            if (managedConnection == replyHandler || !managedConnection.shouldForwardQuery(queryRequest)) continue;
            list2.add(managedConnection);
        }
        if (list.size() > 8 && (double)list2.size() / (double)list.size() > 0.8) {
            n = (int)Math.floor(Math.random() * (double)list2.size() * 0.75);
            list2 = list2.subList(n, n + list2.size() / 4);
        }
        n = list.size() - list2.size();
        RoutedQueryStat.LEAF_DROP.addData(n);
        for (int i = 0; i < list2.size(); ++i) {
            ManagedConnection managedConnection = (ManagedConnection)list2.get(i);
            managedConnection.send(queryRequest);
            RoutedQueryStat.LEAF_SEND.incrementStat();
        }
    }

    private boolean sendRoutedQueryToHost(QueryRequest queryRequest, ManagedConnection managedConnection, ReplyHandler replyHandler) {
        if (managedConnection.shouldForwardQuery(queryRequest)) {
            managedConnection.send(queryRequest);
            return true;
        }
        return false;
    }

    protected void unicastQueryRequest(QueryRequest queryRequest, ReplyHandler replyHandler) {
        queryRequest.setTTL((byte)1);
        this.UNICASTER.addQuery(queryRequest, replyHandler);
    }

    protected void multicastQueryRequest(QueryRequest queryRequest) {
        queryRequest.setTTL((byte)1);
        SentMessageStatHandler.MULTICAST_QUERY_REQUESTS.addMessage(queryRequest);
        MulticastService.instance().send(queryRequest);
    }

    private void forwardQueryToUltrapeers(QueryRequest queryRequest, ReplyHandler replyHandler) {
        List list = _manager.getInitializedConnections();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            ManagedConnection managedConnection = (ManagedConnection)list.get(i);
            this.forwardQueryToUltrapeer(queryRequest, replyHandler, managedConnection);
        }
    }

    private void forwardLimitedQueryToUltrapeers(QueryRequest queryRequest, ReplyHandler replyHandler) {
        List list = _manager.getInitializedConnections();
        int n = list.size();
        int n2 = 15;
        for (int i = 0; i < n && n2 != 0; ++i) {
            ManagedConnection managedConnection = (ManagedConnection)list.get(i);
            if (managedConnection.isGoodUltrapeer() && n - i > n2) continue;
            this.forwardQueryToUltrapeer(queryRequest, replyHandler, managedConnection);
            --n2;
        }
    }

    private void forwardQueryToUltrapeer(QueryRequest queryRequest, ReplyHandler replyHandler, ManagedConnection managedConnection) {
        boolean bl;
        if (managedConnection == replyHandler) {
            return;
        }
        if (managedConnection.isClientSupernodeConnection()) {
            return;
        }
        if (queryRequest.isFeatureQuery() && !managedConnection.getRemoteHostSupportsFeatureQueries()) {
            return;
        }
        boolean bl2 = bl = queryRequest.getTTL() == 1;
        if (bl && managedConnection.isUltrapeerQueryRoutingConnection()) {
            boolean bl3 = this.sendRoutedQueryToHost(queryRequest, managedConnection, replyHandler);
            if (bl3) {
                RoutedQueryStat.ULTRAPEER_SEND.incrementStat();
            } else {
                RoutedQueryStat.ULTRAPEER_DROP.incrementStat();
            }
        } else {
            managedConnection.send(queryRequest);
        }
    }

    private void originateLeafQuery(QueryRequest queryRequest) {
        List list = _manager.getInitializedConnections();
        int n = queryRequest.isWhatIsNewRequest() ? 2 : 5;
        int n2 = !queryRequest.isWhatIsNewRequest() ? 0 : (int)Math.floor(Math.random() * (double)(list.size() - 1));
        int n3 = Math.min(n, list.size());
        boolean bl = queryRequest.desiresOutOfBandReplies();
        for (int i = n2; i < n2 + n3; ++i) {
            ManagedConnection managedConnection = (ManagedConnection)list.get(i);
            QueryRequest queryRequest2 = queryRequest;
            if (bl && managedConnection.remoteHostSupportsLeafGuidance() < 0) {
                queryRequest2 = QueryRequest.unmarkOOBQuery(queryRequest);
            }
            managedConnection.send(queryRequest2);
        }
    }

    public boolean originateQuery(QueryRequest queryRequest, ManagedConnection managedConnection) {
        if (queryRequest == null) {
            throw new NullPointerException("null query");
        }
        if (managedConnection == null) {
            throw new NullPointerException("null connection");
        }
        if (queryRequest.isFeatureQuery() && !managedConnection.getRemoteHostSupportsFeatureQueries()) {
            return false;
        }
        managedConnection.originateQuery(queryRequest);
        return true;
    }

    protected abstract void respondToPingRequest(PingRequest var1, ReplyHandler var2);

    protected abstract void respondToUDPPingRequest(PingRequest var1, InetSocketAddress var2, ReplyHandler var3);

    protected abstract boolean respondToQueryRequest(QueryRequest var1, byte[] var2, ReplyHandler var3);

    protected void handlePingReply(PingReply pingReply, ReplyHandler replyHandler) {
        ReplyHandler replyHandler2;
        boolean bl = RouterService.getHostCatcher().add(pingReply);
        if (bl && !pingReply.isUDPHostCache()) {
            PongCacher.instance().addPong(pingReply);
        }
        if ((replyHandler2 = this._pingRouteTable.getReplyHandler(pingReply.getGUID())) != null) {
            replyHandler2.handlePingReply(pingReply, replyHandler);
        } else {
            RouteErrorStat.PING_REPLY_ROUTE_ERRORS.incrementStat();
            replyHandler.countDroppedMessage();
        }
        boolean bl2 = pingReply.supportsUnicast();
        if (bl && (pingReply.isUltrapeer() || bl2)) {
            List list = _manager.getInitializedClientConnections();
            for (int i = 0; i < list.size(); ++i) {
                ManagedConnection managedConnection = (ManagedConnection)list.get(i);
                Assert.that(managedConnection != null, "null c.");
                if (managedConnection == replyHandler || managedConnection == replyHandler2 || !managedConnection.allowNewPongs()) continue;
                managedConnection.handlePingReply(pingReply, replyHandler);
            }
        }
    }

    public void handleQueryReply(QueryReply queryReply, ReplyHandler replyHandler) {
        if (queryReply == null) {
            throw new NullPointerException("null query reply");
        }
        if (replyHandler == null) {
            throw new NullPointerException("null ReplyHandler");
        }
        RouteTable.ReplyRoutePair replyRoutePair = this._queryRouteTable.getReplyHandler(queryReply.getGUID(), queryReply.getTotalLength(), queryReply.getResultCount());
        if (replyRoutePair != null) {
            queryReply.setPriority(replyRoutePair.getBytesRouted());
            this._pushRouteTable.routeReply(queryReply.getClientGUID(), replyHandler);
            ReplyHandler replyHandler2 = replyRoutePair.getReplyHandler();
            if (!this.shouldDropReply(replyRoutePair, replyHandler2, queryReply)) {
                replyHandler2.handleQueryReply(queryReply, replyHandler);
                this.UNICASTER.handleQueryReply(queryReply);
            } else {
                RouteErrorStat.HARD_LIMIT_QUERY_REPLY_ROUTE_ERRORS.incrementStat();
                byte by = queryReply.getTTL();
                if (by < RouteErrorStat.HARD_LIMIT_QUERY_REPLY_TTL.length) {
                    RouteErrorStat.HARD_LIMIT_QUERY_REPLY_TTL[by].incrementStat();
                } else {
                    RouteErrorStat.HARD_LIMIT_QUERY_REPLY_TTL[RouteErrorStat.HARD_LIMIT_QUERY_REPLY_TTL.length - 1].incrementStat();
                }
                replyHandler.countDroppedMessage();
            }
        } else {
            RouteErrorStat.NO_ROUTE_QUERY_REPLY_ROUTE_ERRORS.incrementStat();
            replyHandler.countDroppedMessage();
        }
    }

    private boolean shouldDropReply(RouteTable.ReplyRoutePair replyRoutePair, ReplyHandler replyHandler, QueryReply queryReply) {
        byte by = queryReply.getTTL();
        if (replyHandler == this.FOR_ME_REPLY_HANDLER) {
            return false;
        }
        if (by == 0) {
            return true;
        }
        int n = replyRoutePair.getResultsRouted();
        if (n > 100) {
            return true;
        }
        int n2 = replyRoutePair.getBytesRouted();
        if (by > 2 && n2 < 51200) {
            return false;
        }
        if (by == 1 && n2 < 204800) {
            return false;
        }
        return by != 2 || n2 >= 102400;
    }

    private void handleGiveStats(GiveStatsVendorMessage giveStatsVendorMessage, ReplyHandler replyHandler) {
        StatisticVendorMessage statisticVendorMessage = null;
        try {
            if (StatisticVendorMessage.isSupported(giveStatsVendorMessage)) {
                statisticVendorMessage = new StatisticVendorMessage(giveStatsVendorMessage);
                replyHandler.handleStatisticVM(statisticVendorMessage);
            }
        }
        catch (IOException iOException) {
            return;
        }
    }

    private void handleStatisticsMessage(final StatisticVendorMessage statisticVendorMessage, ReplyHandler replyHandler) {
        if (StatisticsSettings.RECORD_VM_STATS.getValue()) {
            ManagedThread managedThread = new ManagedThread("Stat writer "){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public void managedRun() {
                    RandomAccessFile randomAccessFile = null;
                    randomAccessFile = new RandomAccessFile("stats_log.log", "rw");
                    randomAccessFile.seek(randomAccessFile.length());
                    randomAccessFile.writeBytes(statisticVendorMessage.getReportedStats() + "\n");
                    Object var4_2 = null;
                    if (randomAccessFile == null) return;
                    try {
                        randomAccessFile.close();
                        return;
                    }
                    catch (IOException iOException) {
                        ErrorService.error(iOException);
                    }
                    return;
                    {
                        catch (IOException iOException) {
                            ErrorService.error(iOException);
                            Object var4_3 = null;
                            if (randomAccessFile == null) return;
                            try {
                                randomAccessFile.close();
                                return;
                            }
                            catch (IOException iOException2) {
                                ErrorService.error(iOException2);
                            }
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var4_4 = null;
                        if (randomAccessFile == null) throw throwable;
                        try {
                            randomAccessFile.close();
                            throw throwable;
                        }
                        catch (IOException iOException) {
                            ErrorService.error(iOException);
                        }
                        throw throwable;
                    }
                }
            };
            managedThread.start();
        }
    }

    private void handleSimppRequest(SimppRequestVM simppRequestVM, ReplyHandler replyHandler) {
        if (simppRequestVM.getVersion() > 1) {
            return;
        }
        byte[] byArray = SimppManager.instance().getSimppBytes();
        if (byArray != null) {
            SimppVM simppVM = new SimppVM(byArray);
            try {
                replyHandler.handleSimppVM(simppVM);
            }
            catch (IOException iOException) {
                return;
            }
        }
    }

    private void handleSimppVM(SimppVM simppVM) {
        SimppManager.instance().checkAndUpdate(simppVM.getPayload());
    }

    protected void handlePushRequest(PushRequest pushRequest, ReplyHandler replyHandler) {
        if (pushRequest == null) {
            throw new NullPointerException("null request");
        }
        if (replyHandler == null) {
            throw new NullPointerException("null ReplyHandler");
        }
        ReplyHandler replyHandler2 = this.getPushHandler(pushRequest.getClientGUID());
        if (replyHandler2 != null) {
            replyHandler2.handlePushRequest(pushRequest, replyHandler);
        } else {
            RouteErrorStat.PUSH_REQUEST_ROUTE_ERRORS.incrementStat();
            replyHandler.countDroppedMessage();
        }
    }

    protected ReplyHandler getPushHandler(byte[] byArray) {
        ReplyHandler replyHandler = this._pushRouteTable.getReplyHandler(byArray);
        if (replyHandler != null) {
            return replyHandler;
        }
        if (Arrays.equals(this._clientGUID, byArray)) {
            return this.FOR_ME_REPLY_HANDLER;
        }
        return null;
    }

    protected void sendPingReply(PingReply pingReply, ReplyHandler replyHandler) {
        if (pingReply == null) {
            throw new NullPointerException("null pong");
        }
        if (replyHandler == null) {
            throw new NullPointerException("null reply handler");
        }
        replyHandler.handlePingReply(pingReply, null);
    }

    protected void sendQueryReply(QueryReply queryReply) throws IOException {
        if (queryReply == null) {
            throw new NullPointerException("null reply");
        }
        RouteTable.ReplyRoutePair replyRoutePair = this._queryRouteTable.getReplyHandler(queryReply.getGUID(), queryReply.getTotalLength(), queryReply.getResultCount());
        if (replyRoutePair == null) {
            throw new IOException("no route for reply");
        }
        queryReply.setPriority(replyRoutePair.getBytesRouted());
        replyRoutePair.getReplyHandler().handleQueryReply(queryReply, null);
    }

    public void sendPushRequest(PushRequest pushRequest) throws IOException {
        if (pushRequest == null) {
            throw new NullPointerException("null push");
        }
        ReplyHandler replyHandler = this.getPushHandler(pushRequest.getClientGUID());
        if (replyHandler == null) {
            throw new IOException("no route for push");
        }
        replyHandler.handlePushRequest(pushRequest, this.FOR_ME_REPLY_HANDLER);
    }

    protected void sendMulticastPushRequest(PushRequest pushRequest) {
        if (pushRequest == null) {
            throw new NullPointerException("null push");
        }
        Assert.that(pushRequest.getTTL() == 1, "multicast push ttl not 1");
        MulticastService.instance().send(pushRequest);
        SentMessageStatHandler.MULTICAST_PUSH_REQUESTS.addMessage(pushRequest);
    }

    public Iterator responsesToQueryReplies(Response[] responseArray, QueryRequest queryRequest) {
        return this.responsesToQueryReplies(responseArray, queryRequest, 10);
    }

    private Iterator responsesToQueryReplies(Response[] responseArray, QueryRequest queryRequest, int n) {
        int n2;
        Response[] responseArray2;
        int n3;
        LinkedList linkedList = new LinkedList();
        byte[] byArray = queryRequest.getGUID();
        byte by = (byte)(queryRequest.getHops() + 1);
        UploadManager uploadManager = RouterService.getUploadManager();
        long l = uploadManager.measuredUploadSpeed();
        boolean bl = true;
        if (l == -1L) {
            l = ConnectionSettings.CONNECTION_SPEED.getValue();
            bl = false;
        }
        int n4 = responseArray.length;
        int n5 = 0;
        byte by2 = queryRequest.getHops();
        if (n > 1 && by2 > 2 && n4 > 10) {
            n3 = (int)(Math.random() * (double)n4) % (n4 - 10);
            responseArray2 = new Response[10];
            n2 = 0;
            while (n2 < 10) {
                responseArray2[n2] = responseArray[n3];
                ++n2;
                ++n3;
            }
            responseArray = responseArray2;
            n4 = responseArray.length;
        }
        while (n4 > 0) {
            boolean bl2;
            n3 = n4 < n ? n4 : n;
            if (n5 == 0 && n3 < n) {
                responseArray2 = responseArray;
            } else {
                responseArray2 = new Response[n3];
                for (n2 = 0; n2 < n3; ++n2) {
                    responseArray2[n2] = responseArray[n5];
                    ++n5;
                }
            }
            n4 -= n3;
            n2 = !uploadManager.isServiceable() ? 1 : 0;
            boolean bl3 = uploadManager.hadSuccesfulUpload();
            boolean bl4 = queryRequest.isMulticast() && queryRequest.getTTL() + queryRequest.getHops() == 1;
            boolean bl5 = bl2 = queryRequest.canDoFirewalledTransfer() && UDPService.instance().canDoFWT() && !RouterService.acceptedIncomingConnection();
            if (bl4) {
                by = 1;
            }
            List list = this.createQueryReply(byArray, by, l, responseArray2, this._clientGUID, n2 != 0, bl3, bl, bl4, bl2);
            linkedList.addAll(list);
        }
        return linkedList.iterator();
    }

    protected abstract List createQueryReply(byte[] var1, byte var2, long var3, Response[] var5, byte[] var6, boolean var7, boolean var8, boolean var9, boolean var10, boolean var11);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleResetTableMessage(ResetTableMessage resetTableMessage, ManagedConnection managedConnection) {
        if (!MessageRouter.isQRPConnection(managedConnection)) {
            return;
        }
        Object object = managedConnection.getQRPLock();
        synchronized (object) {
            managedConnection.resetQueryRouteTable(resetTableMessage);
        }
        if (managedConnection.isLeafConnection()) {
            this._lastQueryRouteTable = MessageRouter.createRouteTable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePatchTableMessage(PatchTableMessage patchTableMessage, ManagedConnection managedConnection) {
        if (!MessageRouter.isQRPConnection(managedConnection)) {
            return;
        }
        Object object = managedConnection.getQRPLock();
        synchronized (object) {
            managedConnection.patchQueryRouteTable(patchTableMessage);
        }
        if (managedConnection.isLeafConnection()) {
            this._lastQueryRouteTable = MessageRouter.createRouteTable();
        }
    }

    private void updateMessage(QueryRequest queryRequest, ReplyHandler replyHandler) {
        if (!(replyHandler instanceof Connection)) {
            return;
        }
        Connection connection = (Connection)((Object)replyHandler);
        if (queryRequest.getHops() == 1 && connection.isOldLimeWire()) {
            if (StaticMessages.updateReply == null) {
                return;
            }
            QueryReply queryReply = new QueryReply(queryRequest.getGUID(), StaticMessages.updateReply);
            try {
                this.sendQueryReply(queryReply);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static boolean isQRPConnection(Connection connection) {
        if (connection.isSupernodeClientConnection()) {
            return true;
        }
        return connection.isUltrapeerQueryRoutingConnection();
    }

    private void forwardQueryRouteTables() {
        long l = System.currentTimeMillis();
        List list = _manager.getInitializedConnections();
        QueryRouteTable queryRouteTable = null;
        List list2 = null;
        QueryRouteTable queryRouteTable2 = null;
        for (int i = 0; i < list.size(); ++i) {
            ManagedConnection managedConnection = (ManagedConnection)list.get(i);
            if (!RouterService.isSupernode() ? !managedConnection.isClientSupernodeConnection() || !managedConnection.isQueryRoutingEnabled() : !managedConnection.isUltrapeerQueryRoutingConnection()) continue;
            if (l < managedConnection.getNextQRPForwardTime()) continue;
            managedConnection.incrementNextQRPForwardTime(l);
            if (queryRouteTable == null) {
                this._lastQueryRouteTable = queryRouteTable = MessageRouter.createRouteTable();
            }
            if (queryRouteTable2 == managedConnection.getQueryRouteTableSent()) {
                if (list2 == null) {
                    list2 = queryRouteTable.encode(queryRouteTable2, true);
                }
            } else {
                queryRouteTable2 = managedConnection.getQueryRouteTableSent();
                list2 = queryRouteTable.encode(queryRouteTable2, true);
            }
            if (!ConnectionSettings.SEND_QRP.getValue()) {
                return;
            }
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                managedConnection.send((RouteTableMessage)iterator.next());
            }
            managedConnection.setQueryRouteTableSent(queryRouteTable);
        }
    }

    public QueryRouteTable getQueryRouteTable() {
        return this._lastQueryRouteTable;
    }

    private static QueryRouteTable createRouteTable() {
        QueryRouteTable queryRouteTable = _fileManager.getQRT();
        if (RouterService.isSupernode()) {
            MessageRouter.addQueryRoutingEntriesForLeaves(queryRouteTable);
        }
        return queryRouteTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addQueryRoutingEntriesForLeaves(QueryRouteTable queryRouteTable) {
        List list = _manager.getInitializedClientConnections();
        for (int i = 0; i < list.size(); ++i) {
            ManagedConnection managedConnection = (ManagedConnection)list.get(i);
            Object object = managedConnection.getQRPLock();
            synchronized (object) {
                QueryRouteTable queryRouteTable2;
                if (!managedConnection.isBusyLeaf() && (queryRouteTable2 = managedConnection.getQueryRouteTableReceived()) != null) {
                    queryRouteTable.addAll(queryRouteTable2);
                }
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerMessageListener(byte[] byArray, MessageListener messageListener) {
        messageListener.registered(byArray);
        Object object = this.MESSAGE_LISTENER_LOCK;
        synchronized (object) {
            TreeMap treeMap = new TreeMap(GUID.GUID_BYTE_COMPARATOR);
            treeMap.putAll(this._messageListeners);
            ArrayList<MessageListener> arrayList = (ArrayList<MessageListener>)treeMap.get(byArray);
            if (arrayList == null) {
                arrayList = new ArrayList<MessageListener>(1);
                arrayList.add(messageListener);
            } else {
                ArrayList<MessageListener> arrayList2 = new ArrayList<MessageListener>(arrayList.size() + 1);
                arrayList2.addAll(arrayList);
                arrayList = arrayList2;
                arrayList.add(messageListener);
            }
            treeMap.put(byArray, Collections.unmodifiableList(arrayList));
            this._messageListeners = Collections.unmodifiableMap(treeMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterMessageListener(byte[] byArray, MessageListener messageListener) {
        boolean bl = false;
        Object object = this.MESSAGE_LISTENER_LOCK;
        synchronized (object) {
            ArrayList arrayList = (ArrayList)this._messageListeners.get(byArray);
            if (arrayList != null && (arrayList = new ArrayList(arrayList)).remove(messageListener)) {
                bl = true;
                TreeMap treeMap = new TreeMap(GUID.GUID_BYTE_COMPARATOR);
                treeMap.putAll(this._messageListeners);
                if (arrayList.isEmpty()) {
                    treeMap.remove(byArray);
                } else {
                    treeMap.put(byArray, Collections.unmodifiableList(arrayList));
                }
                this._messageListeners = Collections.unmodifiableMap(treeMap);
            }
        }
        if (bl) {
            messageListener.unregistered(byArray);
        }
    }

    private void handleUDPCrawlerPing(UDPCrawlerPing uDPCrawlerPing, ReplyHandler replyHandler) {
        if (!this._promotionManager.allowUDPPing(replyHandler)) {
            return;
        }
        UDPCrawlerPong uDPCrawlerPong = new UDPCrawlerPong(uDPCrawlerPing);
        replyHandler.reply(uDPCrawlerPong);
    }

    private void handleHeadPing(HeadPing headPing, ReplyHandler replyHandler) {
        if (DownloadSettings.DROP_HEADPINGS.getValue()) {
            return;
        }
        GUID gUID = headPing.getClientGuid();
        ReplyHandler replyHandler2 = gUID != null ? this.getPushHandler(gUID.bytes()) : this.FOR_ME_REPLY_HANDLER;
        if (replyHandler2 == null) {
            return;
        }
        if (replyHandler2 instanceof ForMeReplyHandler) {
            HeadPong headPong = new HeadPong(headPing);
            replyHandler.reply(headPong);
        } else {
            this._headPongRouteTable.routeReply(headPing.getGUID(), replyHandler);
            if (!(replyHandler instanceof Connection) || ((Connection)((Object)replyHandler)).supportsVMRouting()) {
                replyHandler2.reply(headPing);
            } else {
                replyHandler2.reply(new HeadPing(headPing));
            }
        }
    }

    private void handleHeadPong(HeadPong headPong, ReplyHandler replyHandler) {
        ReplyHandler replyHandler2 = this._headPongRouteTable.getReplyHandler(headPong.getGUID());
        if (replyHandler2 != null && !(replyHandler2 instanceof ForMeReplyHandler)) {
            replyHandler2.reply(headPong);
            this._headPongRouteTable.removeReplyHandler(replyHandler2);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        MAX_BUFFERED_REPLIES = 250;
        _udpConnectBacks = new FixedsizeHashMap(200);
        _tcpConnectBacks = new FixedsizeHashMap(200);
        TCP_CONNECT_BACKER = new ProcessingQueue("TCPConnectBack");
        _udpHeadRequests = Collections.synchronizedSet(new FixedSizeExpiringSet(200, ConnectionSettings.SOLICITED_GRACE_PERIOD.getValue() / 2L));
    }

    static class HopsFlowManager
    implements Runnable {
        private static final byte BUSY_HOPS_FLOW = 0;
        private static final byte FREE_HOPS_FLOW = 5;
        private static boolean _oldBusyState = false;

        HopsFlowManager() {
        }

        public void run() {
            if (RouterService.isSupernode()) {
                return;
            }
            boolean bl = !RouterService.getUploadManager().isServiceable();
            List list = _manager.getInitializedConnections();
            HopsFlowVendorMessage hopsFlowVendorMessage = new HopsFlowVendorMessage(bl ? (byte)0 : 5);
            if (bl == _oldBusyState) {
                for (int i = 0; i < list.size(); ++i) {
                    ManagedConnection managedConnection = (ManagedConnection)list.get(i);
                    if (managedConnection == null || !((double)managedConnection.getConnectionTime() + 18750.0 > (double)System.currentTimeMillis()) || !managedConnection.isClientSupernodeConnection()) continue;
                    managedConnection.send(hopsFlowVendorMessage);
                }
            } else {
                _oldBusyState = bl;
                for (int i = 0; i < list.size(); ++i) {
                    ManagedConnection managedConnection = (ManagedConnection)list.get(i);
                    if (managedConnection == null || !managedConnection.isClientSupernodeConnection()) continue;
                    managedConnection.send(hopsFlowVendorMessage);
                }
            }
        }
    }

    static class ConnectBackExpirer
    implements Runnable {
        ConnectBackExpirer() {
        }

        public void run() {
            try {
                _tcpConnectBacks.clear();
                _udpConnectBacks.clear();
            }
            catch (Throwable throwable) {
                ErrorService.error(throwable);
            }
        }
    }

    private class Expirer
    implements Runnable {
        private Expirer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                HashSet<GUID.TimedGUID> hashSet = new HashSet<GUID.TimedGUID>();
                Map map = MessageRouter.this._outOfBandReplies;
                synchronized (map) {
                    Iterator<Object> iterator = MessageRouter.this._outOfBandReplies.keySet().iterator();
                    while (iterator.hasNext()) {
                        GUID.TimedGUID timedGUID = (GUID.TimedGUID)iterator.next();
                        if (timedGUID == null || !timedGUID.shouldExpire()) continue;
                        hashSet.add(timedGUID);
                    }
                    iterator = hashSet.iterator();
                    while (iterator.hasNext()) {
                        MessageRouter.this._outOfBandReplies.remove(iterator.next());
                    }
                }
            }
            catch (Throwable throwable) {
                ErrorService.error(throwable);
            }
        }
    }

    private static class QueryResponseBundle {
        public final QueryRequest _query;
        public final Response[] _responses;

        public QueryResponseBundle(QueryRequest queryRequest, Response[] responseArray) {
            this._query = queryRequest;
            this._responses = responseArray;
        }
    }

    private class QRPPropagator
    extends ManagedThread {
        public QRPPropagator() {
            this.setName("QRPPropagator");
            this.setDaemon(true);
        }

        public void managedRun() {
            try {
                while (true) {
                    Thread.sleep(10000L);
                    MessageRouter.this.forwardQueryRouteTables();
                }
            }
            catch (Throwable throwable) {
                ErrorService.error(throwable);
                return;
            }
        }
    }
}

