/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.ErrorCallback;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.MessageDispatcher;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.util.ManagedThread;
import com.limegroup.gnutella.util.NetworkUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.SocketException;

public final class MulticastService
implements Runnable {
    private static final MulticastService INSTANCE = new MulticastService();
    private volatile MulticastSocket _socket;
    private final Object _receiveLock = new Object();
    private InetAddress _group = null;
    private int _port = -1;
    private final int BUFFER_SIZE = 32768;
    private final byte[] HEADER_BUF = new byte[23];
    private final Thread MULTICAST_THREAD;
    private final ErrorCallback _err = new ErrorCallbackImpl();

    public static MulticastService instance() {
        return INSTANCE;
    }

    private MulticastService() {
        this.MULTICAST_THREAD = new ManagedThread(this, "MulticastService");
        this.MULTICAST_THREAD.setDaemon(true);
    }

    public void start() {
        this.MULTICAST_THREAD.start();
    }

    MulticastSocket newListeningSocket(int n, InetAddress inetAddress) throws IOException {
        try {
            MulticastSocket multicastSocket = new MulticastSocket(n);
            multicastSocket.setTimeToLive(3);
            multicastSocket.joinGroup(inetAddress);
            this._port = n;
            this._group = inetAddress;
            return multicastSocket;
        }
        catch (SocketException socketException) {
            throw new IOException("socket could not be set on port: " + n);
        }
        catch (SecurityException securityException) {
            throw new IOException("security exception on port: " + n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setListeningSocket(MulticastSocket multicastSocket) throws IOException {
        if (this._socket != null) {
            this._socket.close();
        }
        Object object = this._receiveLock;
        synchronized (object) {
            if (multicastSocket == null && this._socket != null && this._group != null) {
                try {
                    this._socket.leaveGroup(this._group);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this._socket = multicastSocket;
            this._receiveLock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            byte[] byArray = new byte[32768];
            while (true) {
                DatagramPacket datagramPacket = new DatagramPacket(byArray, 32768);
                Object object = this._receiveLock;
                synchronized (object) {
                    while (this._socket == null) {
                        try {
                            this._receiveLock.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    try {
                        this._socket.receive(datagramPacket);
                    }
                    catch (InterruptedIOException interruptedIOException) {
                        continue;
                    }
                    catch (IOException iOException) {
                        continue;
                    }
                }
                if (!NetworkUtils.isValidAddress(datagramPacket.getAddress()) || !NetworkUtils.isValidPort(datagramPacket.getPort())) continue;
                object = datagramPacket.getData();
                try {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])object);
                    Message message = Message.read((InputStream)byteArrayInputStream, 3, this.HEADER_BUF);
                    if (message == null) continue;
                    MessageDispatcher.instance().dispatchMulticast(message, (InetSocketAddress)datagramPacket.getSocketAddress());
                }
                catch (IOException iOException) {
                }
                catch (BadPacketException badPacketException) {}
            }
        }
        catch (Throwable throwable) {
            ErrorService.error(throwable);
            return;
        }
    }

    public synchronized void send(Message message) {
        if (this._port != -1) {
            UDPService.instance().send(message, this._group, this._port, this._err);
        }
    }

    public boolean isListening() {
        if (this._socket == null) {
            return false;
        }
        return this._socket.getLocalPort() != -1;
    }

    public String toString() {
        return "MulticastService\r\nsocket: " + this._socket;
    }

    private class ErrorCallbackImpl
    implements ErrorCallback {
        private ErrorCallbackImpl() {
        }

        public void error(Throwable throwable) {
        }

        public void error(Throwable throwable, String string) {
        }
    }
}

