/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.http.HTTPHeaderValue;
import com.limegroup.gnutella.http.HTTPUtils;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.util.IpPort;
import com.limegroup.gnutella.util.IpPortImpl;
import com.limegroup.gnutella.util.IpPortSet;
import com.limegroup.gnutella.util.NetworkUtils;
import java.io.DataInputStream;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.InetAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.WeakHashMap;

public class PushEndpoint
implements HTTPHeaderValue,
IpPort {
    public static final int HEADER_SIZE = 17;
    public static final int PROXY_SIZE = 6;
    public static final int PLAIN = 0;
    private static final int SIZE_MASK = 7;
    private static final int FWT_VERSION_MASK = 24;
    private static final int FEATURES_MASK = 224;
    private static final Map GUID_PROXY_MAP = Collections.synchronizedMap(new WeakHashMap());
    private final byte[] _clientGUID;
    private GUID _guid;
    private final int _features;
    private final int _fwtVersion;
    private Set _proxies;
    private final IpPort _externalAddr;

    public PushEndpoint(byte[] byArray, Set set, int n, int n2) {
        this(byArray, set, n, n2, null);
    }

    public PushEndpoint(byte[] byArray, Set set, int n, int n2, IpPort ipPort) {
        this._features = n & 0xE0 | n2 << 3;
        this._fwtVersion = n2;
        this._clientGUID = byArray;
        this._guid = new GUID(this._clientGUID);
        this._proxies = set != null ? (set instanceof IpPortSet ? Collections.unmodifiableSet(set) : Collections.unmodifiableSet(new IpPortSet((Collection)set))) : Collections.EMPTY_SET;
        this._externalAddr = ipPort;
    }

    public PushEndpoint(byte[] byArray, Set set) {
        this(byArray, set, 0, 0);
    }

    public PushEndpoint(byte[] byArray) {
        this(byArray, Collections.EMPTY_SET);
    }

    public PushEndpoint(String string) throws IOException {
        if (string.length() < 32 || string.indexOf(";") > 32) {
            throw new IOException("http string does not contain valid guid");
        }
        String string2 = string.substring(0, 32);
        string = string.substring(32);
        try {
            this._clientGUID = GUID.fromHexString(string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IOException(illegalArgumentException.getMessage());
        }
        this._guid = new GUID(this._clientGUID);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        IpPortSet ipPortSet = new IpPortSet();
        int n = 0;
        IpPort ipPort = null;
        while (stringTokenizer.hasMoreTokens() && ipPortSet.size() < 4) {
            String string3 = stringTokenizer.nextToken().trim();
            if (string3.startsWith("fwt")) {
                n = (int)HTTPUtils.parseFeatureToken(string3);
                continue;
            }
            try {
                ipPortSet.add(PushEndpoint.parseIpPort(string3));
            }
            catch (IOException iOException) {
                if (ipPort != null) continue;
                try {
                    ipPort = PushEndpoint.parsePortIp(string3);
                }
                catch (IOException iOException2) {}
            }
        }
        this._proxies = Collections.unmodifiableSet(ipPortSet);
        this._externalAddr = ipPort;
        this._fwtVersion = n;
        this._features = ipPortSet.size() | this._fwtVersion << 3;
    }

    public byte[] toBytes() {
        Set set = this.getProxies();
        int n = PushEndpoint.getSizeBytes(set);
        IpPort ipPort = this.getValidExternalAddress();
        int n2 = this.supportsFWTVersion();
        if (ipPort != null && n2 > 0) {
            n += 6;
        }
        byte[] byArray = new byte[n];
        this.toBytes(byArray, 0, set, ipPort, n2);
        return byArray;
    }

    public void toBytes(byte[] byArray, int n) {
        this.toBytes(byArray, n, this.getProxies(), this.getValidExternalAddress(), this.supportsFWTVersion());
    }

    private void toBytes(byte[] byArray, int n, Set set, IpPort ipPort, int n2) {
        int n3 = PushEndpoint.getSizeBytes(set);
        if (ipPort != null) {
            if (n2 > 0) {
                n3 += 6;
            }
        } else {
            n2 = 0;
        }
        if (byArray.length - n < n3) {
            throw new IllegalArgumentException("target array too small");
        }
        byArray[n] = (byte)(Math.min(4, set.size()) | this.getFeatures() | n2 << 3);
        System.arraycopy(this._clientGUID, 0, byArray, ++n, 16);
        n += 16;
        if (ipPort != null && n2 > 0) {
            byte[] byArray2 = ipPort.getInetAddress().getAddress();
            int n4 = ipPort.getPort();
            System.arraycopy(byArray2, 0, byArray, n, 4);
            ByteOrder.short2leb((short)n4, byArray, n += 4);
            n += 2;
        }
        Iterator iterator = set.iterator();
        for (int i = 0; iterator.hasNext() && i < 4; ++i) {
            IpPort ipPort2 = (IpPort)iterator.next();
            byte[] byArray3 = ipPort2.getInetAddress().getAddress();
            short s = (short)ipPort2.getPort();
            System.arraycopy(byArray3, 0, byArray, n, 4);
            ByteOrder.short2leb(s, byArray, n += 4);
            n += 2;
        }
    }

    protected IpPort getValidExternalAddress() {
        IpPort ipPort = this.getIpPort();
        if (!NetworkUtils.isValidExternalIpPort(ipPort)) {
            return null;
        }
        Assert.that(!ipPort.getAddress().equals("1.1.1.1"), "bogus ip address leaked");
        return ipPort;
    }

    public static PushEndpoint fromBytes(DataInputStream dataInputStream) throws BadPacketException, IOException {
        byte[] byArray;
        byte[] byArray2 = new byte[16];
        IpPortSet ipPortSet = new IpPortSet();
        QueryReply.IPPortCombo iPPortCombo = null;
        int n = dataInputStream.read() & 0xFF;
        int n2 = n & 7;
        int n3 = n & 0xE0;
        int n4 = (n & 0x18) >> 3;
        dataInputStream.readFully(byArray2);
        if (n4 > 0) {
            byArray = new byte[6];
            dataInputStream.readFully(byArray);
            iPPortCombo = QueryReply.IPPortCombo.getCombo(byArray);
            if (iPPortCombo.getAddress().equals("1.1.1.1")) {
                iPPortCombo = null;
                n4 = 0;
            }
        }
        byArray = new byte[6];
        for (int i = 0; i < n2; ++i) {
            dataInputStream.readFully(byArray);
            ipPortSet.add(QueryReply.IPPortCombo.getCombo(byArray));
        }
        PushEndpoint pushEndpoint = new PushEndpoint(byArray2, ipPortSet, n3, n4, iPPortCombo);
        pushEndpoint.updateProxies(true);
        return pushEndpoint;
    }

    public byte[] getClientGUID() {
        return this._clientGUID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getProxies() {
        Object object = this;
        synchronized (object) {
            if (this._proxies != null) {
                return this._proxies;
            }
        }
        object = (GuidSetWrapper)GUID_PROXY_MAP.get(this._guid);
        if (object == null) {
            return Collections.EMPTY_SET;
        }
        return ((GuidSetWrapper)object).getProxies();
    }

    public static int getSizeBytes(Set set) {
        return 17 + Math.min(set.size(), 4) * 6;
    }

    public int supportsFWTVersion() {
        GuidSetWrapper guidSetWrapper = (GuidSetWrapper)GUID_PROXY_MAP.get(this._guid);
        int n = guidSetWrapper == null ? this._fwtVersion : guidSetWrapper.getFWTVersion();
        return n;
    }

    public static void setFWTVersionSupported(byte[] byArray, int n) {
        GUID gUID = new GUID(byArray);
        GuidSetWrapper guidSetWrapper = (GuidSetWrapper)GUID_PROXY_MAP.get(gUID);
        if (guidSetWrapper != null) {
            guidSetWrapper.setFWTVersion(n);
        }
    }

    public int hashCode() {
        return this._guid.hashCode();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof PushEndpoint)) {
            return false;
        }
        PushEndpoint pushEndpoint = (PushEndpoint)object;
        return this._guid.equals(pushEndpoint._guid);
    }

    public String toString() {
        String string = "PE [FEATURES:" + this.getFeatures() + ", FWT Version:" + this.supportsFWTVersion() + ", GUID:" + this._guid + ", address: " + this.getAddress() + ":" + this.getPort() + ", proxies:{ ";
        Iterator iterator = this.getProxies().iterator();
        while (iterator.hasNext()) {
            IpPort ipPort = (IpPort)iterator.next();
            string = string + ipPort.getInetAddress() + ":" + ipPort.getPort() + " ";
        }
        string = string + "}]";
        return string;
    }

    public String httpStringValue() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer(this._guid.toHexString()).append(";");
        int n = this.supportsFWTVersion();
        if (n != 0) {
            stringBuffer.append("fwt").append("/").append(n).append(";");
            IpPort ipPort = this.getValidExternalAddress();
            if (ipPort != null) {
                object = this.getAddress();
                int n2 = this.getPort();
                if (!((String)object).equals("1.1.1.1") && NetworkUtils.isValidPort(n2)) {
                    stringBuffer.append(n2).append(":").append((String)object).append(";");
                }
            }
        }
        object = this.getProxies().iterator();
        for (int i = 0; object.hasNext() && i < 4; ++i) {
            IpPort ipPort = (IpPort)object.next();
            stringBuffer.append(NetworkUtils.ip2string(ipPort.getInetAddress().getAddress()));
            stringBuffer.append(":").append(ipPort.getPort()).append(";");
        }
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        return stringBuffer.toString();
    }

    public int getFeatures() {
        GuidSetWrapper guidSetWrapper = (GuidSetWrapper)GUID_PROXY_MAP.get(this._guid);
        int n = guidSetWrapper == null ? this._features : guidSetWrapper.getFeatures();
        return n & 0xE0;
    }

    public static void setFeatures(byte[] byArray, int n) {
        GUID gUID = new GUID(byArray);
        GuidSetWrapper guidSetWrapper = (GuidSetWrapper)GUID_PROXY_MAP.get(gUID);
        if (guidSetWrapper != null) {
            guidSetWrapper.setFeatures(n);
        }
    }

    public static void setAddr(byte[] byArray, IpPort ipPort) {
        GUID gUID = new GUID(byArray);
        GuidSetWrapper guidSetWrapper = (GuidSetWrapper)GUID_PROXY_MAP.get(gUID);
        if (guidSetWrapper != null) {
            guidSetWrapper.setIpPort(ipPort);
        }
    }

    private IpPort getIpPort() {
        GuidSetWrapper guidSetWrapper = (GuidSetWrapper)GUID_PROXY_MAP.get(this._guid);
        return guidSetWrapper == null || guidSetWrapper.getIpPort() == null ? this._externalAddr : guidSetWrapper.getIpPort();
    }

    public String getAddress() {
        IpPort ipPort = this.getIpPort();
        return ipPort != null ? ipPort.getAddress() : "1.1.1.1";
    }

    public InetAddress getInetAddress() {
        IpPort ipPort = this.getIpPort();
        return ipPort != null ? ipPort.getInetAddress() : null;
    }

    public int getPort() {
        IpPort ipPort = this.getIpPort();
        return ipPort != null ? ipPort.getPort() : 6346;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void updateProxies(boolean bl) {
        GuidSetWrapper guidSetWrapper;
        GUID gUID = null;
        Map map = GUID_PROXY_MAP;
        synchronized (map) {
            guidSetWrapper = (GuidSetWrapper)GUID_PROXY_MAP.get(this._guid);
            if (guidSetWrapper != null) {
                gUID = guidSetWrapper.getGuid();
            }
            if (guidSetWrapper == null || gUID == null) {
                guidSetWrapper = new GuidSetWrapper(this._guid, this._features, this._fwtVersion);
                if (bl) {
                    guidSetWrapper.updateProxies(this._proxies, true);
                } else {
                    guidSetWrapper.updateProxies(Collections.EMPTY_SET, true);
                }
                GUID_PROXY_MAP.put(this._guid, guidSetWrapper);
                this._proxies = null;
                return;
            }
        }
        guidSetWrapper.updateProxies(this._proxies, bl);
        this._guid = gUID;
        this._proxies = null;
    }

    public PushEndpoint createClone() {
        return new PushEndpoint(this._guid.bytes(), this.getProxies(), this.getFeatures(), this.supportsFWTVersion(), this.getIpPort());
    }

    public static void overwriteProxies(byte[] byArray, String string) throws IOException {
        HashSet<IpPort> hashSet = new HashSet<IpPort>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            try {
                hashSet.add(PushEndpoint.parseIpPort(string2));
            }
            catch (IOException iOException) {}
        }
        PushEndpoint.overwriteProxies(byArray, hashSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void overwriteProxies(byte[] byArray, Set set) {
        GUID gUID = new GUID(byArray);
        Map map = GUID_PROXY_MAP;
        synchronized (map) {
            GuidSetWrapper guidSetWrapper = (GuidSetWrapper)GUID_PROXY_MAP.get(gUID);
            if (guidSetWrapper == null) {
                guidSetWrapper = new GuidSetWrapper(gUID);
                GUID_PROXY_MAP.put(gUID, guidSetWrapper);
            }
            guidSetWrapper.overwriteProxies(set);
        }
    }

    private static IpPort parseIpPort(String string) throws IOException {
        int n = string.indexOf(":");
        if (n == -1 || n != string.lastIndexOf(":") || n == string.length()) {
            throw new IOException();
        }
        String string2 = string.substring(0, n);
        if (!NetworkUtils.isValidAddress(string2) || NetworkUtils.isPrivateAddress(string2)) {
            throw new IOException();
        }
        String string3 = string.substring(n + 1);
        try {
            int n2 = Integer.parseInt(string3);
            if (!NetworkUtils.isValidPort(n2)) {
                throw new IOException();
            }
            IpPortImpl ipPortImpl = new IpPortImpl(string2, n2);
            return ipPortImpl;
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException(numberFormatException.getMessage());
        }
    }

    private static IpPort parsePortIp(String string) throws IOException {
        int n = string.indexOf(":");
        if (n == -1 || n != string.lastIndexOf(":") || n == string.length()) {
            throw new IOException();
        }
        String string2 = string.substring(0, n);
        int n2 = 0;
        try {
            n2 = Integer.parseInt(string2);
            if (!NetworkUtils.isValidPort(n2)) {
                throw new IOException();
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException(numberFormatException.getMessage());
        }
        String string3 = string.substring(n + 1);
        if (!NetworkUtils.isValidAddress(string3) || NetworkUtils.isPrivateAddress(string3)) {
            throw new IOException();
        }
        return new IpPortImpl(string3, n2);
    }

    static {
        RouterService.schedule(new WeakCleaner(), 30000L, 30000L);
    }

    private static final class WeakCleaner
    implements Runnable {
        private WeakCleaner() {
        }

        public void run() {
            GUID_PROXY_MAP.size();
        }
    }

    private static class GuidSetWrapper {
        private final WeakReference _guidRef;
        private Set _proxies;
        private int _features;
        private int _fwtVersion;
        private IpPort _externalAddr;

        GuidSetWrapper(GUID gUID) {
            this(gUID, 0, 0);
        }

        GuidSetWrapper(GUID gUID, int n, int n2) {
            this._guidRef = new WeakReference<GUID>(gUID);
            this._features = n;
            this._fwtVersion = n2;
        }

        synchronized void updateProxies(Set set, boolean bl) {
            IpPortSet ipPortSet = new IpPortSet();
            if (set == null) {
                set = this._proxies;
            }
            if (this._proxies != null) {
                ipPortSet.addAll(this._proxies);
            }
            if (bl) {
                ipPortSet.addAll(set);
            } else {
                ipPortSet.removeAll(set);
            }
            this.overwriteProxies(ipPortSet);
        }

        synchronized void overwriteProxies(Set set) {
            this._proxies = Collections.unmodifiableSet(set);
        }

        synchronized Set getProxies() {
            return this._proxies != null ? this._proxies : Collections.EMPTY_SET;
        }

        synchronized int getFeatures() {
            return this._features;
        }

        synchronized int getFWTVersion() {
            return this._fwtVersion;
        }

        synchronized void setFeatures(int n) {
            this._features = n;
        }

        synchronized void setFWTVersion(int n) {
            this._fwtVersion = n;
        }

        synchronized void setIpPort(IpPort ipPort) {
            this._externalAddr = ipPort;
        }

        synchronized IpPort getIpPort() {
            return this._externalAddr;
        }

        GUID getGuid() {
            return (GUID)this._guidRef.get();
        }
    }
}

