/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.FileDetails;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.PushEndpoint;
import com.limegroup.gnutella.RemoteHostData;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.downloader.URLRemoteFileDesc;
import com.limegroup.gnutella.util.DataUtils;
import com.limegroup.gnutella.util.IntervalSet;
import com.limegroup.gnutella.util.IpPort;
import com.limegroup.gnutella.util.IpPortImpl;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RemoteFileDesc
implements IpPort,
Serializable,
FileDetails {
    private static final Log LOG = LogFactory.getLog((Class)(class$com$limegroup$gnutella$RemoteFileDesc == null ? (class$com$limegroup$gnutella$RemoteFileDesc = RemoteFileDesc.class$("com.limegroup.gnutella.RemoteFileDesc")) : class$com$limegroup$gnutella$RemoteFileDesc));
    private static final long serialVersionUID = 6619479308616716538L;
    private static final int COPY_INDEX = Integer.MAX_VALUE;
    public static final String BOGUS_IP = "1.1.1.1";
    private final String _host;
    private final int _port;
    private final String _filename;
    private final long _index;
    private final byte[] _clientGUID;
    private final int _speed;
    private final int _size;
    private final boolean _chatEnabled;
    private final int _quality;
    private final boolean _replyToMulticast;
    private LimeXMLDocument[] _xmlDocs;
    private Set _urns;
    private boolean _browseHostEnabled;
    private boolean _firewalled;
    private String _vendor;
    private long _timestamp;
    private boolean _http11;
    private transient PushEndpoint _pushAddr;
    private transient IntervalSet _availableRanges = null;
    private transient int _queueStatus = Integer.MAX_VALUE;
    private transient int _failedCount = 0;
    private volatile transient long _earliestRetryTime = 0L;
    private transient int _hashCode = 0;
    private transient boolean _THEXFailed = false;
    private transient RemoteHostData _hostData = null;
    private volatile transient boolean _isDownloading = false;
    private transient long _creationTime;
    private volatile transient boolean _serializeProxies = false;
    private Map propertiesMap;
    static /* synthetic */ Class class$com$limegroup$gnutella$RemoteFileDesc;

    public RemoteFileDesc(RemoteFileDesc remoteFileDesc, IpPort ipPort) {
        this(ipPort.getAddress(), ipPort.getPort(), Integer.MAX_VALUE, remoteFileDesc.getFileName(), remoteFileDesc.getSize(), remoteFileDesc.getClientGUID(), 0, false, 2, false, remoteFileDesc.getXMLDocument(), remoteFileDesc.getUrns(), false, false, "ALT", System.currentTimeMillis(), Collections.EMPTY_SET, remoteFileDesc.getCreationTime(), 0, null);
    }

    public RemoteFileDesc(RemoteFileDesc remoteFileDesc, PushEndpoint pushEndpoint) {
        this(pushEndpoint.getAddress(), pushEndpoint.getPort(), Integer.MAX_VALUE, remoteFileDesc.getFileName(), remoteFileDesc.getSize(), DataUtils.EMPTY_GUID, remoteFileDesc.getSpeed(), false, remoteFileDesc.getQuality(), false, remoteFileDesc.getXMLDocument(), remoteFileDesc.getUrns(), false, true, "ALT", System.currentTimeMillis(), null, remoteFileDesc.getCreationTime(), 0, pushEndpoint);
    }

    public RemoteFileDesc(String string, int n, long l, String string2, int n2, byte[] byArray, int n3, boolean bl, int n4, boolean bl2, LimeXMLDocument limeXMLDocument, Set set, boolean bl3, boolean bl4, String string3, long l2, Set set2, long l3) {
        this(string, n, l, string2, n2, byArray, n3, bl, n4, bl2, limeXMLDocument, set, bl3, bl4, string3, l2, set2, l3, 0, null);
    }

    public RemoteFileDesc(String string, int n, long l, String string2, int n2, byte[] byArray, int n3, boolean bl, int n4, boolean bl2, LimeXMLDocument limeXMLDocument, Set set, boolean bl3, boolean bl4, String string3, long l2, Set set2, long l3, int n5) {
        this(string, n, l, string2, n2, byArray, n3, bl, n4, bl2, limeXMLDocument, set, bl3, bl4, string3, l2, set2, l3, n5, null);
    }

    public RemoteFileDesc(String string, int n, long l, String string2, int n2, int n3, boolean bl, int n4, boolean bl2, LimeXMLDocument limeXMLDocument, Set set, boolean bl3, boolean bl4, String string3, long l2, long l3, PushEndpoint pushEndpoint) {
        this(string, n, l, string2, n2, null, n3, bl, n4, bl2, limeXMLDocument, set, bl3, bl4, string3, l2, null, l3, 0, pushEndpoint);
    }

    private RemoteFileDesc(String string, int n, long l, String string2, int n2, byte[] byArray, int n3, boolean bl, int n4, boolean bl2, LimeXMLDocument limeXMLDocument, Set set, boolean bl3, boolean bl4, String string3, long l2, Set set2, long l3, int n5, PushEndpoint pushEndpoint) {
        if (!NetworkUtils.isValidPort(n)) {
            throw new IllegalArgumentException("invalid port: " + n);
        }
        if (((long)n3 & 0xFFFFFFFF00000000L) != 0L) {
            throw new IllegalArgumentException("invalid speed: " + n3);
        }
        if (string2 == null) {
            throw new NullPointerException("null filename");
        }
        if (string2.equals("")) {
            throw new IllegalArgumentException("cannot accept empty string file name");
        }
        if (((long)n2 & 0xFFFFFFFF00000000L) != 0L) {
            throw new IllegalArgumentException("invalid size: " + n2);
        }
        if ((l & 0xFFFFFFFF00000000L) != 0L) {
            throw new IllegalArgumentException("invalid index: " + l);
        }
        if (string == null) {
            throw new NullPointerException("null host");
        }
        this._speed = n3;
        this._host = string;
        this._port = n;
        this._index = l;
        this._filename = string2;
        this._size = n2;
        this._firewalled = bl4;
        if (bl4) {
            if (pushEndpoint != null) {
                this._pushAddr = pushEndpoint;
            } else {
                try {
                    this._pushAddr = new PushEndpoint(byArray, set2, 0, n5, new IpPortImpl(this._host, this._port));
                }
                catch (UnknownHostException unknownHostException) {
                    throw new IllegalArgumentException("invalid host");
                }
            }
            this._clientGUID = this._pushAddr.getClientGUID();
        } else {
            this._clientGUID = byArray;
        }
        this._chatEnabled = bl;
        this._quality = n4;
        this._browseHostEnabled = bl2;
        this._replyToMulticast = bl3;
        this._vendor = string3;
        this._timestamp = l2;
        this._creationTime = l3;
        this._xmlDocs = limeXMLDocument != null ? new LimeXMLDocument[]{limeXMLDocument} : null;
        this._urns = set == null ? Collections.EMPTY_SET : Collections.unmodifiableSet(set);
        this._http11 = !this._urns.isEmpty();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Object object;
        objectInputStream.defaultReadObject();
        if (this._urns == null) {
            this._urns = Collections.EMPTY_SET;
            this._browseHostEnabled = false;
        } else {
            object = null;
            Iterator iterator = this._urns.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e instanceof URN) continue;
                if (object == null) {
                    object = new HashSet();
                    ((AbstractCollection)object).addAll(this._urns);
                }
                ((HashSet)object).remove(e);
            }
            if (object != null) {
                this._urns = Collections.unmodifiableSet(object);
            }
        }
        if (this._xmlDocs != null && this._xmlDocs.length == 0) {
            this._xmlDocs = null;
        }
        boolean bl = this._http11 = this._http11 || !this._urns.isEmpty();
        if (this.propertiesMap != null) {
            object = (String)this.propertiesMap.get("_pushAddr");
            if (object != null) {
                try {
                    this._pushAddr = new PushEndpoint((String)object);
                    if (!this._firewalled) {
                        Assert.silent(false, "deserialized RFD had PE but wasn't firewalled, " + this + " " + this._pushAddr);
                        this._firewalled = true;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.propertiesMap = null;
        }
    }

    public void setSerializeProxies() {
        this._serializeProxies = true;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this._serializeProxies && this._pushAddr != null) {
            if (this.propertiesMap == null) {
                this.propertiesMap = new HashMap();
            }
            this.propertiesMap.put("_pushAddr", this._pushAddr.httpStringValue());
        }
        objectOutputStream.defaultWriteObject();
    }

    public boolean isHTTP11() {
        return this._http11;
    }

    public void setHTTP11(boolean bl) {
        this._http11 = bl;
    }

    public boolean isPartialSource() {
        return this._availableRanges != null;
    }

    public boolean isMe() {
        return this.needsPush() ? Arrays.equals(this._clientGUID, RouterService.getMyGUID()) : NetworkUtils.isMe(this.getHost(), this.getPort());
    }

    public IntervalSet getAvailableRanges() {
        return (IntervalSet)this._availableRanges.clone();
    }

    public void setAvailableRanges(IntervalSet intervalSet) {
        this._availableRanges = intervalSet;
    }

    public void setPushAddress(PushEndpoint pushEndpoint) {
        if (!Arrays.equals(pushEndpoint.getClientGUID(), this._clientGUID)) {
            throw new IllegalArgumentException("different clientGUID");
        }
        this._pushAddr = pushEndpoint;
    }

    public int getFailedCount() {
        return this._failedCount;
    }

    public void incrementFailedCount() {
        ++this._failedCount;
    }

    public void resetFailedCount() {
        this._failedCount = 0;
    }

    public boolean isFromAlternateLocation() {
        return "ALT".equals(this._vendor);
    }

    public boolean isBusy() {
        return this.isBusy(System.currentTimeMillis());
    }

    public boolean isBusy(long l) {
        return l < this._earliestRetryTime;
    }

    public int getWaitTime(long l) {
        return this.isBusy(l) ? (int)(this._earliestRetryTime - l) / 1000 + 1 : 0;
    }

    public void setRetryAfter(int n) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("setting retry after to be [" + n + "] seconds for " + this));
        }
        this._earliestRetryTime = System.currentTimeMillis() + (long)(n * 1000);
    }

    public long getCreationTime() {
        return this._creationTime;
    }

    public boolean hasTHEXFailed() {
        return this._THEXFailed;
    }

    public void setTHEXFailed() {
        this._THEXFailed = true;
    }

    public void setDownloading(boolean bl) {
        this._isDownloading = bl;
    }

    public boolean isDownloading() {
        return this._isDownloading;
    }

    public final String getHost() {
        return this._host;
    }

    public final int getPort() {
        return this._port;
    }

    public final long getIndex() {
        return this._index;
    }

    public final int getSize() {
        return this._size;
    }

    public final long getFileSize() {
        return this._size;
    }

    public final String getFileName() {
        return this._filename;
    }

    public final byte[] getClientGUID() {
        return this._clientGUID;
    }

    public final int getSpeed() {
        return this._speed;
    }

    public final String getVendor() {
        return this._vendor;
    }

    public final boolean chatEnabled() {
        return this._chatEnabled;
    }

    public final boolean browseHostEnabled() {
        return this._browseHostEnabled;
    }

    public final int getQuality() {
        return this._quality;
    }

    public final LimeXMLDocument getXMLDocument() {
        if (this._xmlDocs == null) {
            return null;
        }
        return this._xmlDocs[0];
    }

    public final Set getUrns() {
        return this._urns;
    }

    public final URN getSHA1Urn() {
        Iterator iterator = this._urns.iterator();
        while (iterator.hasNext()) {
            URN uRN = (URN)iterator.next();
            if (uRN == null || !uRN.isSHA1()) continue;
            return uRN;
        }
        return null;
    }

    public URL getUrl() {
        try {
            String string = "";
            URN uRN = this.getSHA1Urn();
            string = uRN == null ? "/get/" + this._index + "/" + this._filename : "/uri-res/N2R?" + uRN.httpStringValue();
            return new URL("http", this._host, this._port, string);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public final boolean isReplyToMulticast() {
        return this._replyToMulticast;
    }

    public final boolean isPrivate() {
        return NetworkUtils.isPrivateAddress(this._host);
    }

    public boolean isFirewalled() {
        return this._firewalled;
    }

    public final Set getPushProxies() {
        if (this._pushAddr != null) {
            return this._pushAddr.getProxies();
        }
        return Collections.EMPTY_SET;
    }

    public final boolean supportsFWTransfer() {
        if (this._host.equals(BOGUS_IP) || !NetworkUtils.isValidAddress(this._host) || NetworkUtils.isPrivateAddress(this._host)) {
            return false;
        }
        return this._pushAddr == null ? false : this._pushAddr.supportsFWTVersion() > 0;
    }

    public final RemoteHostData getRemoteHostData() {
        if (this._hostData == null) {
            this._hostData = new RemoteHostData(this._host, this._port, this._clientGUID);
        }
        return this._hostData;
    }

    public final boolean isAltLocCapable() {
        boolean bl;
        boolean bl2 = bl = this.getSHA1Urn() != null && !this._replyToMulticast;
        bl = this._firewalled ? bl && this._pushAddr != null && this._pushAddr.getProxies().size() > 0 : bl && NetworkUtils.isValidPort(this._port) && !NetworkUtils.isPrivateAddress(this._host) && NetworkUtils.isValidAddress(this._host);
        return bl;
    }

    public boolean needsPush() {
        if (this.isReplyToMulticast()) {
            return true;
        }
        if (this.isPrivate()) {
            return !(this instanceof URLRemoteFileDesc);
        }
        if (!NetworkUtils.isValidPort(this.getPort())) {
            return true;
        }
        return this.isFirewalled();
    }

    public PushEndpoint getPushAddr() {
        return this._pushAddr;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof RemoteFileDesc)) {
            return false;
        }
        RemoteFileDesc remoteFileDesc = (RemoteFileDesc)object;
        if (!this.nullEquals(this._host, remoteFileDesc._host) || this._port != remoteFileDesc._port) {
            return false;
        }
        if (this._size != remoteFileDesc._size) {
            return false;
        }
        if (this._clientGUID == null != (remoteFileDesc._clientGUID == null)) {
            return false;
        }
        if (this._clientGUID != null && !Arrays.equals(this._clientGUID, remoteFileDesc._clientGUID)) {
            return false;
        }
        if (this._urns.isEmpty() && remoteFileDesc._urns.isEmpty()) {
            return this.nullEquals(this._filename, remoteFileDesc._filename);
        }
        return this.urnSetEquals(this._urns, remoteFileDesc._urns);
    }

    private boolean nullEquals(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    private boolean urnSetEquals(Set set, Set set2) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            if (!set2.contains(iterator.next())) continue;
            return true;
        }
        return false;
    }

    private boolean byteArrayEquals(byte[] byArray, byte[] byArray2) {
        return byArray == null ? byArray2 == null : Arrays.equals(byArray, byArray2);
    }

    public int hashCode() {
        if (this._hashCode == 0) {
            int n = 17;
            n = 37 * n + this._host.hashCode();
            n = 37 * n + this._port;
            n = 37 * n + this._size;
            n = 37 * n + ((Object)this._urns).hashCode();
            if (this._clientGUID != null) {
                n = 37 * n + new GUID(this._clientGUID).hashCode();
            }
            this._hashCode = n;
        }
        return this._hashCode;
    }

    public String toString() {
        return "<" + this.getHost() + ":" + this.getPort() + ", " + this.getFileName().toLowerCase() + ">";
    }

    public String getAddress() {
        return this.getHost();
    }

    public InetAddress getInetAddress() {
        try {
            return InetAddress.getByName(this.getAddress());
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    public void setQueueStatus(int n) {
        this._queueStatus = n;
    }

    public int getQueueStatus() {
        return this._queueStatus;
    }

    public InetSocketAddress getSocketAddress() {
        InetAddress inetAddress = this.getInetAddress();
        if (inetAddress != null) {
            return new InetSocketAddress(inetAddress, this.getPort());
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

