/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Acceptor;
import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.BrowseHostHandler;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.ConnectionWatchdog;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.HostCatcher;
import com.limegroup.gnutella.ManagedConnection;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.Pinger;
import com.limegroup.gnutella.PushManager;
import com.limegroup.gnutella.QueryUnicaster;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.ResponseVerifier;
import com.limegroup.gnutella.SaveLocationException;
import com.limegroup.gnutella.SavedFileManager;
import com.limegroup.gnutella.StandardMessageRouter;
import com.limegroup.gnutella.Statistics;
import com.limegroup.gnutella.SupernodeAssigner;
import com.limegroup.gnutella.UDPReplyHandler;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.UploadManager;
import com.limegroup.gnutella.altlocs.AltLocManager;
import com.limegroup.gnutella.bootstrap.BootstrapServerManager;
import com.limegroup.gnutella.browser.HTTPAcceptor;
import com.limegroup.gnutella.browser.MagnetOptions;
import com.limegroup.gnutella.downloader.CantResumeException;
import com.limegroup.gnutella.downloader.HTTPDownloader;
import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.filters.MutableGUIDFilter;
import com.limegroup.gnutella.filters.SpamFilter;
import com.limegroup.gnutella.licenses.LicenseFactory;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.messages.vendor.HeaderUpdateVendorMessage;
import com.limegroup.gnutella.search.QueryDispatcher;
import com.limegroup.gnutella.search.SearchResultHandler;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.FilterSettings;
import com.limegroup.gnutella.settings.SearchSettings;
import com.limegroup.gnutella.settings.SettingsHandler;
import com.limegroup.gnutella.settings.SimppSettingsManager;
import com.limegroup.gnutella.simpp.SimppManager;
import com.limegroup.gnutella.statistics.OutOfBandThroughputStat;
import com.limegroup.gnutella.tigertree.TigerTreeCache;
import com.limegroup.gnutella.udpconnect.UDPMultiplexor;
import com.limegroup.gnutella.upelection.PromotionManager;
import com.limegroup.gnutella.uploader.NormalUploadState;
import com.limegroup.gnutella.util.IpPortSet;
import com.limegroup.gnutella.util.ManagedThread;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.util.SimpleTimer;
import com.limegroup.gnutella.xml.MetaFileManager;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RouterService {
    private static final Log LOG = LogFactory.getLog((Class)(class$com$limegroup$gnutella$RouterService == null ? (class$com$limegroup$gnutella$RouterService = RouterService.class$("com.limegroup.gnutella.RouterService")) : class$com$limegroup$gnutella$RouterService));
    private static FileManager fileManager = new MetaFileManager();
    private static final SimpleTimer timer = new SimpleTimer(true);
    private static final Acceptor acceptor = new Acceptor();
    private static HTTPAcceptor httpAcceptor;
    private static ConnectionManager manager;
    private static HostCatcher catcher;
    private static DownloadManager downloader;
    private static UploadManager uploadManager;
    private static PushManager pushManager;
    private static PromotionManager promotionManager;
    private static final ResponseVerifier VERIFIER;
    private static final Statistics STATISTICS;
    private static final UDPService UDPSERVICE;
    private static final SearchResultHandler RESULT_HANDLER;
    private static AltLocManager altManager;
    private static boolean isShuttingDown;
    private static ActivityCallback callback;
    private static MessageRouter router;
    private static final List SHUTDOWN_ITEMS;
    private static volatile int _state;
    private static long _lastQueryTime;
    private static boolean _fullPower;
    private static final byte[] MYGUID;
    static /* synthetic */ Class class$com$limegroup$gnutella$RouterService;

    public RouterService(ActivityCallback activityCallback) {
        this(activityCallback, new StandardMessageRouter());
    }

    public RouterService(ActivityCallback activityCallback, MessageRouter messageRouter, FileManager fileManager) {
        this(activityCallback, messageRouter);
        RouterService.fileManager = fileManager;
    }

    public RouterService(ActivityCallback activityCallback, MessageRouter messageRouter) {
        callback = activityCallback;
        router = messageRouter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void asyncGuiInit() {
        Object object = class$com$limegroup$gnutella$RouterService == null ? (class$com$limegroup$gnutella$RouterService = RouterService.class$("com.limegroup.gnutella.RouterService")) : class$com$limegroup$gnutella$RouterService;
        synchronized (object) {
            if (_state > 0) {
                return;
            }
            _state = 1;
        }
        object = new ManagedThread(new Initializer());
        ((Thread)object).setName("async gui initializer");
        ((Thread)object).setDaemon(true);
        ((Thread)object).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void preGuiInit() {
        Class clazz = class$com$limegroup$gnutella$RouterService == null ? (class$com$limegroup$gnutella$RouterService = RouterService.class$("com.limegroup.gnutella.RouterService")) : class$com$limegroup$gnutella$RouterService;
        synchronized (clazz) {
            if (_state > 0) {
                return;
            }
            _state = 1;
        }
        new Initializer().run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Class clazz = class$com$limegroup$gnutella$RouterService == null ? (class$com$limegroup$gnutella$RouterService = RouterService.class$("com.limegroup.gnutella.RouterService")) : class$com$limegroup$gnutella$RouterService;
        synchronized (clazz) {
            int n;
            LOG.trace((Object)"START RouterService");
            if (RouterService.isStarted()) {
                return;
            }
            RouterService.preGuiInit();
            _state = 2;
            LOG.trace((Object)"START SimppManager.instance");
            callback.componentLoading("SIMPP_MANAGER");
            SimppManager.instance();
            LOG.trace((Object)"STOP SimppManager.instance");
            LOG.trace((Object)"START SimppSettingsManager.instance");
            SimppSettingsManager.instance();
            LOG.trace((Object)"STOP SimppSettingsManager.instance");
            LOG.trace((Object)"START MessageRouter");
            callback.componentLoading("MESSAGE_ROUTER");
            router.initialize();
            LOG.trace((Object)"STOPMessageRouter");
            LOG.trace((Object)"START Acceptor");
            callback.componentLoading("ACCEPTOR");
            acceptor.start();
            LOG.trace((Object)"STOP Acceptor");
            LOG.trace((Object)"START ConnectionManager");
            callback.componentLoading("CONNECTION_MANAGER");
            manager.initialize();
            LOG.trace((Object)"STOP ConnectionManager");
            LOG.trace((Object)"START DownloadManager");
            downloader.initialize();
            LOG.trace((Object)"STOP DownloadManager");
            LOG.trace((Object)"START SupernodeAssigner");
            SupernodeAssigner supernodeAssigner = new SupernodeAssigner(uploadManager, downloader, manager);
            supernodeAssigner.start();
            LOG.trace((Object)"STOP SupernodeAssigner");
            LOG.trace((Object)"START HostCatcher.initialize");
            callback.componentLoading("HOST_CATCHER");
            catcher.initialize();
            LOG.trace((Object)"STOP HostCatcher.initialize");
            if (ConnectionSettings.CONNECT_ON_STARTUP.getValue() && (n = ConnectionSettings.NUM_CONNECTIONS.getValue()) > 0) {
                LOG.trace((Object)"START connect");
                RouterService.connect();
                LOG.trace((Object)"STOP connect");
            }
            LOG.trace((Object)"START FileManager");
            callback.componentLoading("FILE_MANAGER");
            fileManager.start();
            LOG.trace((Object)"STOP FileManager");
            LOG.trace((Object)"START DownloadManager.postGuiInit");
            callback.componentLoading("DOWNLOAD_MANAGER_POST_GUI");
            downloader.postGuiInit();
            LOG.trace((Object)"STOP DownloadManager.postGuiInit");
            LOG.trace((Object)"START QueryUnicaster");
            callback.componentLoading("QUERY_UNICASTER");
            QueryUnicaster.instance().start();
            LOG.trace((Object)"STOP QueryUnicaster");
            LOG.trace((Object)"START HTTPAcceptor");
            callback.componentLoading("HTTPACCEPTOR");
            httpAcceptor = new HTTPAcceptor();
            httpAcceptor.start();
            LOG.trace((Object)"STOP HTTPAcceptor");
            LOG.trace((Object)"START Pinger");
            callback.componentLoading("PINGER");
            Pinger.instance().start();
            LOG.trace((Object)"STOP Pinger");
            LOG.trace((Object)"START ConnectionWatchdog");
            callback.componentLoading("CONNECTION_WATCHDOG");
            ConnectionWatchdog.instance().start();
            LOG.trace((Object)"STOP ConnectionWatchdog");
            LOG.trace((Object)"START SavedFileManager");
            callback.componentLoading("SAVED_FILE_MANAGER");
            SavedFileManager.instance();
            LOG.trace((Object)"STOP SavedFileManager");
            if (ApplicationSettings.AUTOMATIC_MANUAL_GC.getValue()) {
                this.startManualGCThread();
            }
            LOG.trace((Object)"STOP RouterService.");
        }
    }

    private void startManualGCThread() {
        ManagedThread managedThread = new ManagedThread(new Runnable(){

            public void run() {
                while (true) {
                    try {
                        Thread.sleep(300000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    LOG.trace((Object)"Running GC");
                    System.gc();
                    LOG.trace((Object)"GC finished, running finalizers");
                    System.runFinalization();
                    LOG.trace((Object)"Finalizers finished.");
                }
            }
        }, "ManualGC");
        managedThread.setDaemon(true);
        managedThread.start();
        LOG.trace((Object)"Started manual GC thread.");
    }

    public static boolean isStarted() {
        return _state >= 2;
    }

    public static ActivityCallback getCallback() {
        return callback;
    }

    public static void setFullPower(boolean bl) {
        if (_fullPower != bl) {
            _fullPower = bl;
            NormalUploadState.setThrottleSwitching(!bl);
            HTTPDownloader.setThrottleSwitching(!bl);
        }
    }

    public static MessageRouter getMessageRouter() {
        return router;
    }

    public static FileManager getFileManager() {
        return fileManager;
    }

    public static DownloadManager getDownloadManager() {
        return downloader;
    }

    public static AltLocManager getAltlocManager() {
        return altManager;
    }

    public static UDPService getUdpService() {
        return UDPSERVICE;
    }

    public static UDPMultiplexor getUDPConnectionManager() {
        return UDPMultiplexor.instance();
    }

    public static ConnectionManager getConnectionManager() {
        return manager;
    }

    public static UploadManager getUploadManager() {
        return uploadManager;
    }

    public static PushManager getPushManager() {
        return pushManager;
    }

    public static Acceptor getAcceptor() {
        return acceptor;
    }

    public static HTTPAcceptor getHTTPAcceptor() {
        return httpAcceptor;
    }

    public static HostCatcher getHostCatcher() {
        return catcher;
    }

    public static SearchResultHandler getSearchResultHandler() {
        return RESULT_HANDLER;
    }

    public static PromotionManager getPromotionManager() {
        return promotionManager;
    }

    public static byte[] getMyGUID() {
        return MYGUID;
    }

    public static void schedule(Runnable runnable, long l, long l2) {
        timer.schedule(runnable, l, l2);
    }

    public static ManagedConnection connectToHostBlocking(String string, int n) throws IOException {
        return manager.createConnectionBlocking(string, n);
    }

    public static void connectToHostAsynchronously(String string, int n) {
        byte[] byArray = null;
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            byArray = inetAddress.getAddress();
        }
        catch (UnknownHostException unknownHostException) {
            return;
        }
        if (byArray[0] == 127 && n == acceptor.getPort(true) && ConnectionSettings.LOCAL_IS_PRIVATE.getValue()) {
            return;
        }
        byte[] byArray2 = acceptor.getAddress(true);
        if (Arrays.equals(byArray, byArray2) && n == acceptor.getPort(true)) {
            return;
        }
        if (!acceptor.isBannedIP(byArray)) {
            manager.createConnectionAsynchronously(string, n);
        }
    }

    public static boolean isConnectedTo(InetAddress inetAddress) {
        String string = inetAddress.getHostAddress();
        return manager.isConnectedTo(string) || UDPMultiplexor.instance().isConnectedTo(inetAddress) || uploadManager.isConnectedTo(inetAddress);
    }

    public static void connect() {
        RouterService.adjustSpamFilters();
        manager.connect();
    }

    public static void disconnect() {
        manager.disconnect();
    }

    public static void removeConnection(ManagedConnection managedConnection) {
        manager.remove(managedConnection);
    }

    public static void clearHostCatcher() {
        catcher.clear();
    }

    public static int getRealNumHosts() {
        return catcher.getNumHosts();
    }

    public static int getNumDownloads() {
        return downloader.downloadsInProgress();
    }

    public static int getNumActiveDownloads() {
        return downloader.getNumActiveDownloads();
    }

    public static int getNumWaitingDownloads() {
        return downloader.getNumWaitingDownloads();
    }

    public static int getNumIndividualDownloaders() {
        return downloader.getNumIndividualDownloaders();
    }

    public static int getNumUploads() {
        return uploadManager.uploadsInProgress();
    }

    public static int getNumQueuedUploads() {
        return uploadManager.getNumQueuedUploads();
    }

    public static long getCurrentUptime() {
        return STATISTICS.getUptime();
    }

    public static boolean addShutdownItem(Thread thread) {
        if (RouterService.isShuttingDown() || RouterService.isShutdown()) {
            return false;
        }
        SHUTDOWN_ITEMS.add(thread);
        return true;
    }

    private static void runShutdownItems() {
        Thread thread;
        if (!RouterService.isShuttingDown()) {
            return;
        }
        Iterator iterator = SHUTDOWN_ITEMS.iterator();
        while (iterator.hasNext()) {
            thread = (Thread)iterator.next();
            thread.start();
        }
        iterator = SHUTDOWN_ITEMS.iterator();
        while (iterator.hasNext()) {
            thread = (Thread)iterator.next();
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private static boolean isShuttingDown() {
        return _state >= 3;
    }

    private static boolean isShutdown() {
        return _state >= 4;
    }

    public static synchronized void shutdown() {
        try {
            if (!RouterService.isStarted()) {
                return;
            }
            _state = 3;
            RouterService.getAcceptor().shutdown();
            Statistics.instance().shutdown();
            ConnectionSettings.EVER_ACCEPTED_INCOMING.setValue(RouterService.acceptedIncomingConnection());
            try {
                catcher.write();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            SettingsHandler.save();
            downloader.writeSnapshot();
            fileManager.stop();
            TigerTreeCache.instance().persistCache();
            LicenseFactory.persistCache();
            RouterService.runShutdownItems();
            _state = 4;
        }
        catch (Throwable throwable) {
            ErrorService.error(throwable);
        }
    }

    public static void shutdown(String string) {
        RouterService.shutdown();
        if (string != null) {
            try {
                Runtime.getRuntime().exec(string);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void adjustSpamFilters() {
        IPFilter.refreshIPFilter();
        Iterator iterator = manager.getConnections().iterator();
        while (iterator.hasNext()) {
            ManagedConnection managedConnection = (ManagedConnection)iterator.next();
            managedConnection.setPersonalFilter(SpamFilter.newPersonalFilter());
            managedConnection.setRouteFilter(SpamFilter.newRouteFilter());
        }
        UDPReplyHandler.setPersonalFilter(SpamFilter.newPersonalFilter());
    }

    public static void setListeningPort(int n) throws IOException {
        acceptor.setListeningPort(n);
    }

    public static boolean acceptedIncomingConnection() {
        return acceptor.acceptedIncoming();
    }

    public static int getActiveConnectionMessages() {
        int n = 0;
        Iterator iterator = manager.getInitializedConnections().iterator();
        while (iterator.hasNext()) {
            ManagedConnection managedConnection = (ManagedConnection)iterator.next();
            n += managedConnection.getNumMessagesSent();
            n += managedConnection.getNumMessagesReceived();
        }
        return n;
    }

    public static int countConnectionsWithNMessages(int n) {
        int n2 = 0;
        Iterator iterator = manager.getInitializedConnections().iterator();
        while (iterator.hasNext()) {
            ManagedConnection managedConnection = (ManagedConnection)iterator.next();
            int n3 = managedConnection.getNumMessagesSent();
            if ((n3 += managedConnection.getNumMessagesReceived()) <= n) continue;
            ++n2;
        }
        return n2;
    }

    public static void dumpConnections() {
        System.out.println("UltraPeer connections");
        RouterService.dumpConnections(manager.getInitializedConnections());
        System.out.println("Leaf connections");
        RouterService.dumpConnections(manager.getInitializedClientConnections());
    }

    private static void dumpConnections(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            System.out.println(iterator.next().toString());
        }
    }

    public static byte[] newQueryGUID() {
        if (RouterService.isOOBCapable() && OutOfBandThroughputStat.isOOBEffectiveForMe()) {
            return GUID.makeAddressEncodedGuid(RouterService.getAddress(), RouterService.getPort());
        }
        return GUID.makeGuid();
    }

    public static void query(byte[] byArray, String string, MediaType mediaType) {
        RouterService.query(byArray, string, "", mediaType);
    }

    public static void query(byte[] byArray, String string) {
        RouterService.query(byArray, string, null);
    }

    public static void query(byte[] byArray, String string, String string2, MediaType mediaType) {
        try {
            QueryRequest queryRequest = null;
            if (RouterService.isIpPortValid() && new GUID(byArray).addressesMatch(RouterService.getAddress(), RouterService.getPort())) {
                queryRequest = QueryRequest.createOutOfBandQuery(byArray, string, string2, mediaType);
                OutOfBandThroughputStat.OOB_QUERIES_SENT.incrementStat();
            } else {
                queryRequest = QueryRequest.createQuery(byArray, string, string2, mediaType);
            }
            RouterService.recordAndSendQuery(queryRequest, mediaType);
        }
        catch (Throwable throwable) {
            ErrorService.error(throwable);
        }
    }

    public static void queryWhatIsNew(byte[] byArray, MediaType mediaType) {
        try {
            QueryRequest queryRequest = null;
            if (GUID.addressesMatch(byArray, RouterService.getAddress(), RouterService.getPort())) {
                queryRequest = QueryRequest.createWhatIsNewOOBQuery(byArray, (byte)2, mediaType);
                OutOfBandThroughputStat.OOB_QUERIES_SENT.incrementStat();
            } else {
                queryRequest = QueryRequest.createWhatIsNewQuery(byArray, (byte)2, mediaType);
            }
            if (FilterSettings.FILTER_WHATS_NEW_ADULT.getValue()) {
                MutableGUIDFilter.instance().addGUID(byArray);
            }
            RouterService.recordAndSendQuery(queryRequest, mediaType);
        }
        catch (Throwable throwable) {
            ErrorService.error(throwable);
        }
    }

    private static void recordAndSendQuery(QueryRequest queryRequest, MediaType mediaType) {
        _lastQueryTime = System.currentTimeMillis();
        VERIFIER.record(queryRequest, mediaType);
        RESULT_HANDLER.addQuery(queryRequest);
        router.sendDynamicQuery(queryRequest);
    }

    public static long getLastQueryTime() {
        return _lastQueryTime;
    }

    public static void stopQuery(GUID gUID) {
        QueryUnicaster.instance().purgeQuery(gUID);
        RESULT_HANDLER.removeQuery(gUID);
        router.queryKilled(gUID);
        if (RouterService.isSupernode()) {
            QueryDispatcher.instance().addToRemove(gUID);
        }
        MutableGUIDFilter.instance().removeGUID(gUID.bytes());
    }

    public static boolean matchesType(byte[] byArray, Response response) {
        return VERIFIER.matchesType(byArray, response);
    }

    public static boolean matchesQuery(byte[] byArray, Response response) {
        return VERIFIER.matchesQuery(byArray, response);
    }

    public static boolean isMandragoreWorm(byte[] byArray, Response response) {
        return VERIFIER.isMandragoreWorm(byArray, response);
    }

    public static Collection getPreferencedHosts(boolean bl, String string, int n) {
        IpPortSet ipPortSet = new IpPortSet();
        if (bl) {
            ipPortSet.addAll(catcher.getUltrapeersWithFreeUltrapeerSlots(string, n));
        } else {
            ipPortSet.addAll(catcher.getUltrapeersWithFreeLeafSlots(string, n));
        }
        if (ipPortSet.size() < n) {
            List list = manager.getInitializedConnectionsMatchLocale(string);
            Iterator iterator = list.iterator();
            while (iterator.hasNext() && ipPortSet.size() < n) {
                ipPortSet.add(iterator.next());
            }
            if (ipPortSet.size() < n) {
                list = manager.getInitializedConnections();
                iterator = list.iterator();
                while (iterator.hasNext() && ipPortSet.size() < n) {
                    ipPortSet.add(iterator.next());
                }
            }
        }
        return ipPortSet;
    }

    public static int getNumConnections() {
        return manager.getNumConnections();
    }

    public static int getNumInitializedConnections() {
        return manager.getNumInitializedConnections();
    }

    public static int getNumUltrapeerToLeafConnections() {
        return manager.getNumInitializedClientConnections();
    }

    public static int getNumLeafToUltrapeerConnections() {
        return manager.getNumClientSupernodeConnections();
    }

    public static int getNumUltrapeerToUltrapeerConnections() {
        return manager.getNumUltrapeerConnections();
    }

    public static int getNumOldConnections() {
        return manager.getNumOldConnections();
    }

    public static boolean isFullyConnected() {
        return manager.isFullyConnected();
    }

    public static boolean isConnected() {
        return manager.isConnected();
    }

    public static boolean isConnecting() {
        return manager.isConnecting();
    }

    public static boolean isFetchingEndpoints() {
        return BootstrapServerManager.instance().isEndpointFetchInProgress();
    }

    public static int getNumSharedFiles() {
        return fileManager.getNumFiles();
    }

    public static int getNumPendingShared() {
        return fileManager.getNumPendingFiles();
    }

    public static int getSharedFileSize() {
        return fileManager.getSize();
    }

    public static FileDesc[] getIncompleteFileDescriptors() {
        return fileManager.getIncompleteFileDescriptors();
    }

    public static FileDesc[] getSharedFileDescriptors(File file) {
        return fileManager.getSharedFileDescriptors(file);
    }

    public static Downloader download(RemoteFileDesc[] remoteFileDescArray, List list, GUID gUID, boolean bl, File file, String string) throws SaveLocationException {
        return downloader.download(remoteFileDescArray, list, gUID, bl, file, string);
    }

    public static Downloader download(RemoteFileDesc[] remoteFileDescArray, List list, GUID gUID, boolean bl) throws SaveLocationException {
        return RouterService.download(remoteFileDescArray, list, gUID, bl, null, null);
    }

    public static Downloader download(RemoteFileDesc[] remoteFileDescArray, GUID gUID, boolean bl, File file, String string) throws SaveLocationException {
        return RouterService.download(remoteFileDescArray, Collections.EMPTY_LIST, gUID, bl, file, string);
    }

    public static Downloader download(RemoteFileDesc[] remoteFileDescArray, boolean bl, GUID gUID) throws SaveLocationException {
        return RouterService.download(remoteFileDescArray, gUID, bl, null, null);
    }

    public static Downloader download(MagnetOptions magnetOptions, boolean bl) throws SaveLocationException {
        if (!magnetOptions.isDownloadable()) {
            throw new IllegalArgumentException("invalid magnet: not have enough information for downloading");
        }
        return downloader.download(magnetOptions, bl, null, magnetOptions.getDisplayName());
    }

    public static Downloader download(MagnetOptions magnetOptions, boolean bl, File file, String string) throws SaveLocationException {
        return downloader.download(magnetOptions, bl, file, string);
    }

    public static Downloader download(File file) throws CantResumeException, SaveLocationException {
        return downloader.download(file);
    }

    public static BrowseHostHandler doAsynchronousBrowseHost(final String string, final int n, GUID gUID, GUID gUID2, final Set set, final boolean bl) {
        final BrowseHostHandler browseHostHandler = new BrowseHostHandler(callback, gUID, gUID2);
        ManagedThread managedThread = new ManagedThread(new Runnable(){

            public void run() {
                try {
                    browseHostHandler.browseHost(string, n, set, bl);
                }
                catch (Throwable throwable) {
                    ErrorService.error(throwable);
                }
            }
        }, "BrowseHoster");
        managedThread.setDaemon(true);
        managedThread.start();
        return browseHostHandler;
    }

    public static boolean isSupernode() {
        return manager.isSupernode();
    }

    public static boolean isShieldedLeaf() {
        return manager.isShieldedLeaf();
    }

    public static int getNumFreeLeafSlots() {
        return manager.getNumFreeLeafSlots();
    }

    public static int getNumFreeNonLeafSlots() {
        return manager.getNumFreeNonLeafSlots();
    }

    public static int getNumFreeLimeWireLeafSlots() {
        return manager.getNumFreeLimeWireLeafSlots();
    }

    public static int getNumFreeLimeWireNonLeafSlots() {
        return manager.getNumFreeLimeWireNonLeafSlots();
    }

    public static void setIsShuttingDown(boolean bl) {
        isShuttingDown = bl;
    }

    public static boolean getIsShuttingDown() {
        return isShuttingDown;
    }

    public static boolean addressChanged() {
        if (callback != null) {
            callback.addressStateChanged();
        }
        byte[] byArray = RouterService.getAddress();
        int n = RouterService.getPort();
        if (!NetworkUtils.isValidAddress(byArray)) {
            return false;
        }
        if (NetworkUtils.isPrivateAddress(byArray)) {
            return false;
        }
        if (!NetworkUtils.isValidPort(n)) {
            return false;
        }
        if (acceptor != null) {
            acceptor.resetLastConnectBackTime();
        }
        if (UDPSERVICE != null) {
            UDPSERVICE.resetLastConnectBackTime();
        }
        if (manager != null) {
            ManagedConnection managedConnection;
            Properties properties = new Properties();
            properties.put("Listen-IP", NetworkUtils.ip2string(byArray) + ":" + n);
            HeaderUpdateVendorMessage headerUpdateVendorMessage = new HeaderUpdateVendorMessage(properties);
            Iterator iterator = manager.getInitializedConnections().iterator();
            while (iterator.hasNext()) {
                managedConnection = (ManagedConnection)iterator.next();
                if (managedConnection.remoteHostSupportsHeaderUpdate() < 1) continue;
                managedConnection.send(headerUpdateVendorMessage);
            }
            iterator = manager.getInitializedClientConnections().iterator();
            while (iterator.hasNext()) {
                managedConnection = (ManagedConnection)iterator.next();
                if (managedConnection.remoteHostSupportsHeaderUpdate() < 1) continue;
                managedConnection.send(headerUpdateVendorMessage);
            }
        }
        return true;
    }

    public static boolean incomingStatusChanged() {
        if (callback != null) {
            callback.addressStateChanged();
        }
        byte[] byArray = RouterService.getAddress();
        int n = RouterService.getPort();
        if (!NetworkUtils.isValidAddress(byArray)) {
            return false;
        }
        if (NetworkUtils.isPrivateAddress(byArray)) {
            return false;
        }
        return NetworkUtils.isValidPort(n);
    }

    public static byte[] getExternalAddress() {
        return acceptor.getExternalAddress();
    }

    public static byte[] getAddress() {
        return acceptor.getAddress(true);
    }

    public static byte[] getNonForcedAddress() {
        return acceptor.getAddress(false);
    }

    public static int getPort() {
        return acceptor.getPort(true);
    }

    public static int getNonForcedPort() {
        return acceptor.getPort(false);
    }

    public static boolean isGUESSCapable() {
        return UDPSERVICE.isGUESSCapable();
    }

    public static boolean isOOBCapable() {
        return RouterService.isGUESSCapable() && OutOfBandThroughputStat.isSuccessRateGood() && !NetworkUtils.isPrivate() && SearchSettings.OOB_ENABLED.getValue() && acceptor.isAddressExternal() && RouterService.isIpPortValid();
    }

    public static GUID getUDPConnectBackGUID() {
        return UDPSERVICE.getConnectBackGUID();
    }

    public static boolean isIpPortValid() {
        return NetworkUtils.isValidAddress(RouterService.getAddress()) && NetworkUtils.isValidPort(RouterService.getPort());
    }

    public static boolean canReceiveSolicited() {
        return UDPSERVICE.canReceiveSolicited();
    }

    public static boolean canReceiveUnsolicited() {
        return UDPSERVICE.canReceiveUnsolicited();
    }

    public static boolean canDoFWT() {
        return UDPSERVICE.canDoFWT();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        manager = new ConnectionManager();
        catcher = new HostCatcher();
        downloader = new DownloadManager();
        uploadManager = new UploadManager();
        pushManager = new PushManager();
        promotionManager = new PromotionManager();
        VERIFIER = new ResponseVerifier();
        STATISTICS = Statistics.instance();
        UDPSERVICE = UDPService.instance();
        RESULT_HANDLER = new SearchResultHandler();
        altManager = AltLocManager.instance();
        SHUTDOWN_ITEMS = Collections.synchronizedList(new LinkedList());
        _lastQueryTime = 0L;
        _fullPower = true;
        byte[] byArray = null;
        try {
            byArray = GUID.fromHexString(ApplicationSettings.CLIENT_ID.getValue());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            byArray = GUID.makeGuid();
            ApplicationSettings.CLIENT_ID.setValue(new GUID(byArray).toHexString());
        }
        MYGUID = byArray;
    }

    private static class Initializer
    implements Runnable {
        private Initializer() {
        }

        public void run() {
            RouterService.getAcceptor().init();
        }
    }
}

