/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.UrnCache;
import com.limegroup.gnutella.UrnCallback;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.util.Comparators;
import com.limegroup.gnutella.util.ProcessingQueue;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class SavedFileManager
implements Runnable {
    private static final Log LOG = LogFactory.getLog((Class)(class$com$limegroup$gnutella$SavedFileManager == null ? (class$com$limegroup$gnutella$SavedFileManager = SavedFileManager.class$("com.limegroup.gnutella.SavedFileManager")) : class$com$limegroup$gnutella$SavedFileManager));
    private static SavedFileManager INSTANCE = new SavedFileManager();
    private static final ProcessingQueue QUEUE = new ProcessingQueue("SavedFileLoader");
    private Set _urns = new HashSet();
    private Set _names = new TreeSet(Comparators.caseInsensitiveStringComparator());
    static /* synthetic */ Class class$com$limegroup$gnutella$SavedFileManager;

    public static SavedFileManager instance() {
        return INSTANCE;
    }

    private SavedFileManager() {
        RouterService.schedule(this, 10000L, 180000L);
    }

    public synchronized void addSavedFile(File file, Set set) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Adding: " + file + " with: " + set));
        }
        this._names.add(file.getName());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            this._urns.add(iterator.next());
        }
    }

    public synchronized boolean isSaved(URN uRN, String string) {
        return uRN != null && this._urns.contains(uRN) || this._names.contains(string);
    }

    public void run() {
        QUEUE.add(new Runnable(){

            public void run() {
                SavedFileManager.this.load();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        LOG.trace((Object)"Loading Saved Files");
        HashSet hashSet = new HashSet();
        TreeSet treeSet = new TreeSet(Comparators.caseInsensitiveStringComparator());
        UrnCallback urnCallback = new UrnCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void urnsCalculated(File file, Set set) {
                SavedFileManager savedFileManager = SavedFileManager.this;
                synchronized (savedFileManager) {
                    SavedFileManager.this._urns.addAll(set);
                }
            }

            public boolean isOwner(Object object) {
                return object == SavedFileManager.this;
            }
        };
        Set set = SharingSettings.getAllSaveDirectories();
        Object object = set.iterator();
        while (object.hasNext()) {
            this.loadDirectory((File)object.next(), hashSet, treeSet, urnCallback);
        }
        object = this;
        synchronized (object) {
            this._urns.addAll(hashSet);
            this._names.addAll(treeSet);
        }
    }

    private void loadDirectory(File file, Set set, Set set2, UrnCallback urnCallback) {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (!file2.isFile() || !file2.exists()) continue;
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Loading: " + file2));
            }
            set2.add(file2.getName());
            Set set3 = UrnCache.instance().getUrns(file2);
            if (set3.isEmpty()) {
                UrnCache.instance().calculateAndCacheUrns(file2, urnCallback);
                continue;
            }
            set.addAll(set3);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

