/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.MessageListener;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.PingRequest;
import com.limegroup.gnutella.util.Cancellable;
import com.limegroup.gnutella.util.IpPort;
import com.limegroup.gnutella.util.ProcessingQueue;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UDPPinger {
    private static final Log LOG = LogFactory.getLog((Class)(class$com$limegroup$gnutella$UDPPinger == null ? (class$com$limegroup$gnutella$UDPPinger = UDPPinger.class$("com.limegroup.gnutella.UDPPinger")) : class$com$limegroup$gnutella$UDPPinger));
    protected static final ProcessingQueue QUEUE = new ProcessingQueue("UDPHostRanker");
    public static int LISTEN_EXPIRE_TIME = 20000;
    private static final long SEND_INTERVAL = 500L;
    private static final int MAX_SENDS = 15;
    private static int _sentAmount;
    private static long _lastSentTime;
    static /* synthetic */ Class class$com$limegroup$gnutella$UDPPinger;

    public void rank(Collection collection) {
        this.rank(collection, null, null, null);
    }

    public void rank(Collection collection, Message message) {
        this.rank(collection, null, null, message);
    }

    public void rank(Collection collection, Cancellable cancellable) {
        this.rank(collection, null, cancellable, null);
    }

    public void rank(Collection collection, MessageListener messageListener) {
        this.rank(collection, messageListener, null, null);
    }

    public void rank(Collection collection, MessageListener messageListener, Cancellable cancellable) {
        this.rank(collection, messageListener, cancellable, null);
    }

    public void rank(Collection collection, MessageListener messageListener, Cancellable cancellable, Message message) {
        if (collection == null) {
            throw new NullPointerException("null hosts not allowed");
        }
        if (cancellable == null) {
            cancellable = new Cancellable(){

                public boolean isCancelled() {
                    return false;
                }
            };
        }
        QUEUE.add(new SenderBundle(collection, messageListener, cancellable, message));
    }

    private boolean waitForListening(Cancellable cancellable) {
        int n;
        for (n = 0; !UDPService.instance().isListening() && n < 10 && !cancellable.isCancelled(); ++n) {
            try {
                Thread.sleep(600L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                ErrorService.error(interruptedException);
            }
        }
        return n < 10;
    }

    protected void send(Collection collection, final MessageListener messageListener, Cancellable cancellable, Message message) {
        if (!this.waitForListening(cancellable)) {
            return;
        }
        if (message == null) {
            message = PingRequest.createUDPPing();
        }
        final byte[] byArray = message.getGUID();
        if (messageListener != null) {
            RouterService.getMessageRouter().registerMessageListener(byArray, messageListener);
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext() && !cancellable.isCancelled()) {
            this.sendSingleMessage((IpPort)iterator.next(), message);
        }
        if (messageListener != null) {
            Runnable runnable = new Runnable(){

                public void run() {
                    RouterService.getMessageRouter().unregisterMessageListener(byArray, messageListener);
                }
            };
            RouterService.schedule(runnable, LISTEN_EXPIRE_TIME, 0L);
        }
    }

    protected void sendSingleMessage(IpPort ipPort, Message message) {
        long l = System.currentTimeMillis();
        if (l > _lastSentTime + 500L) {
            _sentAmount = 0;
        } else if (_sentAmount == 15) {
            try {
                Thread.sleep(500L);
                l = System.currentTimeMillis();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            _sentAmount = 0;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Sending to " + ipPort + ": " + message.getClass() + " " + message));
        }
        UDPService.instance().send(message, ipPort);
        ++_sentAmount;
        _lastSentTime = l;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class SenderBundle
    implements Runnable {
        private final Collection hosts;
        private final MessageListener listener;
        private final Cancellable canceller;
        private final Message message;

        public SenderBundle(Collection collection, MessageListener messageListener, Cancellable cancellable, Message message) {
            this.hosts = collection;
            this.listener = messageListener;
            this.canceller = cancellable;
            this.message = message;
        }

        public void run() {
            UDPPinger.this.send(this.hosts, this.listener, this.canceller, this.message);
        }
    }
}

