/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.bitzi.util.Base32;
import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.BandwidthTracker;
import com.limegroup.gnutella.ByteReader;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.IncompleteFileDesc;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.Uploader;
import com.limegroup.gnutella.downloader.Interval;
import com.limegroup.gnutella.http.HTTPRequestMethod;
import com.limegroup.gnutella.http.ProblemReadingHeaderException;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.settings.UploadSettings;
import com.limegroup.gnutella.statistics.UploadStat;
import com.limegroup.gnutella.uploader.FreeloaderUploadingException;
import com.limegroup.gnutella.uploader.HTTPUploader;
import com.limegroup.gnutella.uploader.StalledUploadWatchdog;
import com.limegroup.gnutella.util.Buffer;
import com.limegroup.gnutella.util.FixedSizeExpiringSet;
import com.limegroup.gnutella.util.FixedsizeForgetfulHashMap;
import com.limegroup.gnutella.util.IOUtils;
import com.limegroup.gnutella.util.KeyValue;
import com.limegroup.gnutella.util.URLDecoder;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UploadManager
implements BandwidthTracker {
    private volatile List _activeUploads = Collections.EMPTY_LIST;
    private static final Log LOG = LogFactory.getLog((Class)(class$com$limegroup$gnutella$UploadManager == null ? (class$com$limegroup$gnutella$UploadManager = UploadManager.class$("com.limegroup.gnutella.UploadManager")) : class$com$limegroup$gnutella$UploadManager));
    private final int BYPASS_QUEUE = -1;
    private final int REJECTED = 0;
    private final int QUEUED = 1;
    private final int ACCEPTED = 2;
    private final int BANNED = 3;
    public static final int MIN_POLL_TIME = 45000;
    public static final int MAX_POLL_TIME = 120000;
    private volatile List _activeUploadList = new LinkedList();
    private List _queuedUploads = new ArrayList();
    private volatile boolean _hadSuccesfulUpload = false;
    private int _forcedUploads;
    private static final int MAX_SPEED_SAMPLE_SIZE = 5;
    private static final int MIN_SPEED_SAMPLE_SIZE = 5;
    private static final int MIN_SAMPLE_BYTES = 200000;
    private Buffer speeds = new Buffer(5);
    private volatile int highestSpeed = -1;
    private int numMeasures = 0;
    private float averageBandwidth = 0.0f;
    private static final float MINIMUM_UPLOAD_SPEED = 3.0f;
    public static final int BROWSE_HOST_FILE_INDEX = -1;
    public static final int UPDATE_FILE_INDEX = -2;
    public static final int BAD_URN_QUERY_INDEX = -3;
    public static final int MALFORMED_REQUEST_INDEX = -4;
    public static final int PUSH_PROXY_FILE_INDEX = -5;
    public static final int FILE_VIEW_FILE_INDEX = -6;
    public static final int RESOURCE_INDEX = -7;
    public static final int BROWSER_CONTROL_INDEX = -8;
    public static final String BROWSER_CONTROL_STR = "/browser-control";
    public static final String SERVICE_ID = "service_id";
    public static final String FV_REQ_BEGIN = "/gnutella/file-view";
    public static final String RESOURCE_GET = "/gnutella/res/";
    private final Map REQUESTS = new FixedsizeForgetfulHashMap(250);
    static /* synthetic */ Class class$com$limegroup$gnutella$UploadManager;

    public List getActiveUploads() {
        if (!((Object)this._activeUploads).equals(this._activeUploadList)) {
            LinkedList linkedList = new LinkedList(this._activeUploadList);
            this._activeUploads = Collections.unmodifiableList(linkedList);
        }
        return this._activeUploads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void acceptUpload(HTTPRequestMethod hTTPRequestMethod, Socket socket, boolean bl) {
        LOG.trace((Object)"accepting upload");
        HTTPUploader hTTPUploader = null;
        long l = -1L;
        try {
            try {
                int n = -1;
                String string = "";
                HTTPRequestMethod hTTPRequestMethod2 = hTTPRequestMethod;
                StalledUploadWatchdog stalledUploadWatchdog = new StalledUploadWatchdog();
                BufferedInputStream bufferedInputStream = null;
                boolean bl2 = false;
                while (true) {
                    if (hTTPUploader != null) {
                        this.assertAsComplete(hTTPUploader.getState());
                    }
                    if (bufferedInputStream == null) {
                        bufferedInputStream = new BufferedInputStream(socket.getInputStream());
                    }
                    LOG.trace((Object)"parsing http line.");
                    HttpRequestLine httpRequestLine = this.parseHttpRequest(socket, bufferedInputStream);
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("line = " + httpRequestLine));
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)(hTTPUploader + " successfully parsed request"));
                    }
                    String string2 = httpRequestLine._fileName;
                    bl2 = hTTPUploader == null || hTTPRequestMethod2 != hTTPUploader.getMethod() || !string.equalsIgnoreCase(string2);
                    if (bl2) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)(hTTPUploader + " starting new file " + httpRequestLine._fileName + " index " + httpRequestLine._index));
                        }
                        if (hTTPUploader != null) {
                            if (n != 1) {
                                n = -1;
                            } else {
                                hTTPUploader.setState(5);
                            }
                            this.cleanupFinishedUploader(hTTPUploader, l);
                        }
                        hTTPUploader = new HTTPUploader(hTTPRequestMethod2, string2, socket, httpRequestLine._index, httpRequestLine.getParameters(), stalledUploadWatchdog, httpRequestLine.hadPassword());
                    } else {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)(hTTPUploader + " continuing old file"));
                        }
                        hTTPUploader.reinitialize(hTTPRequestMethod2, httpRequestLine.getParameters());
                    }
                    this.assertAsConnecting(hTTPUploader.getState());
                    this.setInitialUploadingState(hTTPUploader);
                    try {
                        hTTPUploader.readHeader(bufferedInputStream);
                        this.setUploaderStateOffHeaders(hTTPUploader);
                    }
                    catch (ProblemReadingHeaderException problemReadingHeaderException) {
                        hTTPUploader.setState(11);
                    }
                    catch (FreeloaderUploadingException freeloaderUploadingException) {
                        hTTPUploader.setState(1);
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)(hTTPUploader + " HTTPUploader created and read all headers"));
                    }
                    if (n != 2 && (n = this.processNewRequest(hTTPUploader, socket, bl)) == 2) {
                        l = System.currentTimeMillis();
                    }
                    if (bl2) {
                        this.addToGUI(hTTPUploader);
                    }
                    this.doSingleUpload(hTTPUploader);
                    this.assertAsFinished(hTTPUploader.getState());
                    string = string2;
                    if (!httpRequestLine.isHTTP11()) {
                        Object var18_19 = null;
                        if (hTTPUploader != null && hTTPUploader.getState() != 4) {
                            hTTPUploader.setState(5);
                        }
                        UploadManager uploadManager = this;
                        // MONITORENTER : uploadManager
                        boolean bl3 = false;
                        Iterator iterator = this._queuedUploads.iterator();
                        while (iterator.hasNext()) {
                            KeyValue keyValue = (KeyValue)iterator.next();
                            if (keyValue.getKey() != socket) continue;
                            iterator.remove();
                            bl3 = true;
                            break;
                        }
                        if (bl3) {
                            hTTPUploader.setState(5);
                        }
                        // MONITOREXIT : uploadManager
                        if (hTTPUploader != null) {
                            hTTPUploader.stop();
                            this.cleanupFinishedUploader(hTTPUploader, l);
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)(hTTPUploader + " closing socket"));
                        }
                        this.close(socket);
                        return;
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)(hTTPUploader + " waiting for next request with socket "));
                    }
                    int n2 = socket.getSoTimeout();
                    if (n != 1) {
                        socket.setSoTimeout(SharingSettings.PERSISTENT_HTTP_CONNECTION_TIMEOUT.getValue());
                    }
                    String string3 = IOUtils.readWord(bufferedInputStream, 4);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)(hTTPUploader + " next request arrived "));
                    }
                    socket.setSoTimeout(n2);
                    if (string3.equals("GET")) {
                        hTTPRequestMethod2 = HTTPRequestMethod.GET;
                        UploadStat.SUBSEQUENT_GET.incrementStat();
                        continue;
                    }
                    if (!string3.equals("HEAD")) break;
                    hTTPRequestMethod2 = HTTPRequestMethod.HEAD;
                    UploadStat.SUBSEQUENT_HEAD.incrementStat();
                }
                UploadStat.SUBSEQUENT_UNKNOWN.incrementStat();
                Object var18_20 = null;
                if (hTTPUploader != null && hTTPUploader.getState() != 4) {
                    hTTPUploader.setState(5);
                }
                UploadManager uploadManager = this;
                // MONITORENTER : uploadManager
                boolean bl4 = false;
                Iterator iterator = this._queuedUploads.iterator();
                while (iterator.hasNext()) {
                    KeyValue keyValue = (KeyValue)iterator.next();
                    if (keyValue.getKey() != socket) continue;
                    iterator.remove();
                    bl4 = true;
                    break;
                }
                if (bl4) {
                    hTTPUploader.setState(5);
                }
                // MONITOREXIT : uploadManager
                if (hTTPUploader != null) {
                    hTTPUploader.stop();
                    this.cleanupFinishedUploader(hTTPUploader, l);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(hTTPUploader + " closing socket"));
                }
                this.close(socket);
                return;
            }
            catch (IOException iOException) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(hTTPUploader + " IOE thrown, closing socket"), (Throwable)iOException);
                }
                Object var18_21 = null;
                if (hTTPUploader != null && hTTPUploader.getState() != 4) {
                    hTTPUploader.setState(5);
                }
                UploadManager uploadManager = this;
                // MONITORENTER : uploadManager
                boolean bl5 = false;
                Iterator iterator = this._queuedUploads.iterator();
                while (iterator.hasNext()) {
                    KeyValue keyValue = (KeyValue)iterator.next();
                    if (keyValue.getKey() != socket) continue;
                    iterator.remove();
                    bl5 = true;
                    break;
                }
                if (bl5) {
                    hTTPUploader.setState(5);
                }
                // MONITOREXIT : uploadManager
                if (hTTPUploader != null) {
                    hTTPUploader.stop();
                    this.cleanupFinishedUploader(hTTPUploader, l);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(hTTPUploader + " closing socket"));
                }
                this.close(socket);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var18_22 = null;
            if (hTTPUploader != null && hTTPUploader.getState() != 4) {
                hTTPUploader.setState(5);
            }
            UploadManager uploadManager = this;
            // MONITORENTER : uploadManager
            boolean bl6 = false;
            Iterator iterator = this._queuedUploads.iterator();
            while (iterator.hasNext()) {
                KeyValue keyValue = (KeyValue)iterator.next();
                if (keyValue.getKey() != socket) continue;
                iterator.remove();
                bl6 = true;
                break;
            }
            if (bl6) {
                hTTPUploader.setState(5);
            }
            // MONITOREXIT : uploadManager
            if (hTTPUploader != null) {
                hTTPUploader.stop();
                this.cleanupFinishedUploader(hTTPUploader, l);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(hTTPUploader + " closing socket"));
            }
            this.close(socket);
            throw throwable;
        }
    }

    private boolean shouldShowInGUI(HTTPUploader hTTPUploader) {
        return hTTPUploader.getIndex() != -1 && hTTPUploader.getIndex() != -5 && hTTPUploader.getIndex() != -2 && hTTPUploader.getIndex() != -4 && hTTPUploader.getIndex() != -3 && hTTPUploader.getIndex() != -6 && hTTPUploader.getIndex() != -7 && hTTPUploader.getIndex() != -8 && hTTPUploader.getMethod() != HTTPRequestMethod.HEAD && !hTTPUploader.isForcedShare();
    }

    private boolean shouldBypassQueue(HTTPUploader hTTPUploader) {
        return hTTPUploader.getState() != 0 || hTTPUploader.getMethod() == HTTPRequestMethod.HEAD || hTTPUploader.isForcedShare();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupFinishedUploader(HTTPUploader hTTPUploader, long l) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)(hTTPUploader + " cleaning up finished."));
        }
        int n = hTTPUploader.getState();
        int n2 = hTTPUploader.getLastTransferState();
        this.assertAsFinished(n);
        long l2 = System.currentTimeMillis();
        Object object = this;
        synchronized (object) {
            if (l > 0L) {
                this.reportUploadSpeed(l2 - l, hTTPUploader.getTotalAmountUploaded());
            }
            this.removeFromList(hTTPUploader);
        }
        hTTPUploader.closeFileStreams();
        switch (n) {
            case 4: {
                UploadStat.COMPLETED.incrementStat();
                if (n2 != 3 && n2 != 15) break;
                UploadStat.COMPLETED_FILE.incrementStat();
                break;
            }
            case 5: {
                UploadStat.INTERRUPTED.incrementStat();
            }
        }
        if (this.shouldShowInGUI(hTTPUploader)) {
            object = hTTPUploader.getFileDesc();
            if (object != null && n == 4 && (n2 == 3 || n2 == 15)) {
                ((FileDesc)object).incrementCompletedUploads();
                RouterService.getCallback().handleSharedFileUpdate(((FileDesc)object).getFile());
            }
            RouterService.getCallback().removeUpload(hTTPUploader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setInitialUploadingState(HTTPUploader hTTPUploader) {
        switch (hTTPUploader.getIndex()) {
            case -1: {
                hTTPUploader.setState(8);
                return;
            }
            case -8: {
                hTTPUploader.setState(16);
                return;
            }
            case -5: {
                hTTPUploader.setState(12);
                return;
            }
            case -2: {
                hTTPUploader.setState(10);
                return;
            }
            case -3: {
                hTTPUploader.setState(7);
                return;
            }
            case -4: {
                hTTPUploader.setState(11);
                return;
            }
        }
        FileManager fileManager = RouterService.getFileManager();
        FileDesc fileDesc = null;
        int n = hTTPUploader.getIndex();
        FileManager fileManager2 = fileManager;
        synchronized (fileManager2) {
            if (fileManager.isValidIndex(n)) {
                fileDesc = fileManager.get(n);
            }
        }
        if (fileDesc == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(hTTPUploader + " fd is null"));
            }
            hTTPUploader.setState(7);
            return;
        }
        if (!hTTPUploader.getFileName().equals(fileDesc.getFileName())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(hTTPUploader + " wrong file name"));
            }
            hTTPUploader.setState(7);
            return;
        }
        try {
            hTTPUploader.setFileDesc(fileDesc);
        }
        catch (IOException iOException) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(hTTPUploader + " could not create file stream " + iOException));
            }
            hTTPUploader.setState(7);
            return;
        }
        this.assertAsConnecting(hTTPUploader.getState());
    }

    private void setUploaderStateOffHeaders(HTTPUploader hTTPUploader) {
        FileDesc fileDesc = hTTPUploader.getFileDesc();
        if (hTTPUploader.getState() == 0) {
            URN uRN = hTTPUploader.getRequestedURN();
            if (fileDesc != null && uRN != null && !fileDesc.containsUrn(uRN)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(hTTPUploader + " wrong content urn"));
                }
                hTTPUploader.setState(7);
                return;
            }
            if (hTTPUploader.isTHEXRequest()) {
                if (hTTPUploader.getFileDesc().getHashTree() != null) {
                    hTTPUploader.setState(15);
                } else {
                    hTTPUploader.setState(7);
                }
                return;
            }
            if (fileDesc instanceof IncompleteFileDesc) {
                if (!UploadSettings.ALLOW_PARTIAL_SHARING.getValue()) {
                    hTTPUploader.setState(7);
                    return;
                }
                if (hTTPUploader.isTHEXRequest()) {
                    hTTPUploader.setState(7);
                    return;
                }
                IncompleteFileDesc incompleteFileDesc = (IncompleteFileDesc)fileDesc;
                int n = hTTPUploader.getUploadBegin();
                int n2 = hTTPUploader.getUploadEnd() - 1;
                if (hTTPUploader.containedRangeRequest()) {
                    Interval interval = incompleteFileDesc.getAvailableSubRange(n, n2);
                    if (interval == null) {
                        hTTPUploader.setState(13);
                        return;
                    }
                    hTTPUploader.setUploadBeginAndEnd(interval.low, interval.high + 1);
                } else if (!incompleteFileDesc.isRangeSatisfiable(n, n2)) {
                    hTTPUploader.setState(13);
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int processNewRequest(HTTPUploader hTTPUploader, Socket socket, boolean bl) throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)(hTTPUploader + " processing new request."));
        }
        int n = -1;
        n = !this.shouldBypassQueue(hTTPUploader) ? (bl ? 2 : this.checkAndQueue(hTTPUploader, socket)) : -1;
        switch (n) {
            case 0: {
                hTTPUploader.setState(2);
                break;
            }
            case 3: {
                hTTPUploader.setState(14);
                break;
            }
            case 1: {
                hTTPUploader.setState(9);
                socket.setSoTimeout(120000);
                break;
            }
            case 2: {
                this.assertAsConnecting(hTTPUploader.getState());
                UploadManager uploadManager = this;
                synchronized (uploadManager) {
                    if (hTTPUploader.isForcedShare()) {
                        ++this._forcedUploads;
                    }
                    this._activeUploadList.add(hTTPUploader);
                    break;
                }
            }
            case -1: {
                break;
            }
            default: {
                Assert.that(false, "Invalid queued state: " + n);
            }
        }
        return n;
    }

    private void addToGUI(HTTPUploader hTTPUploader) {
        UploadStat.ATTEMPTED.incrementStat();
        if (this.shouldShowInGUI(hTTPUploader)) {
            RouterService.getCallback().addUpload(hTTPUploader);
            FileDesc fileDesc = hTTPUploader.getFileDesc();
            if (fileDesc != null) {
                fileDesc.incrementAttemptedUploads();
                RouterService.getCallback().handleSharedFileUpdate(fileDesc.getFile());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSingleUpload(HTTPUploader hTTPUploader) throws IOException {
        switch (hTTPUploader.getState()) {
            case 13: {
                UploadStat.UNAVAILABLE_RANGE.incrementStat();
                break;
            }
            case 7: {
                UploadStat.FILE_NOT_FOUND.incrementStat();
                break;
            }
            case 1: {
                UploadStat.FREELOADER.incrementStat();
                break;
            }
            case 2: {
                UploadStat.LIMIT_REACHED.incrementStat();
                break;
            }
            case 9: {
                UploadStat.QUEUED.incrementStat();
                break;
            }
            case 14: {
                UploadStat.BANNED.incrementStat();
                break;
            }
            case 0: {
                hTTPUploader.setState(3);
                UploadStat.UPLOADING.incrementStat();
                break;
            }
            case 15: {
                UploadStat.THEX.incrementStat();
                break;
            }
            case 4: 
            case 5: {
                Assert.that(false, "invalid state in doSingleUpload");
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)(hTTPUploader + " doing single upload"));
        }
        boolean bl = false;
        try {
            hTTPUploader.initializeStreams();
            hTTPUploader.writeResponse();
            bl = hTTPUploader.getCloseConnection();
            hTTPUploader.setState(4);
        }
        finally {
            hTTPUploader.closeFileStreams();
        }
        if (bl) {
            throw new IOException("close connection");
        }
    }

    public void close(Socket socket) {
        try {
            if (socket != null) {
                socket.getOutputStream().close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (socket != null) {
                socket.getInputStream().close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (socket != null) {
                socket.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized boolean isServiceable() {
        return this.hasFreeSlot(this.uploadsInProgress() + this.getNumQueuedUploads());
    }

    public synchronized int uploadsInProgress() {
        return this._activeUploadList.size() - this._forcedUploads;
    }

    public synchronized int getNumQueuedUploads() {
        return this._queuedUploads.size();
    }

    public boolean hadSuccesfulUpload() {
        return this._hadSuccesfulUpload;
    }

    public synchronized boolean isConnectedTo(InetAddress inetAddress) {
        Object object;
        Object object2;
        Iterator iterator = this._queuedUploads.iterator();
        while (iterator.hasNext()) {
            object2 = (KeyValue)iterator.next();
            object = (Socket)((KeyValue)object2).getKey();
            if (object == null || !((Socket)object).getInetAddress().equals(inetAddress)) continue;
            return true;
        }
        iterator = this._activeUploadList.iterator();
        while (iterator.hasNext()) {
            object2 = (HTTPUploader)iterator.next();
            object = ((HTTPUploader)object2).getConnectedHost();
            if (object == null || !((InetAddress)object).equals(inetAddress)) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean killUploadsForFileDesc(FileDesc fileDesc) {
        boolean bl = false;
        Iterator iterator = this._activeUploadList.iterator();
        while (iterator.hasNext()) {
            HTTPUploader hTTPUploader = (HTTPUploader)iterator.next();
            FileDesc fileDesc2 = hTTPUploader.getFileDesc();
            if (fileDesc2 == null || !fileDesc2.equals(fileDesc)) continue;
            bl = true;
            hTTPUploader.stop();
        }
        return bl;
    }

    private synchronized int checkAndQueue(Uploader uploader, Socket socket) throws IOException {
        RequestCache requestCache = (RequestCache)this.REQUESTS.get(uploader.getHost());
        if (requestCache == null) {
            requestCache = new RequestCache();
        }
        this.REQUESTS.put(uploader.getHost(), requestCache);
        requestCache.countRequest();
        if (requestCache.isHammering()) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)(uploader + " banned."));
            }
            return 3;
        }
        boolean bl = requestCache.isGreedy(uploader.getFileDesc().getSHA1Urn());
        int n = this._queuedUploads.size();
        int n2 = this.positionInQueue(socket);
        int n3 = UploadSettings.UPLOAD_QUEUE_SIZE.getValue();
        boolean bl2 = n >= n3 || requestCache.isDupe(uploader.getFileDesc().getSHA1Urn());
        int n4 = -1;
        boolean bl3 = false;
        if (bl && n >= 1) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)(uploader + " greedy -- limit reached."));
            }
            UploadStat.LIMIT_REACHED_GREEDY.incrementStat();
            bl3 = true;
        } else if (n2 < 0 && (bl3 = this.hostLimitReached(uploader.getHost()))) {
            requestCache.limitReached(uploader.getFileDesc().getSHA1Urn());
        }
        boolean bl4 = uploader.supportsQueueing();
        Assert.that(n3 > 0, "queue size 0, cannot use");
        Assert.that(uploader.getState() == 0, "Bad state: " + uploader.getState());
        Assert.that(uploader.getMethod() == HTTPRequestMethod.GET);
        if (n2 == -1) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(uploader + "Uploader not in que(capacity:" + n3 + ")"));
            }
            if (bl3 || bl2) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(uploader + " limited? " + bl3 + " wontAccept? " + bl2));
                }
                return 0;
            }
            this.addToQueue(socket);
            n2 = n;
            n4 = 1;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(uploader + " new uploader added to queue"));
            }
        } else {
            KeyValue keyValue = (KeyValue)this._queuedUploads.get(n2);
            Long l = (Long)keyValue.getValue();
            if (l + 45000L > System.currentTimeMillis()) {
                this._queuedUploads.remove(n2);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(uploader + " queued uploader flooding-throwing exception"));
                }
                throw new IOException();
            }
            if (requestCache.isDupe(uploader.getFileDesc().getSHA1Urn())) {
                return 0;
            }
            keyValue.setValue(new Long(System.currentTimeMillis()));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(uploader + " updated queued uploader"));
            }
            n4 = 1;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(uploader + " checking if given uploader is can be accomodated "));
        }
        if (this.hasFreeSlot(n2 + this.uploadsInProgress())) {
            n4 = 2;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(uploader + " accepting upload"));
            }
            this._queuedUploads.remove(n2);
        } else if (!bl4) {
            this._queuedUploads.remove(n2);
            n4 = 0;
        }
        if (n4 == 2) {
            requestCache.startedUpload(uploader.getFileDesc().getSHA1Urn());
        }
        return n4;
    }

    private synchronized void addToQueue(Socket socket) {
        Long l = new Long(System.currentTimeMillis());
        this._queuedUploads.add(new KeyValue(socket, l));
    }

    public synchronized int positionInQueue(Socket socket) {
        int n = 0;
        Iterator iterator = this._queuedUploads.iterator();
        while (iterator.hasNext()) {
            Object object = ((KeyValue)iterator.next()).getKey();
            if (object == socket) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private synchronized void removeFromList(Uploader uploader) {
        if (this._activeUploadList.remove(uploader)) {
            RequestCache requestCache;
            if (((HTTPUploader)uploader).isForcedShare()) {
                --this._forcedUploads;
            }
            if ((requestCache = (RequestCache)this.REQUESTS.get(uploader.getHost())) != null && uploader != null && uploader.getFileDesc() != null) {
                requestCache.uploadDone(uploader.getFileDesc().getSHA1Urn());
            }
        }
        if (this._activeUploadList.size() == 0) {
            RouterService.getCallback().uploadsComplete();
        }
    }

    private synchronized boolean hostLimitReached(String string) {
        Object object;
        int n = UploadSettings.UPLOADS_PER_PERSON.getValue();
        int n2 = 0;
        Iterator iterator = this._activeUploadList.iterator();
        while (iterator.hasNext()) {
            object = (Uploader)iterator.next();
            if (!object.getHost().equals(string)) continue;
            ++n2;
        }
        iterator = this._queuedUploads.iterator();
        while (iterator.hasNext()) {
            object = (Socket)((KeyValue)iterator.next()).getKey();
            if (!((Socket)object).getInetAddress().getHostAddress().equals(string)) continue;
            ++n2;
        }
        return n2 >= n;
    }

    private boolean hasFreeSlot(int n) {
        if (n >= UploadSettings.HARD_MAX_UPLOADS.getValue()) {
            return false;
        }
        if (n < UploadSettings.SOFT_MAX_UPLOADS.getValue()) {
            return true;
        }
        float f = 0.0f;
        Iterator iterator = this._activeUploadList.iterator();
        while (iterator.hasNext()) {
            BandwidthTracker bandwidthTracker = (BandwidthTracker)iterator.next();
            float f2 = 0.0f;
            try {
                f2 = bandwidthTracker.getMeasuredBandwidth();
            }
            catch (InsufficientDataException insufficientDataException) {
                f2 = 0.0f;
            }
            f = Math.max(f, f2);
        }
        return f > 3.0f;
    }

    public int calculateBandwidth() {
        float f = this.getTotalBandwith();
        float f2 = f / (float)this.uploadsInProgress();
        return (int)f2;
    }

    private float getTotalBandwith() {
        float f = (float)ConnectionSettings.CONNECTION_SPEED.getValue() / 8.0f;
        float f2 = UploadSettings.UPLOAD_SPEED.getValue();
        float f3 = f * f2 / 100.0f;
        return f3;
    }

    public int measuredUploadSpeed() {
        return this.highestSpeed;
    }

    private void reportUploadSpeed(long l, long l2) {
        if (l2 < 200000L) {
            return;
        }
        int n = 8 * (int)((float)l2 / (float)l);
        this.speeds.add(new Integer(n));
        if (this.speeds.size() >= 5) {
            int n2 = 0;
            for (int i = 0; i < this.speeds.size(); ++i) {
                n2 = Math.max(n2, (Integer)this.speeds.get(i));
            }
            this.highestSpeed = n2;
        }
    }

    private HttpRequestLine parseHttpRequest(Socket socket, InputStream inputStream) throws IOException {
        socket.setSoTimeout(8000);
        ByteReader byteReader = new ByteReader(inputStream);
        LOG.trace((Object)"trying to read request.");
        String string = byteReader.readLine();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("request is: " + string));
        }
        try {
            if (string == null) {
                throw new IOException();
            }
            string.trim();
            if (this.isURNGet(string)) {
                return this.parseURNGet(string);
            }
            return UploadManager.parseTraditionalGet(string);
        }
        catch (IOException iOException) {
            LOG.debug((Object)"http request failed", (Throwable)iOException);
            UploadStat.MALFORMED_REQUEST.incrementStat();
            if (string == null) {
                return new HttpRequestLine(-4, "Malformed Request", false);
            }
            return new HttpRequestLine(-4, "Malformed Request", UploadManager.isHTTP11Request(string));
        }
    }

    private boolean isURNGet(String string) {
        int n = string.indexOf("/");
        int n2 = string.indexOf("/", n + 1);
        if (n == -1 || n2 == -1) {
            return false;
        }
        String string2 = string.substring(n + 1, n2);
        return string2.equalsIgnoreCase("uri-res");
    }

    private static HttpRequestLine parseTraditionalGet(String string) throws IOException {
        try {
            int n;
            int n2 = -1;
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            if (stringTokenizer.countTokens() < 2) {
                throw new IOException("invalid request: " + string);
            }
            String string2 = stringTokenizer.nextToken().trim();
            String string3 = null;
            HashMap<String, Integer> hashMap = null;
            boolean bl = false;
            if (string2.equals("/")) {
                n2 = -1;
                string3 = "Browse-Host Request";
                UploadStat.BROWSE_HOST.incrementStat();
            } else if (string2.startsWith(BROWSER_CONTROL_STR)) {
                n2 = -8;
                string3 = string2;
            } else if (string2.startsWith(FV_REQ_BEGIN)) {
                n2 = -6;
                string3 = string2;
            } else if (string2.startsWith(RESOURCE_GET)) {
                n2 = -7;
                string3 = string2.substring(RESOURCE_GET.length());
            } else if (string2.equals("/update.xml")) {
                n2 = -2;
                string3 = "Update-File Request";
                UploadStat.UPDATE_FILE.incrementStat();
            } else if (string2.startsWith("/gnutella/push-proxy") || string2.startsWith("/gnet/push-proxy")) {
                n = string2.indexOf(63);
                if (n == -1) {
                    throw new IOException("Malformed PushProxy Req");
                }
                string2 = string2.substring(n + 1);
                n2 = -5;
                StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "=&");
                if (stringTokenizer2.countTokens() < 2 || stringTokenizer2.countTokens() % 2 != 0) {
                    throw new IOException("Malformed PushProxy HTTP Request");
                }
                Integer n3 = null;
                while (stringTokenizer2.hasMoreTokens()) {
                    String string4 = stringTokenizer2.nextToken();
                    String string5 = stringTokenizer2.nextToken();
                    if (string4.equalsIgnoreCase("ServerId")) {
                        if (string3 != null) {
                            throw new IOException("Malformed PushProxy Req");
                        }
                        byte[] byArray = Base32.decode(string5);
                        if (byArray.length != 16) {
                            throw new IOException("Malformed PushProxy Req");
                        }
                        string3 = new GUID(byArray).toHexString();
                        continue;
                    }
                    if (string4.equalsIgnoreCase("guid")) {
                        if (string3 != null) {
                            throw new IOException("Malformed PushProxy Req");
                        }
                        if (string5.length() != 32) {
                            throw new IOException("Malformed PushProxy Req");
                        }
                        string3 = string5;
                        continue;
                    }
                    if (!string4.equalsIgnoreCase("file")) continue;
                    if (n3 != null) {
                        throw new IOException("Malformed PushProxy Req");
                    }
                    n3 = Integer.valueOf(string5);
                    if (n3 < 0) {
                        throw new IOException("Malformed PushProxy Req");
                    }
                    if (hashMap == null) {
                        hashMap = new HashMap<String, Integer>();
                    }
                    hashMap.put("file", n3);
                }
                UploadStat.PUSH_PROXY.incrementStat();
            } else {
                n = string.indexOf("/get/");
                int n4 = string.indexOf("/", n + 5);
                String string6 = string.substring(n + 5, n4);
                n2 = Integer.parseInt(string6);
                int n5 = string.indexOf(" HTTP/", n4);
                try {
                    string3 = URLDecoder.decode(string.substring(n4 + 1, n5));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    string3 = string.substring(n4 + 1, n5);
                }
                UploadStat.TRADITIONAL_GET.incrementStat();
            }
            n = UploadManager.isHTTP11Request(string);
            return new HttpRequestLine(n2, string3, n != 0, hashMap, bl);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IOException();
        }
    }

    private HttpRequestLine parseURNGet(String string) throws IOException {
        URN uRN = URN.createSHA1UrnFromHttpRequest(string);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string2 = string.toUpperCase(Locale.US);
        if (string2.indexOf("N2X?") > 0) {
            hashMap.put(SERVICE_ID, "N2X?");
        } else if (string2.indexOf("N2R?") > 0) {
            hashMap.put(SERVICE_ID, "N2R?");
        } else {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("Invalid URN query: " + string));
            }
            return new HttpRequestLine(-3, "Invalid URN query", UploadManager.isHTTP11Request(string));
        }
        FileDesc fileDesc = RouterService.getFileManager().getFileDescForUrn(uRN);
        if (fileDesc == null) {
            UploadStat.UNKNOWN_URN_GET.incrementStat();
            return new HttpRequestLine(-3, "Invalid URN query", UploadManager.isHTTP11Request(string));
        }
        UploadStat.URN_GET.incrementStat();
        return new HttpRequestLine(fileDesc.getIndex(), fileDesc.getFileName(), UploadManager.isHTTP11Request(string), hashMap, false);
    }

    private static boolean isHTTP11Request(String string) {
        return string.endsWith("1.1");
    }

    private void assertAsConnecting(int n) {
        Assert.that(n == 0, "invalid state: " + n);
    }

    private void assertAsComplete(int n) {
        Assert.that(n == 4, "invalid state: " + n);
    }

    private void assertAsFinished(int n) {
        Assert.that(n == 5 || n == 4, "invalid state: " + n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void measureBandwidth() {
        ArrayList arrayList;
        UploadManager uploadManager = this;
        synchronized (uploadManager) {
            arrayList = new ArrayList(this._activeUploadList);
        }
        float f = 0.0f;
        boolean bl = false;
        Object object = arrayList.iterator();
        while (object.hasNext()) {
            HTTPUploader hTTPUploader = (HTTPUploader)object.next();
            if (hTTPUploader.isForcedShare()) continue;
            bl = true;
            hTTPUploader.measureBandwidth();
            f += hTTPUploader.getAverageBandwidth();
        }
        if (bl) {
            object = this;
            synchronized (object) {
                this.averageBandwidth = (this.averageBandwidth * (float)this.numMeasures + f) / (float)(++this.numMeasures);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getMeasuredBandwidth() {
        ArrayList arrayList;
        UploadManager uploadManager = this;
        synchronized (uploadManager) {
            arrayList = new ArrayList(this._activeUploadList);
        }
        float f = 0.0f;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            HTTPUploader hTTPUploader = (HTTPUploader)iterator.next();
            if (hTTPUploader.isForcedShare()) continue;
            f += hTTPUploader.getMeasuredBandwidth();
        }
        return f;
    }

    public synchronized float getAverageBandwidth() {
        return this.averageBandwidth;
    }

    static void tBandwidthTracker(UploadManager uploadManager) {
        uploadManager.reportUploadSpeed(100000L, 1000000L);
        Assert.that(uploadManager.measuredUploadSpeed() == -1);
        uploadManager.reportUploadSpeed(100000L, 2000000L);
        Assert.that(uploadManager.measuredUploadSpeed() == -1);
        uploadManager.reportUploadSpeed(100000L, 3000000L);
        Assert.that(uploadManager.measuredUploadSpeed() == -1);
        uploadManager.reportUploadSpeed(100000L, 4000000L);
        Assert.that(uploadManager.measuredUploadSpeed() == -1);
        uploadManager.reportUploadSpeed(100000L, 5000000L);
        Assert.that(uploadManager.measuredUploadSpeed() == 400);
        uploadManager.reportUploadSpeed(100000L, 6000000L);
        Assert.that(uploadManager.measuredUploadSpeed() == 480);
        uploadManager.reportUploadSpeed(1L, 1000L);
        Assert.that(uploadManager.measuredUploadSpeed() == 480);
        uploadManager.reportUploadSpeed(100000L, 1000000L);
        uploadManager.reportUploadSpeed(100000L, 1000000L);
        uploadManager.reportUploadSpeed(100000L, 1000000L);
        uploadManager.reportUploadSpeed(100000L, 1000000L);
        uploadManager.reportUploadSpeed(100000L, 1000000L);
        Assert.that(uploadManager.measuredUploadSpeed() == 80);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class RequestCache {
        private static final double MAX_REQUESTS = 5000.0;
        private static final int MAX_ENTRIES = 10;
        static long WAIT_TIME = 900000L;
        static long FIRST_CHECK_TIME = 30000L;
        private final Set REQUESTS = new FixedSizeExpiringSet(10, WAIT_TIME);
        private final Set ACTIVE_UPLOADS = new HashSet();
        private double _numRequests = 0.0;
        private long _lastRequest = this._firstRequest = System.currentTimeMillis();
        private long _firstRequest;

        RequestCache() {
        }

        boolean isGreedy(URN uRN) {
            return this.REQUESTS.contains(uRN);
        }

        void startedUpload(URN uRN) {
            this.ACTIVE_UPLOADS.add(uRN);
        }

        boolean isHammering() {
            if (this._lastRequest - this._firstRequest <= FIRST_CHECK_TIME) {
                return false;
            }
            return (double)(this._lastRequest - this._firstRequest) / this._numRequests < 5000.0;
        }

        void limitReached(URN uRN) {
            this.REQUESTS.add(uRN);
        }

        void countRequest() {
            this._numRequests += 1.0;
            this._lastRequest = System.currentTimeMillis();
        }

        boolean isDupe(URN uRN) {
            return this.ACTIVE_UPLOADS.contains(uRN);
        }

        void uploadDone(URN uRN) {
            this.ACTIVE_UPLOADS.remove(uRN);
        }
    }

    private static final class HttpRequestLine {
        final int _index;
        final String _fileName;
        final boolean _http11;
        final Map _params;
        final boolean _hadPass;

        public String toString() {
            return "Index = " + this._index + ", FileName = " + this._fileName + ", is HTTP1.1? " + this._http11 + ", Parameters = " + this._params;
        }

        HttpRequestLine(int n, String string, boolean bl) {
            this(n, string, bl, Collections.EMPTY_MAP, false);
        }

        HttpRequestLine(int n, String string, boolean bl, Map map, boolean bl2) {
            this._index = n;
            this._fileName = string;
            this._http11 = bl;
            this._params = map == null ? Collections.EMPTY_MAP : map;
            this._hadPass = bl2;
        }

        boolean isHTTP11() {
            return this._http11;
        }

        Map getParameters() {
            return this._params;
        }

        boolean hadPassword() {
            return this._hadPass;
        }
    }
}

