/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.UrnCallback;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.ConverterObjectInputStream;
import com.limegroup.gnutella.util.IOUtils;
import com.limegroup.gnutella.util.ProcessingQueue;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class UrnCache {
    private static final Log LOG = LogFactory.getLog((Class)(class$com$limegroup$gnutella$UrnCache == null ? (class$com$limegroup$gnutella$UrnCache = UrnCache.class$("com.limegroup.gnutella.UrnCache")) : class$com$limegroup$gnutella$UrnCache));
    private static final File URN_CACHE_FILE = new File(CommonUtils.getUserSettingsDir(), "fileurns.cache");
    private static final File URN_CACHE_BACKUP_FILE = new File(CommonUtils.getUserSettingsDir(), "fileurns.bak");
    private static UrnCache instance = null;
    private static final Map URN_MAP = UrnCache.createMap();
    private final ProcessingQueue QUEUE = new ProcessingQueue("Hasher");
    private Map pendingHashing = new HashMap();
    private boolean dirty = UrnCache.removeOldEntries(URN_MAP);
    static /* synthetic */ Class class$com$limegroup$gnutella$UrnCache;

    public static synchronized UrnCache instance() {
        if (instance == null) {
            instance = new UrnCache();
        }
        return instance;
    }

    private UrnCache() {
    }

    public synchronized void calculateAndCacheUrns(File file, UrnCallback urnCallback) {
        Set set = this.getUrns(file);
        if (!set.isEmpty()) {
            urnCallback.urnsCalculated(file, set);
        } else {
            ArrayList<UrnCallback> arrayList;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Adding: " + file + " to be hashed."));
            }
            if ((arrayList = (ArrayList<UrnCallback>)this.pendingHashing.get(file)) == null) {
                arrayList = new ArrayList<UrnCallback>(1);
                this.pendingHashing.put(file, arrayList);
            }
            arrayList.add(urnCallback);
            this.QUEUE.add(new Processor(file));
        }
    }

    public synchronized void clearPendingHashes(Object object) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Clearing all pending hashes owned by: " + object));
        }
        Iterator iterator = this.pendingHashing.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            File file = (File)entry.getKey();
            List list = (List)entry.getValue();
            for (int i = list.size() - 1; i >= 0; --i) {
                UrnCallback urnCallback = (UrnCallback)list.get(i);
                if (!urnCallback.isOwner(object)) continue;
                list.remove(i);
            }
            if (!list.isEmpty()) continue;
            iterator.remove();
        }
    }

    public synchronized void clearPendingHashesFor(File file, Object object) {
        List list;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Clearing all pending hashes for: " + file + ", owned by: " + object));
        }
        if ((list = (List)this.pendingHashing.get(file)) != null) {
            for (int i = list.size() - 1; i >= 0; --i) {
                UrnCallback urnCallback = (UrnCallback)list.get(i);
                if (!urnCallback.isOwner(object)) continue;
                list.remove(i);
            }
            if (list.isEmpty()) {
                this.pendingHashing.remove(file);
            }
        }
    }

    public Set calculateUrns(File file) throws IOException, InterruptedException {
        HashSet<URN> hashSet = new HashSet<URN>(1);
        hashSet.add(URN.createSHA1Urn(file));
        return hashSet;
    }

    public synchronized Set getUrns(File file) {
        if (file.lastModified() == 0L) {
            return Collections.EMPTY_SET;
        }
        UrnSetKey urnSetKey = new UrnSetKey(file);
        Set set = (Set)URN_MAP.get(urnSetKey);
        if (set == null) {
            return Collections.EMPTY_SET;
        }
        return set;
    }

    public synchronized void removeUrns(File file) {
        UrnSetKey urnSetKey = new UrnSetKey(file);
        URN_MAP.remove(urnSetKey);
        this.dirty = true;
    }

    public synchronized void addUrns(File file, Set set) {
        UrnSetKey urnSetKey = new UrnSetKey(file);
        URN_MAP.put(urnSetKey, Collections.unmodifiableSet(set));
        this.dirty = true;
    }

    private static Map createMap() {
        HashMap hashMap = UrnCache.readMap(URN_CACHE_FILE);
        if (hashMap == null) {
            hashMap = UrnCache.readMap(URN_CACHE_BACKUP_FILE);
        }
        if (hashMap == null) {
            hashMap = new HashMap();
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Map readMap(File file) {
        ObjectInputStream objectInputStream = null;
        objectInputStream = new ConverterObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
        Map map = (Map)objectInputStream.readObject();
        Object var5_3 = null;
        if (objectInputStream == null) return map;
        try {
            objectInputStream.close();
            return map;
        }
        catch (IOException iOException) {}
        return map;
        {
            catch (Throwable throwable) {
                LOG.error((Object)"Unable to read UrnCache", throwable);
                map = null;
                Object var5_4 = null;
                if (objectInputStream == null) return map;
                try {
                    objectInputStream.close();
                    return map;
                }
                catch (IOException iOException) {}
                return map;
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (objectInputStream == null) throw throwable;
            try {
                objectInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private static boolean removeOldEntries(Map map) {
        boolean bl = false;
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            if (k instanceof UrnSetKey) {
                File file;
                UrnSetKey urnSetKey = (UrnSetKey)k;
                if (urnSetKey == null || (file = new File(urnSetKey._path)).exists() && file.lastModified() == urnSetKey._modTime) continue;
                bl = true;
                iterator.remove();
                continue;
            }
            bl = true;
            iterator.remove();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void persistCache() {
        if (!this.dirty) {
            return;
        }
        URN_CACHE_FILE.renameTo(URN_CACHE_BACKUP_FILE);
        ObjectOutputStream objectOutputStream = null;
        try {
            objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(URN_CACHE_FILE)));
            objectOutputStream.writeObject(URN_MAP);
            objectOutputStream.flush();
            IOUtils.close(objectOutputStream);
        }
        catch (IOException iOException) {
            ErrorService.error(iOException);
        }
        finally {
            IOUtils.close(objectOutputStream);
        }
        this.dirty = false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class UrnSetKey
    implements Serializable {
        static final long serialVersionUID = -7183232365833531645L;
        transient long _modTime;
        transient String _path;
        transient int _hashCode;

        UrnSetKey(File file) {
            this._modTime = file.lastModified();
            this._path = file.getAbsolutePath();
            this._hashCode = this.calculateHashCode();
        }

        int calculateHashCode() {
            int n = 17;
            n = n * 37 + (int)(this._modTime ^ this._modTime >>> 32);
            n = n * 37 + this._path.hashCode();
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof UrnSetKey)) {
                return false;
            }
            UrnSetKey urnSetKey = (UrnSetKey)object;
            return this._modTime == urnSetKey._modTime && this._path.equals(urnSetKey._path);
        }

        public int hashCode() {
            return this._hashCode;
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.defaultWriteObject();
            objectOutputStream.writeLong(this._modTime);
            objectOutputStream.writeObject(this._path);
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            this._modTime = objectInputStream.readLong();
            this._path = (String)objectInputStream.readObject();
            this._hashCode = this.calculateHashCode();
        }
    }

    private class Processor
    implements Runnable {
        private final File file;

        Processor(File file) {
            this.file = file;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Set set;
            List list;
            UrnCache urnCache = UrnCache.this;
            synchronized (urnCache) {
                list = (List)UrnCache.this.pendingHashing.remove(this.file);
                set = UrnCache.this.getUrns(this.file);
            }
            if (list != null && !list.isEmpty()) {
                if (set.isEmpty()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Hashing file: " + this.file));
                    }
                    try {
                        set = UrnCache.this.calculateUrns(this.file);
                        UrnCache.this.addUrns(this.file, set);
                    }
                    catch (IOException iOException) {
                        LOG.warn((Object)"Unable to calculate URNs", (Throwable)iOException);
                    }
                    catch (InterruptedException interruptedException) {
                        LOG.warn((Object)"Unable to calculate URNs", (Throwable)interruptedException);
                    }
                }
                for (int i = 0; i < list.size(); ++i) {
                    ((UrnCallback)list.get(i)).urnsCalculated(this.file, set);
                }
            }
        }
    }
}

