/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.browser;

import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.ByteReader;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.MessageService;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.SaveLocationException;
import com.limegroup.gnutella.browser.MagnetOptions;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.util.Sockets;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExternalControl {
    private static final Log LOG = LogFactory.getLog((Class)(class$com$limegroup$gnutella$browser$ExternalControl == null ? (class$com$limegroup$gnutella$browser$ExternalControl = ExternalControl.class$("com.limegroup.gnutella.browser.ExternalControl")) : class$com$limegroup$gnutella$browser$ExternalControl));
    private static final String LOCALHOST = "127.0.0.1";
    private static final String HTTP = "http://";
    private static boolean initialized = false;
    private static String enqueuedRequest = null;
    static /* synthetic */ Class class$com$limegroup$gnutella$browser$ExternalControl;

    public static String preprocessArgs(String[] stringArray) {
        LOG.trace((Object)"enter proprocessArgs");
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
        }
        return stringBuffer.toString();
    }

    public static void checkForActiveLimeWire() {
        if (ExternalControl.testForLimeWire(null)) {
            System.exit(0);
        }
    }

    public static void checkForActiveLimeWire(String string) {
        if (CommonUtils.isWindows() && ExternalControl.testForLimeWire(string)) {
            System.exit(0);
        }
    }

    public static boolean isInitialized() {
        return initialized;
    }

    public static void enqueueMagnetRequest(String string) {
        LOG.trace((Object)"enter enqueueMagnetRequest");
        enqueuedRequest = string;
    }

    public static void runQueuedMagnetRequest() {
        initialized = true;
        if (enqueuedRequest != null) {
            String string = enqueuedRequest;
            enqueuedRequest = null;
            ExternalControl.handleMagnetRequest(string);
        }
    }

    public static void handleMagnetRequest(String string) {
        LOG.trace((Object)"enter handleMagnetRequest");
        ActivityCallback activityCallback = RouterService.getCallback();
        activityCallback.restoreApplication();
        activityCallback.showDownloads();
        MagnetOptions[] magnetOptionsArray = MagnetOptions.parseMagnet(string);
        if (magnetOptionsArray.length == 0) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("Invalid magnet, ignoring: " + string));
            }
            return;
        }
        if (!activityCallback.handleMagnets(magnetOptionsArray)) {
            ExternalControl.downloadMagnet(magnetOptionsArray);
        }
    }

    public static void downloadMagnet(MagnetOptions[] magnetOptionsArray) {
        int n;
        if (LOG.isDebugEnabled()) {
            for (n = 0; n < magnetOptionsArray.length; ++n) {
                LOG.debug((Object)("Kicking off downloader for option " + n + " " + magnetOptionsArray[n]));
            }
        }
        for (n = 0; n < magnetOptionsArray.length; ++n) {
            Object object;
            MagnetOptions magnetOptions = magnetOptionsArray[n];
            if (LOG.isDebugEnabled()) {
                object = magnetOptions.getSHA1Urn();
                LOG.debug((Object)("Processing magnet with params:\nurn [" + object + "]\n" + "options [" + magnetOptions + "]"));
            }
            object = magnetOptions.getErrorMessage();
            if (!magnetOptions.isDownloadable()) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)("Invalid magnet: " + magnetOptions));
                }
                object = object != null ? object : magnetOptions.toString();
                MessageService.showError("ERROR_BAD_MAGNET_LINK", (String)object);
                return;
            }
            if (object != null) {
                MessageService.showError("ERROR_INVALID_URLS_IN_MAGNET");
            }
            try {
                RouterService.download(magnetOptions, false);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ErrorService.error(illegalArgumentException);
                continue;
            }
            catch (SaveLocationException saveLocationException) {
                if (saveLocationException.getErrorCode() == 5) {
                    MessageService.showError("ERROR_ALREADY_EXISTS", saveLocationException.getFile().getName());
                    continue;
                }
                if (saveLocationException.getErrorCode() != 10) continue;
                MessageService.showError("ERROR_ALREADY_DOWNLOADING", saveLocationException.getFile().getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fireMagnet(Socket socket) {
        LOG.trace((Object)"enter fireMagnet");
        Thread.currentThread().setName("IncomingMagnetThread");
        try {
            if (!NetworkUtils.isLocalHost(socket)) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)("Invalid magnet request from: " + socket.getInetAddress().getHostAddress()));
                }
                return;
            }
            socket.setSoTimeout(8000);
            ByteReader byteReader = new ByteReader(socket.getInputStream());
            String string = byteReader.readLine();
            socket.setSoTimeout(0);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(socket.getOutputStream());
            String string2 = CommonUtils.getUserName() + "\r\n";
            byte[] byArray = string2.getBytes();
            bufferedOutputStream.write(byArray);
            bufferedOutputStream.flush();
            ExternalControl.handleMagnetRequest(string);
        }
        catch (IOException iOException) {
            LOG.warn((Object)"Exception while responding to magnet request", (Throwable)iOException);
        }
        finally {
            try {
                socket.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean testForLimeWire(String string) {
        Socket socket = null;
        int n = ConnectionSettings.PORT.getValue();
        if (!NetworkUtils.isValidPort(n)) {
            ConnectionSettings.PORT.revertToDefault();
            n = ConnectionSettings.PORT.getValue();
        }
        socket = Sockets.connect(LOCALHOST, n, 500);
        InputStream inputStream = socket.getInputStream();
        socket.setSoTimeout(500);
        ByteReader byteReader = new ByteReader(inputStream);
        OutputStream outputStream = socket.getOutputStream();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
        BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
        bufferedWriter.write("MAGNET " + string + " ");
        bufferedWriter.write("\r\n");
        bufferedWriter.flush();
        String string2 = byteReader.readLine();
        boolean bl = string2 != null && string2.startsWith(CommonUtils.getUserName());
        Object var11_11 = null;
        if (socket == null) return bl;
        try {
            socket.close();
            return bl;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bl;
        catch (IOException iOException) {
            try {
                Object var11_12 = null;
                if (socket == null) return false;
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                if (socket == null) throw throwable;
                try {
                    socket.close();
                    throw throwable;
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                socket.close();
                return false;
            }
            catch (IOException iOException3) {}
            return false;
        }
    }

    public static MagnetOptions[] parseMagnets(String string) {
        ArrayList<MagnetOptions> arrayList = new ArrayList<MagnetOptions>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, System.getProperty("line.separator"));
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            MagnetOptions[] magnetOptionsArray = MagnetOptions.parseMagnet(string2);
            if (magnetOptionsArray.length <= 0) continue;
            arrayList.addAll(Arrays.asList(magnetOptionsArray));
        }
        return arrayList.toArray(new MagnetOptions[0]);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

