/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.browser;

import com.limegroup.gnutella.ByteReader;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.MessageService;
import com.limegroup.gnutella.browser.ExternalControl;
import com.limegroup.gnutella.browser.HTTPHandler;
import com.limegroup.gnutella.browser.MagnetHTML;
import com.limegroup.gnutella.util.IOUtils;
import com.limegroup.gnutella.util.ManagedThread;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.util.URLDecoder;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Date;

public class HTTPAcceptor
implements Runnable {
    private static final String MAGNET_DEFAULT = "magnet10/default.js?";
    private static final String MAGNET_PAUSE = "magnet10/pause";
    private static final String LOCALHOST = "127.0.0.1";
    private static final String MAGNET = "magnet:?";
    private static final String NOCONTENT = "HTTP/1.1 204 No Content\r\n";
    private static final String MAGNETDETAIL = "magcmd/detail?";
    private volatile ServerSocket _socket = null;
    private int _port = 45100;
    private Object _socketLock = new Object();
    private static String _lastRequest = null;
    private static long _lastRequestTime = 0L;

    public void start() {
        ManagedThread managedThread = new ManagedThread(this, "HTTPAcceptor");
        managedThread.setDaemon(true);
        managedThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setListeningPort(int n) throws IOException {
        if (this._socket != null && this._port == n) {
            return;
        }
        if (n == 0) {
            if (this._socket != null) {
                try {
                    this._socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            Object object = this._socketLock;
            synchronized (object) {
                this._socket = null;
                this._port = 0;
                this._socketLock.notify();
            }
            return;
        }
        ServerSocket serverSocket = null;
        serverSocket = new ServerSocket(n);
        if (this._socket != null) {
            try {
                this._socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        Object object = this._socketLock;
        synchronized (object) {
            this._socket = serverSocket;
            this._port = n;
            this._socketLock.notify();
        }
    }

    public int getPort() {
        return this._port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block18: {
            IOException iOException = null;
            try {
                this.setListeningPort(this._port);
            }
            catch (IOException iOException2) {
                boolean bl = true;
                iOException = iOException2;
                for (int i = 1; i < 20; ++i) {
                    this._port = i + 45100;
                    try {
                        this.setListeningPort(this._port);
                        bl = false;
                        break;
                    }
                    catch (IOException iOException3) {
                        iOException = iOException3;
                        continue;
                    }
                }
                if (!bl) break block18;
                MessageService.showError("ERROR_NO_PORTS_AVAILABLE");
            }
        }
        while (true) {
            try {
                while (true) {
                    Socket socket = null;
                    Object object = this._socketLock;
                    synchronized (object) {
                        if (this._socket != null) {
                            try {
                                socket = this._socket.accept();
                            }
                            catch (IOException iOException) {
                                continue;
                            }
                        }
                        try {
                            this._socketLock.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        continue;
                    }
                    new ConnectionDispatchRunner(socket);
                }
            }
            catch (SecurityException securityException) {
                ErrorService.error(securityException);
                return;
            }
            catch (Throwable throwable) {
                ErrorService.error(throwable);
                continue;
            }
            break;
        }
    }

    private void handleHTTPRequest(Socket socket) throws IOException {
        socket.setSoTimeout(8000);
        ByteReader byteReader = new ByteReader(socket.getInputStream());
        String string = byteReader.readLine();
        if (string == null) {
            throw new IOException();
        }
        string.trim();
        string = URLDecoder.decode(string);
        if (string.indexOf("magnet10") > 0) {
            int n = 0;
            n = string.indexOf(MAGNET_DEFAULT);
            if (n > 0) {
                int n2 = string.lastIndexOf(" HTTP");
                String string2 = string.substring(n + MAGNET_DEFAULT.length(), n2);
                this.triggerMagnetHandling(socket, MAGNET + string2);
            } else {
                n = string.indexOf(MAGNET_PAUSE);
                if (n > 0) {
                    try {
                        Thread.sleep(250L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.returnNoContent(socket);
                }
            }
        } else if (string.indexOf(MAGNETDETAIL) >= 0) {
            int n = 0;
            n = string.indexOf(MAGNETDETAIL);
            if (n < 0) {
                return;
            }
            int n3 = string.lastIndexOf(" HTTP");
            String string3 = string.substring(n + MAGNETDETAIL.length(), n3);
            String string4 = MagnetHTML.buildMagnetDetailPage(string3);
            HTTPHandler.createPage(socket, string4);
        } else if (string.indexOf(MAGNET) >= 0) {
            int n = string.indexOf(MAGNET);
            int n4 = string.lastIndexOf(" HTTP");
            if (n < 0) {
                return;
            }
            String string5 = string.substring(n, n4);
            this.triggerMagnetHandling(socket, string5);
        }
        try {
            socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void triggerMagnetHandling(Socket socket, String string) {
        long l = new Date().getTime();
        if (!string.equals(_lastRequest) || l - _lastRequestTime >= 1500L) {
            ExternalControl.handleMagnetRequest(string);
            _lastRequest = string;
            _lastRequestTime = l;
        }
        this.returnNoContent(socket);
    }

    private void returnNoContent(Socket socket) {
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(socket.getOutputStream());
            String string = NOCONTENT;
            byte[] byArray = string.getBytes();
            bufferedOutputStream.write(byArray);
            bufferedOutputStream.flush();
            socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private class ConnectionDispatchRunner
    extends ManagedThread {
        private Socket _socket;

        public ConnectionDispatchRunner(Socket socket) {
            super("ConnectionDispatchRunner");
            this._socket = socket;
            this.setDaemon(true);
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void managedRun() {
            try {
                InputStream inputStream = this._socket.getInputStream();
                this._socket.setSoTimeout(8000);
                String string = IOUtils.readWord(inputStream, 8);
                this._socket.setSoTimeout(0);
                if (NetworkUtils.isLocalHost(this._socket)) {
                    if (string.equals("GET")) {
                        HTTPAcceptor.this.handleHTTPRequest(this._socket);
                    } else if (string.equals("MAGNET")) {
                        ExternalControl.fireMagnet(this._socket);
                    }
                }
            }
            catch (IOException iOException) {
            }
            catch (Throwable throwable) {
                ErrorService.error(throwable);
            }
            finally {
                try {
                    this._socket.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

