/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.browser;

import com.limegroup.gnutella.util.CommonUtils;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.StringTokenizer;

public class HTTPHandler {
    private static final String ROOT = "root/";
    private Socket _socket;
    private OutputStream _ostream;
    private boolean _inErrorState;
    private String _line;

    public static HTTPHandler createPage(Socket socket, String string) {
        HTTPHandler hTTPHandler = new HTTPHandler(socket, null);
        hTTPHandler.handlePage(string);
        return hTTPHandler;
    }

    public HTTPHandler(Socket socket, String string) {
        this._socket = socket;
        this._line = string;
        this._inErrorState = false;
    }

    public void handlePage(String string) {
        this.setupIO();
        this.uploadPage(string);
    }

    private void setupIO() {
        try {
            this._ostream = this._socket.getOutputStream();
        }
        catch (IOException iOException) {
            this._inErrorState = true;
        }
    }

    private String getRelativePath(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String string2 = null;
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
        } else {
            this._inErrorState = true;
        }
        return string2;
    }

    private void processRequest(File file, String string) {
        String string2 = string;
        int n = string2.indexOf("?");
        if (n > 0) {
            string2 = string2.substring(0, n);
        }
        if (!file.exists()) {
            this._inErrorState = true;
        }
        if (!file.canRead()) {
            this._inErrorState = true;
        }
        if (this._inErrorState) {
            this.writeError();
        }
    }

    public void uploadPage(String string) {
        int n = string.length();
        try {
            this.writeHeader(n, this.getMimeType(".html"));
            byte[] byArray = string.getBytes();
            this._ostream.write(byArray);
        }
        catch (IOException iOException) {
            this._inErrorState = true;
        }
        try {
            this._ostream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private String getMimeType(String string) {
        if (string.endsWith(".gif")) {
            return "image/gif";
        }
        if (string.endsWith(".img")) {
            return "image/gif";
        }
        if (string.endsWith(".js")) {
            return "application/x-javascript";
        }
        if (string.endsWith(".css")) {
            return "text/css";
        }
        return "text/html";
    }

    private void writeHeader(int n, String string) throws IOException {
        String string2 = "HTTP/1.1 200 OK \r\n";
        this._ostream.write(string2.getBytes());
        string2 = "Server: " + CommonUtils.getVendor() + "\r\n";
        this._ostream.write(string2.getBytes());
        string2 = "Content-type:" + string + "\r\n";
        this._ostream.write(string2.getBytes());
        string2 = "Content-length:" + n + "\r\n";
        this._ostream.write(string2.getBytes());
        string2 = "\r\n";
        this._ostream.write(string2.getBytes());
    }

    public void writeError() {
        try {
            String string = "HTTP/1.1 404 Not Found\r\n";
            this._ostream.write(string.getBytes());
            this._ostream.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this._ostream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

