/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.browser;

import com.limegroup.gnutella.FileDetails;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.util.URLDecoder;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;

public class MagnetOptions
implements Serializable {
    public static final String MAGNET = "magnet:?";
    private static final String HTTP = "http://";
    private static final String DOWNLOAD_PREFIX = "MAGNET download from ";
    private final Map optionsMap;
    private static final String XS = "XS";
    private static final String XT = "XT";
    private static final String AS = "AS";
    private static final String DN = "DN";
    private static final String KT = "KT";
    private transient String[] defaultURLs;
    private transient String localizedErrorMessage;
    private transient URN urn;
    private transient String extractedFileName;

    public static MagnetOptions createMagnet(FileDetails fileDetails) {
        Serializable serializable;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(DN, fileDetails.getFileName());
        URN uRN = fileDetails.getSHA1Urn();
        if (uRN != null) {
            MagnetOptions.addAppend(hashMap, XT, uRN.httpStringValue());
        }
        InetSocketAddress inetSocketAddress = fileDetails.getSocketAddress();
        String string = null;
        if (inetSocketAddress != null && uRN != null) {
            serializable = new StringBuffer(HTTP);
            ((StringBuffer)serializable).append(inetSocketAddress.getAddress().getHostAddress()).append(':').append(inetSocketAddress.getPort()).append("/uri-res/N2R?");
            ((StringBuffer)serializable).append(uRN.httpStringValue());
            string = ((StringBuffer)serializable).toString();
            MagnetOptions.addAppend(hashMap, XS, string);
        }
        serializable = new MagnetOptions(hashMap);
        ((MagnetOptions)serializable).urn = uRN;
        if (string != null) {
            ((MagnetOptions)serializable).defaultURLs = new String[]{string};
        }
        return serializable;
    }

    public static MagnetOptions createMagnet(String string, String string2, URN uRN, String[] stringArray) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(KT, string);
        hashMap.put(DN, string2);
        if (uRN != null) {
            MagnetOptions.addAppend(hashMap, XT, uRN.httpStringValue());
        }
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                MagnetOptions.addAppend(hashMap, AS, stringArray[i]);
            }
        }
        MagnetOptions magnetOptions = new MagnetOptions(hashMap);
        magnetOptions.urn = uRN;
        if (stringArray != null) {
            magnetOptions.defaultURLs = new String[stringArray.length];
            System.arraycopy(stringArray, 0, magnetOptions.defaultURLs, 0, magnetOptions.defaultURLs.length);
        } else {
            magnetOptions.defaultURLs = new String[0];
        }
        return magnetOptions;
    }

    public static MagnetOptions[] parseMagnet(String string) {
        Object object;
        HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>();
        if (string.startsWith("'")) {
            string = string.substring(1);
        }
        if (string.endsWith("'")) {
            string = string.substring(0, string.length() - 1);
        }
        if (!string.startsWith(MAGNET)) {
            return new MagnetOptions[0];
        }
        string = string.substring(8);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "&");
        while (stringTokenizer.hasMoreTokens()) {
            int n;
            String string2;
            String string3;
            block15: {
                string3 = stringTokenizer.nextToken();
                int n2 = (string3 = string3.trim()).indexOf("=") + 1;
                if (n2 == 0) continue;
                string2 = string3.substring(n2);
                string3 = string3.substring(0, n2 - 1);
                try {
                    string2 = URLDecoder.decode(string2);
                }
                catch (IOException iOException) {
                    continue;
                }
                int n3 = string3.indexOf(".");
                if (n3 > 0) {
                    try {
                        n = Integer.parseInt(string3.substring(n3 + 1));
                        break block15;
                    }
                    catch (NumberFormatException numberFormatException) {
                        continue;
                    }
                }
                n = 0;
            }
            Integer n4 = new Integer(n);
            object = (Map)hashMap.get(n4);
            if (object == null) {
                object = new HashMap();
                hashMap.put(n4, object);
            }
            if (string3.startsWith("xt")) {
                MagnetOptions.addAppend((Map)object, XT, string2);
                continue;
            }
            if (string3.startsWith("dn")) {
                object.put(DN, string2);
                continue;
            }
            if (string3.startsWith("kt")) {
                object.put(KT, string2);
                continue;
            }
            if (string3.startsWith("xs")) {
                MagnetOptions.addAppend((Map)object, XS, string2);
                continue;
            }
            if (!string3.startsWith("as")) continue;
            MagnetOptions.addAppend((Map)object, AS, string2);
        }
        object = new MagnetOptions[hashMap.size()];
        int n = 0;
        Iterator iterator = hashMap.values().iterator();
        while (iterator.hasNext()) {
            Map map = (Map)iterator.next();
            object[n] = new MagnetOptions(map);
            ++n;
        }
        return object;
    }

    private static void addAppend(Map map, String string, String string2) {
        ArrayList<String> arrayList = (ArrayList<String>)map.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList<String>(1);
            map.put(string, arrayList);
        }
        arrayList.add(string2);
    }

    private MagnetOptions(Map map) {
        this.optionsMap = Collections.unmodifiableMap(map);
    }

    public String toString() {
        return this.toExternalForm();
    }

    public String toExternalForm() {
        String string;
        StringBuffer stringBuffer = new StringBuffer(MAGNET);
        Iterator iterator = this.getExactTopics().iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            stringBuffer.append("&xt=").append(string);
        }
        if (this.getDisplayName() != null) {
            stringBuffer.append("&dn=").append(URLEncoder.encode(this.getDisplayName()));
        }
        if (this.getKeywordTopic() != null) {
            stringBuffer.append("&kt=").append(URLEncoder.encode(this.getKeywordTopic()));
        }
        iterator = this.getXS().iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            stringBuffer.append("&xs=").append(string);
        }
        iterator = this.getAS().iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            stringBuffer.append("&as=").append(string);
        }
        return stringBuffer.toString();
    }

    public URN getSHA1Urn() {
        if (this.urn == null) {
            this.urn = this.extractSHA1URNFromList(this.getExactTopics());
            if (this.urn == null) {
                this.urn = this.extractSHA1URNFromList(this.getXS());
            }
            if (this.urn == null) {
                this.urn = this.extractSHA1URNFromList(this.getAS());
            }
            if (this.urn == null) {
                this.urn = this.extractSHA1URNFromURLS(this.getDefaultURLs());
            }
            if (this.urn == null) {
                this.urn = URN.INVALID;
            }
        }
        if (this.urn == URN.INVALID) {
            return null;
        }
        return this.urn;
    }

    private URN extractSHA1URNFromURLS(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                URI uRI = new URI(stringArray[i].toCharArray());
                String string = uRI.getQuery();
                if (string == null) continue;
                return URN.createSHA1Urn(uRI.getQuery());
            }
            catch (URIException uRIException) {
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean isDownloadable() {
        return this.getDefaultURLs().length > 0 || this.getSHA1Urn() != null && this.getQueryString() != null;
    }

    public boolean isHashOnly() {
        String string = this.getKeywordTopic();
        String string2 = this.getDisplayName();
        return !(string != null && string.length() <= 0 || string2 != null && string2.length() <= 0 || !this.getAS().isEmpty() || !this.getXS().isEmpty() || this.getExactTopics().isEmpty());
    }

    public String getQueryString() {
        String string = this.getKeywordTopic();
        if (string != null && string.length() > 0) {
            return string;
        }
        String string2 = this.getDisplayName();
        if (string2 != null && string2.length() > 0) {
            return string2;
        }
        return null;
    }

    public boolean isKeywordTopicOnly() {
        String string = this.getKeywordTopic();
        String string2 = this.getDisplayName();
        return string != null && string.length() > 0 && (string2 == null || string2.length() > 0) && this.getAS().isEmpty() && this.getXS().isEmpty() && this.getExactTopics().isEmpty();
    }

    private URN extractSHA1URNFromList(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            try {
                return URN.createSHA1Urn((String)iterator.next());
            }
            catch (IOException iOException) {
            }
        }
        return null;
    }

    private List getPotentialURLs() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.getPotentialURLs(this.getExactTopics()));
        arrayList.addAll(this.getPotentialURLs(this.getXS()));
        arrayList.addAll(this.getPotentialURLs(this.getAS()));
        return arrayList;
    }

    private List getPotentialURLs(List list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!string.startsWith(HTTP)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public String[] getDefaultURLs() {
        if (this.defaultURLs == null) {
            List list = this.getPotentialURLs();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                try {
                    String string = (String)iterator.next();
                    new URI(string.toCharArray());
                }
                catch (URIException uRIException) {
                    iterator.remove();
                    this.localizedErrorMessage = uRIException.getLocalizedMessage();
                }
            }
            this.defaultURLs = list.toArray(new String[list.size()]);
        }
        return this.defaultURLs;
    }

    public String getDisplayName() {
        return (String)this.optionsMap.get(DN);
    }

    public String getFileNameForSaving() {
        File file;
        if (this.extractedFileName != null) {
            return this.extractedFileName;
        }
        this.extractedFileName = this.getDisplayName();
        if (this.extractedFileName != null && this.extractedFileName.length() > 0) {
            return this.extractedFileName;
        }
        this.extractedFileName = this.getKeywordTopic();
        if (this.extractedFileName != null && this.extractedFileName.length() > 0) {
            return this.extractedFileName;
        }
        URN uRN = this.getSHA1Urn();
        if (uRN != null) {
            this.extractedFileName = uRN.toString();
            return this.extractedFileName;
        }
        String[] stringArray = this.getDefaultURLs();
        if (stringArray.length > 0) {
            try {
                file = new URI(stringArray[0].toCharArray());
                this.extractedFileName = MagnetOptions.extractFileName((URI)file);
                if (this.extractedFileName != null && this.extractedFileName.length() > 0) {
                    return this.extractedFileName;
                }
            }
            catch (URIException uRIException) {
                // empty catch block
            }
        }
        try {
            file = File.createTempFile("magnet", "");
            file.deleteOnExit();
            this.extractedFileName = file.getName();
            return this.extractedFileName;
        }
        catch (IOException iOException) {
            this.extractedFileName = DOWNLOAD_PREFIX;
            return this.extractedFileName;
        }
    }

    public String getKeywordTopic() {
        return (String)this.optionsMap.get(KT);
    }

    public List getExactTopics() {
        return this.getList(XT);
    }

    public List getXS() {
        return this.getList(XS);
    }

    public List getAS() {
        return this.getList(AS);
    }

    private List getList(String string) {
        List list = (List)this.optionsMap.get(string);
        return list == null ? Collections.EMPTY_LIST : list;
    }

    public String getErrorMessage() {
        return this.localizedErrorMessage;
    }

    public static String extractFileName(URI uRI) {
        String string = null;
        String string2 = null;
        try {
            string = uRI.getPath();
            string2 = uRI.getHost();
        }
        catch (URIException uRIException) {
            // empty catch block
        }
        if (string != null && string.length() > 0) {
            int n = string.lastIndexOf(47);
            if (n < 0) {
                return string;
            }
            if (n >= 0 && n < string.length() - 1) {
                return string.substring(n + 1);
            }
        }
        if (string2 != null) {
            return DOWNLOAD_PREFIX + string2;
        }
        return DOWNLOAD_PREFIX;
    }
}

