/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.connection;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.MessageListener;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.UDPPinger;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.PingRequest;
import com.limegroup.gnutella.util.Cancellable;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.IOUtils;
import com.limegroup.gnutella.util.ManagedThread;
import com.limegroup.gnutella.util.Sockets;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ConnectionChecker
implements Runnable {
    private volatile boolean _connected;
    private int _unsuccessfulAttempts;
    private boolean _triedSP2Workaround;
    private static final Log LOG = LogFactory.getLog((Class)(class$com$limegroup$gnutella$connection$ConnectionChecker == null ? (class$com$limegroup$gnutella$connection$ConnectionChecker = ConnectionChecker.class$("com.limegroup.gnutella.connection.ConnectionChecker")) : class$com$limegroup$gnutella$connection$ConnectionChecker));
    private static String[] STANDARD_HOSTS = new String[]{"http://www.wanadoo.fr", "http://www.tiscali.com", "http://www.ntt.com", "http://www.tonline.com", "http://www.download.com", "http://www.ibm.com", "http://www.sun.com", "http://www.apple.com", "http://www.ebay.com", "http://www.sun.com", "http://www.monster.com", "http://www.uunet.com", "http://www.real.com", "http://www.microsoft.com", "http://www.sco.com", "http://www.google.com", "http://www.cnn.com", "http://www.amazon.com", "http://www.espn.com", "http://www.yahoo.com", "http://www.oracle.com", "http://www.dell.com", "http://www.ge.com", "http://www.sprint.com", "http://www.att.com", "http://www.mci.com", "http://www.cisco.com", "http://www.intel.com", "http://www.motorola.com", "http://www.hp.com", "http://www.gateway.com", "http://www.sony.com", "http://www.ford.com", "http://www.gm.com", "http://www.aol.com", "http://www.verizon.com", "http://www.passport.com", "http://www.go.com", "http://www.overture.com", "http://www.earthlink.net", "http://www.bellsouth.net", "http://www.excite.com", "http://www.paypal.com", "http://www.altavista.com", "http://www.weather.com", "http://www.mapquest.com", "http://www.geocities.com", "http://www.juno.com", "http://www.msnbc.com", "http://www.lycos.com", "http://www.comcast.com"};
    private static ConnectionChecker current;
    static /* synthetic */ Class class$com$limegroup$gnutella$connection$ConnectionChecker;

    private ConnectionChecker() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConnectionChecker checkForLiveConnection() {
        ConnectionChecker connectionChecker;
        LOG.trace((Object)"checking for live connection");
        Object object = class$com$limegroup$gnutella$connection$ConnectionChecker == null ? (class$com$limegroup$gnutella$connection$ConnectionChecker = ConnectionChecker.class$("com.limegroup.gnutella.connection.ConnectionChecker")) : class$com$limegroup$gnutella$connection$ConnectionChecker;
        synchronized (object) {
            if (current == null) {
                current = new ConnectionChecker();
            }
            connectionChecker = current;
        }
        object = new ManagedThread(connectionChecker, "check for live connection");
        ((Thread)object).setDaemon(true);
        ((Thread)object).start();
        return connectionChecker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void run() {
        block18: {
            block17: {
                Class clazz;
                block19: {
                    block15: {
                        block16: {
                            try {
                                try {
                                    List<String> list = Arrays.asList(STANDARD_HOSTS);
                                    Collections.shuffle(list);
                                    Iterator<String> iterator = list.iterator();
                                    while (iterator.hasNext()) {
                                        String string = iterator.next();
                                        this.connectToHost(string);
                                        if (this._connected) {
                                            if (this._triedSP2Workaround && !RouterService.isConnected() && !RouterService.isConnecting()) {
                                                RouterService.connect();
                                            }
                                            Object var5_5 = null;
                                            if (class$com$limegroup$gnutella$connection$ConnectionChecker != null) break block15;
                                            break block16;
                                        }
                                        if (this._unsuccessfulAttempts <= 2) continue;
                                        if (this._triedSP2Workaround || !CommonUtils.isWindowsXP()) {
                                            RouterService.getConnectionManager().noInternetConnection();
                                            break block17;
                                        }
                                        this._triedSP2Workaround = true;
                                        this.trySP2Workaround();
                                    }
                                    break block18;
                                }
                                catch (Throwable throwable) {
                                    ErrorService.error(throwable);
                                    Object var5_8 = null;
                                    Class clazz2 = class$com$limegroup$gnutella$connection$ConnectionChecker == null ? (class$com$limegroup$gnutella$connection$ConnectionChecker = ConnectionChecker.class$("com.limegroup.gnutella.connection.ConnectionChecker")) : class$com$limegroup$gnutella$connection$ConnectionChecker;
                                    synchronized (clazz2) {
                                        current = null;
                                        return;
                                    }
                                }
                            }
                            catch (Throwable throwable) {
                                Object var5_9 = null;
                                Class clazz3 = class$com$limegroup$gnutella$connection$ConnectionChecker == null ? (class$com$limegroup$gnutella$connection$ConnectionChecker = ConnectionChecker.class$("com.limegroup.gnutella.connection.ConnectionChecker")) : class$com$limegroup$gnutella$connection$ConnectionChecker;
                                synchronized (clazz3) {
                                    current = null;
                                    throw throwable;
                                }
                            }
                        }
                        clazz = class$com$limegroup$gnutella$connection$ConnectionChecker = ConnectionChecker.class$("com.limegroup.gnutella.connection.ConnectionChecker");
                        break block19;
                    }
                    clazz = class$com$limegroup$gnutella$connection$ConnectionChecker;
                }
                Class clazz4 = clazz;
                synchronized (clazz) {
                    current = null;
                    // ** MonitorExit[var6_10] (shouldn't be in output)
                    return;
                }
            }
            Object var5_6 = null;
            Class clazz = class$com$limegroup$gnutella$connection$ConnectionChecker == null ? (class$com$limegroup$gnutella$connection$ConnectionChecker = ConnectionChecker.class$("com.limegroup.gnutella.connection.ConnectionChecker")) : class$com$limegroup$gnutella$connection$ConnectionChecker;
            synchronized (clazz) {
                current = null;
                return;
            }
        }
        Object var5_7 = null;
        Class clazz = class$com$limegroup$gnutella$connection$ConnectionChecker == null ? (class$com$limegroup$gnutella$connection$ConnectionChecker = ConnectionChecker.class$("com.limegroup.gnutella.connection.ConnectionChecker")) : class$com$limegroup$gnutella$connection$ConnectionChecker;
        synchronized (clazz) {
            current = null;
            return;
        }
    }

    private void trySP2Workaround() {
        if (this.hasNoTransfers() && this.udpIsDead()) {
            return;
        }
        this.killAndSleep();
    }

    private boolean hasNoTransfers() {
        RouterService.getDownloadManager().measureBandwidth();
        float f = RouterService.getDownloadManager().getMeasuredBandwidth();
        if (f != 0.0f) {
            return false;
        }
        RouterService.getUploadManager().measureBandwidth();
        float f2 = RouterService.getUploadManager().getMeasuredBandwidth();
        return f2 == 0.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean udpIsDead() {
        PingRequest pingRequest = PingRequest.createUDPPing();
        Collection collection = RouterService.getPreferencedHosts(false, "en", 50);
        UDPPinger uDPPinger = RouterService.getHostCatcher().getPinger();
        UDPChecker uDPChecker = new UDPChecker();
        uDPPinger.rank(collection, uDPChecker, uDPChecker, pingRequest);
        long l = System.currentTimeMillis();
        UDPChecker uDPChecker2 = uDPChecker;
        synchronized (uDPChecker2) {
            try {
                for (int i = 0; i < 5; ++i) {
                    uDPChecker.wait(1000L);
                    if (UDPService.instance().getLastReceivedTime() <= l) continue;
                    uDPChecker.received = true;
                    return false;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return !uDPChecker.received;
    }

    private void killAndSleep() {
        RouterService.disconnect();
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this._unsuccessfulAttempts = 0;
    }

    public boolean hasConnected() {
        return this._connected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectToHost(String string) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("connecting to: " + string));
        }
        Socket socket = null;
        try {
            InetAddress.getByName(string);
            socket = Sockets.connectHardTimeout(string, 80, 20000);
            this._connected = true;
        }
        catch (IOException iOException) {
            try {
                ++this._unsuccessfulAttempts;
            }
            catch (Throwable throwable) {
                IOUtils.close(socket);
                throw throwable;
            }
            IOUtils.close(socket);
        }
        IOUtils.close(socket);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class UDPChecker
    implements MessageListener,
    Cancellable {
        volatile boolean received;

        private UDPChecker() {
        }

        public boolean isCancelled() {
            return this.received;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processMessage(Message message, ReplyHandler replyHandler) {
            this.received = true;
            UDPChecker uDPChecker = this;
            synchronized (uDPChecker) {
                this.notify();
            }
        }

        public void registered(byte[] byArray) {
        }

        public void unregistered(byte[] byArray) {
        }
    }
}

