/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.ByteOrder;
import java.io.Serializable;

public class Interval
implements Serializable {
    static final long serialVersionUID = -2562093104400487554L;
    public final int low;
    public final int high;

    public Interval(long l, long l2) {
        if (l2 < l) {
            throw new IllegalArgumentException("low: " + l + ", high: " + l2);
        }
        if (l < 0L) {
            throw new IllegalArgumentException("low < min int:" + l);
        }
        if (l2 > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("high > max int:" + l2);
        }
        this.low = (int)l;
        this.high = (int)l2;
    }

    public Interval(long l) {
        if (l < Integer.MIN_VALUE) {
            throw new IllegalArgumentException("singleton < min:" + l);
        }
        if (l > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("singleton > max int:" + l);
        }
        this.low = (int)l;
        this.high = (int)l;
    }

    public boolean isSubrange(Interval interval) {
        return this.low >= interval.low && this.high <= interval.high;
    }

    public String toString() {
        if (this.low == this.high) {
            return String.valueOf(this.low);
        }
        return String.valueOf(this.low) + "-" + String.valueOf(this.high);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Interval)) {
            return false;
        }
        Interval interval = (Interval)object;
        return this.low == interval.low && this.high == interval.high;
    }

    public byte[] toBytes() {
        byte[] byArray = new byte[8];
        this.toBytes(byArray, 0);
        return byArray;
    }

    public void toBytes(byte[] byArray, int n) {
        ByteOrder.int2beb(this.low, byArray, n);
        ByteOrder.int2beb(this.high, byArray, n + 4);
    }
}

