/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.DownloadCallback;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.SaveLocationException;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.browser.MagnetOptions;
import com.limegroup.gnutella.downloader.CantResumeException;
import com.limegroup.gnutella.downloader.IncompleteFileManager;
import com.limegroup.gnutella.downloader.ManagedDownloader;
import com.limegroup.gnutella.downloader.URLRemoteFileDesc;
import com.limegroup.gnutella.http.HttpClientManager;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.HashSet;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MagnetDownloader
extends ManagedDownloader
implements Serializable {
    private static final Log LOG = LogFactory.getLog((Class)(class$com$limegroup$gnutella$downloader$MagnetDownloader == null ? (class$com$limegroup$gnutella$downloader$MagnetDownloader = MagnetDownloader.class$("com.limegroup.gnutella.downloader.MagnetDownloader")) : class$com$limegroup$gnutella$downloader$MagnetDownloader));
    static final long serialVersionUID = 9092913030585214105L;
    private static final transient String MAGNET = "MAGNET";
    static /* synthetic */ Class class$com$limegroup$gnutella$downloader$MagnetDownloader;

    public MagnetDownloader(IncompleteFileManager incompleteFileManager, MagnetOptions magnetOptions, boolean bl, File file, String string) throws SaveLocationException {
        super(new RemoteFileDesc[0], incompleteFileManager, null, file, MagnetDownloader.checkMagnetAndExtractFileName(magnetOptions, string), bl);
        this.propertiesMap.put(MAGNET, magnetOptions);
    }

    public void initialize(DownloadManager downloadManager, FileManager fileManager, DownloadCallback downloadCallback) {
        Assert.that(this.getMagnet() != null);
        this.downloadSHA1 = this.getMagnet().getSHA1Urn();
        super.initialize(downloadManager, fileManager, downloadCallback);
    }

    private MagnetOptions getMagnet() {
        return (MagnetOptions)this.propertiesMap.get(MAGNET);
    }

    protected int initializeDownload() {
        if (!this.hasRFD()) {
            MagnetOptions magnetOptions = this.getMagnet();
            String[] stringArray = magnetOptions.getDefaultURLs();
            if (stringArray.length == 0) {
                return 6;
            }
            RemoteFileDesc remoteFileDesc = null;
            for (int i = 0; i < stringArray.length && remoteFileDesc == null; ++i) {
                try {
                    remoteFileDesc = MagnetDownloader.createRemoteFileDesc(stringArray[i], this.getSaveFile().getName(), magnetOptions.getSHA1Urn());
                    this.initPropertiesMap(remoteFileDesc);
                    this.addDownloadForced(remoteFileDesc, true);
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (remoteFileDesc == null) {
                return 6;
            }
        }
        return super.initializeDownload();
    }

    private static RemoteFileDesc createRemoteFileDesc(String string, String string2, URN uRN) throws IOException {
        if (string == null) {
            LOG.debug((Object)"createRemoteFileDesc called with null URL");
            return null;
        }
        URL uRL = null;
        uRL = new URL(string);
        int n = uRL.getPort();
        if (n < 0) {
            n = 80;
        }
        HashSet<URN> hashSet = new HashSet<URN>(1);
        if (uRN != null) {
            hashSet.add(uRN);
        }
        URI uRI = new URI(uRL);
        return new URLRemoteFileDesc(uRL.getHost(), n, 0L, string2 != null ? string2 : MagnetOptions.extractFileName(uRI), MagnetDownloader.contentLength(uRL), new byte[16], 3000, false, 3, false, null, hashSet, false, false, "", 0L, uRL, null, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int contentLength(URL uRL) throws IOException {
        try {
            new URI(uRL.toExternalForm().toCharArray());
        }
        catch (URIException uRIException) {
            throw new IOException("invalid url: " + uRL);
        }
        HttpClient httpClient = HttpClientManager.getNewClient();
        HeadMethod headMethod = new HeadMethod(uRL.toExternalForm());
        headMethod.addRequestHeader("User-Agent", CommonUtils.getHttpServer());
        try {
            httpClient.executeMethod((HttpMethod)headMethod);
            if (headMethod.getStatusCode() != 200) {
                throw new IOException("Got " + headMethod.getStatusCode() + " instead of 200");
            }
            int n = headMethod.getResponseContentLength();
            if (n < 0) {
                throw new IOException("No content length");
            }
            int n2 = n;
            return n2;
        }
        finally {
            if (headMethod != null) {
                headMethod.releaseConnection();
            }
        }
    }

    protected QueryRequest newRequery(int n) throws CantResumeException {
        MagnetOptions magnetOptions = this.getMagnet();
        String string = magnetOptions.getQueryString();
        if (string != null) {
            String string2 = StringUtils.createQueryString(string);
            return QueryRequest.createQuery(string2);
        }
        String string3 = StringUtils.createQueryString(this.getSaveFile().getName());
        return QueryRequest.createQuery(string3);
    }

    protected boolean allowAddition(RemoteFileDesc remoteFileDesc) {
        URN uRN = remoteFileDesc.getSHA1Urn();
        if (this.downloadSHA1 != null && uRN != null) {
            return this.downloadSHA1.equals(uRN);
        }
        return false;
    }

    protected synchronized boolean addDownloadForced(RemoteFileDesc remoteFileDesc, boolean bl) {
        if (!this.hasRFD()) {
            this.initPropertiesMap(remoteFileDesc);
        }
        return super.addDownloadForced(remoteFileDesc, bl);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        MagnetOptions magnetOptions = this.getMagnet();
        if (magnetOptions == null) {
            String[] stringArray;
            ObjectInputStream.GetField getField = objectInputStream.readFields();
            String string = (String)getField.get("_textQuery", null);
            URN uRN = (URN)getField.get("_urn", null);
            String string2 = (String)getField.get("_filename", null);
            magnetOptions = MagnetOptions.createMagnet(string, string2, uRN, stringArray = (String[])getField.get("_defaultURLs", null));
            if (!magnetOptions.isDownloadable()) {
                throw new IOException("Old undownloadable magnet");
            }
            this.propertiesMap.put(MAGNET, magnetOptions);
        }
        if (this.propertiesMap.get("defaultFileName") == null) {
            this.propertiesMap.put("defaultFileName", magnetOptions.getFileNameForSaving());
        }
    }

    protected boolean shouldSendRequeryImmediately(int n) {
        return this.downloadSHA1 != null ? super.shouldSendRequeryImmediately(n) : false;
    }

    private static String checkMagnetAndExtractFileName(MagnetOptions magnetOptions, String string) {
        if (!magnetOptions.isDownloadable()) {
            throw new IllegalArgumentException("magnet not downloadable");
        }
        if (string != null) {
            return string;
        }
        return magnetOptions.getFileNameForSaving();
    }

    protected void initializeIncompleteFile() throws IOException {
        if (this.getContentLength() != -1) {
            super.initializeIncompleteFile();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

