/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.filters;

import com.limegroup.gnutella.filters.SpamFilter;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.QueryRequest;

public class GreedyQueryFilter
extends SpamFilter {
    private static final int GREEDY_QUERY_MAX = 3;

    public boolean allow(Message message) {
        if (!(message instanceof QueryRequest)) {
            return true;
        }
        QueryRequest queryRequest = (QueryRequest)message;
        String string = queryRequest.getQuery();
        int n = string.length();
        if (n == 1 && !queryRequest.hasQueryUrns()) {
            return false;
        }
        if ((n == 5 || n == 6) && string.charAt(1) == '.' && Character.isLetter(string.charAt(0))) {
            return false;
        }
        if (this.isVeryGeneralSearch(string) || this.isObfuscatedGeneralSearch(string)) {
            byte by = message.getHops();
            byte by2 = message.getTTL();
            if (by >= 3) {
                return false;
            }
            if (by + by2 > 3) {
                message.setTTL((byte)(3 - by));
            }
        }
        return true;
    }

    private boolean isVeryGeneralSearch(String string) {
        int n = string.length();
        if (n == 3 && (string.charAt(1) == '.' || string.equalsIgnoreCase("mp3") || string.equalsIgnoreCase("mpg"))) {
            return true;
        }
        if (n == 5) {
            String string2 = string.substring(2, 5);
            if (string.charAt(1) == '.' && (string2.equalsIgnoreCase("mp3") || string2.equalsIgnoreCase("mpg"))) {
                return true;
            }
        }
        return false;
    }

    private boolean isObfuscatedGeneralSearch(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if ("*.- ".indexOf(string.charAt(i)) != -1) continue;
            return false;
        }
        return true;
    }
}

