/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.guess;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.guess.GUESSEndpoint;
import com.limegroup.gnutella.guess.QueryKey;
import com.limegroup.gnutella.messages.PingReply;
import com.limegroup.gnutella.messages.PingRequest;
import com.limegroup.gnutella.messages.QueryRequest;
import java.net.InetAddress;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

public class OnDemandUnicaster {
    private static final int CLEAR_TIME = 300000;
    private static final Map _queryKeys = new Hashtable();
    private static final UDPService _udp;
    private static final Map _bufferedURNs;

    public static void handleQueryKeyPong(PingReply pingReply) throws NullPointerException, IllegalArgumentException {
        if (pingReply == null) {
            throw new NullPointerException("null pong");
        }
        QueryKey queryKey = pingReply.getQueryKey();
        if (queryKey == null) {
            throw new IllegalArgumentException("no key in pong");
        }
        InetAddress inetAddress = pingReply.getInetAddress();
        int n = pingReply.getPort();
        GUESSEndpoint gUESSEndpoint = new GUESSEndpoint(inetAddress, n);
        _queryKeys.put(gUESSEndpoint, queryKey);
        SendLaterBundle sendLaterBundle = (SendLaterBundle)_bufferedURNs.remove(gUESSEndpoint);
        if (sendLaterBundle != null) {
            QueryRequest queryRequest = QueryRequest.createQueryKeyQuery(sendLaterBundle._queryURN, queryKey);
            RouterService.getMessageRouter().originateQueryGUID(queryRequest.getGUID());
            _udp.send(queryRequest, gUESSEndpoint.getAddress(), gUESSEndpoint.getPort());
        }
    }

    public static void query(GUESSEndpoint gUESSEndpoint, URN uRN) throws IllegalArgumentException {
        if (gUESSEndpoint == null) {
            throw new IllegalArgumentException("No Endpoint!");
        }
        if (uRN == null) {
            throw new IllegalArgumentException("No urn to look for!");
        }
        QueryKey queryKey = (QueryKey)_queryKeys.get(gUESSEndpoint);
        if (queryKey == null) {
            GUESSEndpoint gUESSEndpoint2 = new GUESSEndpoint(gUESSEndpoint.getAddress(), gUESSEndpoint.getPort());
            SendLaterBundle sendLaterBundle = new SendLaterBundle(uRN);
            _bufferedURNs.put(gUESSEndpoint2, sendLaterBundle);
            PingRequest pingRequest = PingRequest.createQueryKeyRequest();
            _udp.send(pingRequest, gUESSEndpoint.getAddress(), gUESSEndpoint.getPort());
        } else {
            QueryRequest queryRequest = QueryRequest.createQueryKeyQuery(uRN, queryKey);
            RouterService.getMessageRouter().originateQueryGUID(queryRequest.getGUID());
            _udp.send(queryRequest, gUESSEndpoint.getAddress(), gUESSEndpoint.getPort());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean clearDataStructures(long l, long l2) throws Throwable {
        boolean bl = false;
        if (System.currentTimeMillis() - l > l2) {
            bl = true;
            _queryKeys.clear();
        }
        Map map = _bufferedURNs;
        synchronized (map) {
            Iterator iterator = _bufferedURNs.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                SendLaterBundle sendLaterBundle = (SendLaterBundle)entry.getValue();
                if (!sendLaterBundle.shouldExpire()) continue;
                iterator.remove();
            }
        }
        return bl;
    }

    static {
        _bufferedURNs = new Hashtable();
        _udp = UDPService.instance();
        RouterService.schedule(new Expirer(), 300000L, 300000L);
    }

    private static class Expirer
    implements Runnable {
        private static final int QUERY_KEY_CLEAR_TIME = 86400000;
        private long _lastQueryKeyClearTime = System.currentTimeMillis();

        public void run() {
            try {
                if (OnDemandUnicaster.clearDataStructures(this._lastQueryKeyClearTime, 86400000L)) {
                    this._lastQueryKeyClearTime = System.currentTimeMillis();
                }
            }
            catch (Throwable throwable) {
                ErrorService.error(throwable);
            }
        }
    }

    private static class SendLaterBundle {
        private static final int MAX_LIFETIME = 60000;
        public final URN _queryURN;
        private final long _creationTime;

        public SendLaterBundle(URN uRN) {
            this._queryURN = uRN;
            this._creationTime = System.currentTimeMillis();
        }

        public boolean shouldExpire() {
            return System.currentTimeMillis() - this._creationTime > 60000L;
        }
    }
}

