/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManagerEvent;
import com.limegroup.gnutella.IncompleteFileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.gui.FinalizeListener;
import com.limegroup.gnutella.settings.DaapSettings;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.FileUtils;
import com.limegroup.gnutella.util.ManagedThread;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLReplyCollection;
import com.limegroup.gnutella.xml.SchemaReplyCollectionMapper;
import de.kapsi.net.daap.DaapAuthenticator;
import de.kapsi.net.daap.DaapConfig;
import de.kapsi.net.daap.DaapFilter;
import de.kapsi.net.daap.DaapServer;
import de.kapsi.net.daap.DaapServerFactory;
import de.kapsi.net.daap.DaapStreamSource;
import de.kapsi.net.daap.DaapThreadFactory;
import de.kapsi.net.daap.Database;
import de.kapsi.net.daap.Library;
import de.kapsi.net.daap.Song;
import de.kapsi.net.daap.Transaction;
import de.kapsi.net.daap.TransactionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.BindException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import javax.jmdns.JmDNS;
import javax.jmdns.ServiceInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class DaapManager
implements FinalizeListener {
    private static final Log LOG = LogFactory.getLog((Class)(class$com$limegroup$gnutella$gui$DaapManager == null ? (class$com$limegroup$gnutella$gui$DaapManager = DaapManager.class$("com.limegroup.gnutella.gui.DaapManager")) : class$com$limegroup$gnutella$gui$DaapManager));
    private static final DaapManager INSTANCE = new DaapManager();
    private static final String AUDIO_SCHEMA = "http://www.limewire.com/schemas/audio.xsd";
    private SongURNMap map;
    private Library library;
    private Database database;
    private DaapServer server;
    private RendezvousService rendezvous;
    private boolean enabled = false;
    private int maxPlaylistSize;
    static /* synthetic */ Class class$com$limegroup$gnutella$gui$DaapManager;

    public static DaapManager instance() {
        return INSTANCE;
    }

    private DaapManager() {
        if (!CommonUtils.isJava14OrLater()) {
            throw new RuntimeException("Cannot instance DaapManager");
        }
    }

    public synchronized void init() {
        if (this.isServerRunning()) {
            this.setEnabled(this.enabled);
        }
    }

    public synchronized void start() throws IOException {
        if (!this.isServerRunning()) {
            try {
                InetAddress inetAddress;
                Enumeration<NetworkInterface> enumeration;
                InetAddress inetAddress2 = InetAddress.getLocalHost();
                if (inetAddress2.isLoopbackAddress() || !(inetAddress2 instanceof Inet4Address)) {
                    inetAddress2 = null;
                    enumeration = NetworkInterface.getNetworkInterfaces();
                    if (enumeration != null) {
                        block4: while (inetAddress2 == null && enumeration.hasMoreElements()) {
                            NetworkInterface networkInterface = enumeration.nextElement();
                            Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                            while (enumeration2.hasMoreElements()) {
                                inetAddress = enumeration2.nextElement();
                                if (inetAddress.isLoopbackAddress() || !(inetAddress instanceof Inet4Address)) continue;
                                inetAddress2 = inetAddress;
                                continue block4;
                            }
                        }
                    }
                }
                if (inetAddress2 == null) {
                    this.stop();
                    return;
                }
                this.rendezvous = new RendezvousService(inetAddress2);
                this.map = new SongURNMap();
                this.maxPlaylistSize = DaapSettings.DAAP_MAX_LIBRARY_SIZE.getValue();
                enumeration = DaapSettings.DAAP_LIBRARY_NAME.getValue();
                int n = DaapSettings.DAAP_LIBRARY_REVISIONS.getValue();
                boolean bl = DaapSettings.DAAP_LIBRARY_GC.getValue();
                this.library = new Library((String)((Object)enumeration), n, bl);
                this.database = new Database((String)((Object)enumeration));
                inetAddress = this.library.open(false);
                this.library.add((Transaction)inetAddress, this.database);
                inetAddress.commit();
                LimeConfig limeConfig = new LimeConfig(inetAddress2);
                boolean bl2 = DaapSettings.DAAP_USE_NIO.getValue();
                this.server = DaapServerFactory.createServer((Library)this.library, (DaapConfig)limeConfig, (boolean)bl2);
                this.server.setAuthenticator((DaapAuthenticator)new LimeAuthenticator());
                this.server.setStreamSource((DaapStreamSource)new LimeStreamSource());
                this.server.setFilter((DaapFilter)new LimeFilter());
                if (!bl2) {
                    this.server.setThreadFactory((DaapThreadFactory)new LimeThreadFactory());
                }
                for (int i = 0; i < 10; ++i) {
                    try {
                        this.server.bind();
                        break;
                    }
                    catch (BindException bindException) {
                        if (i >= 9) {
                            throw bindException;
                        }
                        limeConfig.nextPort();
                        continue;
                    }
                }
                ManagedThread managedThread = new ManagedThread((Runnable)this.server, "DaapServerThread"){

                    protected void managedRun() {
                        block3: {
                            try {
                                super.managedRun();
                            }
                            catch (Throwable throwable) {
                                DaapManager.this.stop();
                                if (DaapManager.this.handleError(throwable)) break block3;
                                DaapSettings.DAAP_ENABLED.setValue(false);
                                if (throwable instanceof RuntimeException) {
                                    throw (RuntimeException)throwable;
                                }
                                throw new RuntimeException(throwable);
                            }
                        }
                    }
                };
                managedThread.setDaemon(true);
                managedThread.start();
                this.rendezvous.registerService();
            }
            catch (IOException iOException) {
                this.stop();
                throw iOException;
            }
        }
    }

    public synchronized void stop() {
        if (this.rendezvous != null) {
            this.rendezvous.close();
        }
        if (this.server != null) {
            this.server.stop();
            this.server = null;
        }
        if (this.map != null) {
            this.map.clear();
        }
        this.rendezvous = null;
        this.map = null;
        this.library = null;
        this.database = null;
    }

    public synchronized void restart() throws IOException {
        if (this.isServerRunning()) {
            this.stop();
        }
        this.start();
        this.init();
    }

    public void doFinalize() {
        this.stop();
    }

    public synchronized void updateService() throws IOException {
        if (this.isServerRunning()) {
            this.rendezvous.updateService();
            Transaction transaction = this.library.open(false);
            String string = DaapSettings.DAAP_LIBRARY_NAME.getValue();
            this.library.setName(transaction, string);
            this.database.setName(transaction, string);
            transaction.commit();
            this.server.update();
        }
    }

    public synchronized void disconnectAll() {
        if (this.isServerRunning()) {
            this.server.disconnectAll();
        }
    }

    public synchronized boolean isServerRunning() {
        if (this.server != null) {
            return this.server.isRunning();
        }
        return false;
    }

    private boolean handleError(Throwable throwable) {
        if (throwable == null) {
            return false;
        }
        String string = throwable.getMessage();
        if (string == null || string.indexOf("Unable to establish loopback connection") == -1) {
            return this.handleError(throwable.getCause());
        }
        DaapSettings.DAAP_ENABLED.setValue(false);
        return true;
    }

    private static boolean isSupportedFormat(String string) {
        String[] stringArray = DaapSettings.DAAP_SUPPORTED_FILE_TYPES.getValue();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.endsWith(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    private void handleChangeEvent(FileManagerEvent fileManagerEvent) {
        FileDesc fileDesc = fileManagerEvent.getFileDescs()[0];
        Song song = this.map.remove(fileDesc.getSHA1Urn());
        if (song != null) {
            FileDesc fileDesc2 = fileManagerEvent.getFileDescs()[1];
            this.map.put(song, fileDesc2.getSHA1Urn());
            if (this.updateSongMeta(song, fileDesc2)) {
                Transaction transaction = this.library.open(true);
                transaction.addTransactionListener((TransactionListener)new ServerUpdater(this.server));
                this.database.update(transaction, song);
            }
        }
    }

    private void handleAddEvent(FileManagerEvent fileManagerEvent) {
        String string;
        if (this.database.getMasterPlaylist().size() >= this.maxPlaylistSize) {
            return;
        }
        FileDesc fileDesc = fileManagerEvent.getFileDescs()[0];
        if (!(fileDesc instanceof IncompleteFileDesc) && DaapManager.isSupportedFormat(string = fileDesc.getFileName().toLowerCase(Locale.US))) {
            Song song = this.createSong(fileDesc);
            this.map.put(song, fileDesc.getSHA1Urn());
            Transaction transaction = this.library.open(true);
            transaction.addTransactionListener((TransactionListener)new ServerUpdater(this.server));
            this.database.getMasterPlaylist().add(transaction, song);
        }
    }

    private void handleRenameEvent(FileManagerEvent fileManagerEvent) {
        FileDesc fileDesc = fileManagerEvent.getFileDescs()[0];
        Song song = this.map.remove(fileDesc.getSHA1Urn());
        if (song != null) {
            FileDesc fileDesc2 = fileManagerEvent.getFileDescs()[1];
            this.map.put(song, fileDesc2.getSHA1Urn());
        }
    }

    private void handleRemoveEvent(FileManagerEvent fileManagerEvent) {
        FileDesc fileDesc = fileManagerEvent.getFileDescs()[0];
        Song song = this.map.remove(fileDesc.getSHA1Urn());
        if (song != null) {
            Transaction transaction = this.library.open(true);
            transaction.addTransactionListener((TransactionListener)new ServerUpdater(this.server));
            this.database.remove(transaction, song);
        }
    }

    public synchronized void handleFileManagerEvent(FileManagerEvent fileManagerEvent) {
        if (!this.enabled || !this.isServerRunning()) {
            return;
        }
        if (fileManagerEvent.isChangeEvent()) {
            this.handleChangeEvent(fileManagerEvent);
        } else if (fileManagerEvent.isAddEvent()) {
            this.handleAddEvent(fileManagerEvent);
        } else if (fileManagerEvent.isRenameEvent()) {
            this.handleRenameEvent(fileManagerEvent);
        } else if (fileManagerEvent.isRemoveEvent()) {
            this.handleRemoveEvent(fileManagerEvent);
        }
    }

    public void fileManagerLoading() {
        this.setEnabled(false);
    }

    public void fileManagerLoaded() {
        this.setEnabled(true);
    }

    public synchronized boolean isEnabled() {
        return this.enabled;
    }

    private synchronized void setEnabled(boolean bl) {
        FileDesc fileDesc;
        this.enabled = bl;
        if (!bl || !this.isServerRunning()) {
            return;
        }
        int n = this.database.getMasterPlaylist().size();
        Transaction transaction = this.library.open(false);
        SongURNMap songURNMap = new SongURNMap();
        FileDesc[] fileDescArray = RouterService.getFileManager().getAllSharedFileDescriptors();
        for (int i = 0; i < fileDescArray.length; ++i) {
            String string;
            fileDesc = fileDescArray[i];
            if (fileDesc instanceof IncompleteFileDesc || !DaapManager.isSupportedFormat(string = fileDesc.getFileName().toLowerCase(Locale.US))) continue;
            URN uRN = fileDesc.getSHA1Urn();
            Song song = this.map.remove(uRN);
            if (songURNMap.contains(uRN)) continue;
            if (song != null) {
                songURNMap.put(song, uRN);
                if (!this.updateSongMeta(song, fileDesc)) continue;
                this.database.update(transaction, song);
                continue;
            }
            if (n >= this.maxPlaylistSize) continue;
            song = this.createSong(fileDesc);
            songURNMap.put(song, uRN);
            this.database.getMasterPlaylist().add(transaction, song);
            ++n;
        }
        Iterator iterator = this.map.getSongIterator();
        while (iterator.hasNext()) {
            fileDesc = (Song)iterator.next();
            this.database.remove(transaction, (Song)fileDesc);
        }
        this.map.clear();
        this.map = songURNMap;
        transaction.addTransactionListener((TransactionListener)new ServerUpdater(this.server));
        transaction.commit();
    }

    private Song createSong(FileDesc fileDesc) {
        Song song = new Song(fileDesc.getFileName());
        song.setSize((int)fileDesc.getFileSize());
        song.setDateAdded((int)(System.currentTimeMillis() / 1000L));
        File file = fileDesc.getFile();
        String string = FileUtils.getFileExtension(file);
        if (string != null) {
            song.setFormat(string.toLowerCase(Locale.US));
            this.updateSongMeta(song, fileDesc);
        }
        return song;
    }

    private boolean updateSongMeta(Song song, FileDesc fileDesc) {
        int n;
        int n2;
        int n3;
        String string;
        SchemaReplyCollectionMapper schemaReplyCollectionMapper = SchemaReplyCollectionMapper.instance();
        LimeXMLReplyCollection limeXMLReplyCollection = schemaReplyCollectionMapper.getReplyCollection(AUDIO_SCHEMA);
        if (limeXMLReplyCollection == null) {
            LOG.error((Object)"LimeXMLReplyCollection is null");
            return false;
        }
        LimeXMLDocument limeXMLDocument = limeXMLReplyCollection.getDocForHash(fileDesc.getSHA1Urn());
        if (limeXMLDocument == null) {
            return false;
        }
        boolean bl = false;
        String string2 = limeXMLDocument.getValue("audios__audio__title__");
        String string3 = limeXMLDocument.getValue("audios__audio__track__");
        String string4 = limeXMLDocument.getValue("audios__audio__artist__");
        String string5 = limeXMLDocument.getValue("audios__audio__album__");
        String string6 = limeXMLDocument.getValue("audios__audio__genre__");
        String string7 = limeXMLDocument.getValue("audios__audio__bitrate__");
        String string8 = limeXMLDocument.getValue("audios__audio__comments__");
        String string9 = limeXMLDocument.getValue("audios__audio__seconds__");
        String string10 = limeXMLDocument.getValue("audios__audio__year__");
        if (!(string2 == null || (string = song.getName()) != null && string2.equals(string))) {
            bl = true;
            song.setName(string2);
        }
        int n4 = song.getTrackNumber();
        if (string3 != null) {
            try {
                int n5 = Integer.parseInt(string3);
                if (n5 > 0 && n5 != n4) {
                    bl = true;
                    song.setTrackNumber(n5);
                }
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (n4 != 0) {
            bl = true;
            song.setTrackNumber(0);
        }
        String string11 = song.getArtist();
        if (string4 != null) {
            if (string11 == null || !string4.equals(string11)) {
                bl = true;
                song.setArtist(string4);
            }
        } else if (string11 != null) {
            bl = true;
            song.setArtist(null);
        }
        String string12 = song.getAlbum();
        if (string5 != null) {
            if (string12 == null || !string5.equals(string12)) {
                bl = true;
                song.setAlbum(string5);
            }
        } else if (string12 != null) {
            bl = true;
            song.setAlbum(null);
        }
        String string13 = song.getGenre();
        if (string6 != null) {
            if (string13 == null || !string6.equals(string13)) {
                bl = true;
                song.setGenre(string6);
            }
        } else if (string13 != null) {
            bl = true;
            song.setGenre(null);
        }
        String string14 = song.getComment();
        if (string8 != null) {
            if (string14 == null || !string8.equals(string14)) {
                bl = true;
                song.setComment(string8);
            }
        } else if (string14 != null) {
            bl = true;
            song.setComment(null);
        }
        int n6 = song.getBitrate();
        if (string7 != null) {
            try {
                n3 = Integer.parseInt(string7);
                if (n3 > 0 && n3 != n6) {
                    bl = true;
                    song.setBitrate(n3);
                }
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (n6 != 0) {
            bl = true;
            song.setBitrate(0);
        }
        n3 = song.getTime();
        if (string9 != null) {
            try {
                n2 = Integer.parseInt(string9) * 1000;
                if (n2 > 0 && n2 != n3) {
                    bl = true;
                    song.setTime(n2);
                }
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (n3 != 0) {
            bl = true;
            song.setTime(0);
        }
        n2 = song.getYear();
        if (string10 != null) {
            try {
                n = Integer.parseInt(string10);
                if (n > 0 && n != n2) {
                    bl = true;
                    song.setYear(n);
                }
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (n2 != 0) {
            bl = true;
            song.setYear(0);
        }
        n = (int)(fileDesc.lastModified() / 1000L);
        if (song.getDateModified() != n) {
            bl = true;
            song.setDateModified(n);
        }
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class ServerUpdater
    implements TransactionListener {
        private DaapServer server;

        private ServerUpdater(DaapServer daapServer) {
            this.server = daapServer;
        }

        public void commit(Transaction transaction) {
            if (this.server != null) {
                this.server.update();
            }
        }

        public void rollback(Transaction transaction) {
        }
    }

    private final class SongURNMap {
        private HashMap songToUrn = new HashMap();
        private HashMap urnToSong = new HashMap();

        public void put(Song song, URN uRN) {
            this.songToUrn.put(song, uRN);
            this.urnToSong.put(uRN, song);
        }

        public URN get(Song song) {
            return (URN)this.songToUrn.get(song);
        }

        public Song get(URN uRN) {
            return (Song)this.urnToSong.get(uRN);
        }

        public Song remove(URN uRN) {
            Song song = (Song)this.urnToSong.remove(uRN);
            if (song != null) {
                this.songToUrn.remove(song);
            }
            return song;
        }

        public URN remove(Song song) {
            URN uRN = (URN)this.songToUrn.remove(song);
            if (uRN != null) {
                this.urnToSong.remove(uRN);
            }
            return uRN;
        }

        public boolean contains(URN uRN) {
            return this.urnToSong.containsKey(uRN);
        }

        public boolean contains(Song song) {
            return this.songToUrn.containsKey(song);
        }

        public Iterator getSongIterator() {
            return this.songToUrn.keySet().iterator();
        }

        public Iterator getURNIterator() {
            return this.urnToSong.keySet().iterator();
        }

        public void clear() {
            this.urnToSong.clear();
            this.songToUrn.clear();
        }

        public int size() {
            return this.songToUrn.size();
        }
    }

    private final class RendezvousService {
        private static final String VERSION = "Version";
        private static final String MACHINE_NAME = "Machine Name";
        private static final String PASSWORD = "Password";
        private final JmDNS zeroConf;
        private ServiceInfo service;

        public RendezvousService(InetAddress inetAddress) throws IOException {
            this.zeroConf = new JmDNS(inetAddress);
        }

        public boolean isRegistered() {
            return this.service != null;
        }

        private ServiceInfo createServiceInfo() {
            String string = DaapSettings.DAAP_TYPE_NAME.getValue();
            String string2 = DaapSettings.DAAP_SERVICE_NAME.getValue();
            int n = DaapSettings.DAAP_PORT.getValue();
            int n2 = DaapSettings.DAAP_WEIGHT.getValue();
            int n3 = DaapSettings.DAAP_PRIORITY.getValue();
            boolean bl = DaapSettings.DAAP_REQUIRES_PASSWORD.getValue();
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put(VERSION, Integer.toString(196608));
            hashtable.put(MACHINE_NAME, string2);
            hashtable.put(PASSWORD, Boolean.toString(bl));
            String string3 = null;
            string3 = bl ? string2 + "_PW." + string : string2 + "." + string;
            ServiceInfo serviceInfo = new ServiceInfo(string, string3, n, n2, n3, hashtable);
            return serviceInfo;
        }

        public void registerService() throws IOException {
            if (this.isRegistered()) {
                throw new IOException();
            }
            ServiceInfo serviceInfo = this.createServiceInfo();
            this.zeroConf.registerService(serviceInfo);
            this.service = serviceInfo;
        }

        public void unregisterService() {
            if (!this.isRegistered()) {
                return;
            }
            this.zeroConf.unregisterService(this.service);
            this.service = null;
        }

        public void updateService() throws IOException {
            if (!this.isRegistered()) {
                throw new IOException();
            }
            if (this.service.getPort() != DaapSettings.DAAP_PORT.getValue()) {
                this.unregisterService();
            }
            ServiceInfo serviceInfo = this.createServiceInfo();
            this.zeroConf.registerService(serviceInfo);
            this.service = serviceInfo;
        }

        public void close() {
            this.unregisterService();
            this.zeroConf.close();
        }
    }

    private final class LimeConfig
    implements DaapConfig {
        private InetAddress addr;

        public LimeConfig(InetAddress inetAddress) {
            this.addr = inetAddress;
            DaapSettings.DAAP_PORT.revertToDefault();
        }

        public String getServerName() {
            return CommonUtils.getHttpServer();
        }

        public void nextPort() {
            int n = DaapSettings.DAAP_PORT.getValue();
            DaapSettings.DAAP_PORT.setValue(n + 1);
        }

        public int getBacklog() {
            return 0;
        }

        public InetSocketAddress getInetSocketAddress() {
            int n = DaapSettings.DAAP_PORT.getValue();
            return new InetSocketAddress(this.addr, n);
        }

        public int getMaxConnections() {
            return DaapSettings.DAAP_MAX_CONNECTIONS.getValue();
        }
    }

    private final class LimeFilter
    implements DaapFilter {
        private LimeFilter() {
        }

        public boolean accept(InetAddress inetAddress) {
            byte[] byArray = inetAddress.getAddress();
            try {
                if (!NetworkUtils.isVeryCloseIP(byArray) && !NetworkUtils.isPrivateAddress(byArray)) {
                    return false;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LOG.error((Object)illegalArgumentException);
                return false;
            }
            return IPFilter.instance().allow(byArray);
        }
    }

    private final class LimeAuthenticator
    implements DaapAuthenticator {
        private LimeAuthenticator() {
        }

        public boolean requiresAuthentication() {
            return DaapSettings.DAAP_REQUIRES_PASSWORD.getValue();
        }

        public boolean authenticate(String string, String string2) {
            return string2.equals(DaapSettings.DAAP_PASSWORD.getValue());
        }
    }

    private final class LimeStreamSource
    implements DaapStreamSource {
        private LimeStreamSource() {
        }

        public FileInputStream getSource(Song song) throws IOException {
            FileDesc fileDesc;
            URN uRN = DaapManager.this.map.get(song);
            if (uRN != null && (fileDesc = RouterService.getFileManager().getFileDescForUrn(uRN)) != null) {
                return new FileInputStream(fileDesc.getFile());
            }
            return null;
        }
    }

    private final class LimeThreadFactory
    implements DaapThreadFactory {
        private LimeThreadFactory() {
        }

        public Thread createDaapThread(Runnable runnable, String string) {
            ManagedThread managedThread = new ManagedThread(runnable, string);
            managedThread.setDaemon(true);
            return managedThread;
        }
    }
}

