/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.handshaking;

import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.handshaking.HeaderNames;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.IpPort;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;

public final class HandshakeResponse {
    public static final int OK = 200;
    public static final String OK_MESSAGE = "OK";
    public static final int CRAWLER_CODE = 593;
    public static final String CRAWLER_MESSAGE = "Hi";
    public static final int SHIELDED = 503;
    public static final String SHIELDED_MESSAGE = "I am a shielded leaf node";
    public static final int SLOTS_FULL = 503;
    public static final String SLOTS_FULL_MESSAGE = "Service unavailable";
    public static final int DEFAULT_BAD_STATUS_CODE = 503;
    public static final String DEFAULT_BAD_STATUS_MESSAGE = "Service Not Available";
    public static final int LOCALE_NO_MATCH = 577;
    public static final String LOCALE_NO_MATCH_MESSAGE = "Service Not Available";
    private final int STATUS_CODE;
    private final String STATUS_MESSAGE;
    private final Properties HEADERS;
    private Boolean _supportsGGEP;
    private final boolean GOOD_LEAF;
    private final boolean GOOD_ULTRAPEER;
    private final int DEGREE;
    private final boolean HIGH_DEGREE;
    private final boolean ULTRAPEER_QRP;
    private final byte MAX_TTL;
    private final boolean DYNAMIC_QUERY;
    private final boolean ULTRAPEER;
    private final boolean LEAF;
    private final boolean DEFLATE_ENCODED;
    private final boolean PROBE_QUERIES;
    private final boolean PONG_CACHING;
    private final boolean GUESS_CAPABLE;
    private final boolean IS_CRAWLER;
    private final boolean IS_LIMEWIRE;
    private final boolean IS_OLD_LIMEWIRE;
    private final boolean NO_REQUERYING;
    private final String LOCALE_PREF;
    private static final int NUM_X_TRY_ULTRAPEER_HOSTS = 10;

    private HandshakeResponse(Properties properties) {
        this(200, OK_MESSAGE, properties);
    }

    private HandshakeResponse(int n, String string) {
        this(n, string, new Properties());
    }

    HandshakeResponse(int n, String string, Properties properties) {
        this.STATUS_CODE = n;
        this.STATUS_MESSAGE = string;
        this.HEADERS = properties;
        this.DEGREE = HandshakeResponse.extractIntHeaderValue(this.HEADERS, "X-Degree", 6);
        this.HIGH_DEGREE = this.getNumIntraUltrapeerConnections() >= 15;
        this.ULTRAPEER_QRP = HandshakeResponse.isVersionOrHigher(this.HEADERS, "X-Ultrapeer-Query-Routing", 0.1f);
        this.MAX_TTL = HandshakeResponse.extractByteHeaderValue(this.HEADERS, "X-Max-TTL", (byte)4);
        this.DYNAMIC_QUERY = HandshakeResponse.isVersionOrHigher(this.HEADERS, "X-Dynamic-Querying", 0.1f);
        this.PROBE_QUERIES = HandshakeResponse.isVersionOrHigher(this.HEADERS, "X-Ext-Probes", 0.1f);
        this.NO_REQUERYING = HandshakeResponse.isFalseValue(this.HEADERS, "X-Requeries");
        this.IS_LIMEWIRE = HandshakeResponse.extractStringHeaderValue(properties, "User-Agent").toLowerCase().startsWith("limewire");
        this.GOOD_ULTRAPEER = this.isHighDegreeConnection() && this.isUltrapeerQueryRoutingConnection() && this.getMaxTTL() < 5 && this.isDynamicQueryConnection();
        this.GOOD_LEAF = this.GOOD_ULTRAPEER && (this.IS_LIMEWIRE || this.NO_REQUERYING);
        this.ULTRAPEER = HandshakeResponse.isTrueValue(this.HEADERS, "X-Ultrapeer");
        this.LEAF = HandshakeResponse.isFalseValue(this.HEADERS, "X-Ultrapeer");
        this.DEFLATE_ENCODED = HandshakeResponse.isStringValue(this.HEADERS, HeaderNames.CONTENT_ENCODING, HeaderNames.DEFLATE_VALUE);
        this.PONG_CACHING = HandshakeResponse.isVersionOrHigher(properties, "Pong-Caching", 0.1f);
        this.GUESS_CAPABLE = HandshakeResponse.isVersionOrHigher(properties, "X-Guess", 0.1f);
        this.IS_CRAWLER = HandshakeResponse.isVersionOrHigher(properties, "Crawler", 0.1f);
        this.IS_OLD_LIMEWIRE = this.IS_LIMEWIRE && this.oldVersion(HandshakeResponse.extractStringHeaderValue(properties, "User-Agent"));
        String string2 = HandshakeResponse.extractStringHeaderValue(properties, "X-Locale-Pref");
        this.LOCALE_PREF = string2.equals("") ? ApplicationSettings.DEFAULT_LOCALE.getValue() : string2;
    }

    private boolean oldVersion(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/.");
        int n = -1;
        int n2 = -1;
        boolean bl = false;
        boolean bl2 = false;
        if (stringTokenizer.countTokens() < 3) {
            return false;
        }
        try {
            String string2 = stringTokenizer.nextToken();
            string2 = stringTokenizer.nextToken();
            n = Integer.parseInt(string2);
            string2 = stringTokenizer.nextToken();
            n2 = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            bl2 = true;
        }
        if (!bl2 && (n < 3 || n == 3 && n2 < 4)) {
            bl = true;
        }
        return bl;
    }

    public static HandshakeResponse createEmptyResponse() {
        return new HandshakeResponse(new Properties());
    }

    public static HandshakeResponse createResponse(Properties properties) throws IOException {
        return new HandshakeResponse(properties);
    }

    public static HandshakeResponse createRemoteResponse(String string, Properties properties) throws IOException {
        int n = HandshakeResponse.extractCode(string);
        if (n == -1) {
            throw new IOException("could not parse status code: " + string);
        }
        String string2 = HandshakeResponse.extractMessage(string);
        if (string2 == null) {
            throw new IOException("could not parse status message: " + string);
        }
        return new HandshakeResponse(n, string2, properties);
    }

    static HandshakeResponse createAcceptIncomingResponse(HandshakeResponse handshakeResponse, Properties properties) {
        return new HandshakeResponse(HandshakeResponse.addXTryHeader(handshakeResponse, properties));
    }

    static HandshakeResponse createAcceptOutgoingResponse(Properties properties) {
        return new HandshakeResponse(properties);
    }

    static HandshakeResponse createCrawlerResponse() {
        Properties properties = new Properties();
        properties.put("User-Agent", CommonUtils.getHttpServer());
        properties.put("X-Ultrapeer", "" + RouterService.isSupernode());
        List list = RouterService.getConnectionManager().getInitializedClientConnections();
        properties.put("Leaves", HandshakeResponse.createEndpointString(list, list.size()));
        List list2 = RouterService.getConnectionManager().getInitializedConnections();
        properties.put("Peers", HandshakeResponse.createEndpointString(list2, list2.size()));
        return new HandshakeResponse(593, CRAWLER_MESSAGE, properties);
    }

    static HandshakeResponse createUltrapeerRejectIncomingResponse(HandshakeResponse handshakeResponse) {
        return new HandshakeResponse(503, SLOTS_FULL_MESSAGE, HandshakeResponse.addXTryHeader(handshakeResponse, new Properties()));
    }

    static HandshakeResponse createRejectOutgoingResponse() {
        return new HandshakeResponse(503, SLOTS_FULL_MESSAGE, new Properties());
    }

    static HandshakeResponse createLeafRejectIncomingResponse(HandshakeResponse handshakeResponse) {
        return new HandshakeResponse(503, SHIELDED_MESSAGE, HandshakeResponse.addXTryHeader(handshakeResponse, new Properties()));
    }

    static HandshakeResponse createLeafRejectOutgoingResponse() {
        return new HandshakeResponse(503, SHIELDED_MESSAGE);
    }

    static HandshakeResponse createLeafRejectLocaleOutgoingResponse() {
        return new HandshakeResponse(577, "Service Not Available");
    }

    private static String createEndpointString(Collection collection) {
        return HandshakeResponse.createEndpointString(collection, 10);
    }

    private static String createEndpointString(Collection collection, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = collection.iterator();
        for (int i = 0; iterator.hasNext() && i < n; ++i) {
            IpPort ipPort = (IpPort)iterator.next();
            stringBuffer.append(ipPort.getAddress());
            stringBuffer.append(":");
            stringBuffer.append(ipPort.getPort());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }

    private static int extractCode(String string) {
        int n = string.indexOf(" ");
        if (n == -1) {
            return -1;
        }
        try {
            return Integer.parseInt(string.substring(0, n).trim());
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    private static String extractMessage(String string) {
        int n = string.indexOf(" ");
        if (n == -1) {
            return null;
        }
        return string.substring(n).trim();
    }

    private static Properties addXTryHeader(HandshakeResponse handshakeResponse, Properties properties) {
        Collection collection = RouterService.getPreferencedHosts(handshakeResponse.isUltrapeer(), handshakeResponse.getLocalePref(), 10);
        properties.put("X-Try-Ultrapeers", HandshakeResponse.createEndpointString(collection));
        return properties;
    }

    public int getStatusCode() {
        return this.STATUS_CODE;
    }

    public String getStatusMessage() {
        return this.STATUS_MESSAGE;
    }

    public boolean notOKStatusCode() {
        return this.STATUS_CODE != 200;
    }

    public boolean isAccepted() {
        return this.STATUS_CODE == 200;
    }

    public String getStatusLine() {
        return new String(this.STATUS_CODE + " " + this.STATUS_MESSAGE);
    }

    public Properties props() {
        return this.HEADERS;
    }

    public String getProperty(String string) {
        return this.HEADERS.getProperty(string);
    }

    public String getUserAgent() {
        return this.HEADERS.getProperty("User-Agent");
    }

    public byte getMaxTTL() {
        return this.MAX_TTL;
    }

    public String getXTryUltrapeers() {
        return HandshakeResponse.extractStringHeaderValue(this.HEADERS, "X-Try-Ultrapeers");
    }

    public boolean hasXTryUltrapeers() {
        return HandshakeResponse.headerExists(this.HEADERS, "X-Try-Ultrapeers");
    }

    public boolean hasLeafGuidance() {
        return HandshakeResponse.isFalseValue(this.HEADERS, "X-Ultrapeer-Needed");
    }

    public int getNumIntraUltrapeerConnections() {
        return this.DEGREE;
    }

    public boolean isHighDegreeConnection() {
        return this.HIGH_DEGREE;
    }

    public boolean isLimeWire() {
        return this.IS_LIMEWIRE;
    }

    public boolean isOldLimeWire() {
        return this.IS_OLD_LIMEWIRE;
    }

    public boolean isGoodLeaf() {
        return this.GOOD_LEAF;
    }

    public boolean isDeflateEnabled() {
        return this.DEFLATE_ENCODED;
    }

    public boolean isDeflateAccepted() {
        return ConnectionSettings.ENCODE_DEFLATE.getValue() && HandshakeResponse.containsStringValue(this.HEADERS, HeaderNames.ACCEPT_ENCODING, HeaderNames.DEFLATE_VALUE);
    }

    public boolean isGoodUltrapeer() {
        return this.GOOD_ULTRAPEER;
    }

    public boolean isUltrapeerQueryRoutingConnection() {
        return this.ULTRAPEER_QRP;
    }

    public boolean isLeaf() {
        return this.LEAF;
    }

    public boolean isUltrapeer() {
        return this.ULTRAPEER;
    }

    public boolean isGUESSCapable() {
        return this.GUESS_CAPABLE;
    }

    public boolean isGUESSUltrapeer() {
        return this.isGUESSCapable() && this.isUltrapeer();
    }

    public boolean isTempConnection() {
        String string = this.HEADERS.getProperty("X-Temp-Connection");
        if (string == null) {
            return false;
        }
        return Boolean.valueOf(string);
    }

    public boolean supportsGGEP() {
        if (this._supportsGGEP == null) {
            String string = this.HEADERS.getProperty("GGEP");
            this._supportsGGEP = new Boolean(string != null);
        }
        return this._supportsGGEP;
    }

    public float supportsVendorMessages() {
        String string = this.HEADERS.getProperty("Vendor-Message");
        if (string != null && !string.equals("")) {
            try {
                return Float.parseFloat(string);
            }
            catch (NumberFormatException numberFormatException) {
                return 0.0f;
            }
        }
        return 0.0f;
    }

    public boolean supportsPongCaching() {
        return this.PONG_CACHING;
    }

    public String getVersion() {
        return this.HEADERS.getProperty("X-Version");
    }

    public boolean isQueryRoutingEnabled() {
        return HandshakeResponse.isVersionOrHigher(this.HEADERS, "X-Query-Routing", 0.1f);
    }

    public boolean isDynamicQueryConnection() {
        return this.DYNAMIC_QUERY;
    }

    public boolean supportsProbeQueries() {
        return this.PROBE_QUERIES;
    }

    public boolean isCrawler() {
        return this.IS_CRAWLER;
    }

    public String getLocalePref() {
        return this.LOCALE_PREF;
    }

    private static boolean headerExists(Properties properties, String string) {
        String string2 = properties.getProperty(string);
        return string2 != null;
    }

    private static boolean isTrueValue(Properties properties, String string) {
        String string2 = properties.getProperty(string);
        if (string2 == null) {
            return false;
        }
        return Boolean.valueOf(string2);
    }

    private static boolean isFalseValue(Properties properties, String string) {
        String string2 = properties.getProperty(string);
        if (string2 == null) {
            return false;
        }
        return string2.equalsIgnoreCase("false");
    }

    private static boolean isStringValue(Properties properties, String string, String string2) {
        String string3 = properties.getProperty(string);
        if (string3 == null) {
            return false;
        }
        return string3.equalsIgnoreCase(string2);
    }

    private static boolean containsStringValue(Properties properties, String string, String string2) {
        String string3 = properties.getProperty(string);
        if (string3 == null) {
            return false;
        }
        if (string3.equalsIgnoreCase(string2)) {
            return true;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
        while (stringTokenizer.hasMoreTokens()) {
            if (!stringTokenizer.nextToken().equalsIgnoreCase(string2)) continue;
            return true;
        }
        return false;
    }

    private static boolean isVersionOrHigher(Properties properties, String string, float f) {
        String string2 = properties.getProperty(string);
        if (string2 == null) {
            return false;
        }
        try {
            Float f2 = new Float(string2);
            return f2.floatValue() >= f;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private static int extractIntHeaderValue(Properties properties, String string, int n) {
        String string2 = properties.getProperty(string);
        if (string2 == null) {
            return n;
        }
        try {
            return Integer.valueOf(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    private static byte extractByteHeaderValue(Properties properties, String string, byte by) {
        String string2 = properties.getProperty(string);
        if (string2 == null) {
            return by;
        }
        try {
            return Byte.valueOf(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return by;
        }
    }

    private static String extractStringHeaderValue(Properties properties, String string) {
        String string2 = properties.getProperty(string);
        if (string2 == null) {
            return "";
        }
        return string2;
    }

    public String toString() {
        return "<" + this.STATUS_CODE + ", " + this.STATUS_MESSAGE + ">" + this.HEADERS;
    }
}

