/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.http;

import com.limegroup.gnutella.util.Sockets;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpClientManager {
    private static final Log LOG = LogFactory.getLog((Class)(class$com$limegroup$gnutella$http$HttpClientManager == null ? (class$com$limegroup$gnutella$http$HttpClientManager = HttpClientManager.class$("com.limegroup.gnutella.http.HttpClientManager")) : class$com$limegroup$gnutella$http$HttpClientManager));
    private static final int CONNECTION_TIMEOUT = 5000;
    private static final int TIMEOUT = 8000;
    private static final int MAXIMUM_REDIRECTS = 10;
    private static final long IDLE_TIME = 30000L;
    private static final HttpConnectionManager MANAGER = new MultiThreadedHttpConnectionManager();
    static /* synthetic */ Class class$com$limegroup$gnutella$http$HttpClientManager;

    public static HttpClient getNewClient() {
        return HttpClientManager.getNewClient(5000, 8000);
    }

    public static HttpClient getNewClient(int n, int n2) {
        HttpClient httpClient = new HttpClient(MANAGER);
        httpClient.setConnectionTimeout(n);
        httpClient.setTimeout(n2);
        return httpClient;
    }

    public static void executeMethodRedirecting(HttpClient httpClient, HttpMethod httpMethod) throws IOException, HttpException {
        HttpClientManager.executeMethodRedirecting(httpClient, httpMethod, 10);
    }

    public static void executeMethodRedirecting(HttpClient httpClient, HttpMethod httpMethod, int n) throws IOException, HttpException {
        block3: for (int i = 0; i < n; ++i) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Attempting connection (" + i + ") to " + httpMethod.getURI().getEscapedURI()));
            }
            httpClient.executeMethod(httpMethod);
            switch (httpMethod.getStatusCode()) {
                case 301: 
                case 302: 
                case 303: 
                case 307: {
                    if (!httpMethod.getFollowRedirects()) {
                        if (LOG.isInfoEnabled()) {
                            LOG.warn((Object)"Redirect requested but not supported");
                        }
                        throw new HttpException("Redirect requested");
                    }
                    Header header = httpMethod.getResponseHeader("location");
                    if (header == null) {
                        if (LOG.isInfoEnabled()) {
                            LOG.warn((Object)"Redirect requested, no location header");
                        }
                        throw new HttpException("Redirected without a location");
                    }
                    String string = header.getValue();
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)("Redirected requested to: " + string));
                    }
                    URI uRI = new URI(string.toCharArray());
                    Header[] headerArray = httpMethod.getRequestHeaders();
                    httpMethod.recycle();
                    HostConfiguration hostConfiguration = httpMethod.getHostConfiguration();
                    hostConfiguration.setHost(uRI.getHost(), uRI.getPort(), uRI.getScheme());
                    httpMethod.setFollowRedirects(true);
                    for (int j = 0; j < headerArray.length; ++j) {
                        if (headerArray[j].getName().equals("Host")) continue;
                        httpMethod.addRequestHeader(headerArray[j]);
                    }
                    httpMethod.setPath(uRI.getEscapedPath());
                    httpMethod.setQueryString(uRI.getEscapedQuery());
                    httpMethod.removeRequestHeader("Authorization");
                    continue block3;
                }
                default: {
                    return;
                }
            }
        }
        throw new HttpException("Maximum redirects encountered, bailing");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        ((MultiThreadedHttpConnectionManager)MANAGER).setIdleConnectionTime(30000L);
        Protocol protocol = new Protocol("http", (ProtocolSocketFactory)new LimeSocketFactory(), 80);
        Protocol.registerProtocol((String)"http", (Protocol)protocol);
    }

    private static class LimeSocketFactory
    implements ProtocolSocketFactory {
        private LimeSocketFactory() {
        }

        public Socket createSocket(String string, int n, InetAddress inetAddress, int n2) throws IOException, UnknownHostException {
            return Sockets.connect(string, n, 0);
        }

        public Socket createSocket(String string, int n) throws IOException, UnknownHostException {
            return Sockets.connect(string, n, 0);
        }

        public Socket createSocket(String string, int n, int n2) throws IOException, UnknownHostException {
            return Sockets.connect(string, n, n2);
        }
    }
}

