/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.io;

import com.limegroup.gnutella.io.ChannelWriter;
import com.limegroup.gnutella.io.InterestWriteChannel;
import com.limegroup.gnutella.io.WriteObserver;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DelayedBufferWriter
implements ChannelWriter,
InterestWriteChannel {
    private static final Log LOG = LogFactory.getLog((Class)(class$com$limegroup$gnutella$io$DelayedBufferWriter == null ? (class$com$limegroup$gnutella$io$DelayedBufferWriter = DelayedBufferWriter.class$("com.limegroup.gnutella.io.DelayedBufferWriter")) : class$com$limegroup$gnutella$io$DelayedBufferWriter));
    private static final int MAX_TIME = 200;
    private volatile InterestWriteChannel sink;
    private volatile WriteObserver observer;
    private final ByteBuffer buf;
    private long lastFlushTime;
    static /* synthetic */ Class class$com$limegroup$gnutella$io$DelayedBufferWriter;

    public DelayedBufferWriter(int n) {
        this.buf = ByteBuffer.allocate(n);
    }

    public synchronized void interest(WriteObserver writeObserver, boolean bl) {
        this.observer = bl ? writeObserver : null;
        InterestWriteChannel interestWriteChannel = this.sink;
        if (interestWriteChannel != null) {
            interestWriteChannel.interest(this, true);
        }
    }

    public void close() throws IOException {
        InterestWriteChannel interestWriteChannel = this.sink;
        if (interestWriteChannel != null) {
            interestWriteChannel.close();
        }
    }

    public boolean isOpen() {
        InterestWriteChannel interestWriteChannel = this.sink;
        return interestWriteChannel != null ? interestWriteChannel.isOpen() : false;
    }

    public InterestWriteChannel getWriteChannel() {
        return this.sink;
    }

    public void setWriteChannel(InterestWriteChannel interestWriteChannel) {
        this.sink = interestWriteChannel;
        interestWriteChannel.interest(this, true);
    }

    public void handleIOException(IOException iOException) {
        throw new RuntimeException("Unsupported", iOException);
    }

    public void shutdown() {
        WriteObserver writeObserver = this.observer;
        if (writeObserver != null) {
            writeObserver.shutdown();
        }
    }

    public int write(ByteBuffer byteBuffer) throws IOException {
        int n = byteBuffer.position();
        while (byteBuffer.hasRemaining()) {
            if (this.buf.hasRemaining()) {
                int n2;
                int n3 = this.buf.remaining();
                if (n3 >= (n2 = byteBuffer.remaining())) {
                    this.buf.put(byteBuffer);
                    continue;
                }
                int n4 = byteBuffer.limit();
                int n5 = byteBuffer.position();
                byteBuffer.limit(n5 + n3);
                this.buf.put(byteBuffer);
                byteBuffer.limit(n4);
                continue;
            }
            this.flush(System.currentTimeMillis());
            if (this.buf.hasRemaining()) continue;
            break;
        }
        return byteBuffer.position() - n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleWrite() throws IOException {
        WriteObserver writeObserver = this.observer;
        if (writeObserver != null) {
            writeObserver.handleWrite();
        }
        long l = System.currentTimeMillis();
        if (this.lastFlushTime == 0L) {
            this.lastFlushTime = l;
        }
        if (l - this.lastFlushTime > 200L) {
            this.flush(l);
        }
        if (this.buf.position() == 0) {
            DelayedBufferWriter delayedBufferWriter = this;
            synchronized (delayedBufferWriter) {
                writeObserver = this.observer;
                if (writeObserver == null) {
                    this.sink.interest(this, false);
                }
            }
            return false;
        }
        return true;
    }

    private void flush(long l) throws IOException {
        this.buf.flip();
        InterestWriteChannel interestWriteChannel = this.sink;
        interestWriteChannel.write(this.buf);
        if (this.buf.position() > 0) {
            this.lastFlushTime = l;
            if (this.buf.hasRemaining()) {
                this.buf.compact();
            } else {
                this.buf.clear();
            }
        } else {
            this.buf.position(this.buf.limit()).limit(this.buf.capacity());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

