/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.io;

import com.limegroup.gnutella.io.NIODispatcher;
import com.limegroup.gnutella.io.Throttle;
import com.limegroup.gnutella.io.ThrottleListener;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NBThrottle
implements Throttle {
    private static final Log LOG = LogFactory.getLog((Class)(class$com$limegroup$gnutella$io$NBThrottle == null ? (class$com$limegroup$gnutella$io$NBThrottle = NBThrottle.class$("com.limegroup.gnutella.io.NBThrottle")) : class$com$limegroup$gnutella$io$NBThrottle));
    private static final int MAXIMUM_TO_GIVE = 1400;
    private static final int MINIMUM_TO_GIVE = 30;
    private static final int DEFAULT_TICK_TIME = 100;
    private final int MILLIS_PER_TICK;
    private final boolean _write;
    private final int _processOp;
    private int _bytesPerTick;
    private int _available;
    private long _nextTickTime = -1L;
    private Set _requests = new HashSet();
    private Map _interested = new LinkedHashMap();
    private Map _ready = new HashMap();
    private boolean _active = false;
    static /* synthetic */ Class class$com$limegroup$gnutella$io$NBThrottle;

    public NBThrottle(boolean bl, float f) {
        this(bl, f, true, 100);
    }

    public NBThrottle(boolean bl, float f, int n, int n2) {
        this(bl, f, true, n == 0 ? 100 : n2 / n);
    }

    protected NBThrottle(boolean bl, float f, boolean bl2, int n) {
        this.MILLIS_PER_TICK = Math.min(100, Math.max(50, n));
        int n2 = 1000 / n;
        this._write = bl;
        this._processOp = bl ? 4 : 1;
        this._bytesPerTick = (int)(f / (float)n2);
        if (bl2) {
            NIODispatcher.instance().addThrottle(this);
        }
    }

    void selectableKeys(Collection collection) {
        if (this._available >= 30 && !this._interested.isEmpty()) {
            Object object;
            Object object2;
            Iterator<Object> iterator = collection.iterator();
            while (iterator.hasNext()) {
                object2 = (SelectionKey)iterator.next();
                try {
                    if (!((SelectionKey)object2).isValid() || !(this._write ? ((SelectionKey)object2).isWritable() : ((SelectionKey)object2).isReadable()) || !this._interested.containsKey(object = NIODispatcher.instance().attachment(((SelectionKey)object2).attachment()))) continue;
                    this._ready.put(object, object2);
                }
                catch (CancelledKeyException cancelledKeyException) {
                    iterator.remove();
                }
            }
            this._active = true;
            iterator = this._interested.entrySet().iterator();
            while (!this._ready.isEmpty() && iterator.hasNext()) {
                object2 = (Map.Entry)iterator.next();
                object = (ThrottleListener)object2.getValue();
                Object k = object2.getKey();
                SelectionKey selectionKey = (SelectionKey)this._ready.remove(k);
                if (!object.isOpen()) {
                    iterator.remove();
                    continue;
                }
                if (selectionKey == null) continue;
                NIODispatcher.instance().process(selectionKey, selectionKey.attachment(), this._processOp);
                iterator.remove();
                if (this._available >= 30) continue;
            }
            this._active = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interest(ThrottleListener throttleListener) {
        Set set = this._requests;
        synchronized (set) {
            this._requests.add(throttleListener);
        }
    }

    public int request() {
        if (!this._active) {
            return 0;
        }
        int n = Math.min(this._available, 1400);
        this._available -= n;
        return n;
    }

    public void release(int n) {
        this._available += n;
    }

    void tick(long l) {
        if (l >= this._nextTickTime) {
            float f = 1.0f + (float)(l - this._nextTickTime) / (float)this.MILLIS_PER_TICK;
            f = Math.min(f, 2.0f);
            this._available = (int)((float)this._bytesPerTick * f);
            this._nextTickTime = l + (long)this.MILLIS_PER_TICK;
            this.spreadBandwidth();
        } else if (this._available > 30) {
            this.spreadBandwidth();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void spreadBandwidth() {
        Set set = this._requests;
        synchronized (set) {
            if (!this._requests.isEmpty()) {
                Iterator iterator = this._requests.iterator();
                while (iterator.hasNext()) {
                    ThrottleListener throttleListener = (ThrottleListener)iterator.next();
                    Object object = throttleListener.getAttachment();
                    if (this._interested.containsKey(object) || !throttleListener.bandwidthAvailable()) continue;
                    this._interested.put(object, throttleListener);
                }
                this._requests.clear();
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

