/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.io;

import com.limegroup.gnutella.io.BufferInputStream;
import com.limegroup.gnutella.io.NIODispatcher;
import com.limegroup.gnutella.io.NIOSocket;
import com.limegroup.gnutella.io.ReadObserver;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SocketChannel;
import java.util.Stack;

class NIOInputStream
implements ReadObserver,
ReadableByteChannel {
    static final Stack CACHE = new Stack();
    private final NIOSocket handler;
    private final SocketChannel channel;
    private BufferInputStream source;
    private Object bufferLock;
    private ByteBuffer buffer;
    private boolean shutdown;

    NIOInputStream(NIOSocket nIOSocket, SocketChannel socketChannel) throws IOException {
        this.handler = nIOSocket;
        this.channel = socketChannel;
    }

    synchronized void init() throws IOException {
        if (this.buffer != null) {
            throw new IllegalStateException("already init'd!");
        }
        if (this.shutdown) {
            throw new IOException("Already closed!");
        }
        this.buffer = NIOInputStream.getBuffer();
        this.source = new BufferInputStream(this.buffer, this.handler, this.channel);
        this.bufferLock = this.source.getBufferLock();
        NIODispatcher.instance().interestRead(this.channel, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ByteBuffer getBuffer() {
        Stack stack = CACHE;
        synchronized (stack) {
            if (CACHE.isEmpty()) {
                ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8192);
                CACHE.push(byteBuffer);
            }
            return (ByteBuffer)CACHE.pop();
        }
    }

    public int read(ByteBuffer byteBuffer) {
        if (this.buffer == null) {
            return 0;
        }
        int n = 0;
        if (this.buffer.position() > 0) {
            this.buffer.flip();
            int n2 = this.buffer.remaining();
            int n3 = byteBuffer.remaining();
            if (n3 >= n2) {
                byteBuffer.put(this.buffer);
                n += n2;
            } else {
                int n4 = this.buffer.limit();
                int n5 = this.buffer.position();
                this.buffer.limit(n5 + n3);
                byteBuffer.put(this.buffer);
                n += n3;
                this.buffer.limit(n4);
            }
            this.buffer.compact();
        }
        return n;
    }

    synchronized InputStream getInputStream() throws IOException {
        if (this.buffer == null) {
            this.init();
        }
        return this.source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRead() throws IOException {
        Object object = this.bufferLock;
        synchronized (object) {
            int n = 0;
            while (this.buffer.hasRemaining() && (n = this.channel.read(this.buffer)) > 0) {
            }
            if (n == -1) {
                this.source.finished();
            }
            if (this.buffer.position() > 0 || n == -1) {
                this.bufferLock.notify();
            }
            if (!this.buffer.hasRemaining() || n == -1) {
                NIODispatcher.instance().interestRead(this.channel, false);
            }
        }
    }

    public synchronized void shutdown() {
        if (this.shutdown) {
            return;
        }
        if (this.source != null) {
            this.source.shutdown();
        }
        this.shutdown = true;
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void handleIOException(IOException iOException) {
        throw new RuntimeException("unsupported operation", iOException);
    }

    public void close() throws IOException {
        if (this.buffer != null) {
            this.buffer.clear();
            CACHE.push(this.buffer);
        }
    }

    public boolean isOpen() {
        return true;
    }
}

