/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.io;

import com.limegroup.gnutella.io.BufferOutputStream;
import com.limegroup.gnutella.io.NIODispatcher;
import com.limegroup.gnutella.io.NIOInputStream;
import com.limegroup.gnutella.io.NIOSocket;
import com.limegroup.gnutella.io.WriteObserver;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

class NIOOutputStream
implements WriteObserver {
    private final NIOSocket handler;
    private final SocketChannel channel;
    private BufferOutputStream sink;
    private Object bufferLock;
    private ByteBuffer buffer;
    private boolean shutdown;

    NIOOutputStream(NIOSocket nIOSocket, SocketChannel socketChannel) throws IOException {
        this.handler = nIOSocket;
        this.channel = socketChannel;
    }

    synchronized void init() throws IOException {
        if (this.buffer != null) {
            throw new IllegalStateException("already init'd!");
        }
        if (this.shutdown) {
            throw new IOException("already closed!");
        }
        this.buffer = NIOInputStream.getBuffer();
        this.sink = new BufferOutputStream(this.buffer, this.handler, this.channel);
        this.bufferLock = this.sink.getBufferLock();
    }

    synchronized OutputStream getOutputStream() throws IOException {
        if (this.buffer == null) {
            this.init();
        }
        return this.sink;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleWrite() throws IOException {
        Object object = this.bufferLock;
        synchronized (object) {
            this.buffer.flip();
            while (this.buffer.hasRemaining() && this.channel.write(this.buffer) > 0) {
            }
            if (this.buffer.position() > 0) {
                if (this.buffer.hasRemaining()) {
                    this.buffer.compact();
                } else {
                    this.buffer.clear();
                }
            } else {
                this.buffer.position(this.buffer.limit()).limit(this.buffer.capacity());
            }
            if (this.buffer.hasRemaining()) {
                this.bufferLock.notify();
            }
            if (this.buffer.position() == 0) {
                NIODispatcher.instance().interestWrite(this.channel, false);
                return false;
            }
            return true;
        }
    }

    public synchronized void shutdown() {
        if (this.shutdown) {
            return;
        }
        if (this.sink != null) {
            this.sink.shutdown();
        }
        this.shutdown = true;
        if (this.buffer != null) {
            this.buffer.clear();
            NIOInputStream.CACHE.push(this.buffer);
        }
    }

    public void handleIOException(IOException iOException) {
        throw new RuntimeException("unsupported operation", iOException);
    }
}

