/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.io;

import com.limegroup.gnutella.io.ChannelReadObserver;
import com.limegroup.gnutella.io.ChannelReader;
import com.limegroup.gnutella.io.ChannelWriter;
import com.limegroup.gnutella.io.ConnectObserver;
import com.limegroup.gnutella.io.InterruptedIOException;
import com.limegroup.gnutella.io.NIODispatcher;
import com.limegroup.gnutella.io.NIOInputStream;
import com.limegroup.gnutella.io.NIOMultiplexor;
import com.limegroup.gnutella.io.NIOOutputStream;
import com.limegroup.gnutella.io.ReadObserver;
import com.limegroup.gnutella.io.SocketInterestWriteAdapater;
import com.limegroup.gnutella.io.ThrottleListener;
import com.limegroup.gnutella.io.WriteObserver;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SocketChannel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NIOSocket
extends Socket
implements ConnectObserver,
NIOMultiplexor {
    private static final Log LOG = LogFactory.getLog((Class)(class$com$limegroup$gnutella$io$NIOSocket == null ? (class$com$limegroup$gnutella$io$NIOSocket = NIOSocket.class$("com.limegroup.gnutella.io.NIOSocket")) : class$com$limegroup$gnutella$io$NIOSocket));
    private final SocketChannel channel;
    private final Socket socket;
    private WriteObserver writer;
    private ReadObserver reader;
    private IOException storedException = null;
    private InetAddress connectedTo;
    private boolean shuttingDown;
    private final Object LOCK = new Object();
    static /* synthetic */ Class class$com$limegroup$gnutella$io$NIOSocket;

    NIOSocket(Socket socket) throws IOException {
        this.channel = socket.getChannel();
        this.socket = socket;
        this.writer = new NIOOutputStream(this, this.channel);
        this.reader = new NIOInputStream(this, this.channel);
        ((NIOOutputStream)this.writer).init();
        ((NIOInputStream)this.reader).init();
        NIODispatcher.instance().registerReadWrite(this.channel, this);
        this.connectedTo = socket.getInetAddress();
    }

    public NIOSocket() throws IOException {
        this.channel = SocketChannel.open();
        this.socket = this.channel.socket();
        this.init();
        this.writer = new NIOOutputStream(this, this.channel);
        this.reader = new NIOInputStream(this, this.channel);
    }

    public NIOSocket(InetAddress inetAddress, int n) throws IOException {
        this.channel = SocketChannel.open();
        this.socket = this.channel.socket();
        this.init();
        this.writer = new NIOOutputStream(this, this.channel);
        this.reader = new NIOInputStream(this, this.channel);
        this.connect(new InetSocketAddress(inetAddress, n));
    }

    public NIOSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
        this.channel = SocketChannel.open();
        this.socket = this.channel.socket();
        this.init();
        this.writer = new NIOOutputStream(this, this.channel);
        this.reader = new NIOInputStream(this, this.channel);
        this.bind(new InetSocketAddress(inetAddress2, n2));
        this.connect(new InetSocketAddress(inetAddress, n));
    }

    public NIOSocket(String string, int n) throws UnknownHostException, IOException {
        this(InetAddress.getByName(string), n);
    }

    public NIOSocket(String string, int n, InetAddress inetAddress, int n2) throws IOException {
        this(InetAddress.getByName(string), n, inetAddress, n2);
    }

    private void init() throws IOException {
        this.channel.configureBlocking(false);
    }

    public void setReadObserver(final ChannelReadObserver channelReadObserver) {
        NIODispatcher.instance().invokeLater(new Runnable(){

            public void run() {
                ReadObserver readObserver = NIOSocket.this.reader;
                try {
                    NIOSocket.this.reader = channelReadObserver;
                    ChannelReader channelReader = channelReadObserver;
                    while (channelReader.getReadChannel() instanceof ChannelReader) {
                        channelReader = (ChannelReader)((Object)channelReader.getReadChannel());
                    }
                    if (readObserver instanceof ReadableByteChannel && readObserver != channelReadObserver) {
                        channelReader.setReadChannel((ReadableByteChannel)((Object)readObserver));
                        NIOSocket.this.reader.handleRead();
                        readObserver.shutdown();
                    }
                    channelReader.setReadChannel(NIOSocket.this.channel);
                    NIODispatcher.instance().interestRead(NIOSocket.this.channel, true);
                }
                catch (IOException iOException) {
                    NIOSocket.this.shutdown();
                    readObserver.shutdown();
                }
            }
        });
    }

    public void setWriteObserver(final ChannelWriter channelWriter) {
        NIODispatcher.instance().invokeLater(new Runnable(){

            public void run() {
                try {
                    if (NIOSocket.this.writer.handleWrite()) {
                        throw new IllegalStateException("data still in old writer!");
                    }
                    NIOSocket.this.writer.shutdown();
                    ChannelWriter channelWriter2 = channelWriter;
                    while (channelWriter2.getWriteChannel() instanceof ChannelWriter) {
                        if (!((channelWriter2 = (ChannelWriter)((Object)channelWriter2.getWriteChannel())) instanceof ThrottleListener)) continue;
                        ((ThrottleListener)((Object)channelWriter2)).setAttachment(NIOSocket.this);
                    }
                    SocketInterestWriteAdapater socketInterestWriteAdapater = new SocketInterestWriteAdapater(NIOSocket.this.channel);
                    NIOSocket.this.writer = socketInterestWriteAdapater;
                    channelWriter2.setWriteChannel(socketInterestWriteAdapater);
                }
                catch (IOException iOException) {
                    NIOSocket.this.shutdown();
                    channelWriter.shutdown();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleConnect() throws IOException {
        Object object = this.LOCK;
        synchronized (object) {
            this.LOCK.notify();
        }
    }

    public void handleRead() throws IOException {
        this.reader.handleRead();
    }

    public boolean handleWrite() throws IOException {
        return this.writer.handleWrite();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleIOException(IOException iOException) {
        Object object = this.LOCK;
        synchronized (object) {
            this.storedException = iOException;
            this.LOCK.notify();
        }
        this.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.shuttingDown) {
                return;
            }
            this.shuttingDown = true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Shutting down socket & streams for: " + this));
        }
        try {
            this.shutdownInput();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.shutdownOutput();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.reader.shutdown();
        this.writer.shutdown();
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
        }
        catch (Error error) {
            // empty catch block
        }
        try {
            this.channel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        object = this.LOCK;
        synchronized (object) {
            this.LOCK.notify();
        }
    }

    public void bind(SocketAddress socketAddress) throws IOException {
        this.socket.bind(socketAddress);
    }

    public void close() throws IOException {
        NIODispatcher.instance().shutdown(this);
    }

    public void connect(SocketAddress socketAddress) throws IOException {
        this.connect(socketAddress, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(SocketAddress socketAddress, int n) throws IOException {
        this.connectedTo = ((InetSocketAddress)socketAddress).getAddress();
        InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
        if (inetSocketAddress.isUnresolved()) {
            throw new IOException("unresolved: " + socketAddress);
        }
        Object object = this.LOCK;
        synchronized (object) {
            if (!this.channel.connect(socketAddress)) {
                NIODispatcher.instance().registerConnect(this.channel, this);
                try {
                    this.LOCK.wait(n);
                }
                catch (InterruptedException interruptedException) {
                    throw new InterruptedIOException(interruptedException);
                }
                IOException iOException = this.storedException;
                this.storedException = null;
                if (iOException != null) {
                    this.shutdown();
                    throw iOException;
                }
                if (!this.isConnected()) {
                    this.shutdown();
                    throw new SocketTimeoutException("couldn't connect in " + n + " milliseconds");
                }
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Connected to: " + socketAddress));
        }
        if (this.writer instanceof NIOOutputStream) {
            ((NIOOutputStream)this.writer).init();
        }
        if (this.reader instanceof NIOInputStream) {
            ((NIOInputStream)this.reader).init();
        }
    }

    public InetAddress getInetAddress() {
        return this.connectedTo;
    }

    public InputStream getInputStream() throws IOException {
        if (this.isClosed()) {
            throw new IOException("Socket closed.");
        }
        if (this.reader instanceof NIOInputStream) {
            return ((NIOInputStream)this.reader).getInputStream();
        }
        throw new IllegalStateException("reader not NIOInputStream!");
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.isClosed()) {
            throw new IOException("Socket closed.");
        }
        if (this.writer instanceof NIOOutputStream) {
            return ((NIOOutputStream)this.writer).getOutputStream();
        }
        throw new IllegalStateException("writer not NIOOutputStream!");
    }

    public SocketChannel getChannel() {
        return this.socket.getChannel();
    }

    public int getLocalPort() {
        return this.socket.getLocalPort();
    }

    public SocketAddress getLocalSocketAddress() {
        return this.socket.getLocalSocketAddress();
    }

    public InetAddress getLocalAddress() {
        try {
            return this.socket.getLocalAddress();
        }
        catch (Error error) {
            try {
                return InetAddress.getLocalHost();
            }
            catch (UnknownHostException unknownHostException) {
                return null;
            }
        }
    }

    public boolean getOOBInline() throws SocketException {
        return this.socket.getOOBInline();
    }

    public int getPort() {
        return this.socket.getPort();
    }

    public int getReceiveBufferSize() throws SocketException {
        return this.socket.getReceiveBufferSize();
    }

    public boolean getReuseAddress() throws SocketException {
        return this.socket.getReuseAddress();
    }

    public int getSendBufferSize() throws SocketException {
        return this.socket.getSendBufferSize();
    }

    public int getSoLinger() throws SocketException {
        return this.socket.getSoLinger();
    }

    public int getSoTimeout() throws SocketException {
        return this.socket.getSoTimeout();
    }

    public boolean getTcpNoDelay() throws SocketException {
        return this.socket.getTcpNoDelay();
    }

    public int getTrafficClass() throws SocketException {
        return this.socket.getTrafficClass();
    }

    public boolean isBound() {
        return this.socket.isBound();
    }

    public boolean isClosed() {
        return this.socket.isClosed();
    }

    public boolean isConnected() {
        return this.socket.isConnected();
    }

    public boolean isInputShutdown() {
        return this.socket.isInputShutdown();
    }

    public boolean isOutputShutdown() {
        return this.socket.isOutputShutdown();
    }

    public void sendUrgentData(int n) {
        throw new UnsupportedOperationException("No urgent data.");
    }

    public void setKeepAlive(boolean bl) throws SocketException {
        this.socket.setKeepAlive(bl);
    }

    public void setOOBInline(boolean bl) throws SocketException {
        this.socket.setOOBInline(bl);
    }

    public void setReceiveBufferSize(int n) throws SocketException {
        this.socket.setReceiveBufferSize(n);
    }

    public void setReuseAddress(boolean bl) throws SocketException {
        this.socket.setReuseAddress(bl);
    }

    public void setSendBufferSize(int n) throws SocketException {
        this.socket.setSendBufferSize(n);
    }

    public void setSoLinger(boolean bl, int n) throws SocketException {
        this.socket.setSoLinger(bl, n);
    }

    public void setSoTimeout(int n) throws SocketException {
        this.socket.setSoTimeout(n);
    }

    public void setTcpNoDelay(boolean bl) throws SocketException {
        this.socket.setTcpNoDelay(bl);
    }

    public void setTrafficClass(int n) throws SocketException {
        this.socket.setTrafficClass(n);
    }

    public void shutdownInput() throws IOException {
        this.socket.shutdownInput();
    }

    public void shutdownOutput() throws IOException {
        this.socket.shutdownOutput();
    }

    public String toString() {
        return "NIOSocket::" + this.channel.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

