/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.io;

import com.limegroup.gnutella.io.ChannelWriter;
import com.limegroup.gnutella.io.InterestWriteChannel;
import com.limegroup.gnutella.io.Throttle;
import com.limegroup.gnutella.io.ThrottleListener;
import com.limegroup.gnutella.io.WriteObserver;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ThrottleWriter
implements ChannelWriter,
InterestWriteChannel,
ThrottleListener {
    private static final Log LOG = LogFactory.getLog((Class)(class$com$limegroup$gnutella$io$ThrottleWriter == null ? (class$com$limegroup$gnutella$io$ThrottleWriter = ThrottleWriter.class$("com.limegroup.gnutella.io.ThrottleWriter")) : class$com$limegroup$gnutella$io$ThrottleWriter));
    private volatile InterestWriteChannel channel;
    private volatile WriteObserver observer;
    private final Throttle throttle;
    private int available;
    private Object attachment;
    static /* synthetic */ Class class$com$limegroup$gnutella$io$ThrottleWriter;

    public ThrottleWriter(Throttle throttle) {
        this(throttle, null);
    }

    public ThrottleWriter(Throttle throttle, InterestWriteChannel interestWriteChannel) {
        this.throttle = throttle;
        this.channel = interestWriteChannel;
    }

    public InterestWriteChannel getWriteChannel() {
        return this.channel;
    }

    public void setWriteChannel(InterestWriteChannel interestWriteChannel) {
        this.channel = interestWriteChannel;
        this.throttle.interest(this);
    }

    public void setAttachment(Object object) {
        this.attachment = object;
    }

    public Object getAttachment() {
        return this.attachment;
    }

    public void interest(WriteObserver writeObserver, boolean bl) {
        if (bl) {
            this.observer = writeObserver;
            if (this.channel != null) {
                this.throttle.interest(this);
            }
        } else {
            this.observer = null;
        }
    }

    public boolean bandwidthAvailable() {
        if (this.channel.isOpen()) {
            this.channel.interest(this, true);
            return true;
        }
        return false;
    }

    public int write(ByteBuffer byteBuffer) throws IOException {
        InterestWriteChannel interestWriteChannel = this.channel;
        if (interestWriteChannel == null) {
            throw new IllegalStateException("writing with no chain!");
        }
        if (this.available == 0) {
            return 0;
        }
        int n = byteBuffer.limit();
        if (byteBuffer.remaining() > this.available) {
            byteBuffer.limit(byteBuffer.position() + this.available);
        }
        int n2 = this.channel.write(byteBuffer);
        this.available -= n2;
        byteBuffer.limit(n);
        return n2;
    }

    public void close() throws IOException {
        InterestWriteChannel interestWriteChannel = this.channel;
        if (interestWriteChannel != null) {
            interestWriteChannel.close();
        }
    }

    public boolean isOpen() {
        InterestWriteChannel interestWriteChannel = this.channel;
        return interestWriteChannel != null ? interestWriteChannel.isOpen() : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleWrite() throws IOException {
        InterestWriteChannel interestWriteChannel = this.channel;
        if (interestWriteChannel == null) {
            throw new IllegalStateException("writing with no source.");
        }
        WriteObserver writeObserver = this.observer;
        this.available = this.throttle.request();
        if (this.available != 0) {
            try {
                interestWriteChannel.interest(this, false);
                if (writeObserver != null) {
                    writeObserver.handleWrite();
                }
            }
            finally {
                this.throttle.release(this.available);
            }
            writeObserver = this.observer;
            if (writeObserver != null) {
                this.throttle.interest(this);
                return true;
            }
            return false;
        }
        return true;
    }

    public void shutdown() {
        WriteObserver writeObserver = this.observer;
        if (writeObserver != null) {
            writeObserver.shutdown();
        }
    }

    public void handleIOException(IOException iOException) {
        throw new RuntimeException("Unsupported", iOException);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

