/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.library;

import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.IOUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class Container {
    private static final Log LOG = LogFactory.getLog((Class)(class$com$limegroup$gnutella$library$Container == null ? (class$com$limegroup$gnutella$library$Container = Container.class$("com.limegroup.gnutella.library.Container")) : class$com$limegroup$gnutella$library$Container));
    private final Map STORED = new HashMap();
    private final String filename;
    static /* synthetic */ Class class$com$limegroup$gnutella$library$Container;

    Container(String string) {
        this.filename = string;
        this.load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void load() {
        Map map = this.readFromDisk();
        Container container = this;
        synchronized (container) {
            if (this.STORED.isEmpty()) {
                this.STORED.putAll(map);
            } else {
                Iterator iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    Object k = entry.getKey();
                    Object v = entry.getValue();
                    Object v2 = this.STORED.get(k);
                    if (v2 == null) {
                        this.STORED.put(k, v);
                        continue;
                    }
                    Object v3 = v2;
                    synchronized (v3) {
                        Object object;
                        if (v instanceof Collection && v2 instanceof Collection) {
                            object = (Collection)v2;
                            object.clear();
                            object.addAll((Collection)v);
                        } else if (v instanceof Map && v2 instanceof Map) {
                            object = (Map)v2;
                            object.clear();
                            object.putAll((Map)v);
                        } else if (LOG.isWarnEnabled()) {
                            LOG.warn((Object)("Unable to reload data, key: " + k));
                        }
                    }
                }
            }
        }
    }

    synchronized Set getSet(String string) {
        Object v = this.STORED.get(string);
        if (v != null) {
            return (Set)v;
        }
        Set set = Collections.synchronizedSet(new HashSet());
        this.STORED.put(string, set);
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void clear() {
        Iterator iterator = this.STORED.entrySet().iterator();
        while (iterator.hasNext()) {
            Object v;
            Map.Entry entry = iterator.next();
            Object v2 = v = entry.getValue();
            synchronized (v2) {
                if (v instanceof Collection) {
                    ((Collection)v).clear();
                } else if (v instanceof Map) {
                    ((Map)v).clear();
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Unable to clear data, key: " + entry.getKey()));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void save() {
        HashMap hashMap;
        Container container = this;
        synchronized (container) {
            hashMap = new HashMap(this.STORED.size());
            Iterator iterator = this.STORED.entrySet().iterator();
            while (iterator.hasNext()) {
                Object v;
                Map.Entry entry = iterator.next();
                Object k = entry.getKey();
                Object v2 = v = entry.getValue();
                synchronized (v2) {
                    if (v instanceof SortedSet) {
                        hashMap.put(k, new TreeSet((SortedSet)v));
                    } else if (v instanceof Set) {
                        hashMap.put(k, new HashSet((Set)v));
                    } else if (v instanceof Map) {
                        hashMap.put(k, new HashMap((Map)v));
                    } else if (v instanceof List) {
                        if (v instanceof RandomAccess) {
                            hashMap.put(k, new ArrayList((List)v));
                        } else {
                            hashMap.put(k, new LinkedList((List)v));
                        }
                    } else {
                        if (LOG.isWarnEnabled()) {
                            LOG.warn((Object)("Update to clone! key: " + k));
                        }
                        hashMap.put(k, v);
                    }
                }
            }
        }
        this.writeToDisk(hashMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToDisk(Object object) {
        File file = new File(CommonUtils.getUserSettingsDir(), this.filename);
        ObjectOutputStream objectOutputStream = null;
        try {
            objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
            IOUtils.close(objectOutputStream);
        }
        catch (IOException iOException) {
            LOG.warn((Object)"Can't write to disk!", (Throwable)iOException);
        }
        finally {
            IOUtils.close(objectOutputStream);
        }
    }

    /*
     * Exception decompiling
     */
    private Map readFromDisk() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

