/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.licenses;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.licenses.AbstractLicense;
import com.limegroup.gnutella.licenses.CCConstants;
import com.limegroup.gnutella.licenses.License;
import com.limegroup.gnutella.licenses.LicenseCache;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class CCLicense
extends AbstractLicense {
    private static final Log LOG = LogFactory.getLog((Class)(class$com$limegroup$gnutella$licenses$CCLicense == null ? (class$com$limegroup$gnutella$licenses$CCLicense = CCLicense.class$("com.limegroup.gnutella.licenses.CCLicense")) : class$com$limegroup$gnutella$licenses$CCLicense));
    private static final long serialVersionUID = 8213994964631107858L;
    private transient String license;
    private Map allWorks;
    static /* synthetic */ Class class$com$limegroup$gnutella$licenses$CCLicense;

    CCLicense(String string, URI uRI) {
        super(uRI);
        this.license = string;
    }

    public String getLicense() {
        return this.license;
    }

    public URL getLicenseDeed(URN uRN) {
        Details details = this.getDetails(uRN);
        if (details == null || details.licenseURL == null) {
            return this.guessLicenseDeed();
        }
        return details.licenseURL;
    }

    private URL guessLicenseDeed() {
        return CCConstants.guessLicenseDeed(this.license);
    }

    public boolean isValid(URN uRN) {
        return this.getDetails(uRN) != null;
    }

    public License copy(String string, URI uRI) {
        CCLicense cCLicense = null;
        try {
            cCLicense = (CCLicense)this.clone();
            cCLicense.license = string;
            cCLicense.licenseLocation = uRI;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            ErrorService.error(cloneNotSupportedException);
        }
        return cCLicense;
    }

    public String getLicenseDescription(URN uRN) {
        Iterator iterator;
        List list = Collections.EMPTY_LIST;
        List list2 = Collections.EMPTY_LIST;
        List list3 = Collections.EMPTY_LIST;
        Details details = this.getDetails(uRN);
        if (details != null) {
            list = details.permitted;
            list2 = details.prohibited;
            list3 = details.required;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (list != null && !list.isEmpty()) {
            stringBuffer.append("Permitted: ");
            iterator = list.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(iterator.next().toString());
                if (!iterator.hasNext()) continue;
                stringBuffer.append(", ");
            }
        }
        if (list2 != null && !list2.isEmpty()) {
            if (stringBuffer.length() != 0) {
                stringBuffer.append("\n");
            }
            stringBuffer.append("Prohibited: ");
            iterator = list2.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(iterator.next().toString());
                if (!iterator.hasNext()) continue;
                stringBuffer.append(", ");
            }
        }
        if (list3 != null && !list3.isEmpty()) {
            if (stringBuffer.length() != 0) {
                stringBuffer.append("\n");
            }
            stringBuffer.append("Required: ");
            iterator = list3.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(iterator.next().toString());
                if (!iterator.hasNext()) continue;
                stringBuffer.append(", ");
            }
        }
        if (stringBuffer.length() == 0) {
            stringBuffer.append("Permissions unknown.");
        }
        return stringBuffer.toString();
    }

    protected void clear() {
        if (this.allWorks != null) {
            this.allWorks.clear();
        }
    }

    protected String getBody(String string) {
        return this.locateRDF(super.getBody(string));
    }

    private void addWork(URN uRN, String string) {
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            LOG.warn((Object)("Unable to make licenseURL out of: " + string), (Throwable)malformedURLException);
        }
        Details details = this.getDetails(uRN);
        if (details != null) {
            URL uRL2;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Found existing details item for URN: " + uRN));
            }
            if (uRL != null && (uRL2 = this.guessLicenseDeed()) != null && uRL2.equals(uRL)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Updating license URL to be: " + uRL));
                }
                details.licenseURL = uRL;
            }
            return;
        }
        details = new Details(uRL);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Adding new " + details + " for urn: " + uRN));
        }
        if (this.allWorks == null) {
            this.allWorks = new HashMap(1);
        }
        this.allWorks.put(uRN, details);
    }

    private Details getDetails(URN uRN) {
        if (this.allWorks == null) {
            return null;
        }
        Details details = (Details)this.allWorks.get(uRN);
        if (details != null) {
            return details;
        }
        if (uRN != null) {
            return (Details)this.allWorks.get(null);
        }
        return (Details)this.allWorks.values().iterator().next();
    }

    private List getDetailsForLicenseURL(URL uRL) {
        if (this.allWorks == null || uRL == null) {
            return Collections.EMPTY_LIST;
        }
        LinkedList<Details> linkedList = new LinkedList<Details>();
        Iterator iterator = this.allWorks.values().iterator();
        while (iterator.hasNext()) {
            Details details = (Details)iterator.next();
            if (details.licenseURL == null || !uRL.equals(details.licenseURL)) continue;
            linkedList.add(details);
        }
        return linkedList;
    }

    private String locateRDF(String string) {
        if (string == null || string.trim().equals("")) {
            return null;
        }
        int n = string.indexOf("<rdf:RDF");
        if (n >= string.length() - 1) {
            return null;
        }
        int n2 = string.indexOf("rdf:RDF", n + 6);
        if (n == -1 || n2 == -1) {
            return null;
        }
        if ((n2 = string.indexOf(62, n2)) == -1) {
            return null;
        }
        return string.substring(n, n2 + 1);
    }

    protected void parseDocumentNode(Node node, boolean bl) {
        Node node2;
        int n;
        NodeList nodeList = node.getChildNodes();
        if (bl) {
            for (n = 0; n < nodeList.getLength(); ++n) {
                node2 = nodeList.item(n);
                if (!node2.getNodeName().equals("Work")) continue;
                this.parseWorkItem(node2);
            }
        }
        for (n = 0; n < nodeList.getLength(); ++n) {
            node2 = nodeList.item(n);
            if (!node2.getNodeName().equals("License")) continue;
            this.parseLicenseItem(node2);
        }
        if (bl) {
            this.updateLicenseDetails();
        }
    }

    protected void parseWorkItem(Node node) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"Parsing work item.");
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem("rdf:about");
        URN uRN = null;
        if (node2 != null) {
            try {
                uRN = URN.createSHA1Urn(node2.getNodeValue());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node3;
            Node node4 = nodeList.item(i);
            if (!node4.getNodeName().equals("license") || (node3 = (namedNodeMap = node4.getAttributes()).getNamedItem("rdf:resource")) == null) continue;
            this.addWork(uRN, node3.getNodeValue());
        }
    }

    protected void parseLicenseItem(Node node) {
        Object object;
        Object object2;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"Parsing license item.");
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem("rdf:about");
        List list = Collections.EMPTY_LIST;
        if (node2 != null) {
            object2 = node2.getNodeValue();
            try {
                list = this.getDetailsForLicenseURL(new URL((String)object2));
            }
            catch (MalformedURLException malformedURLException) {
                LOG.warn((Object)("Unable to create license URL for: " + (String)object2), (Throwable)malformedURLException);
            }
        }
        if (!list.iterator().hasNext()) {
            return;
        }
        object2 = null;
        LinkedList linkedList = null;
        LinkedList linkedList2 = null;
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            object = nodeList.item(i);
            String string = object.getNodeName();
            if (string.equalsIgnoreCase("requires")) {
                if (object2 == null) {
                    object2 = new LinkedList();
                }
                this.addPermission((List)object2, (Node)object);
                continue;
            }
            if (string.equalsIgnoreCase("permits")) {
                if (linkedList2 == null) {
                    linkedList2 = new LinkedList();
                }
                this.addPermission(linkedList2, (Node)object);
                continue;
            }
            if (!string.equalsIgnoreCase("prohibits")) continue;
            if (linkedList == null) {
                linkedList = new LinkedList();
            }
            this.addPermission(linkedList, (Node)object);
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object = (Details)iterator.next();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Setting license details for " + list));
            }
            ((Details)object).required = object2;
            ((Details)object).prohibited = linkedList;
            ((Details)object).permitted = linkedList2;
        }
    }

    private void addPermission(List list, Node node) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem("rdf:resource");
        if (node2 != null) {
            String string = node2.getNodeValue();
            int n = string.lastIndexOf(47);
            if (n != -1 && n != string.length() - 1) {
                String string2 = string.substring(n + 1);
                if (!list.contains(string2)) {
                    list.add(string2);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Added permission: " + string2));
                    }
                } else if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)("Duplicate permission: " + string2 + "!"));
                }
            } else if (LOG.isWarnEnabled()) {
                LOG.trace((Object)("Unable to find permission name: " + string));
            }
        } else if (LOG.isWarnEnabled()) {
            LOG.warn((Object)"No resource item for permission.");
        }
    }

    private void updateLicenseDetails() {
        if (this.allWorks == null) {
            return;
        }
        Iterator iterator = this.allWorks.values().iterator();
        while (iterator.hasNext()) {
            Details details = (Details)iterator.next();
            if (details.isDescriptionAvailable() || details.licenseURL == null) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Updating licenseURL for :" + details));
            }
            String string = details.licenseURL.toExternalForm();
            Object object = LicenseCache.instance().getData(string);
            String string2 = null;
            if (object != null && object instanceof String) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Using cached data for url: " + string));
                }
                string2 = this.locateRDF((String)object);
            } else {
                string2 = this.getBody(string);
                if (string2 != null) {
                    LicenseCache.instance().addData(string, string2);
                } else {
                    LOG.debug((Object)("Couldn't retrieve license details from url: " + string));
                }
            }
            if (string2 == null) continue;
            this.parseXML(string2, false);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class Details
    implements Serializable {
        private static final long serialVersionUID = -1719502030054241350L;
        URL licenseURL;
        List required;
        List permitted;
        List prohibited;

        Details() {
        }

        Details(URL uRL) {
            this.licenseURL = uRL;
        }

        boolean isDescriptionAvailable() {
            return this.required != null || this.permitted != null || this.prohibited != null;
        }

        public String toString() {
            return "details:: license: " + this.licenseURL;
        }
    }
}

