/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.licenses;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.licenses.License;
import com.limegroup.gnutella.util.CommonUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.httpclient.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class LicenseCache {
    private static final Log LOG = LogFactory.getLog((Class)(class$com$limegroup$gnutella$licenses$LicenseCache == null ? (class$com$limegroup$gnutella$licenses$LicenseCache = LicenseCache.class$("com.limegroup.gnutella.licenses.LicenseCache")) : class$com$limegroup$gnutella$licenses$LicenseCache));
    private static final long EXPIRY_TIME = 604800000L;
    private final File CACHE_FILE = new File(CommonUtils.getUserSettingsDir(), "licenses.cache");
    private Map licenses;
    private Map data;
    private boolean dirty = false;
    private static final LicenseCache INSTANCE = new LicenseCache();
    static /* synthetic */ Class class$com$limegroup$gnutella$licenses$LicenseCache;

    private LicenseCache() {
        this.deserialize();
    }

    public static LicenseCache instance() {
        return INSTANCE;
    }

    synchronized void addVerifiedLicense(License license) {
        this.licenses.put(license.getLicenseURI(), license);
        this.dirty = true;
    }

    synchronized void addData(Object object, Object object2) {
        this.data.put(object, object2);
        this.dirty = true;
    }

    synchronized License getLicense(String string, URI uRI) {
        License license = (License)this.licenses.get(uRI);
        if (license != null) {
            return license.copy(string, uRI);
        }
        return null;
    }

    synchronized Object getData(Object object) {
        return this.data.get(object);
    }

    synchronized boolean isVerifiedAndValid(URN uRN, URI uRI) {
        License license = (License)this.licenses.get(uRI);
        return license != null && license.isValid(uRN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void deserialize() {
        block22: {
            ObjectInputStream objectInputStream;
            block20: {
                objectInputStream = null;
                objectInputStream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(this.CACHE_FILE)));
                HashMap hashMap = (HashMap)objectInputStream.readObject();
                if (hashMap != null) {
                    Iterator iterator = hashMap.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        Object k = entry.getKey();
                        Object v = entry.getValue();
                        if (k instanceof URI && v instanceof License) continue;
                        if (LOG.isWarnEnabled()) {
                            LOG.warn((Object)("Invalid k[" + k + "], v[" + v + "]"));
                        }
                        iterator.remove();
                    }
                } else {
                    hashMap = new HashMap();
                }
                this.licenses = hashMap;
                this.data = (Map)objectInputStream.readObject();
                this.removeOldEntries();
                Object var8_8 = null;
                if (objectInputStream == null) break block20;
                try {
                    objectInputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.licenses == null) {
                this.licenses = new HashMap();
            }
            if (this.data == null) {
                this.data = new HashMap();
            }
            break block22;
            {
                catch (Throwable throwable) {
                    LOG.error((Object)"Can't read licenses", throwable);
                    Object var8_9 = null;
                    if (objectInputStream != null) {
                        try {
                            objectInputStream.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (this.licenses == null) {
                        this.licenses = new HashMap();
                    }
                    if (this.data == null) {
                        this.data = new HashMap();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                if (objectInputStream != null) {
                    try {
                        objectInputStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (this.licenses == null) {
                    this.licenses = new HashMap();
                }
                if (this.data == null) {
                    this.data = new HashMap();
                }
                throw throwable;
            }
        }
    }

    private void removeOldEntries() {
        long l = System.currentTimeMillis() - 604800000L;
        Iterator iterator = this.licenses.values().iterator();
        while (iterator.hasNext()) {
            License license = (License)iterator.next();
            if (license.getLastVerifiedTime() >= l) continue;
            this.dirty = true;
            iterator.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public synchronized void persistCache() {
        block12: {
            if (!this.dirty) {
                return;
            }
            var1_1 = null;
            try {
                var1_1 = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(this.CACHE_FILE)));
                var1_1.writeObject(this.licenses);
                var1_1.writeObject(this.data);
                var1_1.flush();
                var4_2 = null;
                ** if (var1_1 == null) goto lbl-1000
            }
            catch (Throwable var3_9) {
                var4_4 = null;
                if (var1_1 != null) {
                    try {
                        var1_1.close();
                    }
                    catch (IOException var5_7) {
                        // empty catch block
                    }
                }
                throw var3_9;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    var1_1.close();
                }
                catch (IOException var5_5) {}
            }
lbl-1000:
            // 2 sources

            {
                break block12;
                catch (IOException var2_8) {
                    ErrorService.error(var2_8);
                    var4_3 = null;
                    if (var1_1 != null) {
                        try {
                            var1_1.close();
                        }
                        catch (IOException var5_6) {}
                    }
                }
            }
        }
        this.dirty = false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

