/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.licenses;

import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.licenses.BadCCLicense;
import com.limegroup.gnutella.licenses.CCLicense;
import com.limegroup.gnutella.licenses.License;
import com.limegroup.gnutella.licenses.LicenseCache;
import com.limegroup.gnutella.licenses.NamedLicense;
import com.limegroup.gnutella.licenses.UnknownLicense;
import com.limegroup.gnutella.licenses.WeedLicense;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class LicenseFactory {
    private static final Log LOG = LogFactory.getLog((Class)(class$com$limegroup$gnutella$licenses$LicenseFactory == null ? (class$com$limegroup$gnutella$licenses$LicenseFactory = LicenseFactory.class$("com.limegroup.gnutella.licenses.LicenseFactory")) : class$com$limegroup$gnutella$licenses$LicenseFactory));
    public static final String WEED_NAME = "Weed License";
    public static final String CC_NAME = "Creative Commons License";
    public static final String UNKNOWN_NAME = "Unknown License";
    static /* synthetic */ Class class$com$limegroup$gnutella$licenses$LicenseFactory;

    private LicenseFactory() {
    }

    public static boolean isVerifiedAndValid(URN uRN, String string) {
        URI uRI = LicenseFactory.getLicenseURI(string);
        return uRI != null && LicenseCache.instance().isVerifiedAndValid(uRN, uRI);
    }

    public static String getLicenseName(String string) {
        if (LicenseFactory.isCCLicense(string)) {
            return CC_NAME;
        }
        if (LicenseFactory.isWeedLicense(string)) {
            return WEED_NAME;
        }
        if (LicenseFactory.isUnknownLicense(string)) {
            return UNKNOWN_NAME;
        }
        return null;
    }

    public static License create(String string) {
        if (string == null) {
            return null;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Attempting to create license from: " + string));
        }
        License license = null;
        URI uRI = LicenseFactory.getLicenseURI(string);
        if (uRI != null) {
            license = LicenseCache.instance().getLicense(string, uRI);
        }
        if (license == null) {
            if (LicenseFactory.isCCLicense(string)) {
                license = uRI != null ? new CCLicense(string, uRI) : new BadCCLicense(string);
            } else if (LicenseFactory.isWeedLicense(string) && uRI != null) {
                license = new WeedLicense(uRI);
            } else if (LicenseFactory.isUnknownLicense(string)) {
                license = new UnknownLicense();
            }
        }
        if (license != null && license instanceof NamedLicense) {
            ((NamedLicense)license).setLicenseName(LicenseFactory.getLicenseName(string));
        }
        return license;
    }

    private static boolean isCCLicense(String string) {
        return string.indexOf("verify at") != -1;
    }

    private static boolean isWeedLicense(String string) {
        return string.startsWith("http://www.shmedlic.com/license/3play.aspx");
    }

    private static boolean isUnknownLicense(String string) {
        return string.startsWith("licensed: ");
    }

    public static void persistCache() {
        LicenseCache.instance().persistCache();
    }

    static URI getLicenseURI(String string) {
        if (string == null) {
            return null;
        }
        URI uRI = LicenseFactory.getCCLicenseURI(string);
        if (uRI == null) {
            uRI = LicenseFactory.getWeedLicenseURI(string);
        }
        return uRI;
    }

    private static URI getCCLicenseURI(String string) {
        int n = string.indexOf("verify at");
        if (n == -1) {
            return null;
        }
        int n2 = n + "verify at".length();
        if (n2 >= string.length()) {
            return null;
        }
        String string2 = string.substring(n2).trim();
        URI uRI = null;
        try {
            uRI = new URI(string2.toCharArray());
            String string3 = uRI.getScheme();
            if (string3 == null || !string3.equalsIgnoreCase("http")) {
                throw new URIException("Invalid scheme: " + string3);
            }
            String string4 = uRI.getAuthority();
            if (string4 == null || string4.equals("") || string4.indexOf(32) != -1) {
                throw new URIException("Invalid authority: " + string4);
            }
        }
        catch (URIException uRIException) {
            uRI = null;
            LOG.error((Object)"Unable to create URI", (Throwable)uRIException);
        }
        return uRI;
    }

    private static URI getWeedLicenseURI(String string) {
        int n = string.indexOf("http://www.shmedlic.com/license/3play.aspx");
        if (n == -1) {
            return null;
        }
        int n2 = string.indexOf(" cid: ");
        int n3 = string.indexOf(" vid: ");
        if (n2 == -1 || n3 == -1) {
            LOG.debug((Object)"No cid or vid, bailing.");
            return null;
        }
        int n4 = string.indexOf(" ", n2 += " cid: ".length());
        int n5 = string.indexOf(" ", n3 += " vid: ".length());
        if (n4 == -1 && n5 == -1) {
            LOG.debug((Object)"No endings for both cid & vid, bailing");
            return null;
        }
        if (n4 == -1) {
            n4 = string.length();
        }
        if (n5 == -1) {
            n5 = string.length();
        }
        String string2 = string.substring(n2, n4).trim();
        String string3 = string.substring(n3, n5).trim();
        if (string2.length() == 0 || string3.length() == 0) {
            LOG.debug((Object)"cid or vid is empty, bailing");
            return null;
        }
        if (string2.startsWith(" vid: ".trim()) || string3.startsWith(" cid: ".trim())) {
            LOG.debug((Object)"cid starts with vid, or vice versa, bailing.");
            return null;
        }
        return WeedLicense.buildURI(string2, string3);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

