/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.messages.BadGGEPBlockException;
import com.limegroup.gnutella.messages.BadGGEPPropertyException;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.GGEP;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.search.HostData;
import com.limegroup.gnutella.statistics.DroppedSentMessageStatHandler;
import com.limegroup.gnutella.statistics.ReceivedErrorStat;
import com.limegroup.gnutella.statistics.SentMessageStatHandler;
import com.limegroup.gnutella.util.DataUtils;
import com.limegroup.gnutella.util.IpPort;
import com.limegroup.gnutella.util.IpPortSet;
import com.limegroup.gnutella.util.NetworkUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class QueryReply
extends Message
implements Serializable {
    public static final int XML_MAX_SIZE = 32768;
    public static final int COMMON_PAYLOAD_LEN = 4;
    private byte[] _payload;
    private volatile boolean _parsed = false;
    private volatile Response[] _responses = null;
    private volatile String _vendor = null;
    private volatile int _pushFlag = -1;
    private volatile int _busyFlag = -1;
    private volatile int _uploadedFlag = -1;
    private volatile int _measuredSpeedFlag = -1;
    private volatile boolean _supportsChat = false;
    private volatile boolean _supportsBrowseHost = false;
    private volatile boolean _replyToMulticast = false;
    private volatile boolean _supportsFWTransfer = false;
    private volatile byte _fwTransferVersion = 0;
    private static final int TRUE = 1;
    private static final int FALSE = 0;
    private static final int UNDEFINED = -1;
    private static final byte PUSH_MASK = 1;
    private static final byte BUSY_MASK = 4;
    private static final byte UPLOADED_MASK = 8;
    private static final byte SPEED_MASK = 16;
    private static final byte GGEP_MASK = 32;
    private static final byte CHAT_MASK = 1;
    private byte[] _xmlBytes = DataUtils.EMPTY_BYTE_ARRAY;
    private byte[] _address = new byte[4];
    private byte[] clientGUID = null;
    private Set _proxies;
    private boolean _browseHostReply;
    private HostData _hostData;
    private static final GGEPUtil _ggepUtil = new GGEPUtil();
    public static final boolean debugOn = false;

    public QueryReply(byte[] byArray, byte by, int n, byte[] byArray2, long l, Response[] responseArray, byte[] byArray3, boolean bl) {
        this(byArray, by, n, byArray2, l, responseArray, byArray3, DataUtils.EMPTY_BYTE_ARRAY, false, false, false, false, false, false, true, bl, false, Collections.EMPTY_SET);
    }

    public QueryReply(byte[] byArray, byte by, int n, byte[] byArray2, long l, Response[] responseArray, byte[] byArray3, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        this(byArray, by, n, byArray2, l, responseArray, byArray3, DataUtils.EMPTY_BYTE_ARRAY, true, bl, bl2, bl3, bl4, bl5, true, bl6, false, Collections.EMPTY_SET);
    }

    public QueryReply(byte[] byArray, byte by, int n, byte[] byArray2, long l, Response[] responseArray, byte[] byArray3, byte[] byArray4, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) throws IllegalArgumentException {
        this(byArray, by, n, byArray2, l, responseArray, byArray3, byArray4, bl, bl2, bl3, bl4, bl5, bl6, Collections.EMPTY_SET);
    }

    public QueryReply(byte[] byArray, byte by, int n, byte[] byArray2, long l, Response[] responseArray, byte[] byArray3, byte[] byArray4, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, Set set) throws IllegalArgumentException {
        this(byArray, by, n, byArray2, l, responseArray, byArray3, byArray4, true, bl, bl2, bl3, bl4, bl5, true, bl6, false, set);
        if (byArray4.length > 32768) {
            throw new IllegalArgumentException("XML bytes too big: " + byArray4.length);
        }
        this._xmlBytes = byArray4;
    }

    public QueryReply(byte[] byArray, byte by, int n, byte[] byArray2, long l, Response[] responseArray, byte[] byArray3, byte[] byArray4, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, Set set) throws IllegalArgumentException {
        this(byArray, by, n, byArray2, l, responseArray, byArray3, byArray4, true, bl, bl2, bl3, bl4, bl5, true, bl6, bl7, set);
        if (byArray4.length > 32768) {
            throw new IllegalArgumentException("XML bytes too big: " + byArray4.length);
        }
        this._xmlBytes = byArray4;
    }

    public QueryReply(byte[] byArray, byte by, byte by2, byte[] byArray2) throws BadPacketException {
        this(byArray, by, by2, byArray2, -1);
    }

    public QueryReply(byte[] byArray, byte by, byte by2, byte[] byArray2, int n) throws BadPacketException {
        super(byArray, (byte)-127, by, by2, byArray2.length, n);
        this._payload = byArray2;
        if (!NetworkUtils.isValidPort(this.getPort())) {
            ReceivedErrorStat.REPLY_INVALID_PORT.incrementStat();
            throw new BadPacketException("invalid port");
        }
        if ((this.getSpeed() & 0xFFFFFFFF00000000L) != 0L) {
            ReceivedErrorStat.REPLY_INVALID_SPEED.incrementStat();
            throw new BadPacketException("invalid speed: " + this.getSpeed());
        }
        this.setAddress();
        if (!NetworkUtils.isValidAddress(this.getIPBytes())) {
            ReceivedErrorStat.REPLY_INVALID_ADDRESS.incrementStat();
            throw new BadPacketException("invalid address");
        }
    }

    public QueryReply(byte[] byArray, QueryReply queryReply) {
        super(byArray, (byte)-127, queryReply.getTTL(), queryReply.getHops(), queryReply.getLength());
        this._payload = queryReply._payload;
        this.setAddress();
    }

    private QueryReply(byte[] byArray, byte by, int n, byte[] byArray2, long l, Response[] responseArray, byte[] byArray3, byte[] byArray4, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9, Set set) {
        super(byArray, (byte)-127, by, (byte)0, 0, 16);
        if (byArray4.length > 32768) {
            throw new IllegalArgumentException("xml too large: " + new String(byArray4));
        }
        int n2 = responseArray.length;
        if (!NetworkUtils.isValidPort(n)) {
            throw new IllegalArgumentException("invalid port: " + n);
        }
        if (byArray2.length != 4) {
            throw new IllegalArgumentException("invalid ip length: " + byArray2.length);
        }
        if (!NetworkUtils.isValidAddress(byArray2)) {
            throw new IllegalArgumentException("invalid address: " + NetworkUtils.ip2string(byArray2));
        }
        if ((l & 0xFFFFFFFF00000000L) != 0L) {
            throw new IllegalArgumentException("invalid speed: " + l);
        }
        if (n2 >= 256) {
            throw new IllegalArgumentException("invalid num responses: " + n2);
        }
        this._proxies = set;
        this._supportsFWTransfer = bl9;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int n3;
            byteArrayOutputStream.write(n2);
            ByteOrder.short2leb((short)n, byteArrayOutputStream);
            byteArrayOutputStream.write(byArray2, 0, byArray2.length);
            ByteOrder.int2leb((int)l, byteArrayOutputStream);
            for (n3 = n2; n3 > 0; --n3) {
                Response response = responseArray[n2 - n3];
                response.writeToStream(byteArrayOutputStream);
            }
            if (bl) {
                byteArrayOutputStream.write(76);
                byteArrayOutputStream.write(73);
                byteArrayOutputStream.write(77);
                byteArrayOutputStream.write(69);
                byteArrayOutputStream.write(4);
                n3 = _ggepUtil.getQRGGEP(false, false, false, Collections.EMPTY_SET).length;
                boolean bl10 = this._proxies != null && this._proxies.size() > 0;
                byte by2 = (byte)((bl2 && !bl8 ? 1 : 0) | 4 | 8 | 0x10 | 0x20);
                byte by3 = (byte)(1 | (bl3 && !bl8 ? 4 : 0) | (bl4 ? 8 : 0) | (bl5 || bl8 ? 16 : 0) | (bl7 || bl8 || bl10 || bl9 ? 32 : (n3 > 0 ? 32 : 0)));
                byteArrayOutputStream.write(by2);
                byteArrayOutputStream.write(by3);
                int n4 = byArray4.length + 1;
                if (n4 > 32768) {
                    n4 = 32768;
                }
                ByteOrder.short2leb((short)n4, byteArrayOutputStream);
                int n5 = bl6 ? 1 : 0;
                byteArrayOutputStream.write(n5);
                byte[] byArray5 = _ggepUtil.getQRGGEP(bl7, bl8, bl9, this._proxies);
                byteArrayOutputStream.write(byArray5, 0, byArray5.length);
                byteArrayOutputStream.write(byArray4, 0, byArray4.length);
                byteArrayOutputStream.write(0);
            }
            byteArrayOutputStream.write(byArray3, 0, 16);
            this._payload = byteArrayOutputStream.toByteArray();
            this.updateLength(this._payload.length);
        }
        catch (IOException iOException) {
            ErrorService.error(iOException);
        }
        this.setAddress();
    }

    private void setAddress() {
        this._address[0] = this._payload[3];
        this._address[1] = this._payload[4];
        this._address[2] = this._payload[5];
        this._address[3] = this._payload[6];
    }

    public void setOOBAddress(InetAddress inetAddress, int n) {
        this._address = inetAddress.getAddress();
        ByteOrder.short2leb((short)n, this._payload, 1);
    }

    public void setGUID(GUID gUID) {
        super.setGUID(gUID);
    }

    public void writePayload(OutputStream outputStream) throws IOException {
        outputStream.write(this._payload);
        SentMessageStatHandler.TCP_QUERY_REPLIES.addMessage(this);
    }

    public void setBrowseHostReply(boolean bl) {
        this._browseHostReply = bl;
    }

    public boolean isBrowseHostReply() {
        return this._browseHostReply;
    }

    public byte[] getXMLBytes() {
        this.parseResults();
        return this._xmlBytes;
    }

    public short getResultCount() {
        return (short)ByteOrder.ubyte2int(this._payload[0]);
    }

    public int getPort() {
        return ByteOrder.ushort2int(ByteOrder.leb2short(this._payload, 1));
    }

    public String getIP() {
        return NetworkUtils.ip2string(this._address);
    }

    public byte[] getIPBytes() {
        return this._address;
    }

    public long getSpeed() {
        return ByteOrder.uint2long(ByteOrder.leb2int(this._payload, 7));
    }

    public Response[] getResultsArray() throws BadPacketException {
        this.parseResults();
        if (this._responses == null) {
            throw new BadPacketException();
        }
        return this._responses;
    }

    public Iterator getResults() throws BadPacketException {
        this.parseResults();
        if (this._responses == null) {
            throw new BadPacketException();
        }
        List<Response> list = Arrays.asList(this._responses);
        return list.iterator();
    }

    public List getResultsAsList() throws BadPacketException {
        this.parseResults();
        if (this._responses == null) {
            throw new BadPacketException("results are null");
        }
        List<Response> list = Arrays.asList(this._responses);
        return list;
    }

    public String getVendor() throws BadPacketException {
        this.parseResults();
        if (this._vendor == null) {
            throw new BadPacketException();
        }
        return this._vendor;
    }

    public boolean getNeedsPush() throws BadPacketException {
        this.parseResults();
        switch (this._pushFlag) {
            case -1: {
                throw new BadPacketException();
            }
            case 1: {
                return true;
            }
            case 0: {
                return false;
            }
        }
        Assert.that(false, "Bad value for push flag: " + this._pushFlag);
        return false;
    }

    public boolean getIsBusy() throws BadPacketException {
        this.parseResults();
        switch (this._busyFlag) {
            case -1: {
                throw new BadPacketException();
            }
            case 1: {
                return true;
            }
            case 0: {
                return false;
            }
        }
        Assert.that(false, "Bad value for busy flag: " + this._pushFlag);
        return false;
    }

    public boolean getHadSuccessfulUpload() throws BadPacketException {
        this.parseResults();
        switch (this._uploadedFlag) {
            case -1: {
                throw new BadPacketException();
            }
            case 1: {
                return true;
            }
            case 0: {
                return false;
            }
        }
        Assert.that(false, "Bad value for uploaded flag: " + this._pushFlag);
        return false;
    }

    public boolean getIsMeasuredSpeed() throws BadPacketException {
        this.parseResults();
        switch (this._measuredSpeedFlag) {
            case -1: {
                throw new BadPacketException();
            }
            case 1: {
                return true;
            }
            case 0: {
                return false;
            }
        }
        Assert.that(false, "Bad value for measured speed flag: " + this._pushFlag);
        return false;
    }

    public boolean getSupportsChat() {
        this.parseResults();
        return this._supportsChat;
    }

    public boolean getSupportsFWTransfer() {
        this.parseResults();
        return this._supportsFWTransfer;
    }

    public byte getFWTransferVersion() {
        this.parseResults();
        return this._fwTransferVersion;
    }

    public boolean getSupportsBrowseHost() {
        this.parseResults();
        return this._supportsBrowseHost;
    }

    public boolean isReplyToMulticastQuery() {
        this.parseResults();
        return this._replyToMulticast;
    }

    public Set getPushProxies() {
        this.parseResults();
        return this._proxies;
    }

    public HostData getHostData() throws BadPacketException {
        this.parseResults();
        if (this._hostData == null) {
            throw new BadPacketException();
        }
        return this._hostData;
    }

    private void parseResults() {
        if (this._parsed) {
            return;
        }
        this._parsed = true;
        this.parseResults2();
    }

    private void parseResults2() {
        Object object;
        int n;
        int n2 = 11;
        Response[] responseArray = new Response[n];
        try {
            object = new ByteArrayInputStream(this._payload, n2, this._payload.length - n2);
            for (n = this.getResultCount(); n > 0; --n) {
                Response response;
                responseArray[responseArray.length - n] = response = Response.createFromStream((InputStream)object);
                n2 += response.getLength();
            }
            this._responses = responseArray;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return;
        }
        catch (IOException iOException) {
            return;
        }
        try {
            int n3;
            int n4;
            int n5;
            if (n2 >= this._payload.length - 16) {
                throw new BadPacketException("No QHD");
            }
            object = null;
            int n6 = -1;
            int n7 = -1;
            int n8 = -1;
            int n9 = -1;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            Set set = null;
            try {
                object = new String(this._payload, n2, 4, "ISO-8859-1");
                Assert.that(((String)object).length() == 4, "Vendor length wrong.  Wrong character encoding?");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Assert.that(false, "No support for ISO-8859-1 encoding");
            }
            int n10 = ByteOrder.ubyte2int(this._payload[n2 += 4]);
            if (n10 <= 0) {
                throw new BadPacketException("Common payload length zero.");
            }
            if (++n2 + n10 > this._payload.length - 16) {
                throw new BadPacketException("Common payload length imprecise!");
            }
            if (n10 > 1) {
                n5 = this._payload[n2];
                n4 = this._payload[n2 + 1];
                if ((n4 & 1) != 0) {
                    int n11 = n6 = (n5 & 1) == 1 ? 1 : 0;
                }
                if ((n5 & 4) != 0) {
                    int n12 = n7 = (n4 & 4) != 0 ? 1 : 0;
                }
                if ((n5 & 8) != 0) {
                    int n13 = n8 = (n4 & 8) != 0 ? 1 : 0;
                }
                if ((n5 & 0x10) != 0) {
                    int n14 = n9 = (n4 & 0x10) != 0 ? 1 : 0;
                }
                if ((n5 & 0x20) != 0 && (n4 & 0x20) != 0) {
                    for (n3 = n2 + 2; this._payload[n3] != -61 && n3 < this._payload.length; ++n3) {
                    }
                    try {
                        GGEP gGEP = new GGEP(this._payload, n3, null);
                        bl2 = gGEP.hasKey("BH");
                        if (gGEP.hasKey("FW")) {
                            this._fwTransferVersion = gGEP.getBytes("FW")[0];
                            this._supportsFWTransfer = this._fwTransferVersion > 0;
                        }
                        bl3 = gGEP.hasKey("MCAST");
                        set = _ggepUtil.getPushProxies(gGEP);
                    }
                    catch (BadGGEPBlockException badGGEPBlockException) {
                    }
                    catch (BadGGEPPropertyException badGGEPPropertyException) {
                        // empty catch block
                    }
                }
                n2 += 2;
            }
            if (n10 > 2) {
                int n15;
                if ((n15 = (n5 = (n3 = ByteOrder.ubyte2int(this._payload[n2++]))) | (n4 = (n3 = ByteOrder.ubyte2int(this._payload[n2++])) << 8)) > 1) {
                    int n16 = this._payload.length - 16 - n15;
                    this._xmlBytes = new byte[n15 - 1];
                    System.arraycopy(this._payload, n16, this._xmlBytes, 0, n15 - 1);
                } else {
                    this._xmlBytes = DataUtils.EMPTY_BYTE_ARRAY;
                }
            }
            if ((n5 = this._payload.length - n2) > 0 && (((String)object).equals("LIME") || ((String)object).equals("RAZA"))) {
                n4 = this._payload[n2];
                boolean bl4 = bl = (n4 & 1) != 0;
            }
            if (n2 > this._payload.length - 16) {
                throw new BadPacketException("Common payload length too large.");
            }
            Assert.that(object != null);
            this._vendor = ((String)object).toUpperCase(Locale.US);
            this._pushFlag = n6;
            this._busyFlag = n7;
            this._uploadedFlag = n8;
            this._measuredSpeedFlag = n9;
            this._supportsChat = bl;
            this._supportsBrowseHost = bl2;
            this._replyToMulticast = bl3;
            this._proxies = set == null ? Collections.EMPTY_SET : set;
            this._hostData = new HostData(this);
            QueryReply.debug("QR.parseResults2(): returning w/o exception.");
        }
        catch (BadPacketException badPacketException) {
            QueryReply.debug("QR.parseResults2(): bpe = " + badPacketException);
            return;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            QueryReply.debug("QR.parseResults2(): index exception = " + indexOutOfBoundsException);
            return;
        }
    }

    public byte[] getClientGUID() {
        if (this.clientGUID == null) {
            byte[] byArray = new byte[16];
            int n = super.getLength();
            System.arraycopy(this._payload, n - 16, byArray, 0, 16);
            this.clientGUID = byArray;
        }
        return this.clientGUID;
    }

    public Message stripExtendedPayload() {
        return this;
    }

    public String toString() {
        return "QueryReply::\r\n" + this.getResultCount() + " hits\r\n" + super.toString() + "\r\n" + "ip: " + this.getIP() + "\r\n";
    }

    public int calculateQualityOfService(boolean bl) {
        int n;
        int n2;
        try {
            n2 = this.getIsBusy() ? 1 : -1;
        }
        catch (BadPacketException badPacketException) {
            n2 = 0;
        }
        boolean bl2 = this.isReplyToMulticastQuery();
        if (bl2) {
            bl = false;
            n = -1;
        } else if (NetworkUtils.isPrivateAddress(this.getIPBytes())) {
            n = 1;
        } else {
            try {
                n = this.getNeedsPush() ? 1 : -1;
            }
            catch (BadPacketException badPacketException) {
                n = 0;
            }
        }
        boolean bl3 = false;
        if (this.getPushProxies() != null && this.getPushProxies().size() > 1) {
            bl3 = true;
        }
        if (this.getSupportsFWTransfer() && UDPService.instance().canDoFWT()) {
            bl = false;
            n = -1;
        }
        if (Arrays.equals(this._address, RouterService.getAddress())) {
            return 3;
        }
        if (bl2) {
            return 4;
        }
        if (bl && n == 1) {
            return -1;
        }
        if (n2 == 0 || n == 0) {
            return 0;
        }
        if (n2 == 1) {
            Assert.that(n == -1 || !bl);
            if (n == 1) {
                return 0;
            }
            return 1;
        }
        if (n2 == -1) {
            Assert.that(n == -1 || !bl);
            if (n == 1 && !bl3) {
                return 2;
            }
            return 3;
        }
        Assert.that(false, "Unexpected case!");
        return -1;
    }

    public static boolean isFirewalledQuality(int n) {
        return n == 0 || n == 2;
    }

    public void recordDrop() {
        DroppedSentMessageStatHandler.TCP_QUERY_REPLIES.addMessage(this);
    }

    public static void debug(String string) {
    }

    public static void debug(Exception exception) {
    }

    public static class IPPortCombo
    implements IpPort {
        private int _port;
        private InetAddress _addr;
        public static final String DELIM = ":";

        public static IPPortCombo getCombo(byte[] byArray) throws BadPacketException {
            return new IPPortCombo(byArray);
        }

        private IPPortCombo(byte[] byArray) throws BadPacketException {
            if (byArray.length != 6) {
                throw new BadPacketException("Weird Input");
            }
            String string = NetworkUtils.ip2string(byArray, 0);
            int n = ByteOrder.ushort2int(ByteOrder.leb2short(byArray, 4));
            if (!NetworkUtils.isValidPort(n)) {
                throw new BadPacketException("Bad Port: " + n);
            }
            this._port = n;
            try {
                this._addr = InetAddress.getByName(string);
            }
            catch (UnknownHostException unknownHostException) {
                throw new BadPacketException("bad host.");
            }
            if (!NetworkUtils.isValidAddress(this._addr)) {
                throw new BadPacketException("invalid addr: " + this._addr);
            }
        }

        public IPPortCombo(String string, int n) throws UnknownHostException, IllegalArgumentException {
            if (!NetworkUtils.isValidPort(n)) {
                throw new IllegalArgumentException("Bad Port: " + n);
            }
            this._port = n;
            this._addr = InetAddress.getByName(string);
            if (!NetworkUtils.isValidAddress(this._addr)) {
                throw new IllegalArgumentException("invalid addr: " + this._addr);
            }
        }

        public int getPort() {
            return this._port;
        }

        public InetAddress getInetAddress() {
            return this._addr;
        }

        public String getAddress() {
            return this._addr.getHostAddress();
        }

        public byte[] toBytes() {
            byte[] byArray = new byte[6];
            for (int i = 0; i < 4; ++i) {
                byArray[i] = this._addr.getAddress()[i];
            }
            ByteOrder.short2leb((short)this._port, byArray, 4);
            return byArray;
        }

        public boolean equals(Object object) {
            if (object instanceof IPPortCombo) {
                IPPortCombo iPPortCombo = (IPPortCombo)object;
                return this._addr.equals(iPPortCombo._addr) && this._port == iPPortCombo._port;
            }
            return false;
        }

        public int hashCode() {
            return this._addr.hashCode() * this._port;
        }

        public String toString() {
            return this.getAddress() + DELIM + this.getPort();
        }
    }

    static class GGEPUtil {
        private final byte[] _standardGGEP;
        private final byte[] _bhGGEP;
        private final byte[] _mcGGEP;
        private final byte[] _comboGGEP;

        public GGEPUtil() {
            GGEP gGEP;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                gGEP = new GGEP(false);
                gGEP.write(byteArrayOutputStream);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this._standardGGEP = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.reset();
            try {
                gGEP = new GGEP(false);
                gGEP.put("BH");
                gGEP.write(byteArrayOutputStream);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this._bhGGEP = byteArrayOutputStream.toByteArray();
            Assert.that(this._bhGGEP != null);
            byteArrayOutputStream.reset();
            try {
                gGEP = new GGEP(false);
                gGEP.put("MCAST");
                gGEP.write(byteArrayOutputStream);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this._mcGGEP = byteArrayOutputStream.toByteArray();
            Assert.that(this._mcGGEP != null);
            byteArrayOutputStream.reset();
            try {
                gGEP = new GGEP(false);
                gGEP.put("MCAST");
                gGEP.put("BH");
                gGEP.write(byteArrayOutputStream);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this._comboGGEP = byteArrayOutputStream.toByteArray();
            Assert.that(this._comboGGEP != null);
        }

        public byte[] getQRGGEP(boolean bl, boolean bl2, boolean bl3, Set set) {
            byte[] byArray = this._standardGGEP;
            if (set != null && set.size() > 0) {
                GGEP gGEP = new GGEP();
                if (bl) {
                    gGEP.put("BH");
                }
                if (bl2) {
                    gGEP.put("MCAST");
                }
                if (bl3) {
                    gGEP.put("FW", new byte[]{1});
                }
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                int n = 0;
                Iterator iterator = set.iterator();
                while (iterator.hasNext() && n < 4) {
                    IpPort ipPort = (IpPort)iterator.next();
                    String string = ipPort.getAddress();
                    int n2 = ipPort.getPort();
                    try {
                        IPPortCombo iPPortCombo = new IPPortCombo(string, n2);
                        byteArrayOutputStream.write(iPPortCombo.toBytes());
                        ++n;
                    }
                    catch (UnknownHostException unknownHostException) {
                    }
                    catch (IOException iOException) {
                        ErrorService.error(iOException);
                    }
                }
                try {
                    if (n > 0) {
                        gGEP.put("PUSH", byteArrayOutputStream.toByteArray());
                    }
                    byteArrayOutputStream.reset();
                    gGEP.write(byteArrayOutputStream);
                    byArray = byteArrayOutputStream.toByteArray();
                }
                catch (IOException iOException) {
                    ErrorService.error(iOException);
                }
            } else if (bl && bl2) {
                byArray = this._comboGGEP;
            } else if (bl) {
                byArray = this._bhGGEP;
            } else if (bl2) {
                byArray = this._mcGGEP;
            }
            return byArray;
        }

        public Set getPushProxies(GGEP gGEP) {
            IpPortSet ipPortSet = null;
            if (gGEP.hasKey("PUSH")) {
                try {
                    byte[] byArray = gGEP.getBytes("PUSH");
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                    while (byteArrayInputStream.available() > 0) {
                        byte[] byArray2 = new byte[6];
                        if (byteArrayInputStream.read(byArray2, 0, byArray2.length) != byArray2.length) continue;
                        try {
                            if (ipPortSet == null) {
                                ipPortSet = new IpPortSet();
                            }
                            ipPortSet.add(new IPPortCombo(byArray2));
                        }
                        catch (BadPacketException badPacketException) {}
                    }
                }
                catch (BadGGEPPropertyException badGGEPPropertyException) {
                    // empty catch block
                }
            }
            if (ipPortSet == null) {
                return Collections.EMPTY_SET;
            }
            return ipPortSet;
        }
    }
}

