/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.metadata;

import com.jcraft.jogg.Packet;
import com.jcraft.jogg.Page;
import com.jcraft.jogg.StreamState;
import com.jcraft.jogg.SyncState;
import com.jcraft.jorbis.Comment;
import com.jcraft.jorbis.Info;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.util.FileUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JOrbisComment {
    private static final Log LOG = LogFactory.getLog((Class)(class$com$limegroup$gnutella$metadata$JOrbisComment == null ? (class$com$limegroup$gnutella$metadata$JOrbisComment = JOrbisComment.class$("com.limegroup.gnutella.metadata.JOrbisComment")) : class$com$limegroup$gnutella$metadata$JOrbisComment));
    private State state = null;
    private static int CHUNKSIZE = 4096;
    static /* synthetic */ Class class$com$limegroup$gnutella$metadata$JOrbisComment;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Comment comment, File file) throws IOException {
        IOException iOException4;
        File file2;
        InputStream inputStream;
        block15: {
            inputStream = null;
            OutputStream outputStream = null;
            file2 = null;
            try {
                this.state = new State();
                inputStream = new BufferedInputStream(new FileInputStream(file));
                this.read(inputStream);
                this.state.vc = comment;
                file2 = null;
                try {
                    file2 = File.createTempFile(file.getName(), "tmp");
                }
                catch (IOException iOException2) {
                    LOG.debug((Object)"couldn't create temp file in $TEMP, trying elsewhere");
                    file2 = new File(file.getAbsolutePath(), file.getName() + ".tmp");
                }
                outputStream = new BufferedOutputStream(new FileOutputStream(file2));
                LOG.debug((Object)"about to write ogg file");
                this.write(outputStream);
                outputStream.flush();
                Object var8_7 = null;
                if (outputStream == null) break block15;
            }
            catch (Throwable throwable) {
                IOException iOException32;
                Object var8_8 = null;
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException iOException32) {
                        // empty catch block
                    }
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException32) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            try {
                outputStream.close();
            }
            catch (IOException iOException4) {
                // empty catch block
            }
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException4) {}
        }
        if (file2.length() == 0L) {
            throw new IOException("writing of file failed");
        }
        if (!FileUtils.forceRename(file2, file)) {
            throw new IOException("couldn't rename file");
        }
    }

    void read(InputStream inputStream) throws IOException {
        this.state.in = inputStream;
        Page page = new Page();
        int n = 0;
        this.state.oy = new SyncState();
        this.state.oy.init();
        int n2 = this.state.oy.buffer(CHUNKSIZE);
        byte[] byArray = this.state.oy.data;
        n = this.state.in.read(byArray, n2, CHUNKSIZE);
        this.state.oy.wrote(n);
        if (this.state.oy.pageout(page) != 1) {
            throw new IOException("input truncated, empty or not an ogg");
        }
        this.state.serial = page.serialno();
        this.state.os = new StreamState();
        this.state.os.init(this.state.serial);
        this.state.vi = new Info();
        this.state.vi.init();
        this.state.vc = new Comment();
        this.state.vc.init();
        if (this.state.os.pagein(page) < 0) {
            throw new IOException("Error reading first page of Ogg bitstream data.");
        }
        Packet packet = new Packet();
        if (this.state.os.packetout(packet) != 1) {
            throw new IOException("Error reading initial header packet.");
        }
        if (this.state.vi.synthesis_headerin(this.state.vc, packet) < 0) {
            throw new IOException("This Ogg bitstream does not contain Vorbis data.");
        }
        this.state.mainlen = packet.bytes;
        this.state.mainbuf = new byte[this.state.mainlen];
        System.arraycopy(packet.packet_base, packet.packet, this.state.mainbuf, 0, this.state.mainlen);
        int n3 = 0;
        Packet packet2 = new Packet();
        Packet packet3 = new Packet();
        Packet packet4 = packet2;
        while (n3 < 2) {
            int n4;
            while (n3 < 2 && (n4 = this.state.oy.pageout(page)) != 0) {
                if (n4 != 1) continue;
                this.state.os.pagein(page);
                while (n3 < 2 && (n4 = this.state.os.packetout(packet4)) != 0) {
                    if (n4 == -1) {
                        throw new IOException("Corrupt secondary header.");
                    }
                    this.state.vi.synthesis_headerin(this.state.vc, packet4);
                    if (n3 == 1) {
                        this.state.booklen = packet4.bytes;
                        this.state.bookbuf = new byte[this.state.booklen];
                        System.arraycopy(packet4.packet_base, packet4.packet, this.state.bookbuf, 0, packet4.bytes);
                    }
                    ++n3;
                    packet4 = packet3;
                }
            }
            byArray = this.state.oy.data;
            n2 = this.state.oy.buffer(CHUNKSIZE);
            n = this.state.in.read(byArray, n2, CHUNKSIZE);
            if (n == 0 && n3 < 2) {
                throw new IOException("EOF before end of vorbis headers.");
            }
            this.state.oy.wrote(n);
        }
    }

    int write(OutputStream outputStream) throws IOException {
        int n;
        StreamState streamState = new StreamState();
        Packet packet = new Packet();
        Packet packet2 = new Packet();
        Packet packet3 = new Packet();
        Page page = new Page();
        Packet packet4 = new Packet();
        long l = 0L;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        packet.bytes = this.state.mainlen;
        packet.packet_base = this.state.mainbuf;
        packet.packet = 0;
        packet.b_o_s = 1;
        packet.e_o_s = 0;
        packet.granulepos = 0L;
        packet3.bytes = this.state.booklen;
        packet3.packet_base = this.state.bookbuf;
        packet3.packet = 0;
        packet3.b_o_s = 0;
        packet3.e_o_s = 0;
        packet3.granulepos = 0L;
        streamState.init(this.state.serial);
        this.state.vc.header_out(packet2);
        streamState.packetin(packet);
        streamState.packetin(packet2);
        streamState.packetin(packet3);
        while ((n = streamState.flush(page)) != 0) {
            outputStream.write(page.header_base, page.header, page.header_len);
            outputStream.flush();
            outputStream.write(page.body_base, page.body, page.body_len);
            outputStream.flush();
        }
        while (this.state.fetch_next_packet(packet4) != 0) {
            int n2 = this.state.blocksize(packet4);
            l += (long)n2;
            if (bl2) {
                if (streamState.flush(page) != 0) {
                    outputStream.write(page.header_base, page.header, page.header_len);
                    outputStream.flush();
                    outputStream.write(page.body_base, page.body, page.body_len);
                    outputStream.flush();
                }
            } else if (bl3 && streamState.pageout(page) != 0) {
                outputStream.write(page.header_base, page.header, page.header_len);
                outputStream.flush();
                outputStream.write(page.body_base, page.body, page.body_len);
                outputStream.flush();
            }
            bl3 = false;
            bl2 = false;
            if (packet4.granulepos == -1L) {
                packet4.granulepos = l;
                streamState.packetin(packet4);
                continue;
            }
            if (l > packet4.granulepos) {
                l = packet4.granulepos;
                streamState.packetin(packet4);
                bl2 = true;
                continue;
            }
            streamState.packetin(packet4);
            bl3 = true;
        }
        streamState.e_o_s = 1;
        while (streamState.flush(page) != 0) {
            outputStream.write(page.header_base, page.header, page.header_len);
            outputStream.flush();
            outputStream.write(page.body_base, page.body, page.body_len);
            outputStream.flush();
        }
        this.state.vi.clear();
        bl = false;
        while (!bl) {
            while ((n = this.state.oy.pageout(page)) != 0) {
                if (n < 0) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)"Corrupt or missing data, continuing...");
                    continue;
                }
                outputStream.write(page.header_base, page.header, page.header_len);
                outputStream.flush();
                outputStream.write(page.body_base, page.body, page.body_len);
                outputStream.flush();
            }
            int n3 = this.state.oy.buffer(CHUNKSIZE);
            byte[] byArray = this.state.oy.data;
            int n4 = this.state.in.read(byArray, n3, CHUNKSIZE);
            this.state.oy.wrote(n4);
            if (n4 != 0 && n4 != -1) continue;
            bl = true;
            break;
        }
        return 0;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class State {
        private final int CHUNKSIZE = 4096;
        SyncState oy;
        StreamState os;
        Comment vc;
        Info vi;
        InputStream in;
        int serial;
        byte[] mainbuf;
        byte[] bookbuf;
        int mainlen;
        int booklen;
        String lasterror;
        int prevW;
        Page og = new Page();

        State() {
        }

        int blocksize(Packet packet) {
            int n = this.vi.blocksize(packet);
            int n2 = (n + this.prevW) / 4;
            if (this.prevW == 0) {
                this.prevW = n;
                return 0;
            }
            this.prevW = n;
            return n2;
        }

        int fetch_next_packet(Packet packet) {
            int n = this.os.packetout(packet);
            if (n > 0) {
                return 1;
            }
            while (this.oy.pageout(this.og) <= 0) {
                int n2;
                int n3 = this.oy.buffer(4096);
                byte[] byArray = this.oy.data;
                try {
                    n2 = this.in.read(byArray, n3, 4096);
                }
                catch (Exception exception) {
                    ErrorService.error(exception);
                    return 0;
                }
                if (n2 > 0) {
                    this.oy.wrote(n2);
                }
                if (n2 != 0 && n2 != -1) continue;
                return 0;
            }
            this.os.pagein(this.og);
            return this.fetch_next_packet(packet);
        }
    }
}

