/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.metadata;

import com.limegroup.gnutella.metadata.ASFParser;
import com.limegroup.gnutella.metadata.AudioMetaData;
import com.limegroup.gnutella.metadata.VideoMetaData;
import com.limegroup.gnutella.metadata.WMAMetaData;
import com.limegroup.gnutella.metadata.WMVMetaData;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class MetaData {
    private static final Log LOG = LogFactory.getLog((Class)(class$com$limegroup$gnutella$metadata$MetaData == null ? (class$com$limegroup$gnutella$metadata$MetaData = MetaData.class$("com.limegroup.gnutella.metadata.MetaData")) : class$com$limegroup$gnutella$metadata$MetaData));
    static /* synthetic */ Class class$com$limegroup$gnutella$metadata$MetaData;

    protected MetaData() {
    }

    public static MetaData parse(File file) throws IOException {
        try {
            if (LimeXMLUtils.isSupportedAudioFormat(file)) {
                return AudioMetaData.parseAudioFile(file);
            }
            if (LimeXMLUtils.isSupportedVideoFormat(file)) {
                return VideoMetaData.parseVideoMetaData(file);
            }
            if (LimeXMLUtils.isSupportedMultipleFormat(file)) {
                return MetaData.parseMultipleFormat(file);
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            LOG.warn((Object)"Ran out of memory while parsing.", (Throwable)outOfMemoryError);
        }
        return null;
    }

    private static MetaData parseMultipleFormat(File file) throws IOException {
        if (LimeXMLUtils.isASFFile(file)) {
            ASFParser aSFParser = new ASFParser(file);
            if (aSFParser.hasVideo()) {
                return new WMVMetaData(aSFParser);
            }
            if (aSFParser.hasAudio()) {
                return new WMAMetaData(aSFParser);
            }
        }
        return null;
    }

    public abstract boolean isComplete();

    public abstract List toNameValueList();

    public abstract String getSchemaURI();

    protected abstract void parseFile(File var1) throws IOException;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

