/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.metadata;

import com.jcraft.jorbis.Comment;
import com.jcraft.jorbis.JOrbisException;
import com.jcraft.jorbis.VorbisFile;
import com.limegroup.gnutella.metadata.AudioMetaData;
import java.io.File;
import java.io.IOException;

public class OGGMetaData
extends AudioMetaData {
    public static final String TITLE_TAG = "title";
    public static final String TRACK_TAG = "tracknumber";
    public static final String ALBUM_TAG = "album";
    public static final String GENRE_TAG = "genre";
    public static final String DATE_TAG = "date";
    public static final String COMMENT_TAG = "comment";
    public static final String ARTIST_TAG = "artist";
    public static final String LICENSE_TAG = "license";

    public OGGMetaData(File file) throws IOException {
        super(file);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void parseFile(File file) throws IOException {
        VorbisFile vorbisFile;
        block10: {
            vorbisFile = null;
            try {
                try {
                    vorbisFile = new VorbisFile(file.getAbsolutePath());
                }
                catch (JOrbisException jOrbisException) {
                    throw new IOException(jOrbisException.getMessage());
                }
                Object var6_3 = null;
                if (vorbisFile == null) break block10;
            }
            catch (Throwable throwable) {
                Object var6_4 = null;
                if (vorbisFile == null) throw throwable;
                try {
                    vorbisFile.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException iOException) {}
            vorbisFile.close();
        }
        this.setBitrate(vorbisFile.bitrate(-1) / 1024);
        this.setLength((int)vorbisFile.time_total(-1));
        Comment[] commentArray = vorbisFile.getComment();
        if (commentArray.length <= 0) return;
        if (commentArray[0] == null) return;
        this.setTitle(this.safeQuery(TITLE_TAG, commentArray[0]));
        this.setArtist(this.safeQuery(ARTIST_TAG, commentArray[0]));
        this.setAlbum(this.safeQuery(ALBUM_TAG, commentArray[0]));
        this.setComment(this.safeQuery(COMMENT_TAG, commentArray[0]));
        this.setGenre(this.safeQuery(GENRE_TAG, commentArray[0]));
        this.setLicense(this.safeQuery(LICENSE_TAG, commentArray[0]));
        String string = this.safeQuery(DATE_TAG, commentArray[0]);
        if (string.length() > 4) {
            string = string.substring(0, 4);
        }
        this.setYear(string);
        try {
            short s = Short.parseShort(this.safeQuery(TRACK_TAG, commentArray[0]));
            this.setTrack(s);
            return;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private String safeQuery(String string, Comment comment) {
        String string2 = comment.query(string);
        return string2 == null ? "" : string2;
    }
}

