/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.metadata;

import com.limegroup.gnutella.metadata.MetaData;
import com.limegroup.gnutella.metadata.OGMMetaData;
import com.limegroup.gnutella.metadata.RIFFMetaData;
import com.limegroup.gnutella.metadata.WMVMetaData;
import com.limegroup.gnutella.util.NameValue;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public abstract class VideoMetaData
extends MetaData {
    private String title;
    private String year;
    private int length = -1;
    private String comment;
    private String language;
    private String license;
    private int width = -1;
    private int height = -1;
    private String licensetype;
    public static String schemaURI = "http://www.limewire.com/schemas/video.xsd";
    private static final String DLM = "__";
    private static final String KPX = "videos__video__";
    public static final String TITLE_KEY = "videos__video__title__";
    public static final String YEAR_KEY = "videos__video__year__";
    public static final String LENGTH_KEY = "videos__video__length__";
    public static final String LANGUAGE_KEY = "videos__video__language__";
    public static final String COMMENTS_KEY = "videos__video__comments__";
    public static final String LICENSE_KEY = "videos__video__license__";
    public static final String HEIGHT_KEY = "videos__video__width__";
    public static final String WIDTH_KEY = "videos__video__height__";
    public static final String LICENSE_TYPE_KEY = "videos__video__licensetype__";

    protected VideoMetaData() throws IOException {
    }

    public VideoMetaData(File file) throws IOException {
        this.parseFile(file);
    }

    public static VideoMetaData parseVideoMetaData(File file) throws IOException {
        if (LimeXMLUtils.isRIFFFile(file)) {
            return new RIFFMetaData(file);
        }
        if (LimeXMLUtils.isOGMFile(file)) {
            return new OGMMetaData(file);
        }
        if (LimeXMLUtils.isWMVFile(file)) {
            return new WMVMetaData(file);
        }
        return null;
    }

    public String getSchemaURI() {
        return schemaURI;
    }

    public String getTitle() {
        return this.title;
    }

    public String getYear() {
        return this.year;
    }

    public int getLength() {
        return this.length;
    }

    public String getComment() {
        return this.comment;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getLicense() {
        return this.license;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public String getLicenseType() {
        return this.licensetype;
    }

    void setTitle(String string) {
        this.title = string;
    }

    void setYear(String string) {
        this.year = string;
    }

    void setLength(int n) {
        this.length = n;
    }

    void setComment(String string) {
        this.comment = string;
    }

    void setLanguage(String string) {
        this.language = string;
    }

    void setLicense(String string) {
        this.license = string;
    }

    void setWidth(int n) {
        this.width = n;
    }

    void setHeight(int n) {
        this.height = n;
    }

    void setLicenseType(String string) {
        this.licensetype = string;
    }

    public boolean isComplete() {
        return this.isValid(this.title) && this.isValid(this.year) && this.isValid(this.length) && this.isValid(this.comment) && this.isValid(this.language) && this.isValid(this.license) && this.isValid(this.width) && this.isValid(this.height) && this.isValid(this.licensetype);
    }

    public List toNameValueList() {
        ArrayList arrayList = new ArrayList();
        this.add(arrayList, this.title, TITLE_KEY);
        this.add(arrayList, this.year, YEAR_KEY);
        this.add(arrayList, this.length, LENGTH_KEY);
        this.add(arrayList, this.comment, COMMENTS_KEY);
        this.add(arrayList, this.language, LANGUAGE_KEY);
        this.add(arrayList, this.license, LICENSE_KEY);
        this.add(arrayList, this.width, WIDTH_KEY);
        this.add(arrayList, this.height, HEIGHT_KEY);
        this.add(arrayList, this.licensetype, LICENSE_TYPE_KEY);
        return arrayList;
    }

    private void add(List list, String string, String string2) {
        if (this.isValid(string)) {
            list.add(new NameValue(string2, string.trim()));
        }
    }

    private void add(List list, int n, String string) {
        if (this.isValid(n)) {
            list.add(new NameValue(string, "" + n));
        }
    }

    private boolean isValid(String string) {
        return string != null && !string.trim().equals("");
    }

    private boolean isValid(int n) {
        return n >= 0;
    }
}

