/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.metadata;

import com.limegroup.gnutella.xml.LimeXMLUtils;
import java.io.IOException;
import java.io.StringReader;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class WRMXML {
    public static final String PROTECTED = "licensed: ";
    protected String _securityversion;
    protected String _cid;
    protected String _lainfo;
    protected String _kid;
    protected String _checksum;
    protected String _hashalgorithm;
    protected String _signalgorithm;
    protected String _signatureValue;
    protected Node _documentNode;

    WRMXML(String string) {
        this.parse(string);
    }

    WRMXML(Node node) {
        this.parseDocument(node);
    }

    public boolean isValid() {
        return this._documentNode != null && this._lainfo != null && this._hashalgorithm != null && this._signalgorithm != null && this._signatureValue != null;
    }

    public String getSecurityVersion() {
        return this._securityversion;
    }

    public String getCID() {
        return this._cid;
    }

    public String getLAInfo() {
        return this._lainfo;
    }

    public String getKID() {
        return this._kid;
    }

    public String getHashAlgorithm() {
        return this._hashalgorithm;
    }

    public String getSignAlgorithm() {
        return this._signalgorithm;
    }

    public String getSignatureValue() {
        return this._signatureValue;
    }

    public String getChecksum() {
        return this._checksum;
    }

    protected void parse(String string) {
        DOMParser dOMParser = new DOMParser();
        InputSource inputSource = new InputSource(new StringReader(string));
        try {
            dOMParser.parse(inputSource);
        }
        catch (IOException iOException) {
            return;
        }
        catch (SAXException sAXException) {
            return;
        }
        this.parseDocument(dOMParser.getDocument().getDocumentElement());
    }

    protected void parseDocument(Node node) {
        this._documentNode = node;
        if (!this._documentNode.getNodeName().equals("WRMHEADER")) {
            return;
        }
        NodeList nodeList = this._documentNode.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            this.parseNode(node2.getNodeName(), node2);
        }
    }

    protected void parseNode(String string, Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            this.parseAttributes(string, node2);
            String string2 = node2.getNodeName();
            String string3 = LimeXMLUtils.getTextContent(node2);
            if (string3 == null || (string3 = string3.trim()).equals("")) continue;
            this.parseChild(string, string2, null, string3);
        }
    }

    protected void parseAttributes(String string, Node node) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        String string2 = node.getNodeName();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node2 = namedNodeMap.item(i);
            String string3 = node2.getNodeName();
            String string4 = node2.getNodeValue();
            if (string4 == null || (string4 = string4.trim()).equals("")) continue;
            this.parseChild(string, string2, string3, string4);
        }
    }

    protected void parseChild(String string, String string2, String string3, String string4) {
        if (string.equals("DATA")) {
            if (string3 != null) {
                return;
            }
            if (string2.equals("SECURITYVERSION")) {
                this._securityversion = string4;
            } else if (string2.equals("CID")) {
                this._cid = string4;
            } else if (string2.equals("LAINFO")) {
                this._lainfo = string4;
            } else if (string2.equals("KID")) {
                this._kid = string4;
            } else if (string2.equals("CHECKSUM")) {
                this._checksum = string4;
            }
        } else if (string.equals("SIGNATURE")) {
            if (string2.equals("HASHALGORITHM") && "type".equals(string3)) {
                this._hashalgorithm = string4;
            } else if (string2.equals("SIGNALGORITHM") && "type".equals(string3)) {
                this._signalgorithm = string4;
            } else if (string2.equals("VALUE") && string3 == null) {
                this._signatureValue = string4;
            }
        }
    }
}

