/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.security;

import com.bitzi.util.Base32;
import com.limegroup.gnutella.util.FileUtils;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SignatureVerifier {
    private static final Log LOG = LogFactory.getLog((Class)(class$com$limegroup$gnutella$security$SignatureVerifier == null ? (class$com$limegroup$gnutella$security$SignatureVerifier = SignatureVerifier.class$("com.limegroup.gnutella.security.SignatureVerifier")) : class$com$limegroup$gnutella$security$SignatureVerifier));
    private final byte[] plainText;
    private final byte[] signature;
    private final PublicKey publicKey;
    private final String algorithm;
    private final String digAlg;
    static /* synthetic */ Class class$com$limegroup$gnutella$security$SignatureVerifier;

    public SignatureVerifier(byte[] byArray, byte[] byArray2, PublicKey publicKey, String string) {
        this(byArray, byArray2, publicKey, string, null);
    }

    public SignatureVerifier(byte[] byArray, byte[] byArray2, PublicKey publicKey, String string, String string2) {
        this.plainText = byArray;
        this.signature = byArray2;
        this.publicKey = publicKey;
        this.algorithm = string;
        this.digAlg = string2;
    }

    public String toString() {
        return "text: " + new String(this.plainText) + ", sig: " + new String(this.signature) + ", key: " + this.publicKey + ", alg: " + this.algorithm + ", digAlg: " + this.digAlg;
    }

    public boolean verifySignature() {
        String string = this.digAlg == null ? this.algorithm : this.digAlg + "with" + this.algorithm;
        try {
            Signature signature = Signature.getInstance(string);
            signature.initVerify(this.publicKey);
            signature.update(this.plainText, 0, this.plainText.length);
            return signature.verify(this.signature);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            LOG.error((Object)("No alg." + this), (Throwable)noSuchAlgorithmException);
            return false;
        }
        catch (InvalidKeyException invalidKeyException) {
            LOG.error((Object)("Invalid key. " + this), (Throwable)invalidKeyException);
            return false;
        }
        catch (SignatureException signatureException) {
            LOG.error((Object)("Bad sig." + this), (Throwable)signatureException);
            return false;
        }
        catch (ClassCastException classCastException) {
            LOG.error((Object)("bad cast." + this), (Throwable)classCastException);
            return false;
        }
    }

    public static String getVerifiedData(byte[] byArray, File file, String string, String string2) {
        PublicKey publicKey = SignatureVerifier.readKey(file, string);
        byte[][] byArray2 = SignatureVerifier.parseData(byArray);
        return SignatureVerifier.verify(publicKey, byArray2, string, string2);
    }

    public static String getVerifiedData(File file, File file2, String string, String string2) {
        PublicKey publicKey = SignatureVerifier.readKey(file2, string);
        byte[][] byArray = SignatureVerifier.parseData(FileUtils.readFileFully(file));
        return SignatureVerifier.verify(publicKey, byArray, string, string2);
    }

    private static String verify(PublicKey publicKey, byte[][] byArray, String string, String string2) {
        if (publicKey == null || byArray == null) {
            LOG.warn((Object)"No key or data to verify.");
            return null;
        }
        SignatureVerifier signatureVerifier = new SignatureVerifier(byArray[1], byArray[0], publicKey, string, string2);
        if (signatureVerifier.verifySignature()) {
            try {
                return new String(byArray[1], "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return new String(byArray[1]);
            }
        }
        return null;
    }

    private static PublicKey readKey(File file, String string) {
        byte[] byArray = FileUtils.readFileFully(file);
        if (byArray == null) {
            return null;
        }
        try {
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(Base32.decode(new String(byArray)));
            KeyFactory keyFactory = KeyFactory.getInstance(string);
            PublicKey publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
            return publicKey;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            LOG.error((Object)("Invalid algorithm: " + string), (Throwable)noSuchAlgorithmException);
            return null;
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            LOG.error((Object)("Invalid keyspec: " + file), (Throwable)invalidKeySpecException);
            return null;
        }
    }

    private static byte[][] parseData(byte[] byArray) {
        if (byArray == null) {
            LOG.warn((Object)"No data to parse.");
            return null;
        }
        int n = SignatureVerifier.findPipes(byArray);
        if (n == -1 || n >= byArray.length - 3) {
            LOG.warn((Object)"Couldn't find pipes.");
            return null;
        }
        byte[] byArray2 = new byte[n];
        byte[] byArray3 = new byte[byArray.length - n - 2];
        System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
        System.arraycopy(byArray, n + 2, byArray3, 0, byArray3.length);
        return new byte[][]{Base32.decode(new String(byArray2)), byArray3};
    }

    private static int findPipes(byte[] byArray) {
        for (int i = 0; i < byArray.length - 1; ++i) {
            if (byArray[i] != 124 || byArray[i + 1] != 124) continue;
            return i;
        }
        return -1;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

