/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.settings;

import com.limegroup.gnutella.settings.Setting;
import com.limegroup.gnutella.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;

public class FileArraySetting
extends Setting {
    private File[] value;

    FileArraySetting(Properties properties, Properties properties2, String string, File[] fileArray) {
        this(properties, properties2, string, fileArray, null);
    }

    FileArraySetting(Properties properties, Properties properties2, String string, File[] fileArray, String string2) {
        super(properties, properties2, string, FileArraySetting.decode(fileArray), string2);
        this.setPrivate(true);
    }

    public File[] getValue() {
        return this.value;
    }

    public synchronized void setValue(File[] fileArray) {
        super.setValue(FileArraySetting.decode(fileArray));
    }

    public synchronized void add(File file) {
        if (file == null) {
            return;
        }
        File[] fileArray = new File[this.value.length + 1];
        System.arraycopy(this.value, 0, fileArray, 0, this.value.length);
        fileArray[this.value.length] = file;
        this.setValue(fileArray);
    }

    public synchronized boolean remove(File file) {
        if (file == null) {
            return false;
        }
        int n = this.indexOf(file);
        if (n == -1) {
            return false;
        }
        File[] fileArray = new File[this.value.length - 1];
        System.arraycopy(this.value, 0, fileArray, 0, n);
        System.arraycopy(this.value, n + 1, fileArray, n, this.value.length - n - 1);
        this.setValue(fileArray);
        return true;
    }

    public synchronized boolean contains(File file) {
        return this.indexOf(file) >= 0;
    }

    public synchronized int indexOf(File file) {
        if (file == null) {
            return -1;
        }
        List<File> list = Arrays.asList(this.value);
        Iterator<File> iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            try {
                if (FileUtils.getCanonicalFile(iterator.next()).equals(FileUtils.getCanonicalFile(file))) {
                    return n;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ++n;
        }
        return -1;
    }

    public synchronized int length() {
        return this.value.length;
    }

    protected synchronized void loadValue(String string) {
        this.value = FileArraySetting.encode(string);
    }

    private static final File[] encode(String string) {
        if (string == null || string.length() == 0) {
            return new File[0];
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        File[] fileArray = new File[stringTokenizer.countTokens()];
        for (int i = 0; i < fileArray.length; ++i) {
            fileArray[i] = new File(stringTokenizer.nextToken());
        }
        return fileArray;
    }

    private static final String decode(File[] fileArray) {
        if (fileArray == null || fileArray.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < fileArray.length; ++i) {
            stringBuffer.append(fileArray[i].getAbsolutePath());
            if (i >= fileArray.length - 1) continue;
            stringBuffer.append(';');
        }
        return stringBuffer.toString();
    }

    public synchronized void clean() {
        LinkedList<File> linkedList = new LinkedList<File>();
        File file = null;
        for (int i = 0; i < this.value.length; ++i) {
            file = this.value[i];
            if (file == null || !file.exists()) continue;
            linkedList.add(file);
        }
        this.setValue(linkedList.toArray(new File[0]));
    }
}

