/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.settings;

import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.settings.BooleanSetting;
import com.limegroup.gnutella.settings.FileSetSetting;
import com.limegroup.gnutella.settings.FileSetting;
import com.limegroup.gnutella.settings.IntSetting;
import com.limegroup.gnutella.settings.LimeProps;
import com.limegroup.gnutella.settings.StringSetting;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;

public class SharingSettings
extends LimeProps {
    private static final Hashtable downloadDirsByDescription = new Hashtable();
    public static final File DEFAULT_SAVE_DIR = new File(CommonUtils.getUserHomeDir(), "Shared");
    public static final BooleanSetting ADD_ALTERNATE_FOR_SELF = FACTORY.createBooleanSetting("ADD_ALTERNATE_FOR_SELF", true);
    public static final FileSetting DIRECTORY_FOR_SAVING_FILES = (FileSetting)FACTORY.createFileSetting("DIRECTORY_FOR_SAVING_FILES", DEFAULT_SAVE_DIR).setAlwaysSave(true);
    public static final FileSetting INCOMPLETE_DIRECTORY = FACTORY.createFileSetting("INCOMPLETE_DIRECTORY", new File(DIRECTORY_FOR_SAVING_FILES.getValue(), "Incomplete"));
    public static final FileSetting DOWNLOAD_SNAPSHOT_FILE = FACTORY.createFileSetting("DOWNLOAD_SNAPSHOT_FILE", new File(INCOMPLETE_DIRECTORY.getValue(), "downloads.dat"));
    public static final FileSetting DOWNLOAD_SNAPSHOT_BACKUP_FILE = FACTORY.createFileSetting("DOWNLOAD_SNAPSHOT_BACKUP_FILE", new File(INCOMPLETE_DIRECTORY.getValue(), "downloads.bak"));
    public static final IntSetting INCOMPLETE_PURGE_TIME = FACTORY.createIntSetting("INCOMPLETE_PURGE_TIME", 7);
    public static final BooleanSetting CLEAR_DOWNLOAD = FACTORY.createBooleanSetting("CLEAR_DOWNLOAD", false);
    private static final String DEFAULT_EXTENSIONS_TO_SHARE = "asx;html;htm;xml;txt;pdf;ps;rtf;doc;tex;mp3;mp4;wav;wax;au;aif;aiff;ra;ram;wma;wm;wmv;mp2v;mlv;mpa;mpv2;mid;midi;rmi;aifc;snd;flac;fla;mpg;mpeg;asf;qt;mov;avi;mpe;swf;dcr;gif;jpg;jpeg;jpe;png;tif;tiff;exe;zip;gz;gzip;hqx;tar;tgz;z;rmj;lqt;rar;ace;sit;smi;img;ogg;rm;bin;dmg;jve;nsv;med;mod;7z;iso;lwtp;pmf;m4a;idx;bz2;sea;pf;arc;arj;bz;tbz;mime;taz;ua;toast;lit;rpm;deb;pkg;sxw;l6t;srt;sub;idx;mkv;ogm;shn;flac;fla;dvi;rmvp;kar;cdg;ccd;cue;c;h;m;java;jar;pl;py;pyc;pyo;pyz";
    public static final FileSetSetting DIRECTORIES_TO_SHARE = FACTORY.createFileSetSetting("DIRECTORIES_TO_SEARCH_FOR_FILES", new File[0]);
    public static final BooleanSetting SHARE_DOWNLOADED_FILES_IN_NON_SHARED_DIRECTORIES = FACTORY.createBooleanSetting("SHARE_DOWNLOADED_FILES_IN_NON_SHARED_DIRECTORIES", true);
    public static final StringSetting EXTENSIONS_TO_SHARE = FACTORY.createStringSetting("EXTENSIONS_TO_SEARCH_FOR", "asx;html;htm;xml;txt;pdf;ps;rtf;doc;tex;mp3;mp4;wav;wax;au;aif;aiff;ra;ram;wma;wm;wmv;mp2v;mlv;mpa;mpv2;mid;midi;rmi;aifc;snd;flac;fla;mpg;mpeg;asf;qt;mov;avi;mpe;swf;dcr;gif;jpg;jpeg;jpe;png;tif;tiff;exe;zip;gz;gzip;hqx;tar;tgz;z;rmj;lqt;rar;ace;sit;smi;img;ogg;rm;bin;dmg;jve;nsv;med;mod;7z;iso;lwtp;pmf;m4a;idx;bz2;sea;pf;arc;arj;bz;tbz;mime;taz;ua;toast;lit;rpm;deb;pkg;sxw;l6t;srt;sub;idx;mkv;ogm;shn;flac;fla;dvi;rmvp;kar;cdg;ccd;cue;c;h;m;java;jar;pl;py;pyc;pyo;pyz");
    public static final IntSetting FREELOADER_ALLOWED = FACTORY.createIntSetting("FREELOADER_ALLOWED", 100);
    public static final IntSetting FREELOADER_FILES = FACTORY.createIntSetting("FREELOADER_FILES", 1);
    public static final IntSetting PERSISTENT_HTTP_CONNECTION_TIMEOUT = FACTORY.createIntSetting("PERSISTENT_HTTP_CONNECTION_TIMEOUT", 15000);
    public static final BooleanSetting CLEAR_UPLOAD = FACTORY.createBooleanSetting("CLEAR_UPLOAD", true);
    public static final BooleanSetting ALLOW_BROWSER = FACTORY.createBooleanSetting("ALLOW_BROWSER", false);
    public static final BooleanSetting FRIENDLY_HASHING = FACTORY.createBooleanSetting("FRIENDLY_HASHING", true);

    private SharingSettings() {
    }

    public static final void setSaveDirectory(File file) throws IOException {
        if (file == null) {
            throw new NullPointerException();
        }
        if (!file.isDirectory() && !file.mkdirs()) {
            throw new IOException("could not create save dir");
        }
        File file2 = new File(file, "Incomplete");
        if (!file2.isDirectory() && !file2.mkdirs()) {
            throw new IOException("could not create incomplete dir");
        }
        FileUtils.setWriteable(file);
        FileUtils.setWriteable(file2);
        if (!(file.canRead() && file.canWrite() && file2.canRead() && file2.canWrite())) {
            throw new IOException("could not write to selected directory");
        }
        try {
            file = FileUtils.getCanonicalFile(file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            file2 = FileUtils.getCanonicalFile(file2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        File file3 = new File(file2, "downloads.dat");
        try {
            file3 = FileUtils.getCanonicalFile(file3);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        File file4 = new File(file2, "downloads.bak");
        try {
            file4 = FileUtils.getCanonicalFile(file4);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        DIRECTORY_FOR_SAVING_FILES.setValue(file);
        INCOMPLETE_DIRECTORY.setValue(file2);
        DOWNLOAD_SNAPSHOT_FILE.setValue(file3);
        DOWNLOAD_SNAPSHOT_BACKUP_FILE.setValue(file4);
    }

    public static final File getSaveDirectory() {
        return DIRECTORY_FOR_SAVING_FILES.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Set getAllSaveDirectories() {
        HashSet<File> hashSet = new HashSet<File>(7);
        hashSet.add(SharingSettings.getSaveDirectory());
        Hashtable hashtable = downloadDirsByDescription;
        synchronized (hashtable) {
            Iterator iterator = downloadDirsByDescription.values().iterator();
            while (iterator.hasNext()) {
                FileSetting fileSetting = (FileSetting)iterator.next();
                hashSet.add(fileSetting.getValue());
            }
        }
        return hashSet;
    }

    public static final FileSetting getFileSettingForMediaType(MediaType mediaType) {
        FileSetting fileSetting = (FileSetting)downloadDirsByDescription.get(mediaType.getMimeType());
        if (fileSetting == null) {
            fileSetting = FACTORY.createProxyFileSetting("DIRECTORY_FOR_SAVING_" + mediaType.getMimeType() + "_FILES", DIRECTORY_FOR_SAVING_FILES);
            downloadDirsByDescription.put(mediaType.getMimeType(), fileSetting);
        }
        return fileSetting;
    }
}

