/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.settings;

import com.limegroup.gnutella.settings.Setting;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;

public class StringSetSetting
extends Setting {
    private Set value;

    public StringSetSetting(Properties properties, Properties properties2, String string, String string2) {
        super(properties, properties2, string, string2, null);
    }

    public synchronized Set getValue() {
        return this.value;
    }

    public synchronized String[] getValueAsArray() {
        return this.value.toArray(new String[this.value.size()]);
    }

    protected synchronized void loadValue(String string) {
        this.value = StringSetSetting.encode(string);
    }

    private static final Set encode(String string) {
        if (string == null || string.length() == 0) {
            return new HashSet();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        int n = stringTokenizer.countTokens();
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < n; ++i) {
            hashSet.add(stringTokenizer.nextToken());
        }
        return hashSet;
    }

    private static final String decode(Set set) {
        if (set == null || set.isEmpty()) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(';');
        }
        return stringBuffer.toString();
    }

    public synchronized void setValue(Set set) {
        super.setValue(StringSetSetting.decode(set));
    }

    public synchronized boolean add(String string) {
        if (this.value.add(string)) {
            this.setValue(StringSetSetting.decode(this.value));
            return true;
        }
        return false;
    }

    public synchronized boolean remove(String string) {
        if (this.value.remove(string)) {
            this.setValue(StringSetSetting.decode(this.value));
            return true;
        }
        return false;
    }

    public synchronized boolean contains(String string) {
        return this.value.contains(string);
    }
}

