/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.simpp;

import com.bitzi.util.Base32;
import com.limegroup.gnutella.security.SignatureVerifier;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import jp.sourceforge.cabos.AqMain;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SimppDataVerifier {
    private static final Log LOG = LogFactory.getLog((Class)(class$com$limegroup$gnutella$simpp$SimppDataVerifier == null ? (class$com$limegroup$gnutella$simpp$SimppDataVerifier = SimppDataVerifier.class$("com.limegroup.gnutella.simpp.SimppDataVerifier")) : class$com$limegroup$gnutella$simpp$SimppDataVerifier));
    private static final byte SEP = 124;
    public final String DSA_ALGORITHM = "DSA";
    private byte[] simppPayload;
    private byte[] verifiedData;
    static /* synthetic */ Class class$com$limegroup$gnutella$simpp$SimppDataVerifier;

    public SimppDataVerifier(byte[] byArray) {
        this.simppPayload = byArray;
    }

    public boolean verifySource() {
        int n = SimppDataVerifier.findSeperator(this.simppPayload);
        if (n < 0) {
            return false;
        }
        byte[] byArray = new byte[n];
        System.arraycopy(this.simppPayload, 0, byArray, 0, n);
        String string = null;
        try {
            string = new String(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return false;
        }
        byte[] byArray2 = Base32.decode(string);
        byte[] byArray3 = new byte[this.simppPayload.length - 1 - n];
        System.arraycopy(this.simppPayload, n + 1, byArray3, 0, this.simppPayload.length - 1 - n);
        PublicKey publicKey = this.getPublicKey();
        if (publicKey == null) {
            return false;
        }
        String string2 = "DSA";
        SignatureVerifier signatureVerifier = new SignatureVerifier(byArray3, byArray2, publicKey, string2);
        boolean bl = signatureVerifier.verifySignature();
        if (bl) {
            this.verifiedData = byArray3;
        }
        return bl;
    }

    public byte[] getVerifiedData() {
        return this.verifiedData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private PublicKey getPublicKey() {
        X509EncodedKeySpec x509EncodedKeySpec;
        byte[] byArray;
        String string;
        block14: {
            File file = new File(AqMain.getJavaBundlePath(), "pub1.key");
            string = null;
            RandomAccessFile randomAccessFile = null;
            randomAccessFile = new RandomAccessFile(file, "r");
            byArray = new byte[(int)randomAccessFile.length()];
            randomAccessFile.readFully(byArray);
            string = new String(byArray, "UTF-8");
            x509EncodedKeySpec = null;
            try {
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                }
                break block14;
            }
            catch (IOException iOException) {}
            break block14;
            {
                catch (IOException iOException) {
                    LOG.error((Object)"IOX reading file", (Throwable)iOException);
                    PublicKey publicKey = null;
                    Object var7_7 = null;
                    try {
                        if (randomAccessFile != null) {
                            randomAccessFile.close();
                        }
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                    return publicKey;
                }
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                try {
                    if (randomAccessFile != null) {
                        randomAccessFile.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        byArray = Base32.decode(string);
        PublicKey publicKey = null;
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("DSA");
            x509EncodedKeySpec = new X509EncodedKeySpec(byArray);
            publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            LOG.error((Object)"no algorithm", (Throwable)noSuchAlgorithmException);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            LOG.error((Object)"invalid key", (Throwable)invalidKeySpecException);
        }
        return publicKey;
    }

    static int findSeperator(byte[] byArray) {
        int n;
        boolean bl = false;
        for (n = 0; n < byArray.length; ++n) {
            if (byArray[n] != 124) continue;
            bl = true;
            break;
        }
        if (bl) {
            return n;
        }
        return -1;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

