/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.simpp;

import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.messages.vendor.CapabilitiesVM;
import com.limegroup.gnutella.settings.SimppSettingsManager;
import com.limegroup.gnutella.simpp.SimppDataVerifier;
import com.limegroup.gnutella.simpp.SimppParser;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.FileUtils;
import com.limegroup.gnutella.util.ProcessingQueue;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;

public class SimppManager {
    private static final Log LOG = LogFactory.getLog((Class)(class$com$limegroup$gnutella$simpp$SimppManager == null ? (class$com$limegroup$gnutella$simpp$SimppManager = SimppManager.class$("com.limegroup.gnutella.simpp.SimppManager")) : class$com$limegroup$gnutella$simpp$SimppManager));
    private static SimppManager INSTANCE;
    private int _latestVersion;
    private static final String SIMPP_FILE = "simpp.xml";
    private static int MIN_VERSION;
    private byte[] _simppBytes;
    private String _propsStream;
    private final ProcessingQueue _processingQueue;
    static /* synthetic */ Class class$com$limegroup$gnutella$simpp$SimppManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SimppManager() {
        block27: {
            block26: {
                block25: {
                    super();
                    var1_1 = false;
                    var2_2 = null;
                    this._processingQueue = new ProcessingQueue("Simpp Handling Queue");
                    try {
                        try {
                            var3_3 = new File(CommonUtils.getUserSettingsDir(), "simpp.xml");
                            var2_2 = new RandomAccessFile(var3_3, "r");
                            var4_5 = new byte[(int)var2_2.length()];
                            var2_2.readFully(var4_5);
                            var5_6 = new SimppDataVerifier(var4_5);
                            var6_7 = false;
                            this._latestVersion = 0;
                            var6_7 = var5_6.verifySource();
                            if (!var6_7) {
                                SimppManager.LOG.debug((Object)"Unable to verify simpp message.");
                                var1_1 = true;
                                var10_8 = null;
                                if (var1_1) {
                                    this._latestVersion = SimppManager.MIN_VERSION;
                                    this._propsStream = "";
                                    this._simppBytes = "".getBytes();
                                }
                                if (var2_2 == null) return;
                                break block25;
                            }
                            var7_22 = null;
                            try {
                                var7_22 = new SimppParser(var5_6.getVerifiedData());
                            }
                            catch (SAXException var8_23) {
                                SimppManager.LOG.error((Object)"Unable to parse simpp data on disk", (Throwable)var8_23);
                                var1_1 = true;
                                var10_9 = null;
                                if (var1_1) {
                                    this._latestVersion = SimppManager.MIN_VERSION;
                                    this._propsStream = "";
                                    this._simppBytes = "".getBytes();
                                }
                                if (var2_2 == null) return;
                                try {
                                    var2_2.close();
                                    return;
                                }
                                catch (IOException var11_16) {
                                    // empty catch block
                                }
                                return;
                            }
                            catch (IOException var8_24) {
                                SimppManager.LOG.error((Object)"IOX parsing simpp on disk", (Throwable)var8_24);
                                var1_1 = true;
                                var10_10 = null;
                                if (var1_1) {
                                    this._latestVersion = SimppManager.MIN_VERSION;
                                    this._propsStream = "";
                                    this._simppBytes = "".getBytes();
                                }
                                if (var2_2 == null) return;
                                ** try [egrp 3[TRYBLOCK] [14 : 284->291)] { 
lbl57:
                                // 1 sources

                                var2_2.close();
                                return;
lbl59:
                                // 1 sources

                                catch (IOException var11_17) {
                                    // empty catch block
                                }
                                return;
                            }
                            if (var7_22.getVersion() <= SimppManager.MIN_VERSION) {
                                SimppManager.LOG.error((Object)"Version below min on disk, aborting simpp.");
                                var1_1 = true;
                                break block26;
                            }
                            this._latestVersion = var7_22.getVersion();
                            this._propsStream = var7_22.getPropsData();
                            this._simppBytes = var4_5;
                            break block27;
                        }
                        catch (IOException var3_4) {
                            SimppManager.LOG.error((Object)"IOX reading simpp xml on disk", (Throwable)var3_4);
                            var1_1 = true;
                            var10_13 = null;
                            if (var1_1) {
                                this._latestVersion = SimppManager.MIN_VERSION;
                                this._propsStream = "";
                                this._simppBytes = "".getBytes();
                            }
                            if (var2_2 == null) return;
                            try {}
                            catch (IOException var11_20) {
                                return;
                            }
                            var2_2.close();
                            return;
                        }
                    }
                    catch (Throwable var9_25) {
                        var10_14 = null;
                        if (var1_1) {
                            this._latestVersion = SimppManager.MIN_VERSION;
                            this._propsStream = "";
                            this._simppBytes = "".getBytes();
                        }
                        if (var2_2 == null) throw var9_25;
                        ** try [egrp 3[TRYBLOCK] [14 : 284->291)] { 
lbl95:
                        // 1 sources

                        var2_2.close();
                        throw var9_25;
lbl97:
                        // 1 sources

                        catch (IOException var11_21) {
                            // empty catch block
                        }
                        throw var9_25;
                    }
                }
                ** try [egrp 3[TRYBLOCK] [14 : 284->291)] { 
lbl102:
                // 1 sources

                var2_2.close();
                return;
lbl104:
                // 1 sources

                catch (IOException var11_15) {
                    // empty catch block
                }
                return;
            }
            var10_11 = null;
            if (var1_1) {
                this._latestVersion = SimppManager.MIN_VERSION;
                this._propsStream = "";
                this._simppBytes = "".getBytes();
            }
            if (var2_2 == null) return;
            ** try [egrp 3[TRYBLOCK] [14 : 284->291)] { 
lbl115:
            // 1 sources

            var2_2.close();
            return;
lbl117:
            // 1 sources

            catch (IOException var11_18) {
                // empty catch block
            }
            return;
        }
        var10_12 = null;
        if (var1_1) {
            this._latestVersion = SimppManager.MIN_VERSION;
            this._propsStream = "";
            this._simppBytes = "".getBytes();
        }
        if (var2_2 == null) return;
        try {}
        catch (IOException var11_19) {}
        var2_2.close();
        return;
    }

    public static synchronized SimppManager instance() {
        if (INSTANCE == null) {
            INSTANCE = new SimppManager();
        }
        return INSTANCE;
    }

    public int getVersion() {
        return this._latestVersion;
    }

    public byte[] getSimppBytes() {
        return this._simppBytes;
    }

    public String getPropsString() {
        return this._propsStream;
    }

    public void checkAndUpdate(final byte[] byArray) {
        if (byArray == null) {
            return;
        }
        final int n = this._latestVersion;
        Runnable runnable = new Runnable(){

            public void run() {
                SimppDataVerifier simppDataVerifier = new SimppDataVerifier(byArray);
                if (!simppDataVerifier.verifySource()) {
                    return;
                }
                SimppParser simppParser = null;
                try {
                    simppParser = new SimppParser(simppDataVerifier.getVerifiedData());
                }
                catch (SAXException sAXException) {
                    LOG.error((Object)"SAX error reading network simpp", (Throwable)sAXException);
                    return;
                }
                catch (IOException iOException) {
                    LOG.error((Object)"IOX parsing network simpp", (Throwable)iOException);
                    return;
                }
                int n2 = simppParser.getVersion();
                if (n2 <= n) {
                    LOG.error((Object)"Network simpp below current version, aborting.");
                    return;
                }
                SimppManager.this._latestVersion = n2;
                SimppManager.access$202(SimppManager.this, byArray);
                SimppManager.this._propsStream = simppParser.getPropsData();
                String string = simppParser.getPropsData();
                SimppSettingsManager.instance().updateSimppSettings(string);
                for (int i = 0; i < 5 && !SimppManager.this.save(); ++i) {
                }
                CapabilitiesVM.reconstructInstance();
                RouterService.getConnectionManager().sendUpdatedCapabilities();
            }
        };
        this._processingQueue.add(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean save() {
        block20: {
            block19: {
                var1_1 = new File(CommonUtils.getUserSettingsDir(), "simpp.xml.tmp");
                var2_2 = new File(CommonUtils.getUserSettingsDir(), "simpp.xml");
                var3_3 = null;
                try {
                    try {
                        var3_3 = new BufferedOutputStream(new FileOutputStream(var1_1));
                        var3_3.write(this._simppBytes);
                        var3_3.flush();
                    }
                    catch (IOException var4_11) {
                        var5_13 = false;
                        var7_5 = null;
                        if (var3_3 == null) return var5_13;
                        try {
                            var3_3.close();
                            return var5_13;
                        }
                        catch (IOException var8_9) {
                            // empty catch block
                        }
                        return var5_13;
                    }
                    var7_4 = null;
                    if (var3_3 == null) break block19;
                }
                catch (Throwable var6_15) {
                    var7_6 = null;
                    if (var3_3 == null) throw var6_15;
                    ** try [egrp 2[TRYBLOCK] [4 : 87->94)] { 
lbl29:
                    // 1 sources

                    var3_3.close();
                    throw var6_15;
lbl31:
                    // 1 sources

                    catch (IOException var8_10) {
                        // empty catch block
                    }
                    throw var6_15;
                }
                try {}
                catch (IOException var8_8) {}
                var3_3.close();
            }
            var4_12 = null;
            var5_14 = new byte[this._simppBytes.length];
            try {
                try {
                    var4_12 = new DataInputStream(new BufferedInputStream(new FileInputStream(var1_1)));
                    var4_12.readFully(var5_14);
                    if (Arrays.equals(var5_14, this._simppBytes)) break block20;
                    var6_16 = false;
                    var10_18 = null;
                    if (var4_12 == null) return var6_16;
                }
                catch (IOException var6_17) {
                    var7_7 = false;
                    var10_20 = null;
                    if (var4_12 == null) return var7_7;
                    try {
                        var4_12.close();
                        return var7_7;
                    }
                    catch (IOException var11_24) {
                        // empty catch block
                    }
                    return var7_7;
                }
            }
            catch (Throwable var9_26) {
                var10_21 = null;
                if (var4_12 == null) throw var9_26;
                ** try [egrp 5[TRYBLOCK] [10 : 194->202)] { 
lbl67:
                // 1 sources

                var4_12.close();
                throw var9_26;
lbl69:
                // 1 sources

                catch (IOException var11_25) {
                    // empty catch block
                }
                throw var9_26;
            }
            try {}
            catch (IOException var11_22) {
                // empty catch block
                return var6_16;
            }
            var4_12.close();
            return var6_16;
        }
        var10_19 = null;
        if (var4_12 == null) return FileUtils.forceRename(var1_1, var2_2);
        try {}
        catch (IOException var11_23) {}
        var4_12.close();
        return FileUtils.forceRename(var1_1, var2_2);
        return FileUtils.forceRename(var1_1, var2_2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ byte[] access$202(SimppManager simppManager, byte[] byArray) {
        simppManager._simppBytes = byArray;
        return byArray;
    }

    static {
        MIN_VERSION = 3;
    }
}

