/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.statistics;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.statistics.Statistic;
import com.limegroup.gnutella.statistics.StatisticsManager;
import com.limegroup.gnutella.util.IntBuffer;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.StringTokenizer;

public abstract class AbstractStatistic
implements Statistic {
    protected static final StatisticsManager STATS_MANAGER = StatisticsManager.instance();
    protected final IntBuffer _buffer = new IntBuffer(200);
    protected volatile int _current = 0;
    private volatile int _lastStored = 0;
    protected volatile double _total = 0.0;
    protected volatile int _totalStatsRecorded = 0;
    protected volatile double _max = 0.0;
    private Writer _writer;
    private boolean _writeStat = false;
    private int _numWriters = 0;
    protected String _fileName;

    protected AbstractStatistic() {
    }

    public double getTotal() {
        return this._total;
    }

    public double getAverage() {
        if (this._totalStatsRecorded == 0) {
            return 0.0;
        }
        return this._total / (double)this._totalStatsRecorded;
    }

    public double getMax() {
        return this._max;
    }

    public int getCurrent() {
        return this._current;
    }

    public int getLastStored() {
        return this._lastStored;
    }

    public void incrementStat() {
        ++this._current;
        this._total += 1.0;
    }

    public void addData(int n) {
        this._current += n;
        this._total += (double)n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IntBuffer getStatHistory() {
        IntBuffer intBuffer = this._buffer;
        synchronized (intBuffer) {
            this.initializeBuffer();
            return this._buffer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearData() {
        this._current = 0;
        this._total = 0.0;
        this._totalStatsRecorded = 0;
        this._max = 0.0;
        IntBuffer intBuffer = this._buffer;
        synchronized (intBuffer) {
            this._buffer.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeCurrentStat() {
        IntBuffer intBuffer = this._buffer;
        synchronized (intBuffer) {
            this.initializeBuffer();
            this._buffer.addLast(this._current);
        }
        if ((double)this._current > this._max) {
            this._max = this._current;
        }
        if (this._writeStat && this._writer != null) {
            try {
                this._writer.write(Integer.toString(this._current));
                this._writer.write(",");
                this._writer.flush();
            }
            catch (IOException iOException) {
                ErrorService.error(iOException);
            }
        }
        this._lastStored = this._current;
        this._current = 0;
        ++this._totalStatsRecorded;
    }

    public synchronized void setWriteStatToFile(boolean bl) {
        if (bl) {
            ++this._numWriters;
            this._writeStat = true;
            if (this._numWriters == 1) {
                try {
                    if (this._fileName == null || this._fileName.equals("")) {
                        Class<?> clazz = this.getClass().getSuperclass();
                        Class<?> clazz2 = this.getClass().getDeclaringClass();
                        LinkedList<Field> linkedList = new LinkedList<Field>();
                        if (clazz != null) {
                            linkedList.addAll(Arrays.asList(clazz.getFields()));
                        }
                        if (clazz2 != null) {
                            linkedList.addAll(Arrays.asList(clazz2.getFields()));
                        }
                        linkedList.addAll(Arrays.asList(this.getClass().getFields()));
                        Field[] fieldArray = linkedList.toArray(new Field[0]);
                        for (int i = 0; i < fieldArray.length; ++i) {
                            try {
                                Object object = fieldArray[i].get(null);
                                if (!object.equals(this)) continue;
                                StringTokenizer stringTokenizer = new StringTokenizer(fieldArray[i].toString());
                                while (stringTokenizer.hasMoreTokens()) {
                                    this._fileName = stringTokenizer.nextToken();
                                }
                                this._fileName = this._fileName.substring(34);
                                continue;
                            }
                            catch (IllegalAccessException illegalAccessException) {
                                // empty catch block
                            }
                        }
                    }
                    this._writer = new FileWriter(this._fileName, false);
                }
                catch (IOException iOException) {
                    ErrorService.error(iOException);
                }
            }
        } else if (this._numWriters != 0) {
            --this._numWriters;
        }
        if (this._numWriters == 0) {
            this._writeStat = false;
            this._writer = null;
        }
    }

    protected final void initializeBuffer() {
        if (this._buffer.isEmpty()) {
            for (int i = 0; i < 200; ++i) {
                this._buffer.addLast(0);
            }
        }
    }
}

