/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.statistics;

import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.statistics.BasicStatistic;
import com.limegroup.gnutella.statistics.Statistic;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OutOfBandThroughputStat
extends BasicStatistic {
    private static final Log LOG = LogFactory.getLog((Class)(class$com$limegroup$gnutella$statistics$OutOfBandThroughputStat == null ? (class$com$limegroup$gnutella$statistics$OutOfBandThroughputStat = OutOfBandThroughputStat.class$("com.limegroup.gnutella.statistics.OutOfBandThroughputStat")) : class$com$limegroup$gnutella$statistics$OutOfBandThroughputStat));
    public static int MIN_SAMPLE_SIZE = 500;
    public static final int MIN_SUCCESS_RATE = 60;
    public static final int PROXY_SUCCESS_RATE = 80;
    public static final int TERRIBLE_SUCCESS_RATE = 40;
    public static final Statistic RESPONSES_REQUESTED;
    public static final Statistic RESPONSES_RECEIVED;
    public static final Statistic RESPONSES_BYPASSED;
    public static final Statistic OOB_QUERIES_SENT;
    static /* synthetic */ Class class$com$limegroup$gnutella$statistics$OutOfBandThroughputStat;

    private OutOfBandThroughputStat() {
    }

    public static double getSuccessRate() {
        double d = RESPONSES_REQUESTED.getTotal();
        double d2 = RESPONSES_RECEIVED.getTotal();
        return d2 / d * 100.0;
    }

    public static boolean isSuccessRateGood() {
        if (RESPONSES_REQUESTED.getTotal() < (double)MIN_SAMPLE_SIZE) {
            return true;
        }
        return OutOfBandThroughputStat.getSuccessRate() > 60.0;
    }

    public static boolean isSuccessRateGreat() {
        if (RESPONSES_REQUESTED.getTotal() < (double)MIN_SAMPLE_SIZE) {
            return true;
        }
        return OutOfBandThroughputStat.getSuccessRate() > 80.0;
    }

    public static boolean isSuccessRateTerrible() {
        if (RESPONSES_REQUESTED.getTotal() < (double)MIN_SAMPLE_SIZE) {
            return false;
        }
        return OutOfBandThroughputStat.getSuccessRate() < 40.0;
    }

    public static boolean isOOBEffectiveForProxy() {
        return !(OOB_QUERIES_SENT.getTotal() > 40.0) || RESPONSES_REQUESTED.getTotal() != 0.0;
    }

    public static boolean isOOBEffectiveForMe() {
        return !(OOB_QUERIES_SENT.getTotal() > 20.0) || RESPONSES_REQUESTED.getTotal() != 0.0;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Runnable runnable = new Runnable(){

            public void run() {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("current success rate " + OutOfBandThroughputStat.getSuccessRate() + " based on " + (int)RESPONSES_REQUESTED.getTotal() + " measurements with a min sample size " + MIN_SAMPLE_SIZE));
                }
                if (!OutOfBandThroughputStat.isSuccessRateGreat() && !OutOfBandThroughputStat.isSuccessRateTerrible()) {
                    LOG.debug((Object)"boosting sample size by 500");
                    MIN_SAMPLE_SIZE += 500;
                }
            }
        };
        int n = 1800000;
        RouterService.schedule(runnable, n, n);
        RESPONSES_REQUESTED = new OutOfBandThroughputStat();
        RESPONSES_RECEIVED = new OutOfBandThroughputStat();
        RESPONSES_BYPASSED = new OutOfBandThroughputStat();
        OOB_QUERIES_SENT = new OutOfBandThroughputStat();
    }
}

