/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.tigertree;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.tigertree.HashTree;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.ConverterObjectInputStream;
import com.limegroup.gnutella.util.ProcessingQueue;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class TigerTreeCache {
    private static TigerTreeCache instance = null;
    private static final ProcessingQueue QUEUE = new ProcessingQueue("TreeHashTread");
    private static final Log LOG = LogFactory.getLog((Class)(class$com$limegroup$gnutella$tigertree$TigerTreeCache == null ? (class$com$limegroup$gnutella$tigertree$TigerTreeCache = TigerTreeCache.class$("com.limegroup.gnutella.tigertree.TigerTreeCache")) : class$com$limegroup$gnutella$tigertree$TigerTreeCache));
    private static final Object BUSH = new Object();
    private static Map TREE_MAP;
    private static final File CACHE_FILE;
    private static boolean dirty;
    static /* synthetic */ Class class$com$limegroup$gnutella$tigertree$TigerTreeCache;

    public static synchronized TigerTreeCache instance() {
        if (instance == null) {
            instance = new TigerTreeCache();
        }
        return instance;
    }

    public synchronized HashTree getHashTree(FileDesc fileDesc) {
        Object v = TREE_MAP.get(fileDesc.getSHA1Urn());
        if (v != null && v.equals(BUSH)) {
            return null;
        }
        HashTree hashTree = (HashTree)v;
        if (hashTree == null) {
            TREE_MAP.put(fileDesc.getSHA1Urn(), BUSH);
            QUEUE.add(new HashRunner(fileDesc));
        }
        return hashTree;
    }

    public synchronized HashTree getHashTree(URN uRN) {
        Object v = TREE_MAP.get(uRN);
        if (v != null && v.equals(BUSH)) {
            return null;
        }
        return (HashTree)v;
    }

    public synchronized void purgeTree(URN uRN) {
        if (TREE_MAP.remove(uRN) != null) {
            dirty = true;
        }
    }

    public static synchronized void addHashTree(URN uRN, HashTree hashTree) {
        if (hashTree.isGoodDepth()) {
            TREE_MAP.put(uRN, hashTree);
            dirty = true;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("added hashtree for urn " + uRN + ";" + hashTree.getRootHash()));
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("hashtree for urn " + uRN + " had bad depth"));
        }
    }

    private TigerTreeCache() {
        TREE_MAP = TigerTreeCache.createMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map createMap() {
        Object object;
        ObjectInputStream objectInputStream = null;
        try {
            try {
                objectInputStream = new ConverterObjectInputStream(new BufferedInputStream(new FileInputStream(CACHE_FILE)));
                Map map = (Map)objectInputStream.readObject();
                if (map != null) {
                    object = map.entrySet().iterator();
                    while (object.hasNext()) {
                        Map.Entry entry = (Map.Entry)object.next();
                        Object k = entry.getKey();
                        Object v = entry.getValue();
                        if (k instanceof URN && v instanceof HashTree) continue;
                        object.remove();
                    }
                }
                object = map;
                Object var7_8 = null;
                if (objectInputStream == null) return object;
            }
            catch (Throwable throwable) {
                LOG.error((Object)"Can't read tiger trees", throwable);
                HashMap hashMap = new HashMap();
                Object var7_9 = null;
                if (objectInputStream == null) return hashMap;
                try {
                    objectInputStream.close();
                    return hashMap;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return hashMap;
            }
        }
        catch (Throwable throwable2) {
            Object var7_10 = null;
            if (objectInputStream == null) throw throwable2;
            try {}
            catch (IOException iOException) {
                throw throwable2;
            }
            objectInputStream.close();
            throw throwable2;
        }
        try {}
        catch (IOException iOException) {
            // empty catch block
            return object;
        }
        objectInputStream.close();
        return object;
    }

    private static void removeOldEntries(Map map) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            URN uRN = (URN)iterator.next();
            if (map.get(uRN) != BUSH && (RouterService.getFileManager().getFileDescForUrn(uRN) != null || RouterService.getDownloadManager().getIncompleteFileManager().getFileForUrn(uRN) != null || Math.random() > (double)(map.size() / 200))) continue;
            iterator.remove();
            dirty = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public synchronized void persistCache() {
        block12: {
            if (!TigerTreeCache.dirty) {
                return;
            }
            TigerTreeCache.removeOldEntries(TigerTreeCache.TREE_MAP);
            var1_1 = null;
            try {
                var1_1 = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(TigerTreeCache.CACHE_FILE)));
                var1_1.writeObject(TigerTreeCache.TREE_MAP);
                var4_2 = null;
                ** if (var1_1 == null) goto lbl-1000
            }
            catch (Throwable var3_9) {
                var4_4 = null;
                if (var1_1 != null) {
                    try {
                        var1_1.close();
                    }
                    catch (IOException var5_7) {
                        // empty catch block
                    }
                }
                throw var3_9;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    var1_1.close();
                }
                catch (IOException var5_5) {}
            }
lbl-1000:
            // 2 sources

            {
                break block12;
                catch (IOException var2_8) {
                    ErrorService.error(var2_8);
                    var4_3 = null;
                    if (var1_1 != null) {
                        try {
                            var1_1.close();
                        }
                        catch (IOException var5_6) {}
                    }
                }
            }
        }
        TigerTreeCache.dirty = true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        CACHE_FILE = new File(CommonUtils.getUserSettingsDir(), "ttree.cache");
        dirty = false;
    }

    private static class HashRunner
    implements Runnable {
        private final FileDesc FD;

        HashRunner(FileDesc fileDesc) {
            this.FD = fileDesc;
        }

        public void run() {
            try {
                URN uRN = this.FD.getSHA1Urn();
                if (TigerTreeCache.instance().getHashTree(uRN) == null) {
                    HashTree hashTree = HashTree.createHashTree(this.FD);
                    TigerTreeCache.addHashTree(uRN, hashTree);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

